/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fgptas.business.audit.baidu;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class HttpUtil {
    private static final Log log = LogFactory.getLog(HttpUtil.class);

    public static String post(String requestUrl, String accessToken, String params) throws Exception {
        String contentType = "application/x-www-form-urlencoded";
        return HttpUtil.post(requestUrl, accessToken, contentType, params);
    }

    public static String post(String requestUrl, String accessToken, String contentType, String params) throws Exception {
        String encoding = "UTF-8";
        if (requestUrl.contains("nlp")) {
            encoding = "GBK";
        }
        return HttpUtil.post(requestUrl, accessToken, contentType, params, encoding);
    }

    public static String post(String requestUrl, String accessToken, String contentType, String params, String encoding) throws Exception {
        String url = requestUrl + "?access_token=" + accessToken;
        return HttpUtil.postGeneralUrl(url, contentType, params, encoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String postGeneralUrl(String generalUrl, String contentType, String params, String encoding) throws Exception {
        URL url = new URL(generalUrl);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", contentType);
        connection.setRequestProperty("Connection", "Keep-Alive");
        connection.setUseCaches(false);
        connection.setDoOutput(true);
        connection.setDoInput(true);
        DataOutputStream out = null;
        try {
            out = new DataOutputStream(connection.getOutputStream());
            out.write(params.getBytes(encoding));
            out.flush();
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                }
            }
        }
        BufferedReader in = null;
        try {
            String getLine;
            connection.connect();
            in = new BufferedReader(new InputStreamReader(connection.getInputStream(), encoding));
            StringBuilder result = new StringBuilder();
            while ((getLine = in.readLine()) != null) {
                result.append(getLine);
            }
            String string = result.toString();
            return string;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                }
            }
        }
    }
}

