/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fgptas.business.audit.helper;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fgptas.business.audit.pojo.ConditionEditModel;
import org.apache.commons.lang3.StringUtils;

public class AuditConfigSearcher {
    private static final String ORDER_BY = "order,createtime,id";
    private static final Log log = LogFactory.getLog(AuditConfigSearcher.class);

    public final DynamicObject search(DynamicObject dataEntity) {
        DynamicObjectCollection configs = this.findConfigs(dataEntity);
        DynamicObject auditConfigDyo = null;
        if (configs != null && (auditConfigDyo = (DynamicObject)configs.stream().filter(config -> this.matchAuditConfigDyo(dataEntity, (DynamicObject)config, false)).findFirst().map(config -> BusinessDataServiceHelper.loadSingle((Object)config.getLong("id"), (String)"fgptas_auditconfig")).orElse(null)) == null) {
            auditConfigDyo = configs.stream().filter(config -> this.matchAuditConfigDyo(dataEntity, (DynamicObject)config, true)).findFirst().map(config -> BusinessDataServiceHelper.loadSingle((Object)config.getLong("id"), (String)"fgptas_auditconfig")).orElse(null);
        }
        this.afterMatch(dataEntity, auditConfigDyo);
        return auditConfigDyo;
    }

    protected DynamicObjectCollection findConfigs(DynamicObject dataEntity) {
        if (dataEntity == null) {
            log.error("dataEntity of findConfigs is mandatory but null!!");
            return null;
        }
        String entityNumber = dataEntity.getDynamicObjectType().getName();
        QFilter[] qFilters = new QFilter[]{new QFilter("entityobject", "=", (Object)entityNumber), new QFilter("enable", "=", (Object)"1")};
        return QueryServiceHelper.query((String)"fgptas_auditconfig", (String)"id,name,start_rule_be_tag", (QFilter[])qFilters, (String)ORDER_BY, (int)-1);
    }

    protected boolean matchAuditConfigDyo(DynamicObject dataEntity, DynamicObject auditConfigDyo, boolean matchIfBlankStartRule) {
        String entityNumber = dataEntity.getDynamicObjectType().getName();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        String json = auditConfigDyo.getString("start_rule_be_tag");
        if (StringUtils.isBlank((CharSequence)json)) {
            return matchIfBlankStartRule;
        }
        ConditionEditModel conditionEditModel = (ConditionEditModel)SerializationUtils.fromJsonString((String)json, ConditionEditModel.class);
        String condition = conditionEditModel.getCondition();
        FilterCondition startRule = (FilterCondition)SerializationUtils.fromJsonString((String)condition, FilterCondition.class);
        FilterBuilder filterBuilder = new FilterBuilder(entityType, startRule);
        filterBuilder.buildFilter(true);
        if (filterBuilder.getQFilter() == null) {
            return matchIfBlankStartRule;
        }
        FilterObject filterObject = filterBuilder.getFilterObject();
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "=", dataEntity.getPkValue()), filterObject.getQFilter()};
        return QueryServiceHelper.exists((String)entityNumber, (QFilter[])qFilters);
    }

    protected void afterMatch(DynamicObject dataEntity, DynamicObject auditConfigDyo) {
        if (dataEntity == null) {
            return;
        }
        Object pkValue = dataEntity.getPkValue();
        String number = "";
        if (dataEntity.containsProperty("billno")) {
            number = dataEntity.getString("billno");
        } else if (dataEntity.containsProperty("number")) {
            number = dataEntity.getString("number");
        }
        if (auditConfigDyo != null) {
            long id = auditConfigDyo.getLong("id");
            String name = auditConfigDyo.getString("name");
            log.info(String.format("bill_%s_%s matches audit_config_%s_%s", pkValue, number, id, name));
        } else {
            log.error(String.format("bill_%s_%s matches nothing", pkValue, number));
        }
    }
}

