/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fgptas.business.audit.helper;

import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.fi.fgptas.business.audit.FGPTASAuditHelper;
import kd.fi.fgptas.business.audit.FGPTASAuditStatus;
import kd.fi.fgptas.business.audit.OcrStatus;
import kd.fi.fgptas.business.audit.helper.AuditConfigSearcher;
import kd.fi.fgptas.business.audit.pojo.BillAuditHelperParam;

public class BillAuditHelper {
    private static final ThreadPool POOL = ThreadPools.newCachedThreadPool((String)"BillAuditHelper", (int)Math.max(1, Runtime.getRuntime().availableProcessors() - 1), (int)Math.max(1, Runtime.getRuntime().availableProcessors() - 1), (String)"fgptas");
    private static final Log log = LogFactory.getLog(BillAuditHelper.class);

    public static void gptCallAsync(String entityNumber, Object entityId, boolean forced, boolean useFgptasUser) {
        BillAuditHelper.gptCallSync(entityNumber, entityId, forced, useFgptasUser, -1);
    }

    public static void gptCallSync(String entityNumber, Object entityId, boolean forced, boolean useFgptasUser, int timeout) {
        BillAuditHelperParam param = new BillAuditHelperParam();
        param.entityNumber(entityNumber).entityId(entityId).forceAll(forced).useFgptasUser(useFgptasUser).waitTimeoutSeconds(timeout);
        BillAuditHelper.process(param);
    }

    public static void process(BillAuditHelperParam param) {
        if (param == null) {
            log.error("\u53c2\u6570\u4e3anull\uff01\uff01");
            return;
        }
        RequestContext requestContext = RequestContext.get();
        String traceId = requestContext == null ? null : requestContext.getTraceId();
        param.traceId(traceId);
        log.info(param.toString());
        String entityNumber = param.getEntityNumber();
        Object entityId = param.getEntityId();
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)entityNumber) || entityId == null) {
            return;
        }
        FGPTASAuditHelper helper = new FGPTASAuditHelper(param);
        log.info("submit a kd.fi.fgptas.business.audit.FGPTASAuditHelper.process");
        Future submit = POOL.submit(helper::process, RequestContext.get());
        int timeout = param.getWaitTimeoutSeconds();
        if (timeout > 0) {
            timeout = Math.min(timeout, 300);
            log.info(String.format("\u6700\u957f\u7b49\u5f85%s\u79d2", timeout));
            try {
                submit.get(timeout, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                log.error((Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    public static DynamicObject findBillAudit(String entityNumber, Object pk) {
        DynamicObject dataEntity;
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)entityNumber) || pk == null) {
            return null;
        }
        try {
            dataEntity = BusinessDataServiceHelper.loadSingle((Object)pk, (String)entityNumber);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return null;
        }
        AuditConfigSearcher searcher = new AuditConfigSearcher();
        DynamicObject auditConfig = searcher.search(dataEntity);
        if (auditConfig == null) {
            return null;
        }
        QFilter[] qFilters = new QFilter[]{new QFilter("configid", "=", auditConfig.getPkValue()), new QFilter("entityid", "=", pk)};
        try {
            return BusinessDataServiceHelper.loadSingle((String)"fgptas_billaudit", (QFilter[])qFilters);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return null;
        }
    }

    public static boolean enableRisk(DynamicObject obj) {
        return obj != null && obj.getDynamicObjectCollection("riskentry") != null && !obj.getDynamicObjectCollection("riskentry").isEmpty();
    }

    public static Boolean riskStatus(DynamicObject obj) {
        DynamicObjectCollection riskEntry = obj.getDynamicObjectCollection("riskentry");
        boolean loading = riskEntry.stream().anyMatch(r -> StringUtils.isBlank((CharSequence)r.getString("riskstatus")));
        if (loading) {
            return null;
        }
        return riskEntry.stream().allMatch(r -> r.getBoolean("riskstatus"));
    }

    public static boolean riskRunning(DynamicObject obj) {
        OcrStatus ocrStatus = OcrStatus.keyOf(obj.getString("ocr_status"));
        FGPTASAuditStatus ragStatus = FGPTASAuditStatus.keyOf(obj.getString("runtimestatus"));
        String ocrError = obj.getString("ocr_error");
        boolean isFinished = OcrStatus.SUCCESS == ocrStatus && FGPTASAuditStatus.isFinished(ragStatus) || FGPTASAuditStatus.SUCCESS == ragStatus && OcrStatus.isFinished(ocrStatus, ocrError);
        return isFinished && BillAuditHelper.enableRisk(obj) && BillAuditHelper.riskStatus(obj) == null;
    }
}

