/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fgptas.business.audit.helper;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.fgptas.business.audit.FGPTASAuditStatus;
import kd.fi.fgptas.business.audit.OcrStatus;
import kd.fi.fgptas.business.audit.error.AuditErrorCode;
import kd.fi.fgptas.business.audit.helper.BillAuditHelper;
import org.apache.commons.lang3.math.NumberUtils;

public class RetryOrmHelper {
    private static final String ENTITY = "fgptas_billaudit_re";
    private static final String BILL_AUDIT_PK = "billaudit_pk";
    private static final String BILL_AUDIT_STATUS = "billaudit_status";
    private static final String PRIORITY = "priority";
    private static final String TRACE_ID = "traceid";
    private static final String BILL_NO = "billno";
    private static final Log log = LogFactory.getLog(RetryOrmHelper.class);
    public static final String SELECT_PROPERTIES_BILL_AUDIT = "billno,runtimestatus,ocr_status,ocr_error,riskentry";

    public static void save(DynamicObject billAudit) {
        boolean repairable = false;
        String billNo = billAudit.getString(BILL_NO);
        FGPTASAuditStatus status = FGPTASAuditStatus.keyOf(billAudit.getString("runtimestatus"));
        if (status != FGPTASAuditStatus.NO_ATTACHMENT && status != FGPTASAuditStatus.SUCCESS) {
            if (FGPTASAuditStatus.isRunning(status)) {
                RetryOrmHelper.save(billNo, billAudit.getPkValue(), 0, status.key);
                repairable = true;
            } else {
                RetryOrmHelper.save(billNo, billAudit.getPkValue(), 1, status == null ? null : status.key);
                repairable = true;
            }
        }
        if (repairable) {
            return;
        }
        OcrStatus ocrStatus = OcrStatus.keyOf(billAudit.getString("ocr_status"));
        if (ocrStatus == OcrStatus.RUNNING) {
            RetryOrmHelper.save(billNo, billAudit.getPkValue(), 0, ocrStatus.getKey());
            repairable = true;
        } else if (ocrStatus == OcrStatus.FAIL) {
            String ocrError = billAudit.getString("ocr_error");
            if (ocrError == null || !ocrError.contains(AuditErrorCode.NO_ATTACHMENT.getCode())) {
                RetryOrmHelper.save(billNo, billAudit.getPkValue(), 1, ocrStatus.getKey());
                repairable = true;
            }
        } else if (ocrStatus == null) {
            RetryOrmHelper.save(billNo, billAudit.getPkValue(), 1, null);
            repairable = true;
        }
        if (!(repairable || !BillAuditHelper.enableRisk(billAudit) || BillAuditHelper.riskStatus(billAudit) != null && BillAuditHelper.riskStatus(billAudit).booleanValue())) {
            RetryOrmHelper.save(billNo, billAudit.getPkValue(), 1, null);
            repairable = true;
        }
        if (!repairable) {
            RetryOrmHelper.delete(billAudit.getPkValue());
        }
    }

    public static void save(String billNo, Object billAuditPK, int timesAddOn, String status) {
        long pk = NumberUtils.toLong((String)(billAuditPK + ""), (long)0L);
        if (pk == 0L) {
            log.error("invalid pk:" + billAuditPK);
            return;
        }
        try (TXHandle h = TX.requiresNew((String)("kd.fi.fgptas.business.audit.helper.RetryOrmUtil.save" + pk));){
            try {
                DynamicObject dyo;
                QFilter[] qFilters = new QFilter(BILL_AUDIT_PK, "=", (Object)pk).toArray();
                if (QueryServiceHelper.exists((String)ENTITY, (QFilter[])qFilters)) {
                    dyo = BusinessDataServiceHelper.loadSingle((String)ENTITY, (QFilter[])qFilters);
                } else {
                    dyo = BusinessDataServiceHelper.newDynamicObject((String)ENTITY, (boolean)true, null);
                    dyo.set(BILL_AUDIT_PK, (Object)pk);
                    dyo.set(BILL_NO, (Object)billNo);
                }
                int times = dyo.getInt(PRIORITY);
                dyo.set(PRIORITY, (Object)(times + timesAddOn));
                if (StringUtils.isNotBlank((CharSequence)status)) {
                    dyo.set(BILL_AUDIT_STATUS, (Object)status);
                }
                dyo.set(TRACE_ID, (Object)RequestContext.get().getTraceId());
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dyo});
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                h.markRollback();
                throw e;
            }
        }
    }

    public static void delete(Object billAuditPK) {
        long pk = NumberUtils.toLong((String)(billAuditPK + ""), (long)0L);
        if (pk == 0L) {
            log.error("invalid pk:" + billAuditPK);
            return;
        }
        try (TXHandle h = TX.requiresNew((String)("kd.fi.fgptas.business.audit.helper.RetryOrmUtil.delete" + pk));){
            try {
                QFilter[] qFilters = new QFilter(BILL_AUDIT_PK, "=", (Object)pk).toArray();
                DeleteServiceHelper.delete((String)ENTITY, (QFilter[])qFilters);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                h.markRollback();
                throw e;
            }
        }
    }

    public static Set<Long> query(Map<String, Object> params) {
        int top = NumberUtils.toInt((String)(params.get("top") + ""), (int)50);
        int maxPriority = NumberUtils.toInt((String)(params.get("maxPriority") + ""), (int)Integer.MIN_VALUE);
        QFilter[] qFilters = null;
        if (maxPriority > Integer.MIN_VALUE) {
            qFilters = new QFilter[]{new QFilter(PRIORITY, "<=", (Object)maxPriority)};
        }
        DynamicObject[] objects = BusinessDataServiceHelper.load((String)ENTITY, (String)"priority,billaudit_pk", qFilters, (String)PRIORITY, (int)top);
        HashSet<Long> ids = new HashSet<Long>(objects.length);
        for (DynamicObject object : objects) {
            object.set(PRIORITY, (Object)(object.getInt(PRIORITY) + 1));
            ids.add(object.getLong(BILL_AUDIT_PK));
        }
        try (TXHandle h = TX.requiresNew((String)"kd.fi.fgptas.business.audit.helper.RetryOrmUtil.addOn");){
            try {
                SaveServiceHelper.save((DynamicObject[])objects);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                h.markRollback();
                throw e;
            }
        }
        return ids;
    }

    public static boolean insert(DynamicObject billAudit) {
        Object pkValue = billAudit.getPkValue();
        if (!QueryServiceHelper.exists((String)ENTITY, (QFilter[])new QFilter(BILL_AUDIT_PK, "=", pkValue).toArray())) {
            RetryOrmHelper.save(billAudit);
            return true;
        }
        return false;
    }
}

