/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fgptas.business.audit.schedule;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.fi.fgptas.business.audit.FGPTASAuditHelper;
import kd.fi.fgptas.business.audit.FGPTASAuditStatus;
import kd.fi.fgptas.business.audit.GaiRepoStatus;
import kd.fi.fgptas.business.audit.helper.RequestContextHelper;
import kd.fi.fgptas.business.audit.helper.RetryOrmHelper;

public class RagWaiting
implements Runnable {
    private static final AtomicLong AL = new AtomicLong(0L);
    private static final Log log = LogFactory.getLog(RagWaiting.class);
    private static final ScheduledExecutorService ses = Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, "Execute_RagWaiting-" + AL.incrementAndGet()));
    private static final ThreadPool POOL = ThreadPools.newFixedThreadPool((String)"RagWaiting", (int)2);
    private RequestContext requestContext;
    private String entityNumber;
    private Object billPK;
    private boolean useFGPTASUser;
    private boolean forced;
    private int count;

    public void setRequestContext(RequestContext requestContext) {
        this.requestContext = requestContext;
    }

    public void setEntityNumber(String entityNumber) {
        this.entityNumber = entityNumber;
    }

    public void setBillPK(Object billPK) {
        this.billPK = billPK;
    }

    public void setUseFGPTASUser(boolean useFGPTASUser) {
        this.useFGPTASUser = useFGPTASUser;
    }

    public void setForced(boolean forced) {
        this.forced = forced;
    }

    public void setCount(int count) {
        this.count = count;
    }

    @Override
    public void run() {
        try {
            log.info(this.billPK + ":try rag waiting process:" + this.count);
            if (this.requestContext != null) {
                RequestContextHelper.copy(this.requestContext, "");
            }
            if (this.count >= 3) {
                log.info("[count = 3]stop the waiting");
                return;
            }
            FGPTASAuditHelper context = new FGPTASAuditHelper(this.entityNumber, this.useFGPTASUser);
            context.setBillPK(this.billPK);
            context.setForced(this.forced);
            QFilter[] qFilters = new QFilter[]{new QFilter("id", "=", context.getBillAuditPk())};
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)"fgptas_billaudit", (String)"gairepo.id,runtimestatus", (QFilter[])qFilters);
            long repoId = obj.getLong("gairepo.id");
            FGPTASAuditStatus status = FGPTASAuditStatus.keyOf(obj.getString("runtimestatus"));
            if (repoId == 0L || status == null) {
                return;
            }
            GaiRepoStatus repoStatus = GaiRepoStatus.keyOf(context.queryRepoInfo(repoId, data -> data.get("status")) + "");
            log.info("current repo status:" + repoStatus.name() + ", current runtime status:" + (Object)((Object)FGPTASAuditStatus.keyOf(obj.getString("runtimestatus"))));
            if (repoStatus == GaiRepoStatus.SUCCESS) {
                context.process();
            } else if (repoStatus == GaiRepoStatus.RUNNING) {
                if (status != FGPTASAuditStatus.EMBEDDING_PROCESSING) {
                    obj.set("runtimestatus", (Object)FGPTASAuditStatus.EMBEDDING_PROCESSING.getKey());
                    FGPTASAuditHelper.saveRequiresNew(new DynamicObject[]{obj});
                }
                RagWaiting.execute(context, this.count + 1);
            } else if (status != FGPTASAuditStatus.EMBEDDING_ERROR) {
                obj.set("runtimestatus", (Object)FGPTASAuditStatus.EMBEDDING_ERROR.getKey());
                FGPTASAuditHelper.saveRequiresNew(new DynamicObject[]{obj});
                obj = BusinessDataServiceHelper.loadSingle((String)"fgptas_billaudit", (String)"billno,runtimestatus,ocr_status,ocr_error,riskentry", (QFilter[])qFilters);
                RetryOrmHelper.save(obj);
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }

    public static void execute(FGPTASAuditHelper context) {
        RagWaiting.execute(context, 0);
    }

    public static void execute(FGPTASAuditHelper context, int count) {
        RagWaiting ragWaiting = new RagWaiting();
        ragWaiting.entityNumber = context.getEntityNumber();
        ragWaiting.billPK = context.getBillPK();
        ragWaiting.useFGPTASUser = context.isUseFgptasUser();
        ragWaiting.forced = context.isForced();
        ragWaiting.count = count;
        ragWaiting.requestContext = RequestContext.copy((RequestContext)RequestContext.get());
        DynamicObject config = context.getAuditConfig().getConfigDyo();
        int timeout = config.getInt("embbeding_timeout");
        timeout = timeout <= 0 ? 5000 : timeout;
        ses.schedule(() -> POOL.execute((Runnable)ragWaiting), (long)timeout, TimeUnit.MILLISECONDS);
    }
}

