/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fgptas.business.audit.schedule;

import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fgptas.business.audit.helper.AuditConfigSearcher;
import kd.fi.fgptas.business.audit.helper.BillAuditHelper;
import kd.fi.fgptas.business.audit.helper.RetryOrmHelper;
import org.apache.commons.lang3.math.NumberUtils;

public class RetryBillAuditTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(RetryBillAuditTask.class);

    public void execute(RequestContext context, Map<String, Object> params) throws KDException {
        Set<Long> billAudits = RetryOrmHelper.query(params);
        for (Long billAuditPK : billAudits) {
            long entityId;
            String entityNumber;
            block8: {
                DynamicObject obj = QueryServiceHelper.queryOne((String)"fgptas_billaudit", (String)"entityobject,entityid,configid", (QFilter[])new QFilter("id", "=", (Object)billAuditPK).toArray());
                if (obj == null) {
                    log.error("Bill audit " + billAuditPK + " is not exist and delete the retry info!");
                    RetryOrmHelper.delete(billAuditPK);
                    continue;
                }
                entityNumber = obj.getString("entityobject");
                entityId = obj.getLong("entityid");
                if (StringUtils.isBlank((CharSequence)entityNumber) || entityId == 0L) {
                    log.error(String.format("Bill audit [%s_%s_%s] is invalid and delete the retry info!", billAuditPK, entityNumber, entityId));
                    RetryOrmHelper.delete(billAuditPK);
                    continue;
                }
                try {
                    DynamicObject dataEntity = BusinessDataServiceHelper.loadSingle((Object)entityId, (String)entityNumber);
                    DynamicObject auditConfig = new AuditConfigSearcher().search(dataEntity);
                    long configId = obj.getLong("configid");
                    Object pkValue = auditConfig.getPkValue();
                    if (configId == 0L || NumberUtils.toLong((String)(pkValue + ""), (long)0L) == configId) {
                        log.warn(String.format("Bill audit [%s_%s_%s] config change from %s to %s and delete the retry info!", billAuditPK, entityNumber, entityId, configId, pkValue));
                        RetryOrmHelper.delete(billAuditPK);
                    }
                    break block8;
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                }
                continue;
            }
            int timeoutSeconds = NumberUtils.toInt((String)(params.get("timeoutSeconds") + ""), (int)-1);
            try {
                BillAuditHelper.gptCallSync(entityNumber, entityId, false, true, timeoutSeconds);
            }
            catch (Exception e) {
                log.error("Bill audit " + billAuditPK, (Throwable)e);
            }
        }
    }
}

