/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fgptas.business.audit.strategy;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.ErrorCode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.fgptas.business.audit.BillAuditResult;
import kd.fi.fgptas.business.audit.FGPTASAuditHelper;
import kd.fi.fgptas.business.audit.error.AuditErrorCode;

public abstract class AbsBillAudit {
    protected String type;
    protected FGPTASAuditHelper context;
    protected final BillAuditResult result = new BillAuditResult();
    protected DynamicObject billAudit;
    private static final Log log = LogFactory.getLog(AbsBillAudit.class);
    public static final AbsBillAudit NullBillAudit = new AbsBillAudit(){

        @Override
        protected void enhance(List<Map<String, Object>> attachInfos) {
        }

        @Override
        protected void gptCall() {
        }

        @Override
        protected void beforeFinally() {
            this.result.setSuccess(true);
            this.result.setError(null);
        }
    };

    public AbsBillAudit() {
        this.result.setSuccess(true);
    }

    public void setContext(FGPTASAuditHelper context) {
        this.context = context;
    }

    public final BillAuditResult processBillAudit() {
        List<Map<String, Object>> attachInfos = this.context.getAttachInfosByType(this.type);
        this.loadSingleBillAudit();
        this.doRunnable(new NamedRunnable("excludeAttachment", () -> {
            log.info("before excludeAttachment:" + attachInfos);
            this.excludeAttachment(attachInfos);
            log.info(String.format("after excludeAttachment:%s, result:%s", attachInfos, this.result));
        }), new NamedRunnable("bindAttachment", () -> {
            log.info("before bindAttachment:" + attachInfos);
            this.bindAttachment(attachInfos);
            log.info(String.format("after bindAttachment:%s, result:%s", attachInfos, this.result));
        }), new NamedRunnable("enhance", () -> {
            log.info("before enhance:" + attachInfos);
            this.enhance(attachInfos);
            log.info(String.format("after enhance:%s, result:%s", attachInfos, this.result));
        }), new NamedRunnable("afterEnhance", this::afterEnhance), new NamedRunnable("gptCall", this::gptCall));
        return this.result;
    }

    private void loadSingleBillAudit() {
        this.billAudit = this.context.getBillAudit();
    }

    protected void excludeAttachment(List<Map<String, Object>> attachInfos) {
    }

    protected void bindAttachment(List<Map<String, Object>> attachInfos) {
    }

    protected abstract void enhance(List<Map<String, Object>> var1);

    protected void afterEnhance() {
    }

    protected abstract void gptCall();

    protected void beforeFailureReturn() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRunnable(NamedRunnable ... runs) {
        String name = "";
        try {
            for (NamedRunnable run : runs) {
                name = this.getClass().getSimpleName() + "#" + run.name + "#bill-" + this.context.getBillPK() + "#audit-" + this.context.getBillAuditPk();
                run.run();
                if (this.result.isSuccess()) continue;
                log.error("fail to " + name);
                this.beforeFailureReturn();
                return;
            }
        }
        catch (Exception ex) {
            log.error("fail to " + name + "\n", (Throwable)ex);
            StringWriter sw = new StringWriter();
            ex.printStackTrace(new PrintWriter(sw));
            ErrorCode errorCode = AuditErrorCode.UNEXPECTED_ERROR_BUILDER.apply(name + ":\n" + sw);
            this.result.setError(errorCode);
            this.beforeFailureReturn();
        }
        finally {
            this.beforeFinally();
        }
    }

    protected void beforeFinally() {
    }

    private static class NamedRunnable {
        String name;
        Runnable runnable;

        public NamedRunnable(String name, Runnable runnable) {
            this.name = name;
            this.runnable = runnable;
        }

        public void run() {
            this.runnable.run();
        }
    }
}

