/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fgptas.business.audit.strategy;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.fi.fgptas.business.audit.BaiduOcrResultStatus;
import kd.fi.fgptas.business.audit.FGPTASAuditHelper;
import kd.fi.fgptas.business.audit.OcrStatus;
import kd.fi.fgptas.business.audit.baidu.BaiDuRequestHelper;
import kd.fi.fgptas.business.audit.error.AuditErrorCode;
import kd.fi.fgptas.business.audit.strategy.AbsBillAudit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class OcrBillAudit
extends AbsBillAudit {
    private static final Log log = LogFactory.getLog(OcrBillAudit.class);
    private final List<AttachOcr> attachOcrList;

    public OcrBillAudit() {
        this.type = "2";
        this.attachOcrList = new ArrayList<AttachOcr>();
    }

    @Override
    protected void excludeAttachment(List<Map<String, Object>> attachInfos) {
        if (attachInfos == null || attachInfos.isEmpty()) {
            log.error("no image attachment");
            this.result.setError(AuditErrorCode.NO_ATTACHMENT);
            attachInfos = new ArrayList<Map<String, Object>>(0);
        }
        Set pkFromAttachInfos = attachInfos.stream().map(a -> NumberUtils.toLong((String)(a.get("attPkId") + ""), (long)0L)).collect(Collectors.toSet());
        DynamicObjectCollection ocrEntry = this.billAudit.getDynamicObjectCollection("ocrentry");
        Iterator iterator = ocrEntry.iterator();
        while (iterator.hasNext()) {
            DynamicObject ocr = (DynamicObject)iterator.next();
            long attPK = ocr.getLong("attpk");
            String status = ocr.getString("status");
            if (!pkFromAttachInfos.contains(attPK)) {
                iterator.remove();
                continue;
            }
            if (!"10".equals(status)) continue;
            attachInfos.removeIf(a -> NumberUtils.toLong((String)(a.get("attPkId") + ""), (long)0L) == attPK);
        }
    }

    @Override
    protected void bindAttachment(List<Map<String, Object>> attachInfos) {
        DynamicObjectCollection ocrEntry = this.billAudit.getDynamicObjectCollection("ocrentry");
        Set pkFromCollection = ocrEntry.stream().map(o -> o.getLong("attpk")).collect(Collectors.toSet());
        attachInfos.stream().filter(attachInfo -> !pkFromCollection.contains(NumberUtils.toLong((String)(attachInfo.get("attPkId") + ""), (long)0L))).forEach(attachInfo -> {
            DynamicObject ocr = ocrEntry.addNew();
            ocr.set("attpk", attachInfo.get("attPkId"));
            ocr.set("attachname", attachInfo.get("name"));
            ocr.set("relativepath", attachInfo.get("relativeUrl"));
            ocr.set("attachurl", attachInfo.get("url"));
            ocr.set("status", (Object)"1");
        });
        pkFromCollection.clear();
        ocrEntry.stream().filter(o -> BaiduOcrResultStatus.RETRY_OCR.contains(o.getString("status"))).map(o -> o.getLong("attpk")).forEach(pkFromCollection::add);
        attachInfos.removeIf(a -> !pkFromCollection.contains(NumberUtils.toLong((String)(a.get("attPkId") + ""), (long)0L)));
        if (attachInfos.isEmpty()) {
            log.info("the image attachments are ready.");
        } else {
            this.billAudit.set("ocr_status", (Object)OcrStatus.RUNNING.getKey());
            this.billAudit = FGPTASAuditHelper.saveRequiresNew(new DynamicObject[]{this.billAudit})[0];
        }
    }

    @Override
    public void enhance(List<Map<String, Object>> attachInfos) {
        for (Map<String, Object> attachInfo : attachInfos) {
            try {
                Map<String, Object> ocrResult = BaiDuRequestHelper.getOcr(attachInfo.get("relativeUrl") + "", attachInfo.get("type") + "");
                AttachOcr attachOcr = new AttachOcr(attachInfo, ocrResult);
                this.attachOcrList.add(attachOcr);
            }
            catch (Exception e) {
                HashMap<String, Object> ocrResult = new HashMap<String, Object>(2);
                ocrResult.put("error_code", "unexpected and throw");
                ocrResult.put("error_description", e.getMessage());
                AttachOcr attachOcr = new AttachOcr(attachInfo, ocrResult);
                this.attachOcrList.add(attachOcr);
            }
        }
    }

    @Override
    protected void afterEnhance() {
        if (this.attachOcrList.isEmpty()) {
            return;
        }
        DynamicObjectCollection ocrEntry = this.billAudit.getDynamicObjectCollection("ocrentry");
        log.info("ocrEntry size:" + ocrEntry.size());
        for (AttachOcr attachOcr : this.attachOcrList) {
            this.fillEntry(ocrEntry, attachOcr);
        }
        this.attachOcrList.clear();
    }

    private void fillEntry(DynamicObjectCollection ocrEntry, AttachOcr attachOcr) {
        for (DynamicObject ocr : ocrEntry) {
            String status;
            Object relativePath = ocr.get("relativepath");
            Object path = attachOcr.attachInfo.get("relativeUrl");
            if (!StringUtils.equals((CharSequence)(relativePath + ""), (CharSequence)(path + ""))) continue;
            Map<String, Object> ocrResult = attachOcr.ocrResult;
            int diff = 0;
            if (BaiDuRequestHelper.isError(ocrResult)) {
                status = "0";
            } else {
                List wordsResult = (List)ocrResult.get("words_result");
                int num = NumberUtils.toInt((String)(ocrResult.get("words_result_num") + ""), (int)0);
                if (num == 0) {
                    status = "0";
                } else {
                    status = "10";
                    int realNum = wordsResult.stream().filter(r -> r.containsKey("result")).mapToInt(r -> 1).sum();
                    if (realNum != 0) {
                        diff = num - realNum;
                    }
                }
            }
            ocr.set("ocrresponse_tag", (Object)SerializationUtils.toJsonString(ocrResult));
            ocr.set("status", (Object)status);
            ocr.set("unknowncount", (Object)diff);
        }
    }

    @Override
    public void gptCall() {
        boolean success = OcrStatus.SUCCESS.getKey().equals(this.billAudit.getString("ocr_status"));
        if (!this.context.isForced() && success) {
            return;
        }
        DynamicObject configEntity = this.context.getAuditConfig().getConfigDyo();
        long promptImg = NumberUtils.toLong((String)(configEntity.getDynamicObject("prompt_img").getPkValue() + ""), (long)0L);
        if (promptImg == 0L) {
            this.result.setError(AuditErrorCode.NO_OCR_PROMPT);
            log.error(configEntity.getString("name") + "[prompt_img] is not configured");
            return;
        }
        this.gptCallOne(this.billAudit);
        this.billAudit.set("ocr_status", (Object)OcrStatus.SUCCESS.getKey());
    }

    private void gptCallOne(DynamicObject ocr) {
        DynamicObjectCollection ocrEntry = ocr.getDynamicObjectCollection("ocrentry");
        StringJoiner gptBackResult = new StringJoiner("\n");
        StringJoiner errorInfo = new StringJoiner("\n");
        int count = 1;
        for (DynamicObject object : ocrEntry) {
            StringJoiner sj = new StringJoiner("\n");
            String status = object.getString("status");
            String curAttachName = object.getString("attachname");
            if (!"10".equals(status)) {
                errorInfo.add(curAttachName + " has no ocr result.");
                continue;
            }
            String title = String.format(ResManager.loadKDString((String)"\u9644\u4ef6%1$s\u7684\u4fe1\u606f\uff1a", (String)"OcrBillAudit_2", (String)"fi-fgptas-business", (Object[])new Object[0]), count++);
            String response = object.getString("ocrresponse_tag");
            Map res = (Map)SerializationUtils.fromJsonString((String)response, LinkedHashMap.class);
            List wordsResult = (List)res.get("words_result");
            List ocrResult = (wordsResult = Optional.ofNullable(wordsResult).orElseGet(ArrayList::new)).stream().filter(wr -> wr.containsKey("result")).collect(Collectors.toList());
            List list = ocrResult = ocrResult.isEmpty() ? wordsResult.stream().filter(wr -> wr.containsKey("words")).collect(Collectors.toList()) : ocrResult;
            if (ocrResult.isEmpty()) {
                errorInfo.add(curAttachName + " has ocr result but invalid{valid paths: $.words_result[*].result/$.words_result[*].words]}");
                log.warn(curAttachName + " get ocr successfully but response is invalid");
            }
            sj.add(title + SerializationUtils.toJsonString(ocrResult));
            DynamicObject configEntity = this.context.getAuditConfig().getConfigDyo();
            long promptImg = NumberUtils.toLong((String)(configEntity.getDynamicObject("prompt_img").getPkValue() + ""), (long)0L);
            String v1 = sj.toString();
            String v2 = this.billAudit.getString("ocr_element");
            v2 = StringUtils.isBlank((CharSequence)v2) ? ResManager.loadKDString((String)"\u6587\u4ef6\u4e2d\u7684\u4fe1\u606f", (String)"AuditConfig_1", (String)"fi-fgptas-business", (Object[])new Object[0]) : v2;
            HashMap<String, String> variableMap = new HashMap<String, String>();
            variableMap.put("v1", v1);
            variableMap.put("v2", v2);
            log.info("ocr element:" + v2 + ", ocr response:" + v1);
            Object[] params = new Object[]{promptImg, ResManager.loadKDString((String)"\u8f93\u51fa", (String)"OcrBillAudit_1", (String)"fi-fgptas-business", (Object[])new Object[0]), variableMap};
            Object gptResult = DispatchServiceHelper.invokeBizService((String)"ai", (String)"gai", (String)"GaiPromptService", (String)"syncCall", (Object[])params);
            if (gptResult == null) {
                errorInfo.add(curAttachName + " get null from GaiPromptService.syncCall.");
                log.error("ocr name:" + curAttachName + ", gptcall response is null");
                continue;
            }
            String jsonString = JSON.toJSONString((Object)gptResult);
            JSONObject gptJsonObject = JSON.parseObject((String)jsonString);
            if ("0".equals(gptJsonObject.get((Object)"errCode"))) {
                String llmValue = ((Map)gptJsonObject.get((Object)"data")).get("llmValue") + "";
                llmValue = FGPTASAuditHelper.renderLLMValue(llmValue);
                String attpk = object.getString("attpk");
                gptBackResult.add("attachmentid\uff1a" + attpk);
                gptBackResult.add(llmValue);
                continue;
            }
            errorInfo.add(curAttachName + " GaiPromptService.syncCall:" + jsonString);
            log.error("ocr name:" + curAttachName + ", gptcall response:" + jsonString);
        }
        String gptResult = gptBackResult.toString();
        String error = errorInfo.toString();
        if (StringUtils.isNotBlank((CharSequence)error)) {
            this.result.setError(AuditErrorCode.UNEXPECTED_ERROR_BUILDER.apply(error));
        }
        if (StringUtils.isNotBlank((CharSequence)gptResult)) {
            this.billAudit.set("ocr_output_tag", (Object)gptResult);
            this.result.setChanged(true);
            this.result.setError(null);
            this.billAudit.set("ocr_error", (Object)error);
        }
    }

    public static String joinOcrResponse(DynamicObject ocr) {
        DynamicObjectCollection ocrEntry = ocr.getDynamicObjectCollection("ocrentry");
        StringJoiner sj = new StringJoiner("\n");
        int count = 1;
        for (DynamicObject object : ocrEntry) {
            String status = object.getString("status");
            if (!"10".equals(status)) continue;
            String title = String.format(ResManager.loadKDString((String)"\u9644\u4ef6%1$s\u7684\u4fe1\u606f\uff1a", (String)"OcrBillAudit_2", (String)"fi-fgptas-business", (Object[])new Object[0]), count++);
            String response = object.getString("ocrresponse_tag");
            Map res = (Map)SerializationUtils.fromJsonString((String)response, LinkedHashMap.class);
            List wordsResult = (List)res.get("words_result");
            List result = (wordsResult = Optional.ofNullable(wordsResult).orElseGet(ArrayList::new)).stream().filter(wr -> wr.containsKey("result")).collect(Collectors.toList());
            List list = result = result.isEmpty() ? wordsResult.stream().filter(wr -> wr.containsKey("words")).collect(Collectors.toList()) : result;
            if (result.isEmpty()) {
                log.warn(object.getString("attachname") + " get ocr successfully but response is invalid");
            }
            sj.add(title + SerializationUtils.toJsonString(result));
        }
        return sj.toString();
    }

    @Override
    protected void beforeFailureReturn() {
        String errorText = SerializationUtils.toJsonString((Object)this.result);
        errorText = errorText.length() > 2000 ? errorText.substring(0, 2000) : errorText;
        this.billAudit.set("ocr_error", (Object)errorText);
        this.billAudit.set("ocr_status", (Object)OcrStatus.FAIL.getKey());
    }

    @Override
    protected void beforeFinally() {
        if (this.result.isSuccess()) {
            this.billAudit.set("ocr_error", null);
            this.billAudit.set("ocr_status", (Object)OcrStatus.SUCCESS.getKey());
        }
        this.billAudit = FGPTASAuditHelper.saveRequiresNew(new DynamicObject[]{this.billAudit})[0];
    }

    static class AttachOcr {
        Map<String, Object> attachInfo;
        Map<String, Object> ocrResult;

        public AttachOcr(Map<String, Object> attachInfo, Map<String, Object> ocrResult) {
            this.attachInfo = attachInfo;
            this.ocrResult = ocrResult;
        }
    }
}

