/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fgptas.business.audit.strategy;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.fgptas.business.audit.FGPTASAuditStatus;
import kd.fi.fgptas.business.audit.error.AuditErrorCode;
import kd.fi.fgptas.business.audit.schedule.RagWaiting;
import kd.fi.fgptas.business.audit.strategy.AbsBillAudit;

public class RagBillAudit
extends AbsBillAudit {
    private static final Log log = LogFactory.getLog(RagBillAudit.class);

    public RagBillAudit() {
        this.type = "1";
    }

    @Override
    protected void enhance(List<Map<String, Object>> attachInfos) {
        boolean embedding = this.context.embedding();
        if (!embedding) {
            this.result.setError(AuditErrorCode.EMBEDDING_NOT_OK);
        }
    }

    @Override
    protected void gptCall() {
        String outTag = this.billAudit.getString("output_tag");
        boolean b = this.context.attachmentAudit(this.context.isForced());
        if (!b) {
            this.result.setError(AuditErrorCode.RAG_CALL_NOT_OK);
        } else if (outTag != null && !outTag.equals(this.billAudit.getString("output_tag"))) {
            this.result.setChanged(true);
        }
    }

    @Override
    protected void beforeFinally() {
        DynamicObject billAudit = this.context.getBillAudit();
        if (billAudit != null && FGPTASAuditStatus.EMBEDDING_PROCESSING.getKey().equals(billAudit.getString("runtimestatus"))) {
            log.info(this.context.getBillPK() + ": rag embedding is not ready and turn to inner waiting schedule.");
            RagWaiting.execute(this.context);
        }
    }
}

