/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fgptas.business.datatable;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.form.FormShowParameter;
import kd.bos.isv.ISVService;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.metadata.devportal.AppReader;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;

public class ExtAppUtil {
    public static String getExtApp(String bizCloudId, String bizAppId) {
        Map<String, Object> createResult;
        String extAppId = ExtAppUtil.getAppExtAppId(bizAppId);
        if (StringUtils.isNotBlank((CharSequence)extAppId)) {
            return extAppId;
        }
        DynamicObject dynamicObject = ExtAppUtil.generateExtBaseInfo(bizCloudId, bizAppId);
        if (dynamicObject != null && "true".equalsIgnoreCase((createResult = ExtAppUtil.createAndGetExtAppMetaData(dynamicObject)).get("success").toString())) {
            return ExtAppUtil.getAppExtAppId(bizAppId);
        }
        return null;
    }

    private static String getAppExtAppId(String bizAppId) {
        QFilter[] filters;
        DynamicObject dynamicObject;
        QFilter q = new QFilter("parentid", "=", (Object)bizAppId);
        q.and(new QFilter("type", "=", (Object)"2"));
        String currentIsv = ISVService.getISVInfo().getId();
        QFilter qIsv = new QFilter("isv", "=", (Object)currentIsv);
        if ("kingdee".equalsIgnoreCase(currentIsv)) {
            QFilter qIsvNull = new QFilter("isv", "is null", (Object)Boolean.TRUE);
            qIsvNull = qIsvNull.or(new QFilter("isv", "=", (Object)" "));
            qIsv = qIsv.or(qIsvNull);
        }
        if ((dynamicObject = QueryServiceHelper.queryOne((String)"bos_devportal_bizapp", (String)"*", (QFilter[])(filters = new QFilter[]{q, qIsv}))) != null) {
            return dynamicObject.getString("id");
        }
        return null;
    }

    private static DynamicObject generateExtBaseInfo(String bizCloudId, String bizAppId) {
        DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((Object)bizAppId, (String)"bos_devportal_bizapp");
        if (obj == null && (obj = BusinessDataServiceHelper.loadSingle((Object)bizAppId, (String)"bos_devportal_bizapp")) == null) {
            return null;
        }
        ExtAppUtil.removeNotNeedProps(obj);
        ExtAppUtil.setInheritPath(obj, bizAppId);
        ExtAppUtil.generateExtAppNumber(obj, bizAppId, bizCloudId);
        obj.set("type", (Object)"2");
        obj.set("parentid", (Object)bizAppId);
        if (StringUtils.isBlank((CharSequence)obj.getString("masterid"))) {
            obj.set("masterid", (Object)bizAppId);
        }
        ExtAppUtil.dealDbAndDbRoute(obj);
        ExtAppUtil.setImage(obj);
        AppMetadata appMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
        LocaleString metaDesc = appMeta.getAppElement().getDescription();
        obj.set("description", (Object)metaDesc);
        String version = DevportalUtil.getAppVerion((String)obj.getString("number"));
        if (StringUtils.isNotBlank((CharSequence)version)) {
            obj.set("version", (Object)version);
        }
        return obj;
    }

    public static Map<String, Object> createAndGetExtAppMetaData(DynamicObject obj) {
        String checkResult = ExtAppUtil.checkAppBeforeCreate(obj);
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (checkResult.length() > 0) {
            map.put("success", Boolean.FALSE);
            map.put("message", checkResult);
            return map;
        }
        Map result = AppMetaServiceHelper.save((DynamicObject)obj);
        return result;
    }

    private static void removeNotNeedProps(DynamicObject obj) {
        DataEntityPropertyCollection properties = obj.getDataEntityType().getProperties();
        List needRemoveProps = properties.stream().filter(prop -> prop instanceof DynamicLocaleProperty).map(IMetadata::getName).collect(Collectors.toList());
        if (needRemoveProps != null && needRemoveProps.size() > 0) {
            for (String prop2 : needRemoveProps) {
                obj.set(prop2, null);
            }
        }
        String appIsv = AppUtils.getDeveloperInfo();
        obj.set("isv", (Object)appIsv);
        obj.set("id", (Object)"");
    }

    private static void setInheritPath(DynamicObject obj, String bizAppId) {
        String parentInheritPath = obj.getString("inheritpath");
        String inheritPath = "";
        if (StringUtils.isNotBlank((CharSequence)parentInheritPath)) {
            if (parentInheritPath.startsWith(",")) {
                parentInheritPath = parentInheritPath.substring(1);
            }
            inheritPath = parentInheritPath + "," + bizAppId;
        } else {
            inheritPath = bizAppId;
        }
        obj.set("inheritpath", (Object)inheritPath);
    }

    private static void generateExtAppNumber(DynamicObject obj, String bizAppId, String bizCloudId) {
        String number = AppReader.getAppNumberById((String)bizAppId);
        number = AppUtils.autoExtendedNumber((String)number);
        number = AppUtils.autoAppNumber((String)bizCloudId, (String)number, (String)"_ext");
        obj.set("number", (Object)number.toLowerCase());
    }

    private static void dealDbAndDbRoute(DynamicObject obj) {
        String db;
        String dbRoute = obj.getString("dbroute");
        if (dbRoute == null) {
            return;
        }
        JSONObject instance = DevportalUtil.getDbInstanceInfo((String)(dbRoute = dbRoute.toLowerCase()));
        if (instance != null && StringUtils.isNotBlank((Object)instance.get((Object)"number"))) {
            obj.set("db", (Object)instance.get((Object)"number").toString());
        }
        if (StringUtils.isEmpty((CharSequence)(db = obj.getString("db")))) {
            obj.set("db", (Object)"sys");
        }
    }

    private static void setImage(DynamicObject obj) {
        String image = obj.getString("image");
        String backImage = obj.getString("backimage");
        if (StringUtils.isNotBlank((CharSequence)image)) {
            // empty if block
        }
        if (StringUtils.isNotBlank((CharSequence)backImage)) {
            // empty if block
        }
    }

    private static String checkAppBeforeCreate(DynamicObject obj) {
        String mainForm = obj.getString("mainformname");
        String dependency = obj.getString("dependency");
        if (StringUtils.isBlank((CharSequence)mainForm)) {
            obj.set("mainformid", (Object)" ");
            obj.set("mainformname", (Object)" ");
        }
        if (StringUtils.isBlank((CharSequence)dependency)) {
            obj.set("dependencyid", (Object)" ");
            obj.set("dependency", (Object)" ");
        }
        String number = obj.getString("number");
        String appIsv = AppUtils.getDeveloperInfo();
        number = DevportalUtil.autoIsvNumber((String)number, (String)appIsv);
        obj.set("number", (Object)number);
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("");
        formShowParameter.setStatus(OperationStatus.ADDNEW);
        return DevportalUtil.checkAppProperties((DynamicObject)obj, (FormShowParameter)formShowParameter).toString();
    }
}

