/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fgptas.business.datatable;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.property.BasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;

public interface IReportDataPull {
    public static final Log logger = LogFactory.getLog(IReportDataPull.class);

    default public List<Object> getBaseDataId(String dataTableNumber, String fieldNumber, QFilter[] filters, Object[] cusParams) {
        String entityName;
        if (StringUtils.isNotEmpty((String)dataTableNumber) && StringUtils.isNotEmpty((String)fieldNumber) && StringUtils.isNotEmpty((String)(entityName = this.getEntityNumber(dataTableNumber, fieldNumber)))) {
            ArrayList<Object> filterList = new ArrayList(filters != null ? filters.length : 0);
            if (filters != null && filters.length > 0) {
                filterList = new ArrayList<QFilter>(Arrays.asList(filters));
            }
            return QueryServiceHelper.queryPrimaryKeys((String)entityName, (QFilter[])filterList.toArray(new QFilter[0]), null, (int)200);
        }
        return null;
    }

    public String getData(String var1, Object[] var2);

    default public String getEntityNumber(String dataTableNumber, String fieldNumber) {
        DynamicProperty property = EntityMetadataCache.getDataEntityType((String)dataTableNumber).getProperty(fieldNumber);
        if (property instanceof BasedataProp) {
            return ((BasedataProp)property).getBaseEntityId();
        }
        return null;
    }

    default public boolean isBaseData(String dataTableNumber, String fieldNumber) {
        return EntityMetadataCache.getDataEntityType((String)dataTableNumber).getProperty(fieldNumber) instanceof BasedataProp;
    }

    default public String[] getFieldName(DynamicObject dyo, List<String> fieldList) {
        String[] nameArr = new String[fieldList.size()];
        for (int i = 0; i < fieldList.size(); ++i) {
            nameArr[i] = this.getFieldName(dyo, fieldList.get(i));
        }
        return nameArr;
    }

    default public String getFieldName(DynamicObject dyo, String fieldNumber) {
        for (DynamicObject ent : dyo.getDynamicObjectCollection("entryentity")) {
            if (!fieldNumber.equalsIgnoreCase(ent.getString("fieldnumber"))) continue;
            return ent.getString("fieldname");
        }
        return fieldNumber;
    }

    default public List<String> getFieldNumber(DynamicObject dyo) {
        ArrayList<String> fieldNumberList = new ArrayList<String>(16);
        for (DynamicObject ent : dyo.getDynamicObjectCollection("entryentity")) {
            fieldNumberList.add(ent.getString("fieldnumber").toLowerCase(Locale.ENGLISH));
        }
        return fieldNumberList;
    }

    default public List<String> getFieldNumberFromDic(Map<String, String> dicMap, List<String> fieldNumberList) {
        ArrayList<String> fieldNumberFromDicList = new ArrayList<String>(fieldNumberList.size());
        for (String fieldNumber : fieldNumberList) {
            fieldNumberFromDicList.add(dicMap.get(fieldNumber));
        }
        return fieldNumberFromDicList;
    }

    default public String getFieldFixedValue(DynamicObject dyo, String fieldNumber) {
        for (DynamicObject ent : dyo.getDynamicObjectCollection("entryentity")) {
            if (!fieldNumber.equalsIgnoreCase(ent.getString("fieldnumber"))) continue;
            return ent.getString("fixedvalue");
        }
        return null;
    }

    default public List<String> getBaseDataNumber(Map<String, String> nameMap, String dataTableNumber, String fieldNumber, QFilter[] filters) {
        DynamicObjectCollection dyoCol;
        String entityNumber = this.getEntityNumber(dataTableNumber, fieldNumber);
        if (StringUtils.isNotEmpty((String)entityNumber) && (dyoCol = QueryServiceHelper.query((String)entityNumber, (String)"number,name", (QFilter[])filters)) != null && !dyoCol.isEmpty()) {
            ArrayList<String> numberList = new ArrayList<String>(dyoCol.size());
            for (DynamicObject dy : dyoCol) {
                String number = dy.getString("number");
                if (nameMap != null) {
                    nameMap.put(number, dy.getString("name"));
                }
                numberList.add(number);
            }
            return numberList;
        }
        return null;
    }

    default public String getAccountNumber() {
        return null;
    }
}

