/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fgptas.business.datatable;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.fgptas.business.datatable.IReportDataPull;

public class IncomeStatementDataPull
implements IReportDataPull {
    private static final String[] MUST_PARAM_ARR = new String[]{"modelnum", "org", "year", "scenario", "period"};

    @Override
    public String getAccountNumber() {
        return "R2999";
    }

    @Override
    public List<Object> getBaseDataId(String dataTableNumber, String fieldNumber, QFilter[] filters, Object[] cusParams) {
        DynamicObject dyo;
        if (StringUtils.isNotEmpty((String)dataTableNumber) && StringUtils.isNotEmpty((String)fieldNumber) && (dyo = BusinessDataServiceHelper.loadSingle((String)"fgptas_datatable", (QFilter[])new QFilter("number", "=", (Object)dataTableNumber).toArray())) != null) {
            String entityName = this.getEntityNumber(dataTableNumber, fieldNumber);
            logger.info("fgptas getBaseDataId for dim--" + fieldNumber + ", entityName is " + entityName);
            if (StringUtils.isNotEmpty((String)entityName)) {
                ArrayList<QFilter> filterList = new ArrayList<QFilter>(filters != null ? filters.length + 3 : 3);
                if ("modelnum".equalsIgnoreCase(fieldNumber)) {
                    String modelNum;
                    filterList.add(new QFilter("status", "=", (Object)"C"));
                    if (filters != null && filters.length > 0) {
                        filterList.addAll(Arrays.asList(filters));
                    }
                    if (StringUtils.isEmpty((String)(modelNum = this.getFieldFixedValue(dyo, fieldNumber)))) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u4f53\u7cfb\u5b57\u6bb5\u56fa\u5b9a\u503c\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u7ef4\u62a4\u3002", (String)"IncomeStatementDataPull_9", (String)"fi-fgptas-business", (Object[])new Object[0]));
                    }
                    if (modelNum.contains(";")) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u4e2a\u6570\u636e\u8868\u5e94\u53ea\u5b58\u5728\u4e00\u4e2a\u4f53\u7cfb\u4e0b\uff0c\u3010%s\u3011\u5df2\u914d\u7f6e\u4e86\u591a\u4e2a\u4f53\u7cfb\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u8868\u914d\u7f6e\u5e76\u91cd\u65b0\u5206\u914d\u3002", (String)"IncomeStatementDataPull_17", (String)"fi-fgptas-business", (Object[])new Object[0]), EntityMetadataCache.getDataEntityType((String)dataTableNumber).getDisplayName().toString()));
                    }
                    logger.info("fgptas getBaseDataId modelnum fixedvalue is " + modelNum);
                    filterList.add(new QFilter("number", "=", (Object)modelNum));
                    logger.info("fgptas getBaseDataId modelnum filter is " + filterList);
                    List objects = QueryServiceHelper.queryPrimaryKeys((String)entityName, (QFilter[])filterList.toArray(new QFilter[0]), null, (int)1);
                    if (objects.isEmpty()) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u4f53\u7cfb\u5b57\u6bb5\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u67e5\u8be2\u5230\u76f8\u5173\u57fa\u7840\u8d44\u6599\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u7ef4\u62a4\u3002", (String)"IncomeStatementDataPull_0", (String)"fi-fgptas-business", (Object[])new Object[0]));
                    }
                    return objects;
                }
                List<Object> modelIdList = this.getBaseDataId(dataTableNumber, "modelnum", null, null);
                logger.info("fgptas getBaseDataId for dim--" + fieldNumber + ", modelnum is " + modelIdList);
                if (modelIdList != null && !modelIdList.isEmpty()) {
                    List objects;
                    filterList.add(new QFilter("enable", "=", (Object)"1"));
                    filterList.add(new QFilter("model", "=", modelIdList.get(0)));
                    if ("account".equalsIgnoreCase(fieldNumber)) {
                        filterList.add(new QFilter("longnumber", "like", (Object)("%" + this.getAccountNumber() + "!%")));
                    }
                    if (filters != null && filters.length > 0) {
                        filterList.addAll(Arrays.asList(filters));
                    }
                    logger.info("fgptas getBaseDataId for dim--" + fieldNumber + ", filter is " + filterList);
                    if ("bos_org".equals(entityName)) {
                        entityName = "bcm_entitymembertree";
                    }
                    if ((objects = QueryServiceHelper.queryPrimaryKeys((String)entityName, (QFilter[])filterList.toArray(new QFilter[0]), null, (int)200)).isEmpty()) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u672a\u67e5\u5230\u76f8\u5173\u57fa\u7840\u8d44\u6599\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u7ef4\u62a4\u3002", (String)"IncomeStatementDataPull_10", (String)"fi-fgptas-business", (Object[])new Object[0]));
                    }
                    return objects;
                }
            }
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u7f3a\u5c11\u5165\u53c2\u3002", (String)"IncomeStatementDataPull_11", (String)"fi-fgptas-business", (Object[])new Object[0]));
    }

    @Override
    public String getData(String sql, Object[] cusParams) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
        resultMap.put("errorCode", "fail");
        resultMap.put("success", Boolean.FALSE);
        resultMap.put("message", null);
        resultMap.put("data", null);
        if (StringUtils.isNotEmpty((String)sql) && sql.contains(" where ") && sql.contains(" from ")) {
            String[] sqlArr = sql.split(" where ");
            String tableName = sqlArr[0].split(" from ")[1].trim();
            QFilter filter = QFilter.of((String)sqlArr[1], (Object[])new Object[0]);
            List nests = filter.getNests(true);
            HashMap<String, Object> fieldValueMap = new HashMap<String, Object>(1 + nests.size());
            fieldValueMap.put(filter.getProperty().substring(tableName.startsWith("t_") ? 1 : 0), filter.getValue());
            for (QFilter.QFilterNest f : nests) {
                fieldValueMap.put(f.getFilter().getProperty().substring(tableName.startsWith("t_") ? 1 : 0), f.getFilter().getValue());
            }
            String dataTableNumber = tableName.substring(tableName.startsWith("t_") ? 2 : 0);
            DynamicObject dyo = BusinessDataServiceHelper.loadSingleFromCache((String)"fgptas_datatable", (QFilter[])new QFilter("number", "=", (Object)dataTableNumber).toArray());
            if (dyo != null) {
                HashMap<String, Map<String, String>> numberNameMap = new HashMap<String, Map<String, String>>(fieldValueMap.size() + 2);
                Map<String, List<String>> paramMap = this.getParamFromSql(fieldValueMap, numberNameMap, dataTableNumber, resultMap, cusParams);
                if (resultMap.get("message") != null) {
                    return JSON.toJSONString(resultMap);
                }
                List<String> noParamList = this.checkParam(paramMap);
                if (!noParamList.isEmpty()) {
                    if (noParamList.contains("modelnum")) {
                        resultMap.put("message", ResManager.loadKDString((String)"\u4f53\u7cfb\u5b57\u6bb5\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u67e5\u8be2\u5230\u76f8\u5173\u57fa\u7840\u8d44\u6599\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u7ef4\u62a4\u3002", (String)"IncomeStatementDataPull_0", (String)"fi-fgptas-business", (Object[])new Object[0]));
                    } else if (noParamList.contains("scenario") || noParamList.contains("period")) {
                        resultMap.put("message", ResManager.loadKDString((String)"\u672a\u5728\u8bed\u4e49\u4e2d\u8bc6\u522b\u5230\u7cfb\u7edf\u4e2d\u7684\u60c5\u666f/\u671f\u95f4\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"IncomeStatementDataPull_7", (String)"fi-fgptas-business", (Object[])new Object[0]));
                    } else {
                        resultMap.put("message", String.format(ResManager.loadKDString((String)"\u6570\u636e\u67e5\u8be2\u5931\u8d25\uff0c\u7f3a\u5c11\u3010%s\u3011\u5b57\u6bb5\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"IncomeStatementDataPull_1", (String)"fi-fgptas-business", (Object[])new Object[0]), String.join((CharSequence)",", noParamList)));
                    }
                } else {
                    List<Map<String, Object>> responseResultList = this.invokeBizService(paramMap, numberNameMap, resultMap, dyo);
                    this.handleResponseData(responseResultList, numberNameMap, resultMap, dyo);
                }
            } else {
                resultMap.put("message", String.format(ResManager.loadKDString((String)"\u6570\u636e\u8868\u914d\u7f6e\u7f16\u7801\u3010%s\u3011\u4e0d\u5b58\u5728\u3002", (String)"IncomeStatementDataPull_5", (String)"fi-fgptas-business", (Object[])new Object[0]), dataTableNumber));
            }
        } else {
            resultMap.put("message", ResManager.loadKDString((String)"\u5165\u53c2sql\u9519\u8bef\u3002", (String)"IncomeStatementDataPull_4", (String)"fi-fgptas-business", (Object[])new Object[0]));
        }
        return JSON.toJSONString(resultMap);
    }

    private Map<String, List<String>> getParamFromSql(Map<String, Object> fieldValueMap, Map<String, Map<String, String>> numberNameMap, String dataTableNumber, Map<String, Object> resultMap, Object[] cusParams) {
        HashMap<String, List<String>> paramMap = new HashMap<String, List<String>>(fieldValueMap.size());
        for (Map.Entry<String, Object> entry : fieldValueMap.entrySet()) {
            if (("scenario".equals(entry.getKey()) || "period".equals(entry.getKey())) && null != cusParams && StringUtils.isNotEmpty((String)String.valueOf(cusParams[0]))) continue;
            if (this.isBaseData(dataTableNumber, entry.getKey())) {
                Map nameMap = numberNameMap.computeIfAbsent(entry.getKey(), p -> new HashMap(((Collection)entry.getValue()).size()));
                List<String> numberList = this.getBaseDataNumber(nameMap, dataTableNumber, entry.getKey(), new QFilter("id", "in", entry.getValue()).toArray());
                if ("org".equalsIgnoreCase(entry.getKey())) {
                    DynamicObjectCollection entityCol;
                    List<Object> modelIdList = this.getBaseDataId(dataTableNumber, "modelnum", null, null);
                    HashSet orgNameSet = new HashSet(nameMap.values());
                    List orgNumberList = new ArrayList(numberList.size());
                    QFilter entityFilter = new QFilter("asstmember", "in", numberList).and("assttype", "=", (Object)ResManager.loadKDString((String)"\u7ec4\u7ec7", (String)"IncomeStatementDataPull_18", (String)"fi-fgptas-business", (Object[])new Object[0])).and("model", "=", modelIdList.get(0));
                    DynamicObjectCollection memberMapEntity = QueryServiceHelper.query((String)"bcm_membermapentity", (String)"bcmmember,asstmember", (QFilter[])entityFilter.toArray());
                    if (memberMapEntity != null && !memberMapEntity.isEmpty()) {
                        for (DynamicObject memberEntity : memberMapEntity) {
                            String asstMember = memberEntity.getString("asstmember");
                            String bcmMember = memberEntity.getString("bcmmember");
                            orgNumberList.add(bcmMember);
                            nameMap.put(bcmMember, nameMap.get(asstMember));
                            orgNameSet.remove(nameMap.get(asstMember));
                        }
                    }
                    if (!orgNameSet.isEmpty() && (entityCol = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"number,name", (QFilter[])(entityFilter = new QFilter("name", "in", orgNameSet).and("enable", "=", (Object)"1").and("model", "=", modelIdList.get(0))).toArray())) != null && !entityCol.isEmpty()) {
                        ArrayList<Object> entityNumberList = new ArrayList<Object>(entityCol.size());
                        for (DynamicObject entity : entityCol) {
                            String number = entity.getString("number");
                            String name = entity.getString("name");
                            if (numberList.contains(number) && name.equals(nameMap.get(number))) {
                                entityNumberList.clear();
                                entityNumberList.add(number);
                                nameMap.put(number, name);
                                break;
                            }
                            entityNumberList.add(number);
                            nameMap.put(number, name);
                        }
                        orgNumberList.addAll(entityNumberList);
                    }
                    if (orgNumberList.isEmpty()) {
                        HashMap<String, String> modelNameMap = new HashMap<String, String>(1);
                        List<String> modelNumList = this.getBaseDataNumber(modelNameMap, dataTableNumber, "modelnum", new QFilter("id", "in", modelIdList).toArray());
                        resultMap.put("message", String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u3010%1$s\u3011\u5728\u4f53\u7cfb\u3010%2$s\u3011\u4e0b\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"IncomeStatementDataPull_16", (String)"fi-fgptas-business", (Object[])new Object[0]), String.join((CharSequence)",", nameMap.values()), modelNumList.get(0) + " " + (String)modelNameMap.get(modelNumList.get(0))));
                        return paramMap;
                    }
                    orgNumberList = orgNumberList.stream().distinct().collect(Collectors.toList());
                    paramMap.put(entry.getKey(), orgNumberList);
                    continue;
                }
                numberList = numberList.stream().distinct().collect(Collectors.toList());
                paramMap.put(entry.getKey(), numberList);
                continue;
            }
            List values = ((List)entry.getValue()).stream().distinct().collect(Collectors.toList());
            paramMap.put(entry.getKey(), values);
        }
        if (null != cusParams && StringUtils.isNotEmpty((String)String.valueOf(cusParams[0]))) {
            List<Object> scenarioIdList = this.getBaseDataId(dataTableNumber, "scenario", null, null);
            if (scenarioIdList != null && !scenarioIdList.isEmpty()) {
                Map sceDyoMap = BusinessDataServiceHelper.loadFromCache((Object[])scenarioIdList.toArray(), (String)"bcm_scenemembertree");
                Map nameMapSce = numberNameMap.computeIfAbsent("scenario", p -> new HashMap(sceDyoMap.size()));
                Map nameMapPer = numberNameMap.computeIfAbsent("period", p -> new HashMap(16));
                HashMap<String, List> nameMapScePer = new HashMap<String, List>(sceDyoMap.size());
                ArrayList scePerList = new ArrayList(sceDyoMap.size());
                for (Map.Entry entry : sceDyoMap.entrySet()) {
                    DynamicObject sceDyo = (DynamicObject)entry.getValue();
                    nameMapSce.put(sceDyo.getString("number"), sceDyo.getString("name"));
                    HashMap<String, Object> map = new HashMap<String, Object>(2);
                    map.put("Scenario", sceDyo.getString("name"));
                    DynamicObjectCollection perDyoCol = sceDyo.getDynamicObjectCollection("sceneperiod");
                    List perNameList = nameMapScePer.computeIfAbsent(sceDyo.getString("number"), p -> new ArrayList(perDyoCol.size()));
                    ArrayList<String> perList = new ArrayList<String>(perDyoCol.size());
                    for (DynamicObject perDyo : perDyoCol) {
                        DynamicObject dyo = perDyo.getDynamicObject(1);
                        nameMapPer.put(dyo.getString("number"), dyo.getString("name"));
                        perNameList.add(dyo.getString("name"));
                        perList.add(dyo.getString("name"));
                    }
                    map.put("Period", perList);
                    if (perList.isEmpty()) continue;
                    scePerList.add(map);
                }
                HashMap fieldValueList = new HashMap(1);
                fieldValueList.put("sAndp", scePerList);
                HashMap<String, List<String>> matchField = new HashMap<String, List<String>>(1);
                matchField.put("matchField", Arrays.asList("Scenario", "Period"));
                HashMap<String, String> variableMap = new HashMap<String, String>(2);
                variableMap.put("matchField", JSON.toJSONString(matchField));
                variableMap.put("fieldValueList", JSON.toJSONString(fieldValueList));
                variableMap.put("UserInput", String.valueOf(cusParams[0]));
                long promptId = 1832684252462942208L;
                Object[] params = new Object[]{promptId, "1", variableMap};
                logger.info("fgptas getData gptRequestParam variableMap : " + variableMap);
                Map gptResult = (Map)DispatchServiceHelper.invokeBizService((String)"ai", (String)"gai", (String)"GaiPromptService", (String)"syncCall", (Object[])params);
                logger.info("fgptas getData gptResult : " + gptResult);
                if (gptResult != null && !"0".equals(gptResult.get("errCode"))) {
                    resultMap.put("message", gptResult.get("errMsg"));
                } else if (gptResult != null && "0".equals(gptResult.get("errCode")) && gptResult.get("data") != null) {
                    String text = (String)((Map)gptResult.get("data")).get("llmValue");
                    if (StringUtils.isNotEmpty((String)text)) {
                        text = text.substring(text.indexOf(123), text.lastIndexOf(125) + 1);
                        JSONObject valueObj = JSONObject.parseObject((String)text).getJSONObject("matchFieldValue");
                        Object scenario = valueObj.get((Object)"Scenario");
                        Object period = valueObj.get((Object)"Period");
                        if (scenario != null && period != null) {
                            List<Object> sceArray = scenario instanceof Collection ? (List<Object>)scenario : Collections.singletonList(scenario);
                            List<Object> perArray = period instanceof Collection ? (List<Object>)period : Collections.singletonList(period);
                            for (Object e : sceArray) {
                                String sceNumber = "";
                                for (Map.Entry entry : nameMapSce.entrySet()) {
                                    if (!((String)entry.getValue()).equalsIgnoreCase(String.valueOf(e))) continue;
                                    sceNumber = (String)entry.getKey();
                                    break;
                                }
                                if (!StringUtils.isNotEmpty((String)sceNumber)) continue;
                                List perNameList = (List)nameMapScePer.get(sceNumber);
                                perNameList.retainAll(perArray);
                                if (perNameList.isEmpty()) continue;
                                List<Object> perNumberList = new ArrayList(perNameList.size());
                                for (Object perName : perNameList) {
                                    for (Map.Entry entry : nameMapPer.entrySet()) {
                                        if (!((String)entry.getValue()).equalsIgnoreCase(String.valueOf(perName))) continue;
                                        perNumberList.add(entry.getKey());
                                    }
                                }
                                if (perNumberList.isEmpty()) continue;
                                List sceNumList = Collections.singletonList(sceNumber).stream().distinct().collect(Collectors.toList());
                                perNumberList = perNumberList.stream().distinct().collect(Collectors.toList());
                                paramMap.put("scenario", sceNumList);
                                paramMap.put("period", perNumberList);
                                break;
                            }
                        }
                        if (!paramMap.containsKey("scenario") || !paramMap.containsKey("period")) {
                            if (scenario != null && period != null) {
                                resultMap.put("message", String.format(ResManager.loadKDString((String)"\u901a\u8fc7\u8bed\u4e49\u8bc6\u522b\u5230\u7684\u60c5\u666f\u4e3a%1$s\uff0c\u671f\u95f4\u4e3a%2$s\uff0c\u672a\u5339\u914d\u5230\u7cfb\u7edf\u4e2d\u7684\u60c5\u666f/\u671f\u95f4\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"IncomeStatementDataPull_8", (String)"fi-fgptas-business", (Object[])new Object[0]), scenario, period));
                            } else if (scenario == null && period == null) {
                                resultMap.put("message", ResManager.loadKDString((String)"\u672a\u4ece\u8bed\u4e49\u8bc6\u522b\u5230\u60c5\u666f\u548c\u671f\u95f4\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"IncomeStatementDataPull_14", (String)"fi-fgptas-business", (Object[])new Object[0]));
                            } else if (period == null) {
                                resultMap.put("message", String.format(ResManager.loadKDString((String)"\u901a\u8fc7\u8bed\u4e49\u8bc6\u522b\u5230\u7684\u60c5\u666f\u4e3a%1$s\uff0c\u672a\u8bc6\u522b\u5230\u671f\u95f4\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"IncomeStatementDataPull_12", (String)"fi-fgptas-business", (Object[])new Object[0]), scenario));
                            } else {
                                resultMap.put("message", String.format(ResManager.loadKDString((String)"\u901a\u8fc7\u8bed\u4e49\u8bc6\u522b\u5230\u7684\u671f\u95f4\u4e3a%1$s\uff0c\u672a\u8bc6\u522b\u5230\u60c5\u666f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"IncomeStatementDataPull_13", (String)"fi-fgptas-business", (Object[])new Object[0]), period));
                            }
                        }
                    } else {
                        resultMap.put("message", ResManager.loadKDString((String)"\u672a\u4ece\u8bed\u4e49\u8bc6\u522b\u5230\u60c5\u666f\u548c\u671f\u95f4\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"IncomeStatementDataPull_14", (String)"fi-fgptas-business", (Object[])new Object[0]));
                    }
                } else {
                    resultMap.put("message", ResManager.loadKDString((String)"\u672a\u4ece\u8bed\u4e49\u8bc6\u522b\u5230\u60c5\u666f\u548c\u671f\u95f4\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"IncomeStatementDataPull_14", (String)"fi-fgptas-business", (Object[])new Object[0]));
                }
            } else {
                resultMap.put("message", ResManager.loadKDString((String)"\u8be5\u4f53\u7cfb\u4e0b\u672a\u67e5\u8be2\u5230\u53ef\u7528\u671f\u95f4\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"IncomeStatementDataPull_15", (String)"fi-fgptas-business", (Object[])new Object[0]));
            }
        }
        return paramMap;
    }

    private List<String> checkParam(Map<String, List<String>> paramMap) {
        ArrayList<String> noParamList = new ArrayList<String>(3);
        for (String mustParam : MUST_PARAM_ARR) {
            List<String> list = paramMap.get(mustParam);
            if (list != null && !list.isEmpty()) continue;
            noParamList.add(mustParam);
        }
        return noParamList;
    }

    private List<Map<String, Object>> invokeBizService(Map<String, List<String>> paramMap, Map<String, Map<String, String>> numberNameMap, Map<String, Object> resultMap, DynamicObject dyo) {
        HashMap<String, String> paramKeyMap = new HashMap<String, String>(10){
            {
                this.put("modelnum", "modelNum");
                this.put("org", "Entity");
                this.put("account", "Account");
                this.put("scenario", "Scenario");
                this.put("year", "Year");
                this.put("period", "Period");
                this.put("currency", "Currency");
                this.put("changetype", "ChangeType");
                this.put("internalcompany", "InternalCompany");
                this.put("amount", "Amount");
                this.put("process", "Process");
                this.put("audittrail", "AuditTrail");
            }

            @Override
            public String get(Object key) {
                String value = (String)super.get(String.valueOf(key).toLowerCase(Locale.ENGLISH));
                if (StringUtils.isEmpty((String)value)) {
                    char[] chars = String.valueOf(key).toCharArray();
                    if (chars[0] >= 'a' && chars[0] <= 'z') {
                        chars[0] = (char)(chars[0] ^ 0x20);
                    }
                    value = String.valueOf(chars);
                }
                return value;
            }
        };
        String modelNum = paramMap.remove("modelnum").get(0);
        HashMap<String, Object> requestParamMap = new HashMap<String, Object>(6);
        requestParamMap.put("excludeDynaData", Boolean.FALSE);
        requestParamMap.put("includeNull", Boolean.FALSE);
        requestParamMap.put("includeName", Boolean.FALSE);
        List<String> fieldNumberList = this.getFieldNumber(dyo);
        fieldNumberList.remove("modelnum");
        fieldNumberList.remove("amount");
        requestParamMap.put("showDims", this.getFieldNumberFromDic((Map<String, String>)paramKeyMap, fieldNumberList));
        List<String> yearList = paramMap.remove("year");
        List<String> periodList = paramMap.remove("period");
        List<String> scenarioList = paramMap.remove("scenario");
        int num = yearList.size() * periodList.size() * scenarioList.size();
        if (num > 6) {
            resultMap.put("message", ResManager.loadKDString((String)"\u67e5\u8be2\u6570\u636e\u91cf\u8fc7\u5927\uff0c\u8bf7\u7f29\u5c0f\u65f6\u95f4\u8303\u56f4\u3002", (String)"IncomeStatementDataPull_2", (String)"fi-fgptas-business", (Object[])new Object[0]));
            return null;
        }
        paramMap.put("process", paramMap.get("process") == null || paramMap.get("process").isEmpty() ? Collections.singletonList("ERpt") : null);
        paramMap.put("audittrail", paramMap.get("audittrail") == null || paramMap.get("audittrail").isEmpty() ? Collections.singletonList("ATTotal") : null);
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(num);
        HashMap<String, String> fixDimMap = new HashMap<String, String>(3);
        for (String year : yearList) {
            fixDimMap.put("Year", year);
            for (String scenario : scenarioList) {
                fixDimMap.put("Scenario", scenario);
                for (String period : periodList) {
                    fixDimMap.put("Period", period);
                    requestParamMap.put("fixDim", fixDimMap);
                    ArrayList filters = new ArrayList(paramMap.size());
                    for (Map.Entry<String, List<String>> entry : paramMap.entrySet()) {
                        if (entry.getValue() == null || entry.getValue().isEmpty()) continue;
                        HashMap map = new HashMap(3);
                        map.put("dim", paramKeyMap.get(entry.getKey()));
                        map.put("scope", "10");
                        map.put("val", entry.getValue());
                        filters.add(map);
                    }
                    if (paramMap.get("account") == null || paramMap.get("account").isEmpty()) {
                        HashMap<String, Object> map = new HashMap<String, Object>(3);
                        map.put("dim", "Account");
                        map.put("scope", "40");
                        map.put("val", Collections.singletonList(this.getAccountNumber()));
                        filters.add(map);
                        Map nameMap = numberNameMap.computeIfAbsent("account", p -> new HashMap(64));
                        String dataTableNumber = dyo.getString("number");
                        QFilter modelNumFilter = new QFilter("status", "=", (Object)"C").and("number", "=", (Object)modelNum);
                        List modelId = QueryServiceHelper.queryPrimaryKeys((String)this.getEntityNumber(dataTableNumber, "modelnum"), (QFilter[])modelNumFilter.toArray(), null, (int)1);
                        if (!modelId.isEmpty()) {
                            QFilter accountFilter = new QFilter("enable", "=", (Object)"1").and("model", "=", modelId.get(0)).and("longnumber", "like", (Object)("%" + this.getAccountNumber() + "!%"));
                            this.getBaseDataNumber(nameMap, dataTableNumber, "account", accountFilter.toArray());
                        }
                    }
                    requestParamMap.put("filters", filters);
                    try {
                        this.invoke(resultList, modelNum, requestParamMap);
                    }
                    catch (Exception e) {
                        logger.error("fgptas getData error : ", (Object)e.getMessage(), (Object)e);
                        throw e;
                    }
                }
            }
        }
        return resultList;
    }

    private void invoke(List<Map<String, Object>> resultList, String modelNum, Map<String, Object> requestParamMap) {
        logger.info("fgptas getData to bcm requestParam modelNum : " + modelNum + ", other : " + JSON.toJSONString(requestParamMap));
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"bcm", (String)"OlapDataQueryMsService", (String)"queryData", (Object[])new Object[]{modelNum, JSON.toJSONString(requestParamMap)});
        logger.info("fgptas getData to bcm responseData : " + JSON.toJSONString((Object)result));
        resultList.add(result);
    }

    private void handleResponseData(List<Map<String, Object>> responseResultList, Map<String, Map<String, String>> numberNameMap, Map<String, Object> resultMap, DynamicObject dyo) {
        if (responseResultList != null && !responseResultList.isEmpty()) {
            HashSet<String> responseMsgSet = new HashSet<String>(responseResultList.size());
            ArrayList resultDataList = new ArrayList(200);
            for (Map<String, Object> responseMap : responseResultList) {
                Map responseData = (Map)responseMap.get("data");
                if (((Boolean)responseMap.get("success")).booleanValue() && responseData != null && !responseData.isEmpty()) {
                    ArrayList<String> responseDimension = new ArrayList<String>((Collection)responseData.get("dimension"));
                    responseDimension.replaceAll(dim -> "Entity".equalsIgnoreCase((String)dim) ? "org" : dim);
                    String[] fieldNameArr = this.getFieldName(dyo, responseDimension);
                    Collection responseDataCol = (Collection)responseData.get("datas");
                    for (Collection objCol : responseDataCol) {
                        HashMap resultDataMap = new HashMap(objCol.size());
                        int i = 0;
                        for (Object obj : objCol) {
                            if (i < objCol.size() - 1) {
                                Map<String, String> nameMap = numberNameMap.get(((String)responseDimension.get(i)).toLowerCase(Locale.ENGLISH));
                                resultDataMap.put(fieldNameArr[i], nameMap != null && nameMap.containsKey(String.valueOf(obj)) ? nameMap.get(String.valueOf(obj)) : obj);
                            } else {
                                resultDataMap.put(ResManager.loadKDString((String)"\u91d1\u989d", (String)"IncomeStatementDataPull_3", (String)"fi-fgptas-business", (Object[])new Object[0]), obj);
                            }
                            ++i;
                        }
                        resultDataList.add(resultDataMap);
                    }
                    continue;
                }
                if (((Boolean)responseMap.get("success")).booleanValue()) continue;
                responseMsgSet.add((String)responseMap.get("message"));
            }
            if (!resultDataList.isEmpty()) {
                resultMap.put("errorCode", "success");
                resultMap.put("success", Boolean.TRUE);
                resultMap.put("data", resultDataList);
            } else if (responseMsgSet.isEmpty()) {
                resultMap.put("errorCode", "success");
                resultMap.put("success", Boolean.TRUE);
            } else {
                resultMap.put("message", String.join((CharSequence)" | ", responseMsgSet));
            }
        }
    }
}

