/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fgptas.business.datatable.builder;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import kd.bos.entity.property.RefProp;
import kd.bos.ext.bd.metadata.field.CustomerField;
import kd.bos.ext.bd.metadata.field.SupplierField;
import kd.bos.ext.fi.metadata.field.AccountField;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.businessfield.AmountField;
import kd.bos.metadata.entity.businessfield.AssistantField;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.businessfield.BillNoField;
import kd.bos.metadata.entity.businessfield.BillStatusField;
import kd.bos.metadata.entity.businessfield.CreateDateField;
import kd.bos.metadata.entity.businessfield.CreaterField;
import kd.bos.metadata.entity.businessfield.CurrencyField;
import kd.bos.metadata.entity.businessfield.MaterielField;
import kd.bos.metadata.entity.businessfield.ModifierField;
import kd.bos.metadata.entity.businessfield.ModifyDateField;
import kd.bos.metadata.entity.businessfield.OrgField;
import kd.bos.metadata.entity.businessfield.PriceField;
import kd.bos.metadata.entity.businessfield.QtyField;
import kd.bos.metadata.entity.businessfield.UnitField;
import kd.bos.metadata.entity.businessfield.UserField;
import kd.bos.metadata.entity.commonfield.BigIntField;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.ComboItem;
import kd.bos.metadata.entity.commonfield.DateField;
import kd.bos.metadata.entity.commonfield.DateRangeField;
import kd.bos.metadata.entity.commonfield.DateTimeField;
import kd.bos.metadata.entity.commonfield.DecimalField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.IntegerField;
import kd.bos.metadata.entity.commonfield.LargeTextField;
import kd.bos.metadata.entity.commonfield.MulComboField;
import kd.bos.metadata.entity.commonfield.MuliLangTextField;
import kd.bos.metadata.entity.commonfield.TextAreaField;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.entity.commonfield.TimeField;
import kd.bos.metadata.entity.commonfield.TimeRangeField;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.container.FieldsetPanelAp;
import kd.bos.metadata.form.control.FieldAp;

public class WorkBillTemplateTrans {
    private static final String CONTENT_AREA_ID = "sb5ReliwR1";

    public static List<Map<String, Object>> getTemplateField() {
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)"2LYDMCNXHB+5", (MetaCategory)MetaCategory.Form);
        if (formMeta != null) {
            List controlApItems = formMeta.getItems().stream().filter(controlAp -> {
                boolean isFieldPanelAp = controlAp instanceof FieldsetPanelAp;
                boolean isContentAreaAp = controlAp.getParentId().equals(CONTENT_AREA_ID);
                return isFieldPanelAp && isContentAreaAp;
            }).sorted(Comparator.comparing(ControlAp::getIndex)).collect(Collectors.toList());
            ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(controlApItems.size());
            EntityMetadata entityMeta = (EntityMetadata)MetadataDao.readMeta((String)formMeta.getEntityId(), (MetaCategory)MetaCategory.Entity);
            for (ControlAp controlAp2 : controlApItems) {
                HashMap<String, Object> containerData = new HashMap<String, Object>();
                containerData.put("key", controlAp2.getKey());
                containerData.put("name", controlAp2.getName().getLocaleValue());
                containerData.put("index", controlAp2.getIndex());
                containerData.put("isHidden", controlAp2.isInvisible());
                containerData.put("id", controlAp2.getId());
                containerData.put("fieldList", WorkBillTemplateTrans.buildField(formMeta, controlAp2.getId(), entityMeta));
                result.add(containerData);
            }
            return result;
        }
        return null;
    }

    private static List<Map<String, Object>> buildField(FormMetadata formMetadata, String containerId, EntityMetadata entityMetadata) {
        List fieldControlAps = formMetadata.getItems().stream().filter(control -> control.getParentId().equalsIgnoreCase(containerId)).collect(Collectors.toList());
        TreeSet<Map<String, Object>> set = new TreeSet<Map<String, Object>>(Comparator.comparing(map -> (Integer)map.get("index")));
        for (ControlAp controlAp : fieldControlAps) {
            String id = controlAp.getId();
            EntityItem entityItem = entityMetadata.getItemById(id);
            if (!(entityItem instanceof Field)) continue;
            HashMap<String, Object> fieldInfo = new HashMap<String, Object>();
            Field field = (Field)entityItem;
            fieldInfo.put("index", controlAp.getIndex());
            fieldInfo.put("isMustInput", field.isMustInput());
            fieldInfo.put("isHidden", controlAp.isInvisible());
            fieldInfo.put("name", controlAp.getName().getLocaleValue());
            fieldInfo.put("key", controlAp.getKey());
            fieldInfo.put("isPreset", Boolean.TRUE);
            fieldInfo.put("id", controlAp.getId());
            WorkBillTemplateTrans.setFieldTypeAndProperty(field, fieldInfo, controlAp);
            set.add(fieldInfo);
        }
        WorkBillTemplateTrans.dealPropertyRef(set, formMetadata);
        return new ArrayList<Map<String, Object>>(set);
    }

    private static void dealPropertyRef(TreeSet<Map<String, Object>> treeSet, FormMetadata formMetadata) {
        for (Map<String, Object> map : treeSet) {
            String controlId;
            String type = (String)map.get("type");
            Map property = (Map)map.get("property");
            if ("Price".equalsIgnoreCase(type) || "Amount".equalsIgnoreCase(type)) {
                controlId = (String)property.get("currencyFieldId");
                property.put("currencyFieldId", formMetadata.getItem(controlId).getKey());
                continue;
            }
            if ("Qty".equalsIgnoreCase(type)) {
                controlId = (String)property.get("unitFieldId");
                property.put("unitFieldId", formMetadata.getItem(controlId).getKey());
                continue;
            }
            if ("Unit".equalsIgnoreCase(type)) {
                controlId = (String)property.get("materielFieldId");
                property.put("materielFieldId", formMetadata.getItem(controlId).getKey());
                continue;
            }
            if ("Account".equalsIgnoreCase(type)) {
                String refPeriodFieldId = (String)property.get("refPeriodFieldId");
                String refAccTableFieldId = (String)property.get("refAccTableFieldId");
                property.put("refPeriodFieldId", formMetadata.getItem(refPeriodFieldId).getKey());
                property.put("refAccTableFieldId", formMetadata.getItem(refAccTableFieldId).getKey());
                continue;
            }
            if (!"Assistant".equalsIgnoreCase(type)) continue;
            String asstParentId = (String)property.get("asstParentId");
            property.put("asstParentId", asstParentId);
        }
    }

    private static void setFieldTypeAndProperty(Field field, Map<String, Object> fieldInfo, ControlAp controlAp) {
        if (field instanceof LargeTextField) {
            WorkBillTemplateTrans.setLargeTextFieldProperty(field, fieldInfo);
        } else if (field instanceof TextAreaField) {
            WorkBillTemplateTrans.setTextAreaFieldProperty(field, fieldInfo);
        } else if (field instanceof MuliLangTextField) {
            WorkBillTemplateTrans.setMuliLangTextFieldProperty(field, fieldInfo);
        } else if (field instanceof TextField) {
            WorkBillTemplateTrans.setTextFieldProperty(field, fieldInfo);
        } else if (field instanceof QtyField) {
            WorkBillTemplateTrans.setQtyFieldProperty(field, fieldInfo, controlAp);
        } else if (field instanceof PriceField) {
            WorkBillTemplateTrans.setPriceFieldProperty(field, fieldInfo, controlAp);
        } else if (field instanceof AmountField) {
            WorkBillTemplateTrans.setAmountFieldProperty(field, fieldInfo, controlAp);
        } else if (field instanceof BigIntField) {
            WorkBillTemplateTrans.setBigIntFieldProperty(field, fieldInfo, controlAp);
        } else if (field instanceof IntegerField) {
            WorkBillTemplateTrans.setIntegerFieldProperty(field, fieldInfo, controlAp);
        } else if (field instanceof DecimalField) {
            WorkBillTemplateTrans.setDecimalFieldProperty(field, fieldInfo, controlAp);
        } else if (field instanceof DateField) {
            WorkBillTemplateTrans.setDateFieldProperty(field, fieldInfo);
        } else if (field instanceof DateTimeField) {
            WorkBillTemplateTrans.setDateTimeFieldProperty(field, fieldInfo);
        } else if (field instanceof DateRangeField) {
            WorkBillTemplateTrans.setDateRangeFieldProperty(field, fieldInfo);
        } else if (field instanceof TimeField) {
            WorkBillTemplateTrans.setTimeFieldProperty(field, fieldInfo);
        } else if (field instanceof TimeRangeField) {
            WorkBillTemplateTrans.setTimeRangeFieldProperty(field, fieldInfo);
        } else if (field instanceof MulComboField) {
            WorkBillTemplateTrans.setMulComboFieldProperty(field, fieldInfo);
        } else if (field instanceof ComboField) {
            WorkBillTemplateTrans.setComboFieldProperty(field, fieldInfo);
        } else if (field instanceof UserField) {
            WorkBillTemplateTrans.setUserFieldProperty(field, fieldInfo, controlAp);
        } else if (field instanceof CurrencyField) {
            WorkBillTemplateTrans.setCurrencyFieldProperty(field, fieldInfo, controlAp);
        } else if (field instanceof OrgField) {
            WorkBillTemplateTrans.setOrgFieldProperty(field, fieldInfo, controlAp);
        } else if (field instanceof AccountField) {
            WorkBillTemplateTrans.setAccountFieldProperty(field, fieldInfo, controlAp);
        } else if (field instanceof CustomerField) {
            WorkBillTemplateTrans.setCustomerFieldProperty(field, fieldInfo, controlAp);
        } else if (field instanceof SupplierField) {
            WorkBillTemplateTrans.setCustomerFieldProperty(field, fieldInfo, controlAp);
        } else if (field instanceof MaterielField) {
            WorkBillTemplateTrans.setMaterielFieldProperty(field, fieldInfo, controlAp);
        } else if (field instanceof UnitField) {
            WorkBillTemplateTrans.setUnitFieldProperty(field, fieldInfo, controlAp);
        } else if (field instanceof AssistantField) {
            WorkBillTemplateTrans.setAssistantFieldProperty(field, fieldInfo, controlAp);
        } else if (field instanceof BasedataField) {
            WorkBillTemplateTrans.setBasedataFieldProperty(field, fieldInfo, controlAp);
        }
        Map property = (Map)fieldInfo.get("property");
        property.put("lock", controlAp.getLock());
        property.put("visible", controlAp.getVisible());
    }

    private static void setBillNoFieldProperty(Field field, Map<String, Object> fieldInfo) {
        BillNoField billNoField = (BillNoField)field;
        fieldInfo.put("property", WorkBillTemplateTrans.parseTextFieldCommonProperty((TextField)billNoField));
        fieldInfo.put("type", "BillNo");
    }

    private static void setTextFieldProperty(Field field, Map<String, Object> fieldInfo) {
        TextField textField = (TextField)field;
        fieldInfo.put("property", WorkBillTemplateTrans.parseTextFieldCommonProperty(textField));
        fieldInfo.put("type", "Text");
    }

    private static void setLargeTextFieldProperty(Field field, Map<String, Object> fieldInfo) {
        LargeTextField largeTextField = (LargeTextField)field;
        fieldInfo.put("property", WorkBillTemplateTrans.parseTextFieldCommonProperty((TextField)largeTextField));
        fieldInfo.put("type", "LargeText");
    }

    private static void setTextAreaFieldProperty(Field field, Map<String, Object> fieldInfo) {
        TextAreaField textAreaField = (TextAreaField)field;
        fieldInfo.put("property", WorkBillTemplateTrans.parseTextFieldCommonProperty((TextField)textAreaField));
        fieldInfo.put("type", "TextArea");
    }

    private static void setMuliLangTextFieldProperty(Field field, Map<String, Object> fieldInfo) {
        MuliLangTextField muliLangTextField = new MuliLangTextField();
        fieldInfo.put("property", WorkBillTemplateTrans.parseTextFieldCommonProperty((TextField)muliLangTextField));
        fieldInfo.put("type", "MuliLangText");
    }

    private static void setQtyFieldProperty(Field field, Map<String, Object> fieldInfo, ControlAp controlAp) {
        QtyField qtyField = (QtyField)field;
        Map<String, Object> property = WorkBillTemplateTrans.parseDecimalFieldCommonProperty((DecimalField)qtyField, controlAp);
        property.put("unitFieldId", qtyField.getUnitFieldId());
        fieldInfo.put("property", property);
        fieldInfo.put("type", "Qty");
    }

    private static void setPriceFieldProperty(Field field, Map<String, Object> fieldInfo, ControlAp controlAp) {
        PriceField priceField = (PriceField)field;
        Map<String, Object> property = WorkBillTemplateTrans.parseDecimalFieldCommonProperty((DecimalField)priceField, controlAp);
        property.put("amountPrecisionType", priceField.getAmountPrecisionType());
        property.put("currencyFieldId", priceField.getCurrencyFieldId());
        fieldInfo.put("property", property);
        fieldInfo.put("type", "Price");
    }

    private static void setAmountFieldProperty(Field field, Map<String, Object> fieldInfo, ControlAp controlAp) {
        AmountField amountField = (AmountField)field;
        Map<String, Object> property = WorkBillTemplateTrans.parseDecimalFieldCommonProperty((DecimalField)amountField, controlAp);
        property.put("amountPrecisionType", amountField.getAmountPrecisionType());
        property.put("currencyFieldId", amountField.getCurrencyFieldId());
        fieldInfo.put("property", property);
        fieldInfo.put("type", "Amount");
    }

    private static void setBigIntFieldProperty(Field field, Map<String, Object> fieldInfo, ControlAp controlAp) {
        BigIntField bigIntField = (BigIntField)field;
        fieldInfo.put("property", WorkBillTemplateTrans.parseDecimalFieldCommonProperty((DecimalField)bigIntField, controlAp));
        fieldInfo.put("type", "BigInt");
    }

    private static void setIntegerFieldProperty(Field field, Map<String, Object> fieldInfo, ControlAp controlAp) {
        IntegerField integerField = (IntegerField)field;
        fieldInfo.put("property", WorkBillTemplateTrans.parseDecimalFieldCommonProperty((DecimalField)integerField, controlAp));
        fieldInfo.put("type", "Integer");
    }

    private static void setDecimalFieldProperty(Field field, Map<String, Object> fieldInfo, ControlAp controlAp) {
        DecimalField decimalField = (DecimalField)field;
        fieldInfo.put("property", WorkBillTemplateTrans.parseDecimalFieldCommonProperty(decimalField, controlAp));
        fieldInfo.put("type", "Decimal");
    }

    private static void setCreateDateFieldProperty(Field field, Map<String, Object> fieldInfo) {
        CreateDateField createDateField = (CreateDateField)field;
        fieldInfo.put("property", WorkBillTemplateTrans.parseDateTimeFieldCommonProperty((DateTimeField)createDateField));
        fieldInfo.put("type", "CreateDate");
    }

    private static void setModifyDateFieldProperty(Field field, Map<String, Object> fieldInfo) {
        ModifyDateField modifyDateField = (ModifyDateField)field;
        fieldInfo.put("property", WorkBillTemplateTrans.parseDateTimeFieldCommonProperty((DateTimeField)modifyDateField));
        fieldInfo.put("type", "ModifyDate");
    }

    private static void setDateFieldProperty(Field field, Map<String, Object> fieldInfo) {
        DateField dateField = (DateField)field;
        fieldInfo.put("property", WorkBillTemplateTrans.parseDateTimeFieldCommonProperty((DateTimeField)dateField));
        fieldInfo.put("type", "Date");
    }

    private static void setDateTimeFieldProperty(Field field, Map<String, Object> fieldInfo) {
        DateTimeField dateTimeField = (DateTimeField)field;
        fieldInfo.put("property", WorkBillTemplateTrans.parseDateTimeFieldCommonProperty(dateTimeField));
        fieldInfo.put("type", "DateTime");
    }

    private static void setDateRangeFieldProperty(Field field, Map<String, Object> fieldInfo) {
        DateRangeField dateRangeField = (DateRangeField)field;
        HashMap<String, Object> property = new HashMap<String, Object>(8);
        property.put("defValue", dateRangeField.getDefValue());
        property.put("startDateFieldKey", dateRangeField.getStartDateFieldKey());
        property.put("startDateFieldName", dateRangeField.getStartDateFieldName());
        property.put("endDateFieldKey", dateRangeField.getEndDateFieldKey());
        property.put("endDateFieldName", dateRangeField.getEndDateFieldName());
        property.put("regionType", dateRangeField.getRegionType());
        fieldInfo.put("property", property);
        fieldInfo.put("type", "DateRange");
    }

    private static void setTimeFieldProperty(Field field, Map<String, Object> fieldInfo) {
        TimeField timeField = (TimeField)field;
        fieldInfo.put("property", new HashMap());
        fieldInfo.put("type", "Time");
    }

    private static void setTimeRangeFieldProperty(Field field, Map<String, Object> fieldInfo) {
        TimeRangeField timeRangeField = (TimeRangeField)field;
        HashMap<String, String> property = new HashMap<String, String>(8);
        property.put("startDateFieldKey", timeRangeField.getStartDateFieldKey());
        property.put("startDateFieldName", timeRangeField.getStartDateFieldName());
        property.put("endDateFieldKey", timeRangeField.getEndDateFieldKey());
        property.put("endDateFieldName", timeRangeField.getEndDateFieldName());
        fieldInfo.put("property", property);
        fieldInfo.put("type", "TimeRange");
    }

    private static void setBillStatusFieldProperty(Field field, Map<String, Object> fieldInfo) {
        BillStatusField billStatusField = (BillStatusField)field;
        fieldInfo.put("property", WorkBillTemplateTrans.parseComboFieldCommonProperty((ComboField)billStatusField));
        fieldInfo.put("type", "BillStatus");
    }

    private static void setMulComboFieldProperty(Field field, Map<String, Object> fieldInfo) {
        MulComboField mulComboField = (MulComboField)field;
        Map<String, Object> property = WorkBillTemplateTrans.parseComboFieldCommonProperty((ComboField)mulComboField);
        property.put("selectedItemStyle", mulComboField.getSelectedItemStyle());
        fieldInfo.put("property", property);
        fieldInfo.put("type", "MulCombo");
    }

    private static void setComboFieldProperty(Field field, Map<String, Object> fieldInfo) {
        ComboField comboField = (ComboField)field;
        fieldInfo.put("property", WorkBillTemplateTrans.parseComboFieldCommonProperty(comboField));
        fieldInfo.put("type", "Combo");
    }

    private static void setCreaterFieldProperty(Field field, Map<String, Object> fieldInfo, ControlAp controlAp) {
        CreaterField createrField = (CreaterField)field;
        Map<String, Object> property = WorkBillTemplateTrans.parseBasedataCommonProperty((BasedataField)createrField, controlAp);
        property.put("f7Style", createrField.getF7Style());
        fieldInfo.put("property", property);
        fieldInfo.put("type", "Creater");
    }

    private static void setModifierFieldProperty(Field field, Map<String, Object> fieldInfo, ControlAp controlAp) {
        ModifierField modifierField = (ModifierField)field;
        Map<String, Object> property = WorkBillTemplateTrans.parseBasedataCommonProperty((BasedataField)modifierField, controlAp);
        property.put("f7Style", modifierField.getF7Style());
        fieldInfo.put("property", property);
        fieldInfo.put("type", "Modifier");
    }

    private static void setUserFieldProperty(Field field, Map<String, Object> fieldInfo, ControlAp controlAp) {
        UserField userField = (UserField)field;
        Map<String, Object> property = WorkBillTemplateTrans.parseBasedataCommonProperty((BasedataField)userField, controlAp);
        property.put("f7Style", userField.getF7Style());
        fieldInfo.put("property", property);
        fieldInfo.put("type", "User");
    }

    private static void setOrgFieldProperty(Field field, Map<String, Object> fieldInfo, ControlAp controlAp) {
        OrgField orgField = (OrgField)field;
        Map<String, Object> property = WorkBillTemplateTrans.parseBasedataCommonProperty((BasedataField)orgField, controlAp);
        property.put("orgFuncs", orgField.getOrgFuncs());
        property.put("f7Style", orgField.getF7Style());
        fieldInfo.put("property", property);
        fieldInfo.put("type", "Org");
    }

    private static void setCurrencyFieldProperty(Field field, Map<String, Object> fieldInfo, ControlAp controlAp) {
        CurrencyField currencyField = (CurrencyField)field;
        fieldInfo.put("property", WorkBillTemplateTrans.parseBasedataCommonProperty((BasedataField)currencyField, controlAp));
        fieldInfo.put("type", "Currency");
    }

    private static void setAccountFieldProperty(Field field, Map<String, Object> fieldInfo, ControlAp controlAp) {
        AccountField accountField = (AccountField)field;
        Map<String, Object> property = WorkBillTemplateTrans.parseBasedataCommonProperty((BasedataField)accountField, controlAp);
        property.put("displayFullName", accountField.isDisplayFullname());
        property.put("multiVersion", accountField.isMultiVersion());
        property.put("refPeriodFieldId", accountField.getRefPeriodFieldId());
        property.put("refAccTableFieldId", accountField.getRefAcctTableFieldId());
        fieldInfo.put("property", property);
        fieldInfo.put("type", "Account");
    }

    private static void setCustomerFieldProperty(Field field, Map<String, Object> fieldInfo, ControlAp controlAp) {
        CustomerField customerField = (CustomerField)field;
        fieldInfo.put("property", WorkBillTemplateTrans.parseBasedataCommonProperty((BasedataField)customerField, controlAp));
        fieldInfo.put("type", "Customer");
    }

    private static void setSupplierFieldProperty(Field field, Map<String, Object> fieldInfo, ControlAp controlAp) {
        SupplierField supplierField = (SupplierField)field;
        fieldInfo.put("property", WorkBillTemplateTrans.parseBasedataCommonProperty((BasedataField)supplierField, controlAp));
        fieldInfo.put("type", "Supplier");
    }

    private static void setMaterielFieldProperty(Field field, Map<String, Object> fieldInfo, ControlAp controlAp) {
        MaterielField materielField = (MaterielField)field;
        fieldInfo.put("property", WorkBillTemplateTrans.parseBasedataCommonProperty((BasedataField)materielField, controlAp));
        fieldInfo.put("type", "Materiel");
    }

    private static void setUnitFieldProperty(Field field, Map<String, Object> fieldInfo, ControlAp controlAp) {
        UnitField unitField = (UnitField)field;
        Map<String, Object> property = WorkBillTemplateTrans.parseBasedataCommonProperty((BasedataField)unitField, controlAp);
        property.put("materielFieldId", unitField.getMaterielFieldId());
        property.put("followUnitToChange", unitField.isFollowUnitToChange());
        fieldInfo.put("property", property);
        fieldInfo.put("type", "Unit");
    }

    private static void setAssistantFieldProperty(Field field, Map<String, Object> fieldInfo, ControlAp controlAp) {
        AssistantField assistantField = (AssistantField)field;
        Map<String, Object> property = WorkBillTemplateTrans.parseBasedataCommonProperty((BasedataField)assistantField, controlAp);
        property.put("asstTypeId", assistantField.getAsstTypeId());
        property.put("asstParentId", assistantField.getAsstParentId());
        fieldInfo.put("property", property);
        fieldInfo.put("type", "Assistant");
    }

    private static void setBasedataFieldProperty(Field field, Map<String, Object> fieldInfo, ControlAp controlAp) {
        BasedataField basedataField = (BasedataField)field;
        fieldInfo.put("property", WorkBillTemplateTrans.parseBasedataCommonProperty(basedataField, controlAp));
        fieldInfo.put("type", "Basedata");
    }

    private static Map<String, Object> parseTextFieldCommonProperty(TextField textField) {
        HashMap<String, Object> property = new HashMap<String, Object>(8);
        property.put("minLength", textField.getMinLength());
        property.put("maxLength", textField.getMaxLength());
        property.put("defValue", textField.getDefValue());
        property.put("editStyle", textField.getEditStyle());
        return property;
    }

    private static Map<String, Object> parseDecimalFieldCommonProperty(DecimalField decimalField, ControlAp controlAp) {
        HashMap<String, Object> property = new HashMap<String, Object>(8);
        property.put("precision", decimalField.getPrecision());
        property.put("scale", decimalField.getScale());
        property.put("zeroShow", decimalField.isZeroShow());
        property.put("defValue", decimalField.getDefValue());
        property.put("dataScope", decimalField.getDataScope());
        property.put("enableNull", decimalField.isEnableNull());
        property.put("noDisplayScaleZero", ((FieldAp)controlAp).isNoDisplayScaleZero());
        return property;
    }

    private static Map<String, Object> parseDateTimeFieldCommonProperty(DateTimeField dateTimeField) {
        HashMap<String, Object> property = new HashMap<String, Object>(8);
        property.put("minDate", dateTimeField.getMinDate());
        property.put("maxDate", dateTimeField.getMaxDate());
        property.put("timeZoneTransType", dateTimeField.getTimeZoneTransType());
        property.put("relateOrg", dateTimeField.getRelateOrg());
        property.put("regionType", dateTimeField.getRegionType());
        return property;
    }

    private static Map<String, Object> parseComboFieldCommonProperty(ComboField comboField) {
        HashMap<String, Object> property = new HashMap<String, Object>(16);
        List items = comboField.getItems();
        ArrayList itemList = new ArrayList(items.size());
        for (ComboItem comboItem : items) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("Caption", comboItem.getCaption().getLocaleValue());
            map.put("Value", comboItem.getValue());
            itemList.add(map);
        }
        property.put("items", itemList);
        property.put("defValue", comboField.getDefValue());
        property.put("comboValueCheck", comboField.isComboValueCheck());
        return property;
    }

    private static Map<String, Object> parseBasedataCommonProperty(BasedataField baseDataField, ControlAp controlAp) {
        HashMap<String, Object> property = new HashMap<String, Object>(16);
        property.put("baseEntityId", baseDataField.getBaseEntityId());
        property.put("displayProp", baseDataField.getDisplayProp());
        property.put("numberProp", baseDataField.getNumberProp());
        property.put("editSearchProp", baseDataField.getEditSearchProp());
        property.put("displayStyle", baseDataField.getDisplayStyle());
        property.put("showUsed", baseDataField.isShowUsed());
        property.put("viewDetails", baseDataField.isViewDetail());
        property.put("openFuzzyQuery", baseDataField.isOpenFuzzyQuery());
        property.put("showFrequent", baseDataField.isShowFrequent());
        property.put("baseDataEditStyle", baseDataField.getBasedataEditStyle());
        List refProps = baseDataField.getRefProps();
        List refPropStrList = refProps.stream().map(RefProp::getName).collect(Collectors.toList());
        property.put("refProps", refPropStrList);
        FieldAp fieldAp = (FieldAp)controlAp;
        property.put("quickAddNew", fieldAp.isQuickAddNew());
        return property;
    }
}

