/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fgptas.business.indexanalysis.redis;

import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class IndexAnalysisRedis {
    private static final Log logger = LogFactory.getLog(IndexAnalysisRedis.class);
    private static final DistributeSessionlessCache CACHE = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();

    public static void setChartData(String chartData) {
        long userId = RequestContext.get().getCurrUserId();
        String sessionId = RequestContext.get().getGlobalSessionId();
        String key = IndexAnalysisRedis.buildCacheType(userId, sessionId);
        logger.info("setChartData,key:{},chartData:{}", (Object)key, (Object)chartData);
        CACHE.put(key, (Object)chartData, 600);
    }

    public static String getChartData() {
        long userId = RequestContext.get().getCurrUserId();
        String sessionId = RequestContext.get().getGlobalSessionId();
        String key = IndexAnalysisRedis.buildCacheType(userId, sessionId);
        logger.info("getChartData,key:{},chartData:{}", (Object)key, CACHE.get(key));
        return (String)CACHE.get(key);
    }

    private static String buildCacheType(long userId, String sessionId) {
        return "AiIndexAnalysis_" + userId + "_" + sessionId;
    }
}

