/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fgptas.business.report.action;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.form.gpt.IGPTAction;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.fgptas.business.constant.ReportActionConstant;
import kd.fi.fgptas.business.report.helper.ReportGPTAction;
import kd.fi.fgptas.business.report.helper.ReportGPTActionDataHelper;

public class CheckMatchedDataAction
implements IGPTAction,
ReportActionConstant {
    private static final Log LOGGER = LogFactory.getLog(CheckMatchedDataAction.class);

    public Map<String, String> invokeAction(String s, Map<String, String> map) {
        Map<String, String> blank;
        Map matchedResults;
        HashMap<String, String> returnParams = new HashMap<String, String>(8);
        String errorMSg = map.get("msg");
        String matchedResultStr = map.get("matchedResults");
        if (!ReportGPTActionDataHelper.isNullParams(errorMSg)) {
            returnParams.put("msg", errorMSg);
            return returnParams;
        }
        if (ReportGPTActionDataHelper.isNullParams(matchedResultStr)) {
            returnParams.put("msg", ResManager.loadKDString((String)"\u63d0\u793a\u8bed\u7ed9\u5230\u5339\u914d\u7ed3\u679c\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CheckMatchedDataAction_3", (String)"fi-fgptas-business", (Object[])new Object[0]));
            return returnParams;
        }
        try {
            String jsonString = ReportGPTActionDataHelper.standardJsonString(matchedResultStr);
            matchedResults = (Map)SerializationUtils.fromJsonString((String)jsonString, Map.class);
        }
        catch (Exception ex) {
            LOGGER.error(String.format("convert GPT matched results to map format error.matched results is:%s", matchedResultStr), (Throwable)ex);
            returnParams.put("msg", ResManager.loadKDString((String)"\u6a21\u578b\u8f93\u51fa\u6574\u4f53\u6570\u636e\u8981\u6c42\u7684\u683c\u5f0f\u6709\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CheckMatchedDataAction_0", (String)"fi-fgptas-business", (Object[])new Object[0]));
            return returnParams;
        }
        if (!this.checkDataIntegrity(matchedResults, returnParams)) {
            return returnParams;
        }
        try {
            HashMap<String, String> inputData = new HashMap<String, String>();
            inputData.put("org", map.get("orgId"));
            inputData.put("modelid", map.get("templateId"));
            ReportGPTAction reportGPTAction = new ReportGPTAction();
            blank = reportGPTAction.invokeAction("BLANK", inputData);
        }
        catch (Exception exception) {
            LOGGER.error("call Report Generate Service create blank document error.", (Throwable)exception);
            returnParams.put("msg", ResManager.loadKDString((String)"\u8c03\u7528\u62a5\u544a\u751f\u6210\u670d\u52a1\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CheckMatchedDataAction_4", (String)"fi-fgptas-business", (Object[])new Object[0]));
            return returnParams;
        }
        String reportErrorMsg = blank.get("errorMessage");
        if (!StringUtils.isEmpty((String)reportErrorMsg)) {
            returnParams.put("msg", reportErrorMsg);
            return returnParams;
        }
        returnParams.put("wordId", blank.get("wordId"));
        returnParams.put("checkedResults", JSONObject.toJSONString((Object)matchedResults));
        String wordUrl = blank.get("url");
        String msg = ResManager.loadKDString((String)"\u62a5\u544a\u751f\u6210\u4e2d\uff0c\u8bf7\u7a0d\u7b49", (String)"CheckMatchedDataAction_1", (String)"fi-fgptas-business", (Object[])new Object[0]);
        returnParams.put("msg", msg);
        returnParams.put("url", wordUrl);
        return returnParams;
    }

    private boolean checkDataIntegrity(Map<String, Map<String, List<String>>> data, Map<String, String> outputParams) {
        HashMap<String, Set<String>> lackFields = new HashMap<String, Set<String>>(8);
        try {
            for (Map.Entry<String, Map<String, List<String>>> table : data.entrySet()) {
                String entityNumber = table.getKey();
                if (ReportGPTActionDataHelper.isNullParams(entityNumber)) {
                    outputParams.put("msg", ResManager.loadKDString((String)"\u6a21\u578b\u8f93\u51fa\u6574\u4f53\u6570\u636e\u8981\u6c42\u7684\u683c\u5f0f\u6709\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CheckMatchedDataAction_0", (String)"fi-fgptas-business", (Object[])new Object[0]));
                    LOGGER.info(String.format("the GPT matched results json lack data,some table key is null.matched results is:%s", data));
                    return false;
                }
                for (Map.Entry<String, List<String>> field : table.getValue().entrySet()) {
                    String fieldName = field.getKey();
                    if (ReportGPTActionDataHelper.isNullParams(fieldName)) {
                        outputParams.put("msg", ResManager.loadKDString((String)"\u6a21\u578b\u8f93\u51fa\u6574\u4f53\u6570\u636e\u8981\u6c42\u7684\u683c\u5f0f\u6709\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CheckMatchedDataAction_0", (String)"fi-fgptas-business", (Object[])new Object[0]));
                        LOGGER.info(String.format("the GPT matched results json lack data,some field key is null.matched results is:%s", data));
                        return false;
                    }
                    List<String> fieldValue = field.getValue();
                    if (fieldValue != null && fieldValue.size() >= 1 && !ReportGPTActionDataHelper.isNullParams(fieldValue.get(0))) continue;
                    lackFields.computeIfAbsent(entityNumber, v -> new HashSet(4)).add(fieldName);
                }
            }
        }
        catch (ClassCastException castException) {
            outputParams.put("msg", ResManager.loadKDString((String)"\u6a21\u578b\u8f93\u51fa\u6574\u4f53\u6570\u636e\u8981\u6c42\u7684\u683c\u5f0f\u6709\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CheckMatchedDataAction_0", (String)"fi-fgptas-business", (Object[])new Object[0]));
            LOGGER.error(String.format("the GPT matched results json convert map format error.matched results is:%s", data), (Throwable)castException);
            return false;
        }
        catch (Exception exception) {
            LOGGER.error(String.format("check the GPT matched results occurred error.matched results is:%s", data), (Throwable)exception);
            return false;
        }
        if (lackFields.isEmpty()) {
            return true;
        }
        String errorMsg = this.buildLackFieldErrorMsg(lackFields);
        if (errorMsg == null) {
            outputParams.put("msg", ResManager.loadKDString((String)"\u6a21\u578b\u8f93\u51fa\u6574\u4f53\u6570\u636e\u8981\u6c42\u7684\u683c\u5f0f\u6709\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CheckMatchedDataAction_0", (String)"fi-fgptas-business", (Object[])new Object[0]));
            LOGGER.info(String.format("the GPT matched results json contain error data,some table or field key not in config.matched results is:%s", data));
        } else {
            outputParams.put("msg", errorMsg);
        }
        return false;
    }

    private String buildLackFieldErrorMsg(Map<String, Set<String>> lackFields) {
        QFilter filter = new QFilter("entryentity.entity", "in", lackFields.keySet());
        filter.and(new QFilter("entryentity.fieldnumber", "in", lackFields.values()));
        DynamicObjectCollection nameCol = QueryServiceHelper.query((String)"fgptas_tablecol_mapping", (String)"name", (QFilter[])filter.toArray());
        if (!ObjectUtils.isEmpty((Object)nameCol)) {
            Set names = nameCol.stream().map(n -> n.getString("name")).collect(Collectors.toSet());
            return String.format(ResManager.loadKDString((String)"\u751f\u6210\u8be5\u62a5\u544a\u7f3a\u5c11\u5fc5\u8981\u6d88\u606f\uff1a%s\u3002", (String)"CheckMatchedDataAction_2", (String)"fi-fgptas-business", (Object[])new Object[0]), String.join((CharSequence)"fi-fgptas-business", names));
        }
        return null;
    }
}

