/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fgptas.business.report.action;

import com.alibaba.fastjson.JSONObject;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.gpt.IGPTAction;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.IBaseDataService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.fgptas.business.constant.ReportActionConstant;
import kd.fi.fgptas.business.report.helper.ReportGPTActionDataHelper;

public class CheckPermAndMatchTempAction
implements IGPTAction,
ReportActionConstant {
    private static final Log LOGGER = LogFactory.getLog(CheckPermAndMatchTempAction.class);

    public Map<String, String> invokeAction(String action, Map<String, String> params) {
        HashMap<String, String> returnParams = new HashMap<String, String>(8);
        if (!this.dataIntegrityVerify(params, returnParams)) {
            return returnParams;
        }
        if (!this.productReportPermissionVerify(returnParams)) {
            return returnParams;
        }
        if (!this.matchReportTemplate(returnParams)) {
            return returnParams;
        }
        this.otherGlobalFieldsValues(returnParams);
        return returnParams;
    }

    private boolean dataIntegrityVerify(Map<String, String> inputParams, Map<String, String> outputParams) {
        String typeName;
        String orgName;
        String orgStr = inputParams.get("org");
        String typeStr = inputParams.get("reportType");
        try {
            orgName = this.extractValueNameByJson(orgStr, "org");
            typeName = this.extractValueNameByJson(typeStr, "reportType");
        }
        catch (Exception ex) {
            LOGGER.info(String.format("the input params cannot convert JsonObject.params is:%s", orgStr + "\u3001" + typeStr));
            outputParams.put("msg", ResManager.loadKDString((String)"\u6a21\u578b\u7ed9\u5230\u7684\u7ec4\u7ec7\u548c\u62a5\u544a\u7c7b\u578b\u6570\u636e\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CheckPermAndMatchTempAction_5", (String)"fi-fgptas-business", (Object[])new Object[0]));
            return false;
        }
        DynamicObject org = StringUtils.isNotEmpty((String)orgName) ? ReportGPTActionDataHelper.getOrgByName(orgName) : null;
        DynamicObject reportType = StringUtils.isNotEmpty((String)typeName) ? ReportGPTActionDataHelper.getReportTypeByName(typeName) : null;
        if (org == null && reportType == null) {
            outputParams.put("msg", ResManager.loadKDString((String)"\u8bf7\u5b8c\u6574\u5e76\u6b63\u786e\u8f93\u5165XX\u7ec4\u7ec7XX\u62a5\u544a\u3002", (String)"CheckPermAndMatchTempAction_0", (String)"fi-fgptas-business", (Object[])new Object[0]));
            return false;
        }
        if (org == null) {
            outputParams.put("msg", String.format(ResManager.loadKDString((String)"\u8bf7\u5b8c\u6574\u5e76\u6b63\u786e\u8f93\u5165XX\u7ec4\u7ec7%s\u62a5\u544a\u3002", (String)"CheckPermAndMatchTempAction_1", (String)"fi-fgptas-business", (Object[])new Object[0]), reportType.getString("name")));
            return false;
        }
        if (reportType == null) {
            outputParams.put("msg", String.format(ResManager.loadKDString((String)"\u8bf7\u5b8c\u6574\u5e76\u6b63\u786e\u8f93\u5165%s\u7ec4\u7ec7XX\u62a5\u544a\u3002", (String)"CheckPermAndMatchTempAction_2", (String)"fi-fgptas-business", (Object[])new Object[0]), org.getString("name")));
            return false;
        }
        outputParams.put("orgId", org.getString("id"));
        outputParams.put("reportTypeId", reportType.getString("id"));
        return true;
    }

    private boolean productReportPermissionVerify(Map<String, String> outputParams) {
        long orgId = Long.parseLong(outputParams.get("orgId"));
        long reportType = Long.parseLong(outputParams.get("reportTypeId"));
        QFilter dataRuleFilter = ReportGPTActionDataHelper.getReportDataRuleForBdProp(Collections.singletonList(orgId));
        if (dataRuleFilter == null) {
            outputParams.put("msg", String.format(ResManager.loadKDString((String)"\u60a8\u65e0\u6743\u751f\u6210%1s\u7ec4\u7ec7\u7684%2s\u62a5\u544a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CheckPermAndMatchTempAction_3", (String)"fi-fgptas-business", (Object[])new Object[0]), ReportGPTActionDataHelper.getNameById(orgId, "bos_org"), ReportGPTActionDataHelper.getNameById(reportType, "fgptas_report_type")));
            return false;
        }
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        Set<Long> reportTypeIds = ReportGPTActionDataHelper.getReportTypeIds(new QFilter[]{dataRuleFilter, enableFilter, statusFilter});
        if (reportTypeIds != null && reportTypeIds.contains(reportType)) {
            return true;
        }
        outputParams.put("msg", String.format(ResManager.loadKDString((String)"\u60a8\u65e0\u6743\u751f\u6210%1s\u7ec4\u7ec7\u7684%2s\u62a5\u544a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CheckPermAndMatchTempAction_3", (String)"fi-fgptas-business", (Object[])new Object[0]), ReportGPTActionDataHelper.getNameById(orgId, "bos_org"), ReportGPTActionDataHelper.getNameById(reportType, "fgptas_report_type")));
        return false;
    }

    private boolean matchReportTemplate(Map<String, String> outputParams) {
        List notGlobalShare;
        List privateTemp;
        QFilter typeFilter;
        QFilter statusFilter;
        QFilter enableFilter;
        long orgId = Long.parseLong(outputParams.get("orgId"));
        long reportTypeId = Long.parseLong(outputParams.get("reportTypeId"));
        IBaseDataService baseDataService = (IBaseDataService)ServiceFactory.getService(IBaseDataService.class);
        QFilter useOrgFilter = baseDataService.getBaseDataFilter("fgptas_fireport_template", Long.valueOf(orgId));
        DynamicObjectCollection query = QueryServiceHelper.query((String)"fgptas_fireport_template", (String)"id,ctrlstrategy,createorg", (QFilter[])new QFilter[]{useOrgFilter, enableFilter = new QFilter("enable", "=", (Object)"1"), statusFilter = new QFilter("status", "=", (Object)"C"), typeFilter = new QFilter("reporttype", "=", (Object)reportTypeId)});
        if (query == null || query.size() < 1) {
            outputParams.put("msg", String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230%1s\u7ec4\u7ec7\u7684%2s\u62a5\u544a\u6a21\u677f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CheckPermAndMatchTempAction_4", (String)"fi-fgptas-business", (Object[])new Object[0]), ReportGPTActionDataHelper.getNameById(orgId, "bos_org"), ReportGPTActionDataHelper.getNameById(reportTypeId, "fgptas_report_type")));
            return false;
        }
        long templateId = query.size() == 1 ? ((DynamicObject)query.get(0)).getLong("id") : ((privateTemp = query.stream().filter(r -> orgId == r.getLong("createorg")).collect(Collectors.toList())).size() > 0 ? ((DynamicObject)privateTemp.get(0)).getLong("id") : ((notGlobalShare = query.stream().filter(r -> !"5".equals(r.getString("ctrlstrategy"))).collect(Collectors.toList())).size() > 0 ? ((DynamicObject)notGlobalShare.get(0)).getLong("id") : ((DynamicObject)query.get(0)).getLong("id")));
        LOGGER.info("matchReportTemplate:" + templateId);
        outputParams.put("templateId", String.valueOf(templateId));
        return true;
    }

    private void otherGlobalFieldsValues(Map<String, String> outputParams) {
        Map<String, Map<String, Set<String>>> globalFieldValues;
        long templateId = Long.parseLong(outputParams.get("templateId"));
        try {
            globalFieldValues = ReportGPTActionDataHelper.getReportTempGlobalFieldValue(templateId);
        }
        catch (Exception e) {
            outputParams.put("msg", e.getMessage());
            return;
        }
        if (globalFieldValues != null) {
            String fieldMatchKeywords = JSONObject.toJSONString(globalFieldValues);
            outputParams.put("matchKeywords", fieldMatchKeywords);
            Map<String, Set<String>> tableStructure = this.getTableStructure(globalFieldValues);
            String matchStructure = JSONObject.toJSONString(tableStructure);
            outputParams.put("matchStructure", matchStructure);
        }
    }

    private String extractValueNameByJson(String json, String key) {
        JSONObject jsonObject;
        String valueNameJson;
        String valueName = StringUtils.isNotEmpty((String)json) ? (StringUtils.isNotEmpty((String)(valueNameJson = (jsonObject = ReportGPTActionDataHelper.handleJsonString(json)).getString(key))) ? (valueNameJson.startsWith("[") && valueNameJson.endsWith("]") ? jsonObject.getJSONArray(key).getString(0) : valueNameJson) : null) : null;
        return valueName;
    }

    private Map<String, Set<String>> getTableStructure(Map<String, Map<String, Set<String>>> globalFieldValues) {
        HashMap<String, Set<String>> structure = new HashMap<String, Set<String>>(globalFieldValues.size());
        for (Map.Entry<String, Map<String, Set<String>>> ele : globalFieldValues.entrySet()) {
            String entityNumber = ele.getKey();
            Map<String, Set<String>> value = ele.getValue();
            structure.put(entityNumber, value.keySet());
        }
        return structure;
    }
}

