/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fgptas.business.report.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.isv.ISVService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class AWSIndexHelper {
    private static final Log LOG = LogFactory.getLog(AWSIndexHelper.class);

    public static Map<String, Object> queryIndexValueTwo(Map<String, Object> param) {
        LOG.info("queryIndexValueTwo param : " + param.toString());
        String isvPrefix = AWSIndexHelper.getIsvPrefix();
        LOG.info("queryIndexValueTwo isvPrefix : " + isvPrefix);
        HashMap<String, Object> result = new HashMap<String, Object>(8);
        if (CollectionUtils.isEmpty(param)) {
            return result;
        }
        Object categoryinfo = param.get("categoryinfo");
        if (Objects.isNull(categoryinfo)) {
            return result;
        }
        List categoryinfos = (List)categoryinfo;
        HashSet category_name_set = new HashSet(8);
        HashSet subcategory_name_set = new HashSet(8);
        for (Object category : categoryinfos) {
            Map categoryMap = (Map)category;
            category_name_set.add(categoryMap.get("category_name"));
            subcategory_name_set.add(categoryMap.get("subcategory_name"));
        }
        if (CollectionUtils.isEmpty(category_name_set) || CollectionUtils.isEmpty(subcategory_name_set)) {
            LOG.error("queryIndexValueTwo category_name or subcategory_name_set is null");
            return result;
        }
        QFilter filter = new QFilter("name", "in", category_name_set);
        DynamicObject[] fgptas_datatables = BusinessDataServiceHelper.load((String)"fgptas_datatable", (String)"id,number,name,entryentity.fieldnumber", (QFilter[])filter.toArray());
        if (Objects.isNull(fgptas_datatables) || fgptas_datatables.length <= 0) {
            LOG.error("queryIndexValueTwo category_name dont query table");
            return result;
        }
        HashMap<String, String> category_field = new HashMap<String, String>(16);
        HashMap<String, String> category_number = new HashMap<String, String>(16);
        for (DynamicObject dynamicObject : fgptas_datatables) {
            DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
            StringBuilder fields = new StringBuilder();
            for (DynamicObject dy : entryentity) {
                fields.append(dy.getString("fieldnumber")).append(',');
            }
            String substring = fields.substring(0, fields.length() - 1);
            category_field.put(dynamicObject.getString("name"), substring);
            category_number.put(dynamicObject.getString("name"), dynamicObject.getString("number"));
        }
        LOG.info("queryIndexValueTwo category_field : " + ((Object)category_field).toString());
        LOG.info("queryIndexValueTwo category_number : " + ((Object)category_number).toString());
        ArrayList dataList = new ArrayList(8);
        for (Object category : categoryinfos) {
            try {
                Map categoryMap = (Map)category;
                String category_name = categoryMap.get("category_name").toString();
                String metriccode = categoryMap.get("metriccode").toString();
                String subcategory_name = categoryMap.get("subcategory_name").toString();
                String substring = (String)category_field.get(category_name);
                LOG.info("queryIndexValueTwo substring : " + substring);
                Map params = (Map)categoryMap.get("params");
                LOG.info("params : ", (Object)params.toString());
                Object organizes = params.get("organize");
                if (Objects.isNull(organizes)) continue;
                String endtime = params.get("endtime").toString();
                String starttime = params.get("starttime").toString();
                List orgs = (List)organizes;
                for (String org : orgs) {
                    QFilter filter2 = new QFilter(isvPrefix + "index", "=", (Object)subcategory_name);
                    filter2.and("org", "=", (Object)Long.parseLong(org));
                    filter2.and(isvPrefix + "period", "=", (Object)endtime);
                    LOG.info("queryIndexValueTwo filter2 : " + filter2.toString());
                    DynamicObject dy = QueryServiceHelper.queryOne((String)((String)category_number.get(category_name)), (String)substring, (QFilter[])filter2.toArray());
                    HashMap<String, Object> data = new HashMap<String, Object>(8);
                    data.put("category_name", category_name);
                    data.put("subcategory_name", subcategory_name);
                    data.put("metriccode", metriccode);
                    data.put("org", org);
                    data.put("starttime", starttime);
                    data.put("endtime", endtime);
                    data.put("currency", "");
                    data.put("amount", -101);
                    if (!Objects.isNull(dy)) {
                        data.put("currency", dy.getString(isvPrefix + "currency"));
                        data.put("amount", dy.getBigDecimal(isvPrefix + "amount"));
                    }
                    dataList.add(data);
                }
            }
            catch (Exception e) {
                LOG.error("queryIndexValueTwo error ", (Throwable)e);
            }
        }
        result.put("result", dataList);
        LOG.info("queryIndexValueTwo result : " + ((Object)result).toString());
        return result;
    }

    public static Map<String, Object> queryIndexValue(Map<String, Object> param) {
        LOG.info("queryIndexValue param : " + param.toString());
        String isvPrefix = AWSIndexHelper.getIsvPrefix();
        LOG.info("queryIndexValue isvPrefix : " + isvPrefix);
        HashMap<String, Object> result = new HashMap<String, Object>(8);
        if (CollectionUtils.isEmpty(param)) {
            return result;
        }
        Object paramvalue = param.get("paramvalue");
        Object categoryinfo = param.get("categoryinfo");
        if (Objects.isNull(paramvalue) || Objects.isNull(categoryinfo)) {
            return result;
        }
        Map paramvalues = (Map)paramvalue;
        List categoryinfos = (List)categoryinfo;
        HashSet category_name_set = new HashSet(8);
        HashSet subcategory_name_set = new HashSet(8);
        for (Object category : categoryinfos) {
            Map categoryMap = (Map)category;
            category_name_set.add(categoryMap.get("category_name"));
            subcategory_name_set.add(categoryMap.get("subcategory_name"));
        }
        if (CollectionUtils.isEmpty(category_name_set) || CollectionUtils.isEmpty(subcategory_name_set)) {
            LOG.error("queryIndexValue category_name or subcategory_name_set is null");
            return result;
        }
        QFilter filter = new QFilter("name", "in", category_name_set);
        DynamicObject[] fgptas_datatables = BusinessDataServiceHelper.load((String)"fgptas_datatable", (String)"id,number,name,entryentity.fieldnumber", (QFilter[])filter.toArray());
        if (Objects.isNull(fgptas_datatables) || fgptas_datatables.length <= 0) {
            LOG.error("queryIndexValue category_name dont query table");
            return result;
        }
        HashMap<String, String> category_field = new HashMap<String, String>(16);
        HashMap<String, String> category_number = new HashMap<String, String>(16);
        for (DynamicObject dynamicObject : fgptas_datatables) {
            DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
            StringBuilder fields = new StringBuilder();
            for (DynamicObject dy : entryentity) {
                fields.append(dy.getString("fieldnumber")).append(',');
            }
            String substring = fields.substring(0, fields.length() - 1);
            category_field.put(dynamicObject.getString("name"), substring);
            category_number.put(dynamicObject.getString("name"), dynamicObject.getString("number"));
        }
        Object org_name = paramvalues.get("organize");
        if (Objects.isNull(org_name)) {
            LOG.error("queryIndexValue org is null");
            return result;
        }
        QFilter filter1 = new QFilter("name", "=", org_name);
        DynamicObject orgDy = QueryServiceHelper.queryOne((String)"bos_org", (String)"id,number,name", (QFilter[])filter1.toArray());
        if (Objects.isNull(orgDy)) {
            LOG.error("queryIndexValue org name dont query org dy");
            return result;
        }
        LOG.info("category_field : " + ((Object)category_field).toString());
        LOG.info("category_number : " + ((Object)category_number).toString());
        ArrayList dataList = new ArrayList(8);
        for (Object category : categoryinfos) {
            Map categoryMap = (Map)category;
            String category_name = categoryMap.get("category_name").toString();
            String metriccode = categoryMap.get("metriccode").toString();
            String subcategory_name = categoryMap.get("subcategory_name").toString();
            Map params = (Map)categoryMap.get("params");
            String substring = (String)category_field.get(category_name);
            LOG.info("substring : " + substring);
            QFilter filter2 = new QFilter(isvPrefix + "index", "=", (Object)subcategory_name);
            Set strings = params.keySet();
            for (String key : strings) {
                if (key.equals("organize")) {
                    filter2.and("org", "=", (Object)orgDy.getLong("id"));
                    continue;
                }
                if (!key.equals("endtime")) continue;
                filter2.and(isvPrefix + "period", "=", (Object)paramvalues.get(key).toString());
            }
            LOG.info("filter2 : " + filter2.toString());
            DynamicObject dy = QueryServiceHelper.queryOne((String)((String)category_number.get(category_name)), (String)substring, (QFilter[])filter2.toArray());
            if (Objects.isNull(dy)) continue;
            HashMap<String, Object> data = new HashMap<String, Object>(8);
            data.put("subcategory_name", subcategory_name);
            data.put("currency", dy.getString(isvPrefix + "currency"));
            data.put("amount", dy.getBigDecimal(isvPrefix + "amount"));
            data.put("metriccode", metriccode);
            dataList.add(data);
        }
        result.put("result", dataList);
        LOG.info("queryIndexValue result : " + ((Object)result).toString());
        return result;
    }

    public static String getIsvPrefix() {
        String isvInfo = ISVService.getISVInfo().getId().toLowerCase();
        return isvInfo + "_";
    }
}

