/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fgptas.business.report.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.FileNameUtils;
import kd.bos.util.RevProxyUtil;
import kd.fi.fgptas.common.constant.ReportConstants;

public class ReportControlHelper {
    private static final Log logger = LogFactory.getLog(ReportControlHelper.class);

    public static JSONObject dataInit(Object chartData, Object ii18n) {
        JSONObject dataObj = new JSONObject();
        dataObj.put("dataType", (Object)ReportConstants.PropsDataType.DATA_PREVIEW);
        dataObj.put("designMode", (Object)false);
        dataObj.put("data", chartData);
        dataObj.put("i18n", ii18n);
        dataObj.put("t", (Object)TimeServiceHelper.now());
        return dataObj;
    }

    public static DynamicObject getControl(Long controlId, boolean isNeedContent) {
        DynamicObject chapterDy;
        String filedStr = "id,filename,path,fullpath,isupdate,type";
        if (isNeedContent) {
            filedStr = filedStr + ",content";
        }
        if ((chapterDy = QueryServiceHelper.queryOne((String)"fatvs_aiword_control", (String)filedStr, (QFilter[])new QFilter("id", "=", (Object)controlId).toArray())) == null) {
            logger.error("aiword controlId not exist:" + controlId);
            throw new KDBizException(ResManager.loadKDString((String)"\u56fe\u8868\u63a7\u4ef6\u6570\u636e\u4e0d\u5b58\u5728\uff01", (String)"ReportControlHelper_0", (String)"fi-fgptas-business", (Object[])new Object[0]));
        }
        return chapterDy;
    }

    public static JSONObject dataInit(Long controlId) {
        DynamicObject control = ReportControlHelper.getControl(controlId, true);
        JSONObject chartData = new JSONObject();
        String content = control.getString("content");
        if (kd.bos.util.StringUtils.isNotEmpty((String)content)) {
            chartData = JSON.parseObject((String)content);
        }
        return ReportControlHelper.dataInit(chartData, ReportControlHelper.getI18n());
    }

    public static JSONObject getI18n() {
        Lang lang = Lang.get();
        JSONObject dataObj = new JSONObject();
        dataObj.put("lang", (Object)lang.getLangTag());
        return dataObj;
    }

    public static void imageUpload(Long controlId, String eventArgs) {
        JSONObject jsonObject = JSON.parseObject((String)eventArgs);
        String base64 = jsonObject.getString("base64");
        if (kd.bos.util.StringUtils.isEmpty((String)base64)) {
            return;
        }
        if (kd.bos.util.StringUtils.isEmpty((String)(base64 = base64.replace("data:image/png;base64,", "")))) {
            return;
        }
        DynamicObject control = ReportControlHelper.getControl(controlId, false);
        try {
            byte[] imageData = ReportControlHelper.base64ConvetToByte(base64);
            ReportControlHelper.updataUrl(control, imageData);
        }
        catch (Exception ex) {
            logger.error("aiword imageUpload fail", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updataUrl(DynamicObject control, byte[] imageData) throws IOException {
        String filename = control.getString("filename");
        String path = control.getString("path");
        String fullpath = control.getString("fullpath");
        try (ByteArrayInputStream in = null;){
            in = new ByteArrayInputStream(imageData);
            FileService service = FileServiceFactory.getAttachmentFileService();
            FileItem fileItem = null;
            if (!kd.bos.util.StringUtils.isEmpty((String)fullpath)) {
                fileItem = new FileItem(filename, path, (InputStream)in);
                fileItem.setCreateNewFileWhenExists(false);
            }
            String turl = service.upload(fileItem);
            logger.info("aiword updateurl turl:" + turl);
        }
    }

    private static byte[] base64ConvetToByte(String base64) {
        byte[] imageData = Base64.getDecoder().decode(base64);
        for (int i = 0; i < imageData.length; ++i) {
            if (imageData[i] >= 0) continue;
            int n = i;
            imageData[n] = (byte)(imageData[n] + 256);
        }
        return imageData;
    }

    public static Long createChart(String chartData) {
        if (kd.bos.util.StringUtils.isEmpty((String)chartData)) {
            return null;
        }
        Long controlId = DBServiceHelper.genGlobalLongId();
        String fileName = controlId + ".png";
        String path = FileNameUtils.getAttachmentFileName((String)RequestContext.get().getTenantId(), (String)RequestContext.get().getAccountId(), (String)"fgptas", (String)"fatvs_aiword_gpttest", (Object)controlId, (String)fileName);
        String imageData = "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";
        ByteArrayInputStream in = new ByteArrayInputStream(ReportControlHelper.base64ConvetToByte(imageData));
        FileItem fileItem = new FileItem(fileName, path, (InputStream)in);
        fileItem.setCreateNewFileWhenExists(true);
        try {
            in.close();
        }
        catch (IOException var17) {
            logger.error("aiword createChart upload", (Throwable)var17);
        }
        FileService service = FileServiceFactory.getAttachmentFileService();
        service.upload(fileItem);
        String fullpath = UrlService.getAttachmentFullUrl((String)path);
        DynamicObject newControl = BusinessDataServiceHelper.newDynamicObject((String)"fatvs_aiword_control");
        newControl.set("id", (Object)controlId);
        newControl.set("remark", (Object)"");
        newControl.set("isupdate", (Object)0);
        newControl.set("creator", (Object)RequestContext.get().getCurrUserId());
        newControl.set("createtime", (Object)new Date());
        newControl.set("modifier", (Object)RequestContext.get().getCurrUserId());
        newControl.set("modifytime", (Object)new Date());
        newControl.set("filename", (Object)fileName);
        newControl.set("path", (Object)path);
        newControl.set("fullpath", (Object)fullpath);
        newControl.set("content", (Object)chartData);
        try (TXHandle tx = TX.required();){
            try {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newControl});
            }
            catch (Exception e) {
                tx.markRollback();
                throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
            }
        }
        return controlId;
    }

    public static String buildUrl(Long controlId) {
        try {
            String formId = "fatvs_aiword_chart";
            HashMap<String, Long> params = new HashMap<String, Long>(2);
            params.put("pkId", controlId);
            StringBuilder formUrl = new StringBuilder();
            StringBuilder dFormUrl = new StringBuilder();
            formUrl.append("?formId=").append(formId);
            dFormUrl.append("#/dform?formId=").append(formId);
            String customParams = "";
            if (null != params && !params.isEmpty() && !StringUtils.isEmpty((CharSequence)(customParams = URLEncoder.encode(SerializationUtils.toJsonString(params), "utf-8")))) {
                dFormUrl.append("&customParams=").append(customParams);
            }
            String domainUrl = UrlService.getDomainContextUrl();
            domainUrl = RevProxyUtil.addSlash((String)domainUrl);
            StringBuilder url = new StringBuilder();
            url.append(domainUrl).append((CharSequence)formUrl).append((CharSequence)dFormUrl);
            return url.toString();
        }
        catch (Exception ex) {
            logger.error("aiword buildUrl fail", (Throwable)ex);
            return "";
        }
    }
}

