/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fgptas.business.report.helper;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;

public class ReportExceptionHelper {
    public static String buildExceptionMsg(String title, Throwable e, int stackLimit) {
        List stackMsgs = Arrays.stream(e.getStackTrace()).filter(ele -> Objects.nonNull(ele.getClassName()) && ele.getClassName().startsWith("kd.fi.fatvs")).map(ele -> String.format("%s:%s %s \n\n", ele.getFileName(), ele.getLineNumber(), ele.toString())).collect(Collectors.toList());
        if (stackLimit > 0) {
            stackMsgs = stackMsgs.subList(0, Math.min(stackMsgs.size(), stackLimit));
        }
        return String.format("%s\r\n %s[%s] %s", title, e.getMessage(), RequestContext.get().getTraceId(), String.join((CharSequence)",", stackMsgs));
    }
}

