/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fgptas.business.report.helper;

import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.attachment.util.BillFileMappingWriter;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.Uuid8;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.attachment.AttachmentInfo;
import kd.bos.mservice.attachment.FieldType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.FileNameUtils;
import kd.bos.util.StringUtils;
import kd.fi.fgptas.business.report.dto.UserAcl;
import kd.fi.fgptas.business.report.dto.WpsFile;
import kd.fi.fgptas.business.report.dto.WpsGetFileResult;
import kd.fi.fgptas.business.report.dto.WpsGetUserResult;
import kd.fi.fgptas.business.report.dto.WpsSaveFileResult;
import kd.fi.fgptas.business.report.dto.WpsUser;
import kd.fi.fgptas.business.report.helper.ReportConfigHelper;
import kd.fi.fgptas.business.report.helper.ReportHelper;
import kd.fi.fgptas.business.report.helper.ReportSignatureUtil;
import kd.fi.fgptas.common.utils.LongUtil;

public class ReportFileHelper {
    private static final Log logger = LogFactory.getLog(ReportFileHelper.class);

    public static Map<String, String> createDocTempUrl(Long wordId, String sourceUrl, boolean isRead) {
        JSONObject jsonObject = ReportConfigHelper.getWpsConfig();
        String domain = jsonObject.getString("domain").trim();
        String appId = jsonObject.getString("appid").trim();
        String appsecrect = jsonObject.getString("appsecrect").trim();
        Long docId = ReportFileHelper.createDocTemp(wordId, sourceUrl, isRead);
        HashMap<String, String> values = new HashMap<String, String>(2);
        values.put("_w_appid", appId);
        values.put("_w_fileid", docId.toString());
        String keyValueStr = ReportSignatureUtil.getKeyValueStr(values);
        String signature = ReportSignatureUtil.getSignature(values, appsecrect);
        String fileTypeCode = "w";
        if (!domain.endsWith("/")) {
            domain = domain + "/";
        }
        String url = domain + fileTypeCode + "/" + docId + "?" + keyValueStr + "_w_signature=" + signature;
        url = url + "&access_token=" + RequestContext.get().getGlobalSessionId();
        HashMap<String, String> result = new HashMap<String, String>(2);
        result.put("docId", docId.toString());
        result.put("url", url);
        return result;
    }

    private static long createDocTemp(Long wordId, String sourceUrl, boolean isRead) {
        Long docId = DBServiceHelper.genGlobalLongId();
        String downloadurl = "";
        downloadurl = StringUtils.isEmpty((String)sourceUrl) ? ReportFileHelper.uploadEmptyTempFile(docId.toString()) : ReportFileHelper.uploadTempFile(sourceUrl, docId.toString());
        DynamicObject newFileHistory = BusinessDataServiceHelper.newDynamicObject((String)"fgptas_report_wpsfile");
        newFileHistory.set("id", (Object)DBServiceHelper.genGlobalLongId());
        newFileHistory.set("remark", (Object)"");
        newFileHistory.set("docid", (Object)docId.toString());
        newFileHistory.set("reportid", (Object)wordId);
        newFileHistory.set("version", (Object)ReportFileHelper.getSecondTimestamp());
        newFileHistory.set("creator", (Object)RequestContext.get().getCurrUserId());
        newFileHistory.set("createtime", (Object)new Date());
        newFileHistory.set("modifier", (Object)RequestContext.get().getCurrUserId());
        newFileHistory.set("modifytime", (Object)new Date());
        newFileHistory.set("downloadurl", (Object)downloadurl);
        newFileHistory.set("filesize", (Object)String.valueOf(ReportFileHelper.getTempFileSize(downloadurl)));
        newFileHistory.set("name", (Object)docId.toString());
        newFileHistory.set("operpermission", (Object)(isRead ? "read" : "write"));
        newFileHistory.set("token", (Object)RequestContext.get().getGlobalSessionId());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newFileHistory});
        return docId;
    }

    private static int getTempFileSize(String url) {
        int fileSize = 0;
        try {
            TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            InputStream in = cache.getInputStream(url);
            fileSize = in.available();
            in.close();
        }
        catch (IOException ex) {
            logger.info("aiword getTempFileSize InputStream fail:" + ex.getMessage());
        }
        return fileSize;
    }

    private static String uploadTempFile(String url, String docId) {
        String fileName = docId + ".docx";
        logger.info("uploadTempFile url : " + url);
        String newUrl = "";
        try {
            TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            FileService service = FileServiceFactory.getAttachmentFileService();
            InputStream in = service.getInputStream(url);
            newUrl = RequestContext.get() != null && RequestContext.get().getClientFullContextPath() != null ? cache.saveAsFullUrl(fileName, in, 86400) : cache.saveAsUrl(fileName, in, 86400);
            in.close();
        }
        catch (IOException var17) {
            logger.info("aiword uploadTempFile close InputStream fail:" + var17.getMessage());
            throw new KDBizException(ResManager.loadKDString((String)"\u4e34\u65f6\u6587\u4ef6\u8f6c\u6362\u5931\u8d25\uff01", (String)"ReportFileHelper_0", (String)"fi-fgptas-business", (Object[])new Object[0]));
        }
        return newUrl;
    }

    private static String uploadEmptyTempFile(String docId) {
        String fileName = docId + ".docx";
        String sampleString = "UEsDBBQABgAIAAAAIQDfpNJsWgEAACAFAAATAAgCW0NvbnRlbnRfVHlwZXNdLnhtbCCiBAIooAACAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAC0lMtuwjAQRfeV+g+Rt1Vi6KKqKgKLPpYtUukHGHsCVv2Sx7z+vhMCUVUBkQpsIiUz994zVsaD0dqabAkRtXcl6xc9loGTXmk3K9nX5C1/ZBkm4ZQw3kHJNoBsNLy9GUw2ATAjtcOSzVMKT5yjnIMVWPgAjiqVj1Ykeo0zHoT8FjPg973eA5feJXApT7UHGw5eoBILk7LXNX1uSCIYZNlz01hnlUyEYLQUiep86dSflHyXUJBy24NzHfCOGhg/mFBXjgfsdB90NFEryMYipndhqYuvfFRcebmwpCxO2xzg9FWlJbT62i1ELwGRztyaoq1Yod2e/ygHpo0BvDxF49sdDymR4BoAO+dOhBVMP69G8cu8E6Si3ImYGrg8RmvdCZFoA6F59s/m2NqciqTOcfQBaaPjP8ber2ytzmngADHp039dm0jWZ88H9W2gQB3I5tv7bfgDAAD//wMAUEsDBBQABgAIAAAAIQAekRq37wAAAE4CAAALAAgCX3JlbHMvLnJlbHMgogQCKKAAAgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAArJLBasMwDEDvg/2D0b1R2sEYo04vY9DbGNkHCFtJTBPb2GrX/v082NgCXelhR8vS05PQenOcRnXglF3wGpZVDYq9Cdb5XsNb+7x4AJWFvKUxeNZw4gyb5vZm/cojSSnKg4tZFYrPGgaR+IiYzcAT5SpE9uWnC2kiKc/UYySzo55xVdf3mH4zoJkx1dZqSFt7B6o9Rb6GHbrOGX4KZj+xlzMtkI/C3rJdxFTqk7gyjWop9SwabDAvJZyRYqwKGvC80ep6o7+nxYmFLAmhCYkv+3xmXBJa/ueK5hk/Nu8hWbRf4W8bnF1B8wEAAP//AwBQSwMEFAAGAAgAAAAhANZks1H0AAAAMQMAABwACAF3b3JkL19yZWxzL2RvY3VtZW50LnhtbC5yZWxzIKIEASigAAEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAArJLLasMwEEX3hf6DmH0tO31QQuRsSiHb1v0ARR4/qCwJzfThv69ISevQYLrwcq6Yc8+ANtvPwYp3jNR7p6DIchDojK971yp4qR6v7kEQa1dr6x0qGJFgW15ebJ7Qak5L1PWBRKI4UtAxh7WUZDocNGU+oEsvjY+D5jTGVgZtXnWLcpXndzJOGVCeMMWuVhB39TWIagz4H7Zvmt7ggzdvAzo+UyE/cP+MzOk4SlgdW2QFkzBLRJDnRVZLitAfi2Myp1AsqsCjxanAYZ6rv12yntMu/rYfxu+wmHO4WdKh8Y4rvbcTj5/oKCFPPnr5BQAA//8DAFBLAwQUAAYACAAAACEAs8li+kwCAADVBgAAEQAAAHdvcmQvZG9jdW1lbnQueG1spJXfb9owEMffJ+1/iPze5keBQVSotHVFfZhUle15Mo6TWMQ+yzYE9tfvnB+EqVMF5Sm2z/e57/ni8/3DXlbBjhsrQM1JfBuRgCsGmVDFnPz6+XQzJYF1VGW0AsXn5MAteVh8/nRfpxmwreTKBYhQNq01m5PSOZ2GoWUll9TeSsEMWMjdLQMZQp4LxsMaTBYmURw1I22AcWsx3jeqdtSSDsf259EyQ2t09sBRyEpqHN/3DPlWEWiu0JiDkdTh1BShpGaz1TfI1NSJtaiEOyAumvQYmJOtUWmHuDnK8C5pK6P79B7mnLity2N3ik3E0PAKNYCypdDHo5AfpaGx7CG795LYyarfV+t4dF0dH9uKDMBz5HdllFWr/H1iHJ1REY84epwj4d+YvRJJhRoCf+hoTg43Hl8GSN4AJpZfhhh3iNAe5HA1al1cV+Wlga0eaOI62rPaHFm+zVzA6v6W0z/YXidmVVKNV1my9LlQYOi6QkVY+wDLFzQVCPwtIQtsgmvIDv6rgzrFJpq9zkkU3X1JnpKE9EuPPKfbyp1YWk/Y+NazctizcKvIcIP3UVRivN9L+ErZhoSne7+r7LgTDSHG9WbLmXsx/1HQKCtWf9CEVyCOZ76p1WmJ48n0btrCdfGDemcHeFPj0agRYURRouJ4GjXTNTgHcjBXPD+xlpxmHHvedBz7aQ7g/HQ2a86g2Lpm2kiuUwaVxVWrKcM0R8m4XcbXZGmET88dNBoqofCp8aFw8CIcQ9F3cdKl3WbcDNsKhMN7tPgLAAD//wMAUEsDBBQABgAIAAAAIQD+nO9mMgYAAJQaAAAVAAAAd29yZC90aGVtZS90aGVtZTEueG1s7FlNixs3GL4X+h+GuTse2zP+WOIN9thO2uwmIbtJyVGekWcUa0ZGknfXhEBITqVQKKQlhwZKLz2U0kADDe2h/6VbEtL0R1TSeOyRLbOk60Ao2V3W+njeV4/eV3qk8Vy8dJJg6whShkjatisXHNuCaUBClEZt+9bhoNS0LcZBGgJMUti2Z5DZl3Y//ugi2OExTKAl7FO2A9p2zPlkp1xmgWgG7AKZwFT0jQhNABdVGpVDCo6F3wSXq45TLycApbaVgkS4vT4aoQBaf734/fX3T/588IX4s3fzMfpY/Es5kw0BpgdyBKgZKmw4rsgPNmM+ptYRwG1bDBeS40N4wm0LA8ZFR9t21I9d3r1YXhhhvsG2YDdQP3O7uUE4rio7Gg0Xhq7rufXOwr8CYL6O6zf69X594U8BQBCImWZciliv2+r2vDm2AMqKBt+9Rq9W0fAF/7U1fMeTvxpegbKiu4YfDPxlDAugrOgZYtKo+q6GV6CsWF/DN5xOz21oeAWKMUrHa2jHq9f8fLYLyIjgK0Z4y3MHjeocvkSVC6srs0/5prWWgLuEDgRAJRdwlFp8NoEjEAjcq58+f/XbH9YeimKx7iYgJUy0OlVn4NTEf/nrqpIKCNiBoGCcNQVsrUnSsVhA0YS37U+FV7sAefnixenD56cPfz199Oj04c/zsdftroA0Ktq9+eGrf54+sP7+5bs3j78241kRr03NCOcarW+evXr+7OWTL1//+NgA71AwLMIPUQKZdQ0eWzdJIiZoGAAO6dtZHMYAFS06acRACqSNAd3nsYa+NgMYGHBdqMfxNhVqYQJent7VCB/EdMqRAXg1TjTgPiG4S6hxTlflWMUoTNPIPDidFnE3ATgyje2vZLk/nYhlj0wu/RhqNG9gkXIQwRRyS/aRMYQGszsIaXHdRwEljIy4dQdZXYCMITlEQ201LY2uoETkZWYiKPKtxWb/ttUl2OS+B490pNgbAJtcQqyF8TKYcpAYGYMEF5F7gMcmkgczGmgBZ1xkOoKYWP0QMmayuU5nGt2rQMiWMe37eJboSMrR2ITcA4QUkT0y9mOQTIycURoXsZ+wsViiwLpBuJEE0XeIrIs8gHRjum8jqKX77L19S8iQeYHInik1bQlI9P04wyMAlfPyiqwnKD1L41fU3Xt36i409OW3T82SuwVFNwPPo+UdioybaVXBN+FWddsnNETvv2z3wDS9AcVOMUA/qPYH1f7fq/am/bx9rV7Ks7rG55d15SbZeHMfIYwP+AzDPaaEnYnphQPRqCrKaPGgMIlFcT6chosoUGWLEv4Z4vFBDCZimIoaIWJz1xGzJoSJs0E1G33LDjxN9kmYtVYq+bOpMAB82S7OlrxdHEQ8a603lg9hC/eqFqmH5ZyAtH0bEoXBdBI1A4lG3ngGCTWzrbBoGVg0pfuNLNTHPCti/1lAfrvhuRkjsd4AhqHMU2afZ3frmd4UTH3aVcP0WpLrdjKtkSgsN51EYRnGIISrzVvOdWuZUo2eDMU6jUbzXeRaisiKNuBUr1nHYs/VPOEmAJO2PRKXQlFMJsIfk7oJcJS27YDPA/1flGVCGe8BFmcw1ZXNP0EcUgujRKz1YhpwuuRWqTbkHN9Tci3n/Yuc+igmGY5GMOAbWpZV0Zc5MfaeEywrZCpIH8ThsTXEU3oTiEB5jYoMYIgYX0QzRLSwuJdRXJGr+VbUvjNbblGAJzGYnyhFMc/gqrygU5iHYro6K70+n8wwkkk696l7tpHsKIjmhgNEnppm/Xh3h3yB1VL3NVaZdK9qXSvXuk2nxPkPhAK15WAaNcnYQG3ZqlPb4oWgMNxiaW46I7Z9GqyuWnlA5PdKVVt7OUGGd8XK74nr6hRzpqjCE/GM4OdfK2dKoFpzdTnh1pSitn3P8TquX/X8ktP0+iW35jqlpteplTqeV6v0vYrT61bvi6DwOKl42dgD8TyDZ/NXMKp97TVMkl+zLwQkKRN1Dy4rY/UaplI1vYY5lP22hURk7tWrg1at1a2XWrXOoOT2us1Sy693S7263+gNer7XbA3u29aRArudmu/W+81SveL7JbfuSPrNVqnhVqsdt9Fp9t3O/Xmsxczzzzy8itfuvwAAAP//AwBQSwMEFAAGAAgAAAAhALta0h9hBAAAcAsAABEAAAB3b3JkL3NldHRpbmdzLnhtbLRWbXPaOBD+fjP3Hxh/PgI4QBKmpBMCbtKBNhMnd59le8E6ZMkjybykc//9VpKFSXPt0N70E/I++6bVPru8e78rWGsDUlHBx0HvrBu0gKcio3w1Dp6fovZl0FKa8IwwwWEc7EEF769//+3ddqRAa1RTLXTB1ahIx0GudTnqdFSaQ0HUmSiBI7gUsiAaP+WqUxC5rsp2KoqSaJpQRvW+E3a7w6B2I8ZBJfmodtEuaCqFEkttTEZiuaQp1D/eQp4S15lMRVoVwLWN2JHAMAfBVU5L5b0VP+sNwdw72XzvEpuCeb1tr3vCdbdCZgeLU9IzBqUUKSiFD1QwnyDlTeD+G0eH2GcYu76idYXmva49HWc++DEH4RsHQwU/5mJQu+iofQE770ixU0rioDlNJJGu4ep6FOnofsWFJAnDdLAuLbxay2YXXGOXvwhRtLajEmSKT40U6XaDjgEy8UnoKVUlI/sHsoKJqJAlkoKycIKpIq2mRiuupDToHRCUfROOhNA1nMGSVEw/kSTWosT4G4LX7Ic+tiRbfNkPkmZ/gtQ0JSwuSYoir9obDGtVl+GdkPRFcE3YtLGdIfH33sK7dvre7be0Q6ed5kSSFLOuw99iCCmY1zI0l9iFDxVPdWXJVttZ/puTQkOIhHyeu7oQRngKMfpiMNlrJFmVuNNfNNN5U/o5kA1MSLpWjKj8xownC1bsSRJq6+EEVnu2K3GIxTld6kfQSDkLkezvSuk55XAHdJXre/5k+sD5URDN5mQvKn2UcuyGHl6QkwLcDQ+DbCEynEpoKunpnW0M6ic7rs3XgQRWHx8BbIKx3jMsGtcxfYEbnn3EW1D06Cr88xl8LwHgJvJnpNbTvoQICFYRl8GvCWbfLGK0XFDkhrznGZLvlwWjyyVIDECJhgXSjkqxtXV2hP2/cTvH/Y6bNlP+8IiMP/APB9xwdnnlMjXoKcj5RRiFloydg+9iZHbRg/Qn0yitwlnckiKRlLQWZlt1jEYi1xPKPZ4ATk04RuIq8WC77QBVEMYiJL4H7Owo7OyYwtKe2YLIVeO31pD/KcVp9/Hgy4xZkB9wIpYO3UpSugbwKr1+v7akHNlbeLmqkthbcZzzRxCO188baevUlGc70viQlkhz0sxO4O3n2DwhEKVvFCXj4CVv336qe4jJ2Lw/LEhZujZKVr1xwMwA6RkzjV+4Cdb2I1mFNRZaLHSY/SCpuSxq14dGFnrZkd65l503sr6X9RvZwMsGjWzoZUMjy5HAklG+xo72RyNfCsbEFrK7Bn8jckVQOSlh6pYUdpxwgnprqdZmBDvclZBRjX8fS5oVZGdWZ2iXUq3N7Gx9pWswo1y+9pARTTyXXhnbrv8qF7M8U4odGu+LpFlFZy5xRhXyv8StpYX02B8W6w3sOtO4PtI1PuwjLCdEQVZjmUjvM/PnwNl86UWXUTfsTduz4W2/3Z8Mo/bkYnrVvhoOL6Pzweyi17/6pyam/6t8/S8AAAD//wMAUEsDBBQABgAIAAAAIQDd3JDo6AEAAFUFAAASAAAAd29yZC9mb250VGFibGUueG1s3JJNbtswEIX3BXoHgvtYlGQrrhA5cJ0KKFBkUaRAtzRNSUT5I5C0FR+hh+kFuulxco2MKDkJ4hS1t5UgiHxDfjPzyKvreyXRjlsnjC5wPCEYcc3MRui6wN/uyos5Rs5TvaHSaF7gPXf4evH+3VWXV0Z7h2C/drliBW68b/MocqzhirqJabmGYGWsoh6mto4UtT+27QUzqqVerIUUfh8lhGR4xNhTKKaqBOM3hm0V1z7sjyyXQDTaNaJ1B1p3Cq0zdtNaw7hz0LOSA09RoZ8w8fQIpASzxpnKT6CZsaKAgu0xCSMlnwGz8wDJESBz/DzEbEREbq/4PUaK5Z9rbSxdSyBBSwiqQgGMF+Nhoi7XVEH44dfPh99/gk6lvwUNQjsqC3zDdf1dUI2jPthSbRyPD0HS954RQlL4j++wkDXUOt4nCAvn2SBXVAm5P6h0683IFZ41B3lHreirHkJO1BDYujUp8BJSkeRjiQclLnA6X5WXq3I5KgnUFJ44G5X0oBDSKyxwYDKFL3BY4DytgZzRYM6RSXdCcYdueYe+GgWOvG1IAoakZAYJZjBOyfRNQ4ZMrw2xgXuOI596Q5blC0dWoFzOp/FrR8iHfzgCpg2c0x0Zrg36IurG/8WO//l+jAO3eAQAAP//AwBQSwMEFAAGAAgAAAAhAJN21kkYAQAAQAIAABQAAAB3b3JkL3dlYlNldHRpbmdzLnhtbJTRwUoDMRAG4LvgO4Tc22yLLbJ0WxCpeBFBfYA0nW2DmUzIpG7r0zuuVREv7S2TZD7mZ2aLPQb1Bpk9xUaPhpVWEB2tfdw0+uV5ObjWiouNaxsoQqMPwHoxv7yYdXUHqycoRX6yEiVyja7R21JSbQy7LaDlISWI8thSRlukzBuDNr/u0sARJlv8ygdfDmZcVVN9ZPIpCrWtd3BLbocQS99vMgQRKfLWJ/7WulO0jvI6ZXLALHkwfHloffxhRlf/IPQuE1NbhhLmOFFPSfuo6k8YfoHJecD4HzBlOI+YHAnDB4S9Vujq+02kbFdBJImkZCrVw3ouK6VUPPp3WFK+ydQxZPN5bUOg7vHhTgrzZ+/zDwAAAP//AwBQSwMEFAAGAAgAAAAhAHXyRc9tAQAAxwIAABAACAFkb2NQcm9wcy9hcHAueG1sIKIEASigAAEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAnFJNT8MwDL0j8R+q3lk6DghNXiY0hDjwMWkdnKPEbSPSJEoC2v49zspKEZzIyX62X95zAqt9b4oPDFE7uyzns6os0EqntG2X5a6+u7gui5iEVcI4i8vygLFc8fMz2ATnMSSNsSAKG5dll5JfMBZlh72IMypbqjQu9CJRGlrmmkZLvHXyvUeb2GVVXTHcJ7QK1YUfCcuBcfGR/kuqnMz64kt98MTHocbeG5GQP+VJM1Mu9cBGFGqXhKl1j7wieExgI1qMfA5sCODVBRVzzxDAuhNByET7y+AkgxvvjZYi0V75o5bBRdek4vkotsjTwKYtQAa2KN+DTodMNU3hQVs8XjAEpCqINgjfHcFJBlspDK7JOm+EiQjsG4C1672wBz4nO6c4U7/Fna/dbd7D19BPcGLyVadu64Uc1PyJw5ZQVKR/lDACcE/PEUxmp1nbojr1/C7kBb4M/5LPr2YVnePGThj5Hj8M/wQAAP//AwBQSwMEFAAGAAgAAAAhAH0pTTdnAQAA3wIAABEACAFkb2NQcm9wcy9jb3JlLnhtbCCiBAEooAABAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAJySXUvDMBSG7wX/Q8l9m3QFGaXtwI+B4GDoRPEuJmdbXJuGJFvtvzf9nMVdeXc+3vNw8p4ki+8i906gjShlisKAIA8kK7mQuxS9bpb+HHnGUslpXkpIUQ0GLbLrq4SpmJUa1rpUoK0A4zmSNDFTKdpbq2KMDdtDQU3gFNI1t6UuqHWp3mFF2YHuAM8IucEFWMqppbgB+mokoh7J2YhUR523AM4w5FCAtAaHQYjPWgu6MBcH2s4vZSFsreCidGiO6m8jRmFVVUEVtVK3f4jfV08v7VN9IRuvGKAs4Sy2wuaQJfgcusgcP7+A2a48Ji5mGqgtdfb48Lxum0OhsfoAdVVqbtzYJHMyDoZpoaw7YAedFJw6p8au3EW3Avht3fP/1huphpNofkIWtooxTXpbu52Ae86OuDNv6LxFd/ebJcpmZBb5JPQjsiHzOApjQj6atSbzZ2DRL/Bv4gDonJl+yewHAAD//wMAUEsDBBQABgAIAAAAIQAKAlzPLgsAAC1wAAAPAAAAd29yZC9zdHlsZXMueG1svJ1dc6M4Fobvt2r/A+Wr3Yu043x2p8Y9laTTm9R2MplxevtaBjnWRCCWj3Y8v36FABvnIMwRZ3OVGDgPQq9eSUeA/cuvr6H0fvIkFSqajiYfDkcej3wViOh5Ovr+9PXg48hLMxYFTKqIT0drno5+/fz3v/2yukizteSppwFRehH609Eyy+KL8Tj1lzxk6QcV80jvXKgkZJn+mDyPQ5a85PGBr8KYZWIupMjW46PDw7NRhUn6UNRiIXz+Rfl5yKPMxI8TLjVRRelSxGlNW/WhrVQSxInyeZrqiw5lyQuZiDaYyQkAhcJPVKoW2Qd9MVWJDEqHTw7Nf6HcAk5xgCMAOEs5DnFaIcbpOuSvIy/0L+6eI5WwudQkfUmeLpVnwKPPWs1A+V/4guUyS4uPyWNSfaw+mT9fVZSl3uqCpb4QT7oUGhUKTb29jFIx0ns4S7PLVLDmzptqW7F/WRzYGumnWWPzlQjEaFyc9IUnkd79k8np6KjclP612TCpt1wX5Sq3VUdJFj3X23h08H3WLN909Nfy4Pqh2DTXp5qOWHIwuywCx9Xlln8blRBvPpVHvakx3f50a5yVptB7+eKb8l94MMv0junosDiV3vj97jERKtENfzr69KnaOOOhuBVBwKPGgdFSBPzHkkffUx5st//+1TTeaoOv8kj/f3w+MSrKNLh59XlcWEHvjVhRoQ9FgCyOzsX25Cb8vzWsqsfW+CVnRX/gTd4iTPFRiKMiIm1cbTszf3Pt5ijUiY7f60Qn73Wi0/c60dl7nej8vU708b1OZDD/zxOJKOCvpRHhaQB1H8fiRjTHYjY0x+IlNMdiFTTH4gQ0x9LQ0RxLO0ZzLM0UwcmUb2uFjcZ+bGnt3dz9Y4Qbd/+Q4MbdPwK4cfd3+G7c/f27G3d/d+7G3d97u3H3d9Z4bjnV8u60zaJssMsWSmWRyriX8dfhNBZplkmSaHjFoMcTkoskwJQ9WzUQD6b5zHze30KMSd3H86xIxzy18BbiOU90bj204Dz6yaXOcj0WBJpHCEx4lieWGnFp0wlf8IRHPqds2HRQKSLuRXk4J2ibMXsmY/EoIK6+mkjSKWwaNMuzZWESQdCoQ+YnanjRFCPrH76JdHhdFRDvKpeSE7EeaJqYYQ3PDQxmeGpgMMMzA4MZnhg0NKOqoopGVFMVjajCKhpRvZXtk6reKhpRvVU0onqraMPr7Ulk0nTxzVnHpP/a3bVUxbL24HLMxHPE9ARg+HBTrZl6jyxhzwmLl16xqtyObV4z9jxXKlh7TxRj2oZENa83TeRaX7WI8uEVukOjMteGR2SvDY/IYBvecIvd62lyMUG7pclnZvk8azWtIfUy7YzJvJzQDncby4a3sK0BvookJbNBO5agBT8U09lCToqeb1vK4QXbsobb6m2vRFq8CklQSqn8F5pu+HYd80SnZS+DSV+VlGrFAzriLEtU2daalj8ykvSy/E0YL1kqTK60g+g/1Nc3xL17Fg++oEfJRESj281ByIT06GYQt0/337wnFRdpZlExNMArlWUqJGNWK4H/+MHn/6Qp4KVOgqM10dVeEi0PGdi1IBhkSpIKiEh6mikiQTKGGt6/+XquWBLQ0B4TXj6DknEi4oyFcTnpIPCW7hdXuv8hmA0Z3n9YIop1ISpTPZHAGsuGaT7/k/vDu7oH5ZGsDP2WZ2b90Ux1TTQdbvg0YQc3fIpg1NTDQ9F+CS52Bzf8YndwVBd7LVmaCustVGce1eXWPOrrHZ78VTwlVbLIJV0F1kCyGqyBZFWoZB5GKeUVGx7hBRse9fUSNhnDI1iSM7x/JSIgE8PAqJQwMCoZDIxKAwMjFWD4EzoN2PDHdBqw4c/qlDCiKUADRtXOSId/ors8DRhVOzMwqnZmYFTtzMCo2tnxF48vFnoSTDfENJBUba6BpBtoooyHsUpYsiZC3kj+zAgWSEvaY6IWxcsJKiof4iZAFmvUknCyXeKoRP7B52RFK1iU5SJYEWVSKkW0trYdcEzk7rNr+8LMaxiDi/Aomc+XSgY8sVyTPVbny7OY+dUyPbjd12vZ85t4XmbebLlZ7W9izg73RtYJ+07Y/hO21flZ/eZJW9g9D0Qe1gWFL1OcHfcPNi16J/hkf/B2JrETedozEp7zbH/kdpa8E3neMxKe82PPSOPTncguP3xhyUtrQzjvaj+bHM/S+M67WtEmuPW0XQ1pE9nWBM+7WtGOVbxL3y/uFkB1+nnGHt/PPPZ4jIvsFIyd7JTevrIjugz2B/8pipEd02ma822engD9vplE9+o5f89VuW6/c8Op/0tdd3riFKXca+Uc979xtdPL2Ouxd3djR/Tud+yI3h2QHdGrJ7KGo7okO6V332RH9O6k7Ah0bwVHBFxvBeNxvRWMd+mtIMWltxowC7Ajek8H7Ai0USECbdQBMwU7AmVUEO5kVEhBGxUi0EaFCLRR4QQMZ1QYjzMqjHcxKqS4GBVS0EaFCLRRIQJtVIhAGxUi0EZ1nNtbw52MCiloo0IE2qgQgTaqmS8OMCqMxxkVxrsYFVJcjAopaKNCBNqoEIE2KkSgjQoRaKNCBMqoINzJqJCCNipEoI0KEWijlq8auhsVxuOMCuNdjAopLkaFFLRRIQJtVIhAGxUi0EaFCLRRIQJlVBDuZFRIQRsVItBGhQi0Uc3NwgFGhfE4o8J4F6NCiotRIQVtVIhAGxUi0EaFCLRRIQJtVIhAGRWEOxkVUtBGhQi0USGiq31Wtyhtj9lP8Kue1if2+9+6qgr1R/NV7ibquD+qLpWd1f9dhCulXrzWFw+PTb7RDyLmUiizRG25rd7kmkciUDc+f7vufsOnSR/4pUvVuxDmnimAn/SNBGsqJ11NvhkJkryTrpbejASzzpOu3rcZCYbBk65O1/iyfihFD0cguKubaQRPLOFdvXUjHFZxVx/dCIQ13NUzNwJhBXf1x43AU6/onN9Gn/asp7PN86WA0NUcG4RzO6GrWUKt6u4YGqOvaHZCX/XshL4y2gkoPa0YvLB2FFphO8pNamgzrNTuRrUTsFJDgpPUAOMuNUQ5Sw1RblLDjhErNSRgpXbvnO0EJ6kBxl1qiHKWGqLcpIZDGVZqSMBKDQlYqQcOyFaMu9QQ5Sw1RLlJDSd3WKkhASs1JGClhgQnqQHGXWqIcpYaotykBlkyWmpIwEoNCVipIcFJaoBxlxqinKWGqC6pzSrKjtQohRvhuElYIxA3IDcCcZ1zI9AhW2pEO2ZLDYJjtgS1qjXHZUtN0eyEvurZCX1ltBNQeloxeGHtKLTCdpSb1LhsqU1qd6PaCVipcdmSVWpcttQpNS5b6pQaly3ZpcZlS21S47KlNqndO2c7wUlqXLbUKTUuW+qUGpct2aXGZUttUuOypTapcdlSm9QDB2Qrxl1qXLbUKTUuW7JLjcuW2qTGZUttUuOypTapcdmSVWpcttQpNS5b6pQaly3ZpcZlS21S47KlNqlx2VKb1LhsySo1LlvqlBqXLXVKbcmWxqudH2Aq2Ob3yfTB2TrmxXdwN16YCcrvIK1uApoD74LpiJnfUCoK4VW/G1X9dJIpa3Wv0Pwflz+ItRKBWhUvECdK1iFVJf3p1xvmKltWRTRh4+qMsIz+UhfSr752yVbGQ1BIyzeqmmJsa6o+uqr57R3T8ridu6NlaS2lzAplukpY/hQVrMZSU1u5PlWNdF/BdDHmsqx+/c9dFGjAqvo5q7KAwSsrUXr/NZfynpVHq9h+qOSLrNw7OTSv1L/ZPy+/Hc4an5huxAoY7xam/NjdGMrvi6/ub9uq+qilqs2DFkNreVuu+r/08/8AAAD//wMAUEsBAi0AFAAGAAgAAAAhAN+k0mxaAQAAIAUAABMAAAAAAAAAAAAAAAAAAAAAAFtDb250ZW50X1R5cGVzXS54bWxQSwECLQAUAAYACAAAACEAHpEat+8AAABOAgAACwAAAAAAAAAAAAAAAACTAwAAX3JlbHMvLnJlbHNQSwECLQAUAAYACAAAACEA1mSzUfQAAAAxAwAAHAAAAAAAAAAAAAAAAACzBgAAd29yZC9fcmVscy9kb2N1bWVudC54bWwucmVsc1BLAQItABQABgAIAAAAIQCzyWL6TAIAANUGAAARAAAAAAAAAAAAAAAAAOkIAAB3b3JkL2RvY3VtZW50LnhtbFBLAQItABQABgAIAAAAIQD+nO9mMgYAAJQaAAAVAAAAAAAAAAAAAAAAAGQLAAB3b3JkL3RoZW1lL3RoZW1lMS54bWxQSwECLQAUAAYACAAAACEAu1rSH2EEAABwCwAAEQAAAAAAAAAAAAAAAADJEQAAd29yZC9zZXR0aW5ncy54bWxQSwECLQAUAAYACAAAACEA3dyQ6OgBAABVBQAAEgAAAAAAAAAAAAAAAABZFgAAd29yZC9mb250VGFibGUueG1sUEsBAi0AFAAGAAgAAAAhAJN21kkYAQAAQAIAABQAAAAAAAAAAAAAAAAAcRgAAHdvcmQvd2ViU2V0dGluZ3MueG1sUEsBAi0AFAAGAAgAAAAhAHXyRc9tAQAAxwIAABAAAAAAAAAAAAAAAAAAuxkAAGRvY1Byb3BzL2FwcC54bWxQSwECLQAUAAYACAAAACEAfSlNN2cBAADfAgAAEQAAAAAAAAAAAAAAAABeHAAAZG9jUHJvcHMvY29yZS54bWxQSwECLQAUAAYACAAAACEACgJczy4LAAAtcAAADwAAAAAAAAAAAAAAAAD8HgAAd29yZC9zdHlsZXMueG1sUEsFBgAAAAALAAsAwQIAAFcqAAAAAA==";
        String newUrl = "";
        logger.info("aiword uploadEmptyTempFile docId: " + docId);
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(Base64.getDecoder().decode(sampleString));
            TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            newUrl = RequestContext.get() != null && RequestContext.get().getClientFullContextPath() != null ? cache.saveAsFullUrl(fileName, (InputStream)in, 86400) : cache.saveAsUrl(fileName, (InputStream)in, 86400);
            ((InputStream)in).close();
        }
        catch (IOException var17) {
            logger.info("aiword uploadEmptyTempFile InputStream fail:" + var17.getMessage());
            throw new KDBizException(ResManager.loadKDString((String)"\u4e34\u65f6\u6587\u4ef6\u8f6c\u6362\u5931\u8d25\uff01", (String)"ReportFileHelper_0", (String)"fi-fgptas-business", (Object[])new Object[0]));
        }
        return newUrl;
    }

    private static String uploadReturnTempFile(byte[] fileBytes, String docid) {
        String fileName = docid;
        String newUrl = "";
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(fileBytes);
            TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            newUrl = RequestContext.get() != null && RequestContext.get().getClientFullContextPath() != null ? cache.saveAsFullUrl(fileName, (InputStream)in, 86400) : cache.saveAsUrl(fileName, (InputStream)in, 86400);
            ((InputStream)in).close();
        }
        catch (IOException var17) {
            logger.info("report uploadReturnTempFile InputStream fail:" + var17.getMessage());
            throw new KDBizException(ResManager.loadKDString((String)"\u4e34\u65f6\u6587\u4ef6\u8f6c\u6362\u5931\u8d25\uff01", (String)"ReportFileHelper_0", (String)"fi-fgptas-business", (Object[])new Object[0]));
        }
        return newUrl;
    }

    public static String uploadFile(Long wordId, String tempUrl, String formId, String docId, String fileName) {
        String pkId = docId;
        String path = FileNameUtils.getAttachmentFileName((String)RequestContext.get().getTenantId(), (String)RequestContext.get().getAccountId(), (String)"fgptas", (String)formId, (Object)pkId, (String)fileName);
        TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        InputStream in = cache.getInputStream(tempUrl);
        FileService service = FileServiceFactory.getAttachmentFileService();
        FileItem fileItem = new FileItem(fileName, path, in);
        fileItem.setCreateNewFileWhenExists(true);
        String newUrl = "";
        try {
            logger.info("FileService :" + Arrays.toString(new List[]{service.getFileServerList()}));
            newUrl = service.upload(fileItem);
            in.close();
        }
        catch (IOException e) {
            logger.error("aiword upload url close InputStream fail:" + e.getMessage());
        }
        if (StringUtils.isNotEmpty((String)newUrl)) {
            String docUrl = UrlService.getAttachmentFullUrl((String)newUrl);
            ArrayList<AttachmentInfo> attachmentInfoList = new ArrayList<AttachmentInfo>();
            AttachmentInfo attachmentInfo = new AttachmentInfo();
            attachmentInfo.setAppId("fgptas");
            attachmentInfo.setAttPkId(wordId);
            attachmentInfo.setBillPkId(wordId.toString());
            attachmentInfo.setEntityNum("fgptas_report_list");
            attachmentInfo.setFileName(fileName);
            attachmentInfo.setDownloadUrl(docUrl);
            attachmentInfo.setFieldType(FieldType.AttachmentEdit);
            attachmentInfoList.add(attachmentInfo);
            BillFileMappingWriter.syncWriteFileBillMapping(attachmentInfoList);
        }
        return newUrl;
    }

    public static String getFileName(String fileName) {
        String utf8FileName = fileName;
        try {
            utf8FileName = URLEncoder.encode(fileName, "utf-8");
        }
        catch (UnsupportedEncodingException var18) {
            logger.info(var18.getMessage());
        }
        return utf8FileName;
    }

    private static long getSecondTimestamp() {
        return ReportFileHelper.getSecondTimestamp(new Date());
    }

    private static long getSecondTimestamp(Date date) {
        String timestamp = String.valueOf(date.getTime());
        int length = timestamp.length();
        if (length > 3) {
            return Long.parseLong(timestamp.substring(0, length - 3));
        }
        return 0L;
    }

    private static int convertLong(Long val) {
        if (val == null) {
            return 0;
        }
        return val.intValue();
    }

    public static WpsGetFileResult fileInfo(String docId) {
        String selectFileds = "id,downloadurl,reportid,version,filesize,operpermission,creator.id,creator.name,createtime,modifier.id,modifier.name,modifytime,token";
        QFilter qf = new QFilter("docid", "=", (Object)docId);
        DynamicObjectCollection wpsfileList = QueryServiceHelper.query((String)"fgptas_report_wpsfile", (String)selectFileds, (QFilter[])new QFilter[]{qf}, (String)"version");
        if (wpsfileList.size() == 0) {
            return WpsGetFileResult.failEx("docId=" + docId + " not exists");
        }
        DynamicObject wpsfile = (DynamicObject)wpsfileList.get(wpsfileList.size() - 1);
        String userId = wpsfile.getString("creator.id");
        String userName = wpsfile.getString("creator.name");
        long now = ReportFileHelper.getSecondTimestamp();
        WpsFile file = new WpsFile();
        file.setId(docId);
        file.setName(docId + ".docx");
        file.setVersion(ReportFileHelper.convertLong(wpsfile.getLong("version")));
        file.setSize(ReportFileHelper.convertLong(wpsfile.getLong("filesize")));
        file.setCreator(userId);
        file.setCreate_time(ReportFileHelper.convertLong(ReportFileHelper.getSecondTimestamp(wpsfile.getDate("createtime"))));
        file.setModifier(wpsfile.getString("modifier.id"));
        file.setModify_time(ReportFileHelper.convertLong(ReportFileHelper.getSecondTimestamp(wpsfile.getDate("modifytime"))));
        file.setDownload_url(wpsfile.getString("downloadurl") + "&access_token=" + wpsfile.getString("token"));
        UserAcl userAcl = new UserAcl();
        userAcl.setRename(0);
        userAcl.setHistory(1);
        userAcl.setCopy(1);
        userAcl.setExport(1);
        userAcl.setPrint(1);
        userAcl.setComment(1);
        file.setUser_acl(userAcl);
        WpsUser user = new WpsUser();
        user.setId(userId);
        user.setName(userName);
        user.setPermission(wpsfile.getString("operpermission"));
        WpsGetFileResult result = (WpsGetFileResult)WpsGetFileResult.success();
        result.setFile(file);
        result.setUser(user);
        return result;
    }

    public static WpsGetUserResult userInfo(List<String> userIds) {
        ArrayList<WpsUser> users = new ArrayList<WpsUser>(2);
        for (String userId : userIds) {
            Map user = UserServiceHelper.getUserInfoByID((long)LongUtil.toLong((Object)userId));
            if (user == null) continue;
            WpsUser userObj = new WpsUser();
            userObj.setId(userId);
            userObj.setName(user.get("name") == null ? userId : user.get("name").toString());
            userObj.setPermission("write");
            users.add(userObj);
        }
        WpsGetUserResult result = (WpsGetUserResult)WpsGetUserResult.success();
        result.setUsers(users);
        return result;
    }

    public static WpsSaveFileResult fileSave(byte[] fileBytes, String docId) {
        if (fileBytes == null || StringUtils.isEmpty((String)docId)) {
            return WpsSaveFileResult.failEx("fileByte or docId is null");
        }
        String selectFileds = "id,downloadurl,reportid,version,filesize,operpermission,creator.id,creator.name,createtime,modifier.id,modifier.name,modifytime,name,token";
        QFilter qf = new QFilter("docid", "=", (Object)docId);
        DynamicObjectCollection wpsfileList = QueryServiceHelper.query((String)"fgptas_report_wpsfile", (String)selectFileds, (QFilter[])new QFilter[]{qf}, (String)"version", (int)1);
        DynamicObject wpsfile = (DynamicObject)wpsfileList.get(wpsfileList.size() - 1);
        String downloadurl = ReportFileHelper.uploadReturnTempFile(fileBytes, docId + ".doc");
        String userId = wpsfile.getString("creator.id");
        long curTimestamp = ReportFileHelper.getSecondTimestamp();
        DynamicObject newFileHistory = BusinessDataServiceHelper.newDynamicObject((String)"fgptas_report_wpsfile");
        newFileHistory.set("id", (Object)DBServiceHelper.genGlobalLongId());
        newFileHistory.set("remark", (Object)"fileSave");
        newFileHistory.set("docid", (Object)docId);
        newFileHistory.set("reportid", (Object)wpsfile.getLong("reportid"));
        newFileHistory.set("version", (Object)curTimestamp);
        newFileHistory.set("creator", (Object)userId);
        newFileHistory.set("createtime", (Object)new Date());
        newFileHistory.set("modifier", (Object)userId);
        newFileHistory.set("modifytime", (Object)new Date());
        newFileHistory.set("downloadurl", (Object)downloadurl);
        newFileHistory.set("filesize", (Object)String.valueOf(ReportFileHelper.getTempFileSize(downloadurl)));
        newFileHistory.set("name", (Object)wpsfile.getString("name"));
        newFileHistory.set("operpermission", (Object)wpsfile.getString("operpermission"));
        newFileHistory.set("token", (Object)wpsfile.getString("token"));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newFileHistory});
        WpsFile file = new WpsFile();
        file.setId(docId);
        file.setName(docId + ".docx");
        file.setVersion(ReportFileHelper.convertLong(newFileHistory.getLong("version")));
        file.setSize(ReportFileHelper.convertLong(newFileHistory.getLong("filesize")));
        file.setCreator(userId);
        file.setCreate_time(ReportFileHelper.convertLong(ReportFileHelper.getSecondTimestamp(newFileHistory.getDate("createtime"))));
        file.setModifier(newFileHistory.getString("modifier.id"));
        file.setModify_time(ReportFileHelper.convertLong(ReportFileHelper.getSecondTimestamp(newFileHistory.getDate("modifytime"))));
        file.setDownload_url(newFileHistory.getString("downloadurl") + "&access_token=" + wpsfile.getString("token"));
        WpsSaveFileResult result = (WpsSaveFileResult)WpsSaveFileResult.success();
        result.setFile(file);
        return result;
    }

    public static boolean checkSignature(String docId, String w_signature) throws UnsupportedEncodingException {
        JSONObject jsonObject = ReportConfigHelper.getWpsConfig();
        String appId = jsonObject.getString("appid").trim();
        String appsecrect = jsonObject.getString("appsecrect").trim();
        HashMap<String, String> values = new HashMap<String, String>(2);
        values.put("_w_appid", appId);
        values.put("_w_fileid", docId);
        String signature = ReportSignatureUtil.getSignature(values, appsecrect);
        boolean check = signature.equals(URLEncoder.encode(w_signature, "UTF-8"));
        if (!check) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9274\u6743\u4e0d\u901a\u8fc7\uff01", (String)"ReportFileHelper_1", (String)"fi-fgptas-business", (Object[])new Object[0]));
        }
        return check;
    }

    public static String updateTxtFile(Long wordId, String content) {
        DynamicObject word = ReportHelper.getWord(wordId);
        String fileName = word.getString("name");
        Long docId = DBServiceHelper.genGlobalLongId();
        String tempUrl = "";
        content = content.replaceAll("<nextPage>", "");
        content = content.replaceAll("\n\n", "\r\n");
        String replaceAll = content.replaceAll("\n", "\r\n");
        byte[] bytes = new byte[replaceAll.length()];
        try {
            bytes = replaceAll.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.error("update txt file fails", (Object)e.getMessage());
        }
        tempUrl = ReportFileHelper.uploadReturnTempFile(bytes, docId + ".txt");
        return ReportFileHelper.uploadFile(wordId, tempUrl, "fgptas_report", docId.toString(), fileName + ".txt");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String upload(MainEntityType entityType, String fileName, String fileUrl, Object id) {
        FileService fileService = FileServiceFactory.getAttachmentFileService();
        RequestContext ctx = RequestContext.getOrCreate();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMM");
        String path = "/" + ctx.getTenantId() + '/' + ctx.getAccountId() + '/' + sdf.format(new Date()) + '/' + entityType.getAppId() + '/' + entityType.getName() + '/' + id + "/attachments/" + Uuid8.generateShortUuid() + '/' + fileName;
        try (InputStream inputStream = ReportFileHelper.getInputStreamByUrlJDK(fileUrl);){
            String string = fileService.upload(new FileItem(fileName, path, inputStream));
            return string;
        }
        catch (Exception e) {
            logger.error("fgptas file upload error\uff1a", (Throwable)e);
            return null;
        }
    }

    public static InputStream getInputStreamByUrlJDK(String url) {
        try {
            return new URL(url).openStream();
        }
        catch (Exception e) {
            logger.error("fgptas file getInputStream error\uff1a", (Throwable)e);
            return null;
        }
    }
}

