/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fgptas.business.report.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.exception.KDBizException;
import kd.bos.form.gpt.IGPTAction;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.fgptas.business.datatable.InvokePluginHelper;
import kd.fi.fgptas.business.enums.GlobalFieldEnum;
import kd.fi.fgptas.business.report.helper.ReportConfigHelper;
import kd.fi.fgptas.business.report.helper.ReportFileHelper;
import kd.fi.fgptas.business.report.helper.ReportGPTActionDataHelper;
import kd.fi.fgptas.business.report.helper.ReportGptHelper;
import kd.fi.fgptas.business.report.helper.ReportHelper;
import kd.fi.fgptas.business.report.helper.ReportTemDataHelper;
import kd.fi.fgptas.business.report.helper.process.ReportProcessBase;
import kd.fi.fgptas.business.report.redis.ManualGenReportRedis;
import kd.fi.fgptas.common.enums.ReportStatusEnum;
import kd.fi.fgptas.common.utils.LongUtil;

public class ReportGPTAction
extends ReportProcessBase
implements IGPTAction,
Serializable {
    private static final Log log = LogFactory.getLog(ReportGPTAction.class);
    public static final String PROCESS_BLANK = "BLANK";
    public static final String PROCESS_BEGIN = "BEGIN";
    public static final String PROCESS_COVER = "COVER";
    public static final String PROCESS_OUTLINE = "OUTLINE";
    public static final String PROCESS_CONTENT = "CONTENT";
    public static final String BASEDATA = "Basedata";

    public Map<String, String> invokeAction(String actionName, Map<String, String> inputData) {
        log.info("Report invokeAction actionName\uff1a" + actionName);
        log.info("Report invokeAction inputData\uff1a" + SerializationUtils.toJsonString(inputData));
        String process = actionName.toUpperCase(Locale.ENGLISH);
        int gptstatus = ReportStatusEnum.Running.getNumber();
        boolean available = ReportConfigHelper.getWpsConfig().getBoolean("available");
        if (PROCESS_BEGIN.equals(process)) {
            DynamicObject model = this.getModel(inputData);
            log.info("Report invokeAction model\uff1a{}", (Object)model);
            String dataRequire = inputData.get("dataRequire");
            if (StringUtils.isNotEmpty((String)dataRequire)) {
                String reportPeriodNumber;
                JSONObject jsonObject = JSONObject.parseObject((String)dataRequire);
                String tableKey = (String)jsonObject.keySet().stream().findFirst().get();
                JSONObject table = jsonObject.getJSONObject(tableKey);
                HashMap<Long, String> dataGlobalRequire = ReportTemDataHelper.getDataGlobalRequire(model.getLong("id"), tableKey);
                log.info("dataGlobalRequire:" + dataGlobalRequire);
                log.info("dataRequire input:" + tableKey + " " + table.toJSONString());
                String periodNumber = "period";
                String yearNumber = "year";
                if (null != dataGlobalRequire && dataGlobalRequire.size() > 0 && !"scenario_year_period".equals(reportPeriodNumber = dataGlobalRequire.get(GlobalFieldEnum.REPORT_PERIOD.getId()))) {
                    periodNumber = reportPeriodNumber;
                }
                String period = (String)table.getJSONArray(periodNumber).get(0);
                String year = null;
                if (null != table.getJSONArray(yearNumber)) {
                    year = (String)table.getJSONArray(yearNumber).get(0);
                }
                log.info("period from dataGlobalRequire:" + period);
                log.info("year from dataGlobalRequire:" + year);
                inputData.put("period", period);
                inputData.put("year", year);
            }
            String orgName = ReportGPTActionDataHelper.getNameById(Long.valueOf(inputData.get("org")), "bos_org");
            inputData.put("orgName", orgName);
            DynamicObject word = ReportHelper.getWord(Long.valueOf(inputData.get("wordId")));
            word.set("model", (Object)model.getLong("id"));
            word.set("entity", (Object)inputData.get("org"));
            if (null == word.get("name")) {
                word.set("name", (Object)(null == model ? "" : model.getString("reporttitle")));
            }
            if (StringUtils.isNotEmpty((String)inputData.get("period"))) {
                word.set("year", (Object)inputData.get("year"));
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{word});
            if (StringUtils.isNotEmpty((String)word.getString("report_period")) && !ResManager.loadKDString((String)"\u5df2\u9009\u62e9", (String)"ReportPlugin_0", (String)"fi-fgptas-formplugin", (Object[])new Object[0]).equals(word.getString("report_period")) && StringUtils.isNotEmpty((String)inputData.get("peroid"))) {
                inputData.put("peroid", word.getString("report_period"));
            }
            if (!available) {
                inputData.put("txtText", "");
            }
            Date now = TimeServiceHelper.now();
            inputData.put("time", String.valueOf(now.getTime()));
            this.createGptLog(inputData, PROCESS_COVER, model, gptstatus);
            List outlineentry = model.getDynamicObjectCollection("outlineentry").stream().sorted(Comparator.comparingInt(e -> e.getInt("seq"))).collect(Collectors.toList());
            log.info("Report invokeAction outlineentry:{}", outlineentry);
            log.info("Report invokeAction outlineentry:{}", outlineentry);
            if (outlineentry.size() > 0) {
                this.createGptLog(inputData, PROCESS_OUTLINE, model, gptstatus);
                if (null == inputData.get("userInput")) {
                    inputData.put("period_json", word.getString("period_json_tag"));
                }
                JSONObject dataSource = this.getDataSource(inputData, model);
                log.info("Report invokeAction dataSource:{}", (Object)dataSource);
                inputData.put("dataSource", dataSource.toJSONString());
                JSONObject jsonObject = new JSONObject();
                for (int i = 0; i < outlineentry.size(); ++i) {
                    DynamicObject content = (DynamicObject)outlineentry.get(i);
                    if (i == outlineentry.size() - 1) {
                        gptstatus = ReportStatusEnum.Success.getNumber();
                    }
                    jsonObject.put("backgroundprompt", (Object)content.getString("backgroundprompt"));
                    jsonObject.put("contentprompt_tag", (Object)content.getString("contentprompt_tag"));
                    inputData.put(PROCESS_CONTENT, jsonObject.toJSONString());
                    inputData.put("outlineid", content.getString("id"));
                    this.createGptLog(inputData, PROCESS_CONTENT, model, gptstatus);
                    if (StringUtils.isNotEmpty((String)inputData.get("errorMessage"))) {
                        return inputData;
                    }
                    jsonObject.clear();
                    if (inputData.get("manualGenReport") == null || !inputData.get("manualGenReport").equals("1")) continue;
                    log.info("manualGenReport,changeProgress,wordId:{},progress\uff1a{}", word.getPkValue(), (Object)String.valueOf(i + 1));
                    ManualGenReportRedis.setReportProgress(String.valueOf(word.getPkValue()), String.valueOf(i + 1));
                }
                inputData.remove("userInput");
            }
            if (!available && StringUtils.isNotEmpty((String)inputData.get("txtText"))) {
                String url = ReportFileHelper.updateTxtFile(Long.valueOf(inputData.get("wordId")), inputData.get("txtText"));
                word.set("url", (Object)url);
                word.set("enable", (Object)"1");
                word.set("modifytime", (Object)TimeServiceHelper.now());
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{word});
                this.saveRedisContent(inputData);
                inputData.remove("period");
                inputData.remove("outline");
            } else {
                this.updateReportStatus(word);
            }
        } else if (PROCESS_BLANK.equals(process)) {
            this.createGptLog(inputData, process, null, gptstatus);
        }
        return inputData;
    }

    private void updateReportStatus(DynamicObject word) {
        word.set("enable", (Object)"1");
        word.set("modifytime", (Object)TimeServiceHelper.now());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{word});
        QFilter[] qFilter = new QFilter[]{new QFilter("word", "=", (Object)this.curWordId)};
        DynamicObject[] logs = BusinessDataServiceHelper.load((String)"fgptas_report_gptlog", (String)"id,reportlog", (QFilter[])qFilter, (String)"createtime", (int)1);
        DynamicObject log = logs[0];
        log.set("reportlog", (Object)"success");
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{log});
    }

    private void saveRedisContent(Map<String, String> inputData) {
        String content = inputData.remove("txtText");
        DynamicObject log = BusinessDataServiceHelper.newDynamicObject((String)"fgptas_report_gptlog");
        log.set("id", (Object)DBServiceHelper.genGlobalLongId());
        log.set("modifier", (Object)RequestContext.get().getCurrUserId());
        log.set("modifytime", (Object)TimeServiceHelper.now());
        log.set("creator", (Object)RequestContext.get().getCurrUserId());
        log.set("createtime", (Object)TimeServiceHelper.now());
        log.set("docid", (Object)this.curDocId);
        log.set("word", (Object)this.curWordId);
        log.set("sequence", (Object)1);
        log.set("remark", (Object)"GPT-RESULT");
        log.set("gptnumber", (Object)"GPT-RESULT");
        log.set("gpttaskid", (Object)"");
        log.set("gptstatus", (Object)ReportStatusEnum.Success.getNumber());
        log.set("gptinputjson", (Object)"");
        log.set("reportlog_tag", (Object)content);
        log.set("reportlog", (Object)"success");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{log});
    }

    private void saveFailLog(Long wordId, String errorMsg) {
        DynamicObject log = BusinessDataServiceHelper.newDynamicObject((String)"fgptas_report_gptlog");
        log.set("id", (Object)DBServiceHelper.genGlobalLongId());
        log.set("modifier", (Object)RequestContext.get().getCurrUserId());
        log.set("modifytime", (Object)TimeServiceHelper.now());
        log.set("creator", (Object)RequestContext.get().getCurrUserId());
        log.set("createtime", (Object)TimeServiceHelper.now());
        log.set("docid", (Object)this.curDocId);
        log.set("word", (Object)wordId);
        log.set("sequence", (Object)1);
        log.set("remark", (Object)"GPT-RESULT");
        log.set("gptnumber", (Object)"GPT-RESULT");
        log.set("gpttaskid", (Object)"");
        log.set("gptstatus", (Object)ReportStatusEnum.Fail.getNumber());
        log.set("gptinputjson", (Object)"");
        log.set("reportlog_tag", (Object)errorMsg);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{log});
    }

    private void createGptLog(Map<String, String> history, String actionName, DynamicObject model, int gptstatus) {
        this.setGPTParam(history, actionName, model);
        Long wordId = this.getLasterWordId(history);
        boolean isCreate = false;
        boolean updateTxt = false;
        if (PROCESS_BLANK.equals(actionName)) {
            isCreate = true;
        } else if (PROCESS_OUTLINE.equals(actionName)) {
            log.info("createGptLog,PROCESS_OUTLINE,begin,history:{}", history);
            List outlineentry = model.getDynamicObjectCollection("outlineentry").stream().sorted(Comparator.comparingInt(e -> e.getInt("seq"))).collect(Collectors.toList());
            JSONArray jsonArray = new JSONArray();
            JSONObject outlineJson = new JSONObject();
            outlineJson.put("time", (Object)new Date().getTime());
            for (DynamicObject object : outlineentry) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("outlinename", (Object)(object.get("outlinenumber") + " " + object.getString("outlinename")));
                jsonObject.put("outlinelevel", (Object)object.getString("outlinelevel"));
                jsonObject.put("outlineId", (Object)object.getLong("id"));
                jsonArray.add((Object)jsonObject);
            }
            outlineJson.put("assistant", (Object)jsonArray);
            JSONArray input = JSONArray.parseArray((String)history.get("input"));
            input.add((Object)outlineJson);
            history.put("input", input.toJSONString());
            updateTxt = true;
            log.info("createGptLog,PROCESS_OUTLINE,end,history:{}", history);
        } else if (PROCESS_CONTENT.equals(actionName)) {
            log.info("createGptLog,PROCESS_CONTENT,begin,history:{}", history);
            String gptParamName = (actionName + "_param").toLowerCase();
            if (StringUtils.isNotEmpty((String)history.get(gptParamName))) {
                this.getGptResult(history, gptParamName);
            } else {
                String outlineid = history.get("outlineid");
                JSONObject jsonObject = new JSONObject();
                JSONObject assistant = new JSONObject();
                assistant.put("content", null);
                assistant.put("outlineId", (Object)outlineid);
                jsonObject.put("assistant", (Object)assistant);
                history.put("txtContent", jsonObject.toJSONString());
            }
            updateTxt = true;
            log.info("createGptLog,PROCESS_CONTENT,end,history:{}", history);
        } else if (PROCESS_COVER.equals(actionName)) {
            updateTxt = true;
        }
        if (StringUtils.isNotEmpty((String)history.get("errorMessage"))) {
            this.saveFailLog(Long.valueOf(history.get("wordId")), history.get("errorMessage"));
            return;
        }
        StringBuilder strUrl = new StringBuilder();
        strUrl.append("bizAction://currentPage?gaiShow=0&gaiAction=showBillForm&gaiParams=");
        strUrl.append("{\"appId\":\"").append("fgptas");
        if (!ReportConfigHelper.getWpsConfig().getBoolean("available").booleanValue()) {
            strUrl.append("\",\"billFormId\":\"").append("fgptas_report_text");
        } else {
            strUrl.append("\",\"billFormId\":\"").append("fgptas_report_design");
        }
        strUrl.append("\",\"billPkId\":\"").append(wordId).append("\"}");
        strUrl.append("&iconType=pdf&method=bizAction");
        if (isCreate) {
            strUrl.append(ResManager.loadKDString((String)"&title=\u70b9\u51fb\u751f\u6210Word\u6587\u6863", (String)"ReportGPTAction_0", (String)"fi-fgptas-business", (Object[])new Object[0]));
        } else {
            strUrl.append(ResManager.loadKDString((String)"&title=Word\u6587\u6863", (String)"ReportGPTAction_1", (String)"fi-fgptas-business", (Object[])new Object[0]));
        }
        if (isCreate && StringUtils.isEmpty((String)history.get("wordId"))) {
            DynamicObject word = BusinessDataServiceHelper.newDynamicObject((String)"fgptas_report");
            word.set("id", (Object)wordId);
            CodeRuleInfo codeRule = CodeRuleServiceHelper.getCodeRule((String)"fgptas_report", (DynamicObject)word, null);
            String number = CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRule, (DynamicObject)word);
            word.set("number", (Object)number);
            word.set("masterid", (Object)wordId);
            word.set("modifier", (Object)RequestContext.get().getCurrUserId());
            word.set("modifytime", (Object)TimeServiceHelper.now());
            word.set("creator", (Object)RequestContext.get().getCurrUserId());
            word.set("createtime", (Object)TimeServiceHelper.now());
            word.set("status", (Object)"A");
            word.set("enable", (Object)"1");
            word.set("year", (Object)ResManager.loadKDString((String)"2023\u5e74", (String)"ReportGPTAction_2", (String)"fi-fgptas-business", (Object[])new Object[0]));
            word.set("url", (Object)"");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{word});
        }
        this.curWordId = wordId;
        if (updateTxt && !PROCESS_BLANK.equals(actionName) && !ReportConfigHelper.getWpsConfig().getBoolean("available").booleanValue()) {
            log.info("txt file input :" + history.get("input"));
            this.printTxtFile(history, actionName);
        }
        JSONObject resultJson = new JSONObject();
        resultJson.put("input", (Object)(StringUtils.isEmpty((String)history.get("input")) ? "" : history.get("input")));
        resultJson.put("url", (Object)strUrl.toString());
        log.info("getGptResult,resultJson :{},actionName:{}", (Object)resultJson, (Object)actionName);
        JSONObject inputJson = new JSONObject();
        inputJson.put("org", (Object)history.get("org"));
        inputJson.put("userInput", (Object)history.get("userInput"));
        inputJson.put("wordId", (Object)history.get("wordId"));
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
        qFilters.add(new QFilter("word", "=", (Object)wordId));
        qFilters.add(new QFilter("gptnumber", "=", (Object)"GPT-IGPTAction"));
        DynamicObject log = QueryServiceHelper.queryOne((String)"fgptas_report_gptlog", (String)"id", (QFilter[])qFilters.toArray(new QFilter[0]));
        if (log == null) {
            log = BusinessDataServiceHelper.newDynamicObject((String)"fgptas_report_gptlog");
            log.set("id", (Object)DBServiceHelper.genGlobalLongId());
            log.set("creator", (Object)RequestContext.get().getCurrUserId());
            log.set("createtime", (Object)TimeServiceHelper.now());
            log.set("docid", (Object)"");
            log.set("word", (Object)wordId);
            log.set("sequence", (Object)1);
            log.set("gptnumber", (Object)"GPT-IGPTAction");
        } else {
            log = BusinessDataServiceHelper.loadSingle((Object)log.getLong("id"), (String)"fgptas_report_gptlog");
        }
        log.set("remark", (Object)("IGPTAction." + actionName));
        log.set("modifier", (Object)RequestContext.get().getCurrUserId());
        log.set("modifytime", (Object)TimeServiceHelper.now());
        log.set("gpttaskid", (Object)"");
        log.set("gptstatus", (Object)gptstatus);
        log.set("gptinputjson", (Object)JSON.toJSONString((Object)inputJson));
        log.set("reportlog_tag", (Object)resultJson.toJSONString());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{log});
        history.put("url", strUrl.toString());
        history.put("wordId", wordId.toString());
    }

    private void printTxtFile(Map<String, String> history, String actionName) {
        JSONObject txtContent = JSONObject.parseObject((String)history.remove("txtContent"));
        String txtText = StringUtils.isNotEmpty((String)history.get("txtText")) ? history.get("txtText") : "";
        StringBuilder content = new StringBuilder(txtText);
        if (PROCESS_OUTLINE.equals(actionName)) {
            content.append(ResManager.loadKDString((String)"\u5927\u7eb2", (String)"ReportGPTAction_15", (String)"fi-fgptas-business", (Object[])new Object[0])).append(" \n");
            JSONArray input = JSONArray.parseArray((String)history.get("input"));
            JSONObject jsonObject = JSONObject.parseObject((String)input.getString(input.size() - 1));
            log.info("txtText:" + history.get("txtText"));
            JSONArray jsonArray = jsonObject.getJSONArray("assistant");
            if (null != jsonArray) {
                history.put("outline", jsonArray.toJSONString());
            } else {
                history.put("outline", "");
            }
            if (null != jsonArray && jsonArray.size() > 0) {
                for (Object o : jsonArray) {
                    JSONObject oljson = (JSONObject)o;
                    content.append(oljson.getString("outlinename")).append(" \n");
                }
                content.append("<nextPage>").append('\n');
            }
        } else {
            String text = "";
            if (PROCESS_CONTENT.equals(actionName)) {
                text = txtContent.getJSONObject("assistant").getString("content");
                Long outlineId = txtContent.getJSONObject("assistant").getLong("outlineId");
                if (null != history.get("outline")) {
                    JSONObject oljson = JSONArray.parseArray((String)history.get("outline")).stream().filter(e -> ((JSONObject)e).getLong("outlineId").equals(outlineId)).map(e -> (JSONObject)e).findFirst().get();
                    content.append(oljson.getString("outlinename")).append(" \n");
                }
            } else {
                text = txtContent.getString("assistant");
            }
            if (StringUtils.isNotEmpty((String)text)) {
                content.append(text).append(" \n");
            }
            content.append("<nextPage>").append('\n');
        }
        history.put("txtText", content.toString());
    }

    private void setGPTParam(Map<String, String> history, String actionName, DynamicObject model) {
        switch (actionName) {
            case "COVER": {
                this.setCoverParam(history, model);
                break;
            }
            case "CONTENT": {
                this.setContentParam(history);
                break;
            }
        }
    }

    private void setCoverParam(Map<String, String> history, DynamicObject model) {
        String cover = model.getString("covercontent") + "\n";
        if (cover.contains(ResManager.loadKDString((String)"{\u7ec4\u7ec7}", (String)"ReportGPTAction_8", (String)"fi-fgptas-business", (Object[])new Object[0]))) {
            cover = cover.replace(ResManager.loadKDString((String)"{\u7ec4\u7ec7}", (String)"ReportGPTAction_8", (String)"fi-fgptas-business", (Object[])new Object[0]), history.get("orgName"));
        }
        if (cover.contains(ResManager.loadKDString((String)"{\u62a5\u544a\u671f\u95f4}", (String)"ReportGPTAction_9", (String)"fi-fgptas-business", (Object[])new Object[0])) && StringUtils.isNotEmpty((String)history.get("period"))) {
            cover = cover.replace(ResManager.loadKDString((String)"{\u62a5\u544a\u671f\u95f4}", (String)"ReportGPTAction_9", (String)"fi-fgptas-business", (Object[])new Object[0]), history.get("period"));
        } else if (cover.contains(ResManager.loadKDString((String)"{\u62a5\u544a\u671f\u95f4}", (String)"ReportGPTAction_9", (String)"fi-fgptas-business", (Object[])new Object[0])) && StringUtils.isEmpty((String)history.get("period"))) {
            cover = cover.replace(ResManager.loadKDString((String)"\u62a5\u544a\u671f\u95f4\uff1a{\u62a5\u544a\u671f\u95f4}", (String)"ReportGPTAction_16", (String)"fi-fgptas-business", (Object[])new Object[0]), "");
            cover = cover + "\n";
        }
        if (cover.contains(ResManager.loadKDString((String)"{\u8d22\u5e74}", (String)"ReportGPTAction_10", (String)"fi-fgptas-business", (Object[])new Object[0])) && StringUtils.isNotEmpty((String)history.get("year"))) {
            cover = cover.replace(ResManager.loadKDString((String)"{\u8d22\u5e74}", (String)"ReportGPTAction_10", (String)"fi-fgptas-business", (Object[])new Object[0]), history.get("year"));
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("assistant", (Object)cover);
        jsonObject.put("time", (Object)new Date().getTime());
        JSONArray input = null == history.get("input") ? new JSONArray() : JSONArray.parseArray((String)history.get("input"));
        input.add((Object)jsonObject);
        history.put("input", input.toJSONString());
        history.put("txtContent", jsonObject.toJSONString());
    }

    private void setContentParam(Map<String, String> history) {
        JSONObject content = JSONObject.parseObject((String)history.remove(PROCESS_CONTENT));
        if (!StringUtils.isNotEmpty((String)content.getString("backgroundprompt")) && !StringUtils.isNotEmpty((String)content.getString("contentprompt_tag"))) {
            return;
        }
        StringBuilder reportInput = new StringBuilder(content.getString("backgroundprompt"));
        reportInput.append("\\n");
        reportInput.append(content.getString("contentprompt_tag"));
        history.put("content_param", reportInput.toString());
    }

    private JSONObject getDataSource(Map<String, String> inputData, DynamicObject model) {
        JSONObject jsonObject = new JSONObject();
        Set<String> tableNames = new HashSet<String>();
        DynamicObjectCollection outlineentry = model.getDynamicObjectCollection("outlineentry");
        DynamicObjectCollection datasourcesubentry = new ArrayList();
        for (DynamicObject outline : outlineentry) {
            DynamicObjectCollection collection = outline.getDynamicObjectCollection("datasourcesubentry");
            datasourcesubentry.addAll(collection.stream().collect(Collectors.toList()));
        }
        Boolean needQueryBaseId = Boolean.TRUE;
        if (null == inputData.get("dataRequire")) {
            needQueryBaseId = Boolean.FALSE;
            jsonObject = this.getDatarequireFromUserInput(inputData, model, jsonObject, tableNames, (List<DynamicObject>)datasourcesubentry);
        } else if (StringUtils.isNotEmpty((String)inputData.get("dataRequire"))) {
            String answer = "";
            answer = inputData.remove("dataRequire");
            jsonObject = JSONObject.parseObject((String)answer);
            tableNames = jsonObject.keySet();
            for (String tableName : tableNames) {
                jsonObject.getJSONObject(tableName).put("isEntity", (Object)Boolean.TRUE);
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u627e\u5230GPT\u8bed\u4e49\u5316\u63d0\u793a\u8bed", (String)"ReportGPTAction_5", (String)"fi-fgptas-business", (Object[])new Object[0]));
        }
        JSONObject dataSource = new JSONObject();
        if (null != tableNames && tableNames.size() > 0) {
            HashMap<String, List<String>> dataFilterMap = new HashMap<String, List<String>>(tableNames.size());
            DynamicObject[] tableMetaDatas = BusinessDataServiceHelper.load((String)"fgptas_datatable", (String)"number,entryentity,fieldnumber,fieldname,retrievalplugin,datasource,fieldquery,fieldtype,fixedvalue,fieldpropertyjson_tag", (QFilter[])new QFilter("number", "in", tableNames).toArray());
            Map<String, DynamicObject> dataTableMap = Arrays.stream(tableMetaDatas).collect(Collectors.toMap(data -> data.getString("number"), data -> data));
            HashMap<String, List<String>> dataRequireNameMap = new HashMap<String, List<String>>(tableNames.size());
            this.getDataFilterByRequire(inputData, jsonObject, tableNames, dataFilterMap, dataRequireNameMap, tableMetaDatas, needQueryBaseId);
            log.info("\u6574\u4f53\u6570\u636e\u8981\u6c42\u62fc\u63a5\uff1a" + dataFilterMap);
            for (DynamicObject outline : outlineentry) {
                JSONObject outlineDataSource = new JSONObject();
                datasourcesubentry = outline.getDynamicObjectCollection("datasourcesubentry");
                log.info("getDataSource,datasourcesubentry:{}", (Object)datasourcesubentry);
                for (DynamicObject data2 : datasourcesubentry) {
                    String entityNumber = data2.getDynamicObject("datatable").getString("number");
                    String selectFields = data2.getString("datapropnumber");
                    String dataprop = data2.getString("dataprop");
                    DynamicObject tableMetaData = dataTableMap.get(entityNumber);
                    if (null == tableMetaData) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u627e\u5230\u62a5\u8868\u5143\u6570\u636e\uff1a%s", (String)"ReportGPTAction_17", (String)"fi-fgptas-business", (Object[])new Object[0]), entityNumber));
                    }
                    log.info("\u67e5\u8be2\u62a5\u544a\u5143\u6570\u636e\uff1a" + entityNumber + " " + tableMetaData);
                    this.getOutlineDatasource(inputData, jsonObject, dataFilterMap, dataTableMap, dataRequireNameMap, outline, outlineDataSource, data2, entityNumber, selectFields, dataprop, tableMetaData);
                }
                dataSource.put(outline.getString("id"), (Object)outlineDataSource);
            }
        }
        return dataSource;
    }

    private void getOutlineDatasource(Map<String, String> inputData, JSONObject jsonObject, Map<String, List<String>> dataFilterMap, Map<String, DynamicObject> dataTableMap, Map<String, List<String>> dataRequireNameMap, DynamicObject outline, JSONObject outlineDataSource, DynamicObject data, String entityNumber, String selectFields, String dataprop, DynamicObject tableMetaData) {
        String datasource = tableMetaData.getString("datasource");
        DynamicObjectCollection entryentity = tableMetaData.getDynamicObjectCollection("entryentity");
        List<String> sqlList = dataFilterMap.get(entityNumber);
        if (null != sqlList && sqlList.size() > 0) {
            for (String datarequireSQL : sqlList) {
                StringBuilder sql = new StringBuilder(datarequireSQL);
                List<QFilter> qFilterList = this.getQFilters(data, entityNumber, dataTableMap.get(entityNumber), jsonObject);
                log.info("getDataSource,qFilterList:{}", qFilterList);
                List filterFields = qFilterList.stream().map(QFilter::getProperty).collect(Collectors.toList());
                Map<String, QFilter> qFilterMap = qFilterList.stream().collect(Collectors.toMap(QFilter::getProperty, s -> s));
                MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
                for (DynamicObject entry : entryentity) {
                    String fieldValue;
                    Set dataRequireMap;
                    String fieldnumber = entry.getString("fieldnumber");
                    Set set = dataRequireMap = null == jsonObject ? null : ((Map)JSONObject.parseObject((String)jsonObject.getString(entityNumber), Map.class)).keySet();
                    if (null != dataRequireMap && dataRequireMap.contains(fieldnumber)) continue;
                    if (qFilterMap.size() > 0 && !entry.getBoolean("fieldquery")) {
                        QFilter qFilter = qFilterMap.get(fieldnumber);
                        qFilterList.remove(qFilter);
                    }
                    String fieldType = entry.getString("fieldtype");
                    if (!entry.getBoolean("fieldquery") || filterFields.contains(fieldnumber) || !StringUtils.isNotEmpty((String)entry.getString("fixedvalue"))) continue;
                    if (BASEDATA.equals(fieldType) && null != dataTableMap.get(entityNumber) && StringUtils.isNotEmpty((String)dataTableMap.get(entityNumber).getString("retrievalplugin"))) {
                        StringBuilder baseIdValue = this.getBaseDataValue(fieldnumber, "number", entry.getString("fixedvalue"), entityNumber, dataTableMap.get(entityNumber));
                        if (!StringUtils.isNotEmpty((String)baseIdValue.toString())) {
                            log.info("Field " + fieldnumber + " getBaseDataId fail");
                            continue;
                        }
                        fieldValue = baseIdValue.toString();
                    } else if (BASEDATA.equals(fieldType) && null != dataTableMap.get(entityNumber) && StringUtils.isEmpty((String)dataTableMap.get(entityNumber).getString("retrievalplugin"))) {
                        DynamicObject[] load;
                        String fieldproperty = entry.getString("fieldpropertyjson_tag");
                        JSONObject baseDataJson = JSONObject.parseObject((String)fieldproperty);
                        String baseEntityId = MetadataDao.getEntityNumberById((String)baseDataJson.getString("baseEntityId"));
                        String value = entry.getString("fixedvalue");
                        if (StringUtils.isNotEmpty((String)value) && value.contains(";")) {
                            value = value.replaceAll(";", ",");
                        }
                        fieldValue = null != (load = BusinessDataServiceHelper.load((String)baseEntityId, (String)"id", (QFilter[])new QFilter("number", "in", (Object)value).toArray())) && load.length > 0 ? Arrays.stream(load).map(d -> String.valueOf(d.getLong("id"))).collect(Collectors.joining(",")) : entry.getString("fixedvalue");
                    } else {
                        fieldValue = entry.getString("fixedvalue");
                    }
                    if (!StringUtils.isNotEmpty((String)fieldValue)) continue;
                    if (StringUtils.isNotEmpty((String)sql.toString())) {
                        sql.append(" and ");
                    }
                    if (entityType.getProperty(fieldnumber) == null) continue;
                    sql.append(entityType.getProperty(fieldnumber).getAlias()).append(" in (").append(fieldValue).append(" )");
                }
                this.qfilterToSql(sql, qFilterList, entityType);
                if (datasource.equals("1")) {
                    String retrievalplugin = dataTableMap.get(entityNumber).getString("retrievalplugin");
                    this.getDataByPull(outlineDataSource, entityNumber, selectFields, dataprop, sql, inputData.get("userInput"), dataRequireNameMap, retrievalplugin);
                } else if (datasource.equals("2")) {
                    List<String> dataRequireNameList = dataRequireNameMap.get(entityNumber);
                    List<String> numberList = dataRequireNameMap.get(entityNumber + "_requirenumber");
                    String finalSelectFields = selectFields;
                    String dataRequire = numberList.stream().filter(e -> !finalSelectFields.contains((CharSequence)e)).collect(Collectors.joining(","));
                    selectFields = selectFields + "," + dataRequire;
                    this.getDataByEntity(inputData, outlineDataSource, entityNumber, selectFields, dataprop, dataRequireNameList, sql.toString(), dataTableMap);
                }
                if (outlineDataSource.size() >= 1) continue;
                ArrayList<String> emptyContent = new ArrayList<String>();
                if (StringUtils.isNotEmpty((String)inputData.get("emptyContent"))) {
                    Arrays.stream(inputData.get("emptyContent").split(",")).forEach(e -> emptyContent.add((String)e));
                }
                String period = StringUtils.isNotEmpty((String)inputData.get("period")) ? inputData.get("period") : "";
                String emptyContentPrefix = outline.getString("outlinenumber") + outline.getString("outlinename") + "\uff0c" + inputData.get("orgName") + period;
                emptyContent.add(String.format(ResManager.loadKDString((String)"%1$s\u7684%2$s\u4e2d\u7b26\u5408\u67e5\u8be2\u6761\u4ef6\u7684\u6570\u636e\u4e3a\u7a7a\u3002", (String)"ReportGPTAction_14", (String)"fi-fgptas-business", (Object[])new Object[0]), emptyContentPrefix, entityNumber));
                inputData.put("emptyContent", String.join((CharSequence)",", emptyContent));
            }
        }
    }

    private JSONObject getDatarequireFromUserInput(Map<String, String> inputData, DynamicObject model, JSONObject jsonObject, Set<String> tableNames, List<DynamicObject> datasourcesubentry) {
        JSONObject periodJson = JSONObject.parseObject((String)inputData.get("period_json"));
        tableNames.addAll(datasourcesubentry.stream().map(data -> data.getDynamicObject("datatable").getString("number")).collect(Collectors.toSet()));
        if (null != periodJson) {
            HashMap<String, HashMap<Long, String>> dataGlobalRequire = ReportTemDataHelper.getDataGlobalRequire(model.getLong("id"));
            QFilter tableNumberFilter = new QFilter("number", "in", tableNames);
            DynamicObject[] dataTable = BusinessDataServiceHelper.load((String)"fgptas_datatable", (String)"id,number", (QFilter[])tableNumberFilter.toArray());
            Map<Long, String> map = Arrays.stream(dataTable).collect(Collectors.toMap(k -> k.getLong("id"), v -> v.getString("number")));
            if (null != periodJson.keySet() && periodJson.keySet().size() > 0) {
                Set keySet = periodJson.keySet();
                for (String periodKey : keySet) {
                    JSONArray array = (JSONArray)periodJson.get((Object)periodKey);
                    for (Object obj : array) {
                        String tableNumber;
                        List datatableIds;
                        JSONObject table = (JSONObject)obj;
                        if (table.containsKey((Object)"hb_period")) {
                            datatableIds = (List)table.get((Object)"hb_datatable");
                            for (Long tableId : datatableIds) {
                                JSONArray scenarioArray;
                                JSONArray datarequireArray;
                                tableNumber = map.get(tableId);
                                JSONObject tableJson = jsonObject.getJSONObject(tableNumber);
                                JSONObject rowJson = new JSONObject();
                                if (null == tableJson) {
                                    tableJson = new JSONObject();
                                    tableJson.put("isEntity", (Object)Boolean.FALSE);
                                    datarequireArray = new JSONArray();
                                    scenarioArray = new JSONArray();
                                    scenarioArray.add((Object)table.getString("hb_scenario"));
                                    rowJson.put("scenario", (Object)scenarioArray);
                                    JSONArray yearArray = new JSONArray();
                                    yearArray.add((Object)table.getString("hb_year"));
                                    rowJson.put("year", (Object)yearArray);
                                    rowJson.put("period", (Object)table.getJSONArray("hb_period"));
                                    datarequireArray.add((Object)rowJson);
                                    tableJson.put("datarequireArray", (Object)datarequireArray);
                                } else {
                                    datarequireArray = tableJson.getJSONArray("datarequireArray");
                                    if (StringUtils.isNotEmpty((String)table.getString("hb_scenario"))) {
                                        scenarioArray = new JSONArray();
                                        scenarioArray.add((Object)table.getString("hb_scenario"));
                                        rowJson.put("scenario", (Object)scenarioArray);
                                    }
                                    if (StringUtils.isNotEmpty((String)table.getString("hb_year"))) {
                                        JSONArray yearArray = new JSONArray();
                                        yearArray.add((Object)table.getString("hb_year"));
                                        rowJson.put("year", (Object)yearArray);
                                    }
                                    if (StringUtils.isNotEmpty((String)table.getString("hb_period"))) {
                                        rowJson.put("period", (Object)table.getJSONArray("hb_period"));
                                    }
                                    datarequireArray.add((Object)rowJson);
                                    tableJson.put("datarequireArray", (Object)datarequireArray);
                                }
                                jsonObject.put(tableNumber, (Object)tableJson);
                            }
                            continue;
                        }
                        datatableIds = (List)table.get((Object)"datatable");
                        for (Long tableId : datatableIds) {
                            String periodValue;
                            tableNumber = map.get(tableId);
                            HashMap<Long, String> fieldMap = dataGlobalRequire.get(tableNumber);
                            String periodField = fieldMap.get(GlobalFieldEnum.REPORT_PERIOD.getId());
                            JSONObject tableJson = jsonObject.getJSONObject(tableNumber);
                            String string = periodValue = StringUtils.isEmpty((String)table.getString("period_value")) ? table.getString("period") : table.getString("period_value");
                            if (StringUtils.isEmpty((String)periodValue)) continue;
                            JSONArray periodArray = new JSONArray();
                            if (null == tableJson) {
                                tableJson = new JSONObject();
                                tableJson.put("isEntity", (Object)Boolean.TRUE);
                                periodArray.add((Object)periodValue);
                                tableJson.put(periodField, (Object)periodArray);
                                jsonObject.put(tableNumber, (Object)tableJson);
                                continue;
                            }
                            StringBuilder period = new StringBuilder(tableJson.getString(periodField));
                            periodArray.add((Object)period.append(',').append(periodValue));
                            tableJson.put(periodField, (Object)periodArray);
                        }
                    }
                }
            }
        } else {
            jsonObject = null;
        }
        return jsonObject;
    }

    private void getDataByEntity(Map<String, String> inputData, JSONObject dataSource, String entityNumber, String selectFields, String dataprop, List<String> dataRequireNameList, String sql, Map<String, DynamicObject> dataTableMap) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        Map<String, String> fieldNameMap = dataTableMap.get(entityNumber).getDynamicObjectCollection("entryentity").stream().collect(Collectors.toMap(data -> data.getString("fieldnumber"), data -> data.getString("fieldname")));
        String tableName = entityType.getAlias();
        String sqlReturnFields = Arrays.stream(selectFields.split(",")).map(s -> entityType.getProperty(s).getAlias()).collect(Collectors.joining(","));
        StringBuilder dataSql = new StringBuilder("select ");
        dataSql.append(sqlReturnFields);
        dataSql.append(" from ").append(tableName).append(" where ");
        dataSql.append(sql);
        SqlBuilder qBuilder = new SqlBuilder();
        qBuilder.append(dataSql.toString(), new Object[0]);
        log.info("getDataByEntity sql\uff1a" + dataSql);
        JSONObject dataGroup = new JSONObject();
        JSONArray resultArray = new JSONArray();
        if (StringUtils.isNotEmpty((String)dataSource.getString(entityNumber))) {
            resultArray = JSONArray.parseArray((String)dataSource.getString(entityNumber));
        }
        try {
            DataSet dataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)qBuilder);
            Object object = null;
            try {
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    String[] split = selectFields.split(",");
                    JSONObject jsonObject = new JSONObject();
                    StringBuilder dataRequireKey = new StringBuilder();
                    for (String number : split) {
                        Object o = row.get(entityType.getProperty(number).getAlias());
                        String name = fieldNameMap.get(number);
                        if (dataprop.contains(name) && !dataRequireNameList.contains(name)) {
                            jsonObject.put(name, o);
                            continue;
                        }
                        if (!dataRequireNameList.contains(name)) continue;
                        if (StringUtils.isNotEmpty((String)dataRequireKey.toString())) {
                            dataRequireKey.append(',');
                        }
                        dataRequireKey.append(name).append(':').append(o);
                    }
                    if (jsonObject.size() <= 0) continue;
                    JSONArray childArray = dataGroup.getJSONArray(dataRequireKey.toString());
                    if (null == childArray) {
                        childArray = new JSONArray();
                    }
                    childArray.add((Object)jsonObject);
                    dataGroup.put(dataRequireKey.toString(), (Object)childArray);
                }
            }
            catch (Throwable row) {
                object = row;
                throw row;
            }
            finally {
                if (dataSet != null) {
                    if (object != null) {
                        try {
                            dataSet.close();
                        }
                        catch (Throwable row) {
                            ((Throwable)object).addSuppressed(row);
                        }
                    } else {
                        dataSet.close();
                    }
                }
            }
        }
        catch (Exception e2) {
            throw new KDBizException(null == e2.getCause() ? e2.getMessage() : e2.getCause().getMessage());
        }
        Set keySet = dataGroup.keySet();
        for (String key : keySet) {
            JSONObject result = new JSONObject();
            JSONArray array = dataGroup.getJSONArray(key);
            String[] datarequireFields = key.split(",");
            Arrays.stream(datarequireFields).forEach(e -> {
                String[] split = e.split(":");
                if (split.length == 2) {
                    result.put(split[0], (Object)split[1]);
                }
            });
            result.put("data", (Object)array);
            if (result.size() <= 0) continue;
            resultArray.add((Object)result);
        }
        dataSource.put(entityNumber, (Object)resultArray);
        DynamicObject dataSourcelog = BusinessDataServiceHelper.newDynamicObject((String)"fgptas_report_gptlog");
        dataSourcelog.set("id", (Object)DBServiceHelper.genGlobalLongId());
        dataSourcelog.set("modifier", (Object)RequestContext.get().getCurrUserId());
        dataSourcelog.set("modifytime", (Object)TimeServiceHelper.now());
        dataSourcelog.set("creator", (Object)RequestContext.get().getCurrUserId());
        dataSourcelog.set("createtime", (Object)TimeServiceHelper.now());
        dataSourcelog.set("docid", (Object)"");
        dataSourcelog.set("word", (Object)inputData.get("wordId"));
        dataSourcelog.set("sequence", (Object)1);
        dataSourcelog.set("remark", (Object)ResManager.loadKDString((String)"\u6570\u636e\u6e90\u8fd4\u56de\u3002", (String)"ReportGPTAction_13", (String)"fi-fgptas-business", (Object[])new Object[0]));
        dataSourcelog.set("gptnumber", (Object)"EntityQueryResult");
        dataSourcelog.set("gpttaskid", (Object)"EntityQueryResult");
        dataSourcelog.set("gptstatus", (Object)1);
        dataSourcelog.set("reportlog_tag", (Object)dataSource);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataSourcelog});
    }

    private void qfilterToSql(StringBuilder sql, List<QFilter> qFilterList, MainEntityType entityType) {
        log.info("qfilterToSql,sql:{},qFilterList:{}", (Object)sql, qFilterList);
        for (QFilter qFilter : qFilterList) {
            if (null == qFilter.getValue() || null == qFilter.getProperty() || null == entityType.getProperty(qFilter.getProperty())) continue;
            if (StringUtils.isNotEmpty((String)sql.toString())) {
                sql.append(" and ");
            }
            sql.append(entityType.getProperty(qFilter.getProperty()).getAlias());
            sql.append(" in ");
            sql.append("( ");
            Object value = qFilter.getValue();
            if (value instanceof ArrayList) {
                sql.append((Object)((ArrayList)value).stream().map(e -> e instanceof String ? "'" + e + "'" : e + "").collect(Collectors.joining(",")));
            } else {
                sql.append(value);
            }
            sql.append(" )");
        }
    }

    private StringBuilder getBaseDataValue(String fieldnumber, String baseDataQueryField, Object value, String entityNumber, DynamicObject dataTable) {
        StringBuilder baseIdValue = new StringBuilder();
        if (value instanceof String && StringUtils.isNotEmpty((String)String.valueOf(value)) && String.valueOf(value).contains(";")) {
            value = String.valueOf(value).replaceAll(";", ",");
        }
        QFilter[] baseQFilter = new QFilter(baseDataQueryField, "in", value).toArray();
        log.info("getBaseDataId input dataTableNumber :" + entityNumber + " feild :" + fieldnumber);
        List baseDataIds = new ArrayList();
        Object[] args = new Object[]{entityNumber, fieldnumber, baseQFilter, null};
        log.info("getBaseDataValue,retrievalplugin:{}", (Object)dataTable.getString("retrievalplugin"));
        log.info("getBaseDataValue,args:{}", args);
        try {
            baseDataIds = (List)InvokePluginHelper.invokePlugin(dataTable.getString("retrievalplugin"), "getBaseDataId", args);
        }
        catch (KDBizException e) {
            log.error((Throwable)e);
        }
        log.info("getBaseDataValue,baseDataIds:{}", baseDataIds);
        if (null == baseDataIds || baseDataIds.size() == 0) {
            return baseIdValue;
        }
        for (Object baseId : baseDataIds) {
            if (StringUtils.isNotEmpty((String)baseIdValue.toString())) {
                baseIdValue.append(',');
            }
            baseIdValue.append(baseId);
        }
        log.info("getBaseDataValue,baseIdValue:{}", (Object)baseIdValue);
        return baseIdValue;
    }

    private List<QFilter> getQFilters(DynamicObject data, String entityNumber, DynamicObject dataTable, JSONObject jsonObject) {
        log.info("getQFilters :" + data.getString("datafiltervalue_tag"));
        String datafiltervalue = data.getString("datafiltervalue_tag");
        if (!StringUtils.isNotEmpty((String)datafiltervalue)) {
            return new ArrayList<QFilter>();
        }
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)datafiltervalue, FilterCondition.class);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        FilterBuilder filterBuilder = new FilterBuilder(entityType, filterCondition);
        filterBuilder.buildFilter(false);
        List qFilterList = filterBuilder.getQFilters();
        ArrayList<QFilter> resultList = new ArrayList<QFilter>(qFilterList.size());
        Set baseDataFieldNameList = qFilterList.stream().filter(e -> e.getProperty().contains(".")).map(QFilter::getProperty).collect(Collectors.toSet());
        HashMap<String, QFilter> collect = new HashMap<String, QFilter>(qFilterList.size());
        JSONObject tableJson = jsonObject.getJSONObject(entityNumber);
        log.info("\u7ef4\u5ea6\u6761\u4ef6\u5904\u7406 :" + entityNumber + " \u6574\u4f53\u6570\u636e\u8981\u6c42\u5b57\u6bb5\u8fc7\u6ee4 json:" + tableJson);
        for (QFilter qFilter : qFilterList) {
            Set<Object> dataRequireMap = null;
            if (null == tableJson) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u7ef4\u5ea6\u6761\u4ef6\u9519\u8bef\uff0c\u6574\u4f53\u6570\u636e\u8981\u6c42\u672a\u5339\u914d\u3002", (String)"ReportGPTAction_12", (String)"fi-fgptas-business", (Object[])new Object[0]), entityNumber));
            }
            if (null == tableJson.get((Object)"isEntity")) {
                Map jsonArrayMap = (Map)JSONObject.parseObject((String)tableJson.toJSONString(), Map.class);
                dataRequireMap = jsonArrayMap.keySet();
            } else {
                JSONArray datarequireArray = tableJson.getJSONArray("datarequireArray");
                dataRequireMap = new HashSet();
                for (Object o : datarequireArray) {
                    JSONObject datarequire = (JSONObject)o;
                    dataRequireMap.addAll(datarequire.keySet());
                }
            }
            if (null != dataRequireMap && dataRequireMap.contains(qFilter.getProperty())) continue;
            QFilter filter = (QFilter)collect.get(qFilter.getProperty());
            if (null != filter) {
                if (filter.getValue() instanceof ArrayList) {
                    if (qFilter.getValue() instanceof ArrayList) {
                        ((ArrayList)filter.getValue()).addAll((ArrayList)qFilter.getValue());
                        collect.put(qFilter.getProperty(), filter);
                        continue;
                    }
                    ((ArrayList)filter.getValue()).add(qFilter.getValue());
                    collect.put(qFilter.getProperty(), filter);
                    continue;
                }
                if (qFilter.getValue() instanceof ArrayList) {
                    ((ArrayList)qFilter.getValue()).add(filter.getValue());
                    collect.put(qFilter.getProperty(), qFilter);
                    continue;
                }
                filter.__setValue((Object)(filter.getValue() + "," + qFilter.getValue()));
                collect.put(qFilter.getProperty(), filter);
                continue;
            }
            collect.put(qFilter.getProperty(), qFilter);
        }
        for (String fieldName : baseDataFieldNameList) {
            String value;
            String[] split = fieldName.split("\\.");
            QFilter qFilter = (QFilter)collect.remove(fieldName);
            Object inputValue = null;
            if ("in".equals(qFilter.getCP().toLowerCase())) {
                value = qFilter.getValue().toString().replace("[", "").replace("]", "");
                if (StringUtils.isNotEmpty((String)value)) {
                    inputValue = Arrays.stream(value.split(",")).map(String::trim).collect(Collectors.toList());
                } else {
                    log.info("\u7ef4\u5ea6\u6761\u4ef6\u5b57\u6bb5 getBaseData fieldname :" + split[0] + " \u914d\u7f6e\u503c\u4e3a\u7a7a");
                }
            } else {
                value = qFilter.getValue().toString();
                inputValue = value.contains(",") ? Arrays.stream(value.split(",")).map(String::trim).collect(Collectors.toList()) : value;
            }
            StringBuilder baseIdValue = new StringBuilder();
            if (StringUtils.isNotEmpty((String)dataTable.getString("retrievalplugin"))) {
                baseIdValue = this.getBaseDataValue(split[0], split[1], inputValue, entityNumber, dataTable);
            } else {
                String billFormId;
                JSONObject fieldpropertyjson;
                ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
                qFilters.add(new QFilter(split[1], "in", inputValue));
                DynamicObject fieldEntity = dataTable.getDynamicObjectCollection("entryentity").stream().filter(e -> split[0].equals(e.getString("fieldnumber"))).findFirst().get();
                if (null != fieldEntity && StringUtils.isNotEmpty((String)fieldEntity.getString("fieldpropertyjson_tag")) && BASEDATA.equals(fieldEntity.getString("fieldtype"))) {
                    fieldpropertyjson = JSONObject.parseObject((String)fieldEntity.getString("fieldpropertyjson_tag"));
                    String baseEntityId = fieldpropertyjson.getString("baseEntityId");
                    billFormId = MetadataDao.getEntityNumberById((String)baseEntityId);
                } else if (null != fieldEntity && StringUtils.isNotEmpty((String)fieldEntity.getString("fieldpropertyjson_tag")) && "Assistant".equals(fieldEntity.getString("fieldtype"))) {
                    fieldpropertyjson = JSONObject.parseObject((String)fieldEntity.getString("fieldpropertyjson_tag"));
                    String asstTypeId = fieldpropertyjson.getString("asstTypeId");
                    qFilters.add(new QFilter("group", "=", (Object)Long.valueOf(asstTypeId)));
                    billFormId = "bos_assistantdata_detail";
                } else {
                    billFormId = split[0];
                }
                DynamicObject[] load = BusinessDataServiceHelper.load((String)billFormId, (String)"id", (QFilter[])qFilters.toArray(new QFilter[qFilters.size()]));
                if (null != load && load.length > 0) {
                    baseIdValue.append(Arrays.stream(load).map(e -> String.valueOf(e.getLong("id"))).collect(Collectors.joining(",")));
                } else {
                    if (inputValue instanceof String && StringUtils.isNotEmpty((String)String.valueOf(inputValue)) && String.valueOf(inputValue).contains(";")) {
                        inputValue = String.valueOf(inputValue).replaceAll(";", ",");
                    } else if (inputValue instanceof String && StringUtils.isNotEmpty((String)String.valueOf(inputValue))) {
                        inputValue = "'" + inputValue + "'";
                    }
                    baseIdValue.append(inputValue);
                }
            }
            qFilter.__setProperty(split[0]);
            if (StringUtils.isNotEmpty((String)baseIdValue.toString())) {
                qFilter.__setValue((Object)baseIdValue.toString());
            } else {
                qFilter.__setValue(null);
            }
            resultList.add(qFilter);
        }
        resultList.addAll(collect.values());
        log.info("getQFilters,qFilterList:{}", resultList);
        return resultList;
    }

    private void getDataFilterByRequire(Map<String, String> inputData, JSONObject jsonObject, Set<String> tableNames, Map<String, List<String>> dataFilterMap, Map<String, List<String>> dataRequireMap, DynamicObject[] dataTable, Boolean needQueryBaseId) {
        HashSet<Long> fieldIdSet = new HashSet<Long>(1);
        fieldIdSet.add(GlobalFieldEnum.ORG.getId());
        HashMap<String, HashMap<Long, String>> orgMapping = ReportTemDataHelper.getDataGlobalRequire(fieldIdSet, tableNames);
        log.info("getDataGlobalRequire param1:" + fieldIdSet + " param2:" + tableNames + " return:" + orgMapping);
        log.info("data require json:" + jsonObject);
        Map<String, DynamicObjectCollection> dataTableMap = Arrays.stream(dataTable).collect(Collectors.toMap(data -> data.getString("number"), data -> data.getDynamicObjectCollection("entryentity")));
        log.info("dataTableMap:" + dataTableMap);
        Map<String, String> pluginMap = Arrays.stream(dataTable).collect(Collectors.toMap(data -> data.getString("number"), data -> data.getString("retrievalplugin")));
        ArrayList<Map> fieldList = new ArrayList<Map>();
        for (String tableName : tableNames) {
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)tableName);
            if (null != jsonObject) {
                JSONObject tableJson = jsonObject.getJSONObject(tableName);
                log.info("table:" + tableName + " table json:" + tableJson);
                if (tableJson.getBoolean("isEntity").booleanValue()) {
                    tableJson.remove((Object)"isEntity");
                    fieldList.add((Map)JSONObject.parseObject((String)tableJson.toJSONString(), Map.class));
                } else {
                    JSONArray datarequireArray = tableJson.getJSONArray("datarequireArray");
                    for (Object o : datarequireArray) {
                        JSONObject datarequire = (JSONObject)o;
                        Map map = (Map)JSONObject.parseObject((String)datarequire.toJSONString(), Map.class);
                        fieldList.add(map);
                    }
                }
            }
            DynamicObjectCollection dynamicObjects = dataTableMap.get(tableName);
            Map<String, DynamicObject> datatableEntityentryMap = dynamicObjects.stream().collect(Collectors.toMap(data -> data.getString("fieldnumber"), data -> data));
            if (fieldList.size() > 0) {
                for (Map fieldMap : fieldList) {
                    if (null == fieldMap) continue;
                    Set entrySet = fieldMap.entrySet();
                    StringBuilder sql = new StringBuilder();
                    List<String> sqlList = dataFilterMap.get(tableName);
                    for (Map.Entry entry : entrySet) {
                        String fieldnumber = (String)entry.getKey();
                        DynamicObject dynamicObject = datatableEntityentryMap.get(fieldnumber);
                        if (null == dynamicObject) continue;
                        StringBuilder fieldValue = new StringBuilder();
                        String fieldName = dynamicObject.getString("fieldName");
                        List<String> list = dataRequireMap.get(tableName);
                        List<String> numberlist = dataRequireMap.get(tableName + "_requirenumber");
                        if (null == list) {
                            list = new ArrayList<String>();
                            numberlist = new ArrayList<String>();
                        }
                        if (StringUtils.isNotEmpty((String)fieldName)) {
                            list.add(fieldName);
                            numberlist.add(fieldnumber);
                        }
                        dataRequireMap.put(tableName, list);
                        dataRequireMap.put(tableName + "_requirenumber", numberlist);
                        if (needQueryBaseId.booleanValue()) {
                            Set<String> fieldValueSet = Arrays.stream(((JSONArray)entry.getValue()).stream().toArray()).map(e -> String.valueOf(e)).collect(Collectors.toSet());
                            log.info("getBaseDataId input dataTableNumber :" + tableName + " field :" + fieldnumber);
                            List<Object> baseDataIds = null;
                            baseDataIds = this.queryBaseIdByPlugin(tableName, fieldnumber, fieldValueSet, pluginMap, dynamicObject);
                            if (null == baseDataIds || baseDataIds.size() == 0) continue;
                            for (Object value : baseDataIds) {
                                if (StringUtils.isNotEmpty((String)fieldValue.toString())) {
                                    fieldValue.append(',');
                                }
                                fieldValue.append(value);
                            }
                        } else {
                            log.info(tableName + " " + fieldnumber + " value:" + entry.getValue());
                            JSONArray valueArray = (JSONArray)entry.getValue();
                            String value = valueArray.stream().map(e -> e + "").collect(Collectors.joining(","));
                            if (StringUtils.isNotEmpty((String)fieldValue.toString())) {
                                fieldValue.append(',');
                            }
                            fieldValue.append(value);
                        }
                        log.info(tableName + " " + fieldnumber + " final value:" + fieldValue);
                        this.appendDateSql(entityType, fieldnumber, fieldValue, sql);
                        if (null != sqlList && sqlList.size() != 0) continue;
                        sqlList = new ArrayList<String>();
                    }
                    sqlList.add(sql.toString());
                    dataFilterMap.put(tableName, sqlList);
                }
            }
            HashMap<Long, String> orgFieldMap = orgMapping.get(tableName);
            ArrayList<String> fieldnumbers = new ArrayList<String>(orgFieldMap.values());
            Long org = Long.valueOf(inputData.get("org"));
            List<String> sqlList = dataFilterMap.get(tableName);
            for (int i = 0; i < sqlList.size(); ++i) {
                String sql = sqlList.get(i);
                sql = StringUtils.isNotEmpty((String)sql) ? sql + " and " + entityType.getProperty((String)fieldnumbers.get(0)).getAlias() + " in (" + org + ")" : entityType.getProperty((String)fieldnumbers.get(0)).getAlias() + " in (" + org + ")";
                sqlList.set(i, sql);
            }
            dataFilterMap.put(tableName, sqlList);
            List<String> list = dataRequireMap.get(tableName);
            String fieldName = datatableEntityentryMap.get(entityType.getProperty((String)fieldnumbers.get(0)).toString()).getString("fieldName");
            list.add(fieldName);
            fieldList.clear();
        }
    }

    private void appendDateSql(MainEntityType entityType, String fieldnumber, StringBuilder fieldValue, StringBuilder sql) {
        if (entityType.getProperty(fieldnumber) != null) {
            String fieldName = entityType.getProperty(fieldnumber).getAlias();
            if (StringUtils.isNotEmpty((String)sql.toString())) {
                sql.append(" and ");
            }
            if (fieldValue.toString().contains(ResManager.loadKDString((String)"\u5230", (String)"ReportGPTAction_18", (String)"fi-fgptas-business", (Object[])new Object[0]))) {
                String[] split = fieldValue.toString().split(",");
                String value = Arrays.stream(split).map(betweenSql -> {
                    StringBuilder stringBuilder = new StringBuilder();
                    String[] strings = betweenSql.split(ResManager.loadKDString((String)"\u5230", (String)"ReportGPTAction_18", (String)"fi-fgptas-business", (Object[])new Object[0]));
                    stringBuilder.append("( ").append(fieldName).append(" >= '").append(strings[0]).append("' and ").append(fieldName).append(" <= '").append(strings[1]).append("' )");
                    return stringBuilder.toString();
                }).collect(Collectors.joining(" or "));
                sql.append(value);
            } else {
                sql.append(fieldName);
                sql.append(" in (").append((CharSequence)fieldValue).append(')');
            }
        }
    }

    private List<Object> queryBaseIdByPlugin(String tableName, String fieldnumber, Set<String> fieldValueSet, Map<String, String> pluginMap, DynamicObject dynamicObject) {
        List<Object> baseDataIds;
        block4: {
            Object[] args;
            block3: {
                baseDataIds = new ArrayList<Object>();
                args = new Object[]{tableName, fieldnumber, new QFilter("name", "in", fieldValueSet).toArray(), null};
                if (!StringUtils.isEmpty((String)pluginMap.get(tableName))) break block3;
                String fieldproperty = dynamicObject.getString("fieldpropertyjson_tag");
                JSONObject baseDataJson = JSONObject.parseObject((String)fieldproperty);
                String baseEntityId = MetadataDao.getEntityNumberById((String)baseDataJson.getString("baseEntityId"));
                DynamicObject[] load = BusinessDataServiceHelper.load((String)baseEntityId, (String)"id", (QFilter[])new QFilter("number", "in", fieldValueSet).toArray());
                if (null == load || load.length <= 0) break block4;
                for (DynamicObject query : load) {
                    baseDataIds.add(query.get("id"));
                }
                break block4;
            }
            try {
                baseDataIds = (List)InvokePluginHelper.invokePlugin(pluginMap.get(tableName), "getBaseDataId", args);
            }
            catch (KDBizException e) {
                log.error((Throwable)e);
            }
        }
        return baseDataIds;
    }

    private void getDataByPull(JSONObject dataSource, String entityNumber, String selectFields, String dataprop, StringBuilder sql, String userInput, Map<String, List<String>> dataRequireNameMap, String pluginPath) {
        Object[] objectArray;
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        StringBuilder dataSql = new StringBuilder("select ");
        dataSql.append(selectFields);
        dataSql.append(" from ").append(entityType.getAlias()).append(" where ");
        dataSql.append((CharSequence)sql);
        log.info("\u62a5\u8868\u53d6\u6570sql\uff1a" + dataSql);
        if (userInput != null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = userInput;
        } else {
            objectArray = null;
        }
        Object[] cusParams = objectArray;
        Object[] args = new Object[]{dataSql.toString(), cusParams};
        String resultString = (String)InvokePluginHelper.invokePlugin(pluginPath, "getData", args);
        if (StringUtils.isNotEmpty((String)resultString)) {
            JSONObject resultJson = JSON.parseObject((String)resultString);
            log.info("\u53d6\u6570\u63d2\u4ef6\u8fd4\u56de\u6570\u636e\uff1a" + resultString);
            if (null != resultJson.get((Object)"data") && "success".equals(resultJson.getString("errorCode"))) {
                JSONArray resultArray = new JSONArray();
                if (StringUtils.isNotEmpty((String)dataSource.getString(entityNumber))) {
                    resultArray = JSONArray.parseArray((String)dataSource.getString(entityNumber));
                }
                JSONObject dataGroup = new JSONObject();
                JSONArray jsonArray = JSONArray.parseArray((String)resultJson.getString("data"));
                List<String> dataRequireNameList = dataRequireNameMap.get(entityNumber);
                for (Object o : jsonArray) {
                    Map map = (Map)o;
                    JSONArray childArray = new JSONArray();
                    Set entries = map.entrySet();
                    String requireKey = entries.stream().filter(entity -> dataRequireNameList.contains(((String)entity.getKey()).trim())).map(entity -> (String)entity.getKey() + ":" + entity.getValue()).collect(Collectors.joining(","));
                    if (null != dataGroup.getJSONArray(requireKey)) {
                        childArray = dataGroup.getJSONArray(requireKey);
                    }
                    JSONObject jsonObject = new JSONObject();
                    for (Map.Entry entry : entries) {
                        if (!dataprop.contains((CharSequence)entry.getKey()) || dataRequireNameList.contains(((String)entry.getKey()).trim())) continue;
                        jsonObject.put((String)entry.getKey(), entry.getValue());
                    }
                    if (jsonObject.size() > 0) {
                        childArray.add((Object)jsonObject);
                    }
                    dataGroup.put(requireKey, (Object)childArray);
                }
                Set keySet = dataGroup.keySet();
                for (String key : keySet) {
                    JSONObject result = new JSONObject();
                    JSONArray array = dataGroup.getJSONArray(key);
                    String[] datarequireFields = key.split(",");
                    Arrays.stream(datarequireFields).forEach(e -> {
                        String[] split = e.split(":");
                        if (split.length == 2) {
                            result.put(split[0], (Object)split[1]);
                        }
                    });
                    result.put("data", (Object)array);
                    resultArray.add((Object)result);
                }
                log.info("\u5165\u53c2\u62a5\u8868\u6570\u636e\uff1a" + resultArray);
                dataSource.put(entityNumber, (Object)resultArray.toJSONString());
            } else if (!"success".equals(resultJson.getString("errorCode"))) {
                throw new KDBizException(resultJson.getString("message"));
            }
        }
    }

    private DynamicObject getModel(Map<String, String> history) {
        DynamicObject model;
        String modelString = history.remove("model");
        if (StringUtils.isNotEmpty((String)modelString)) {
            model = (DynamicObject)JSONObject.parseObject((String)modelString, DynamicObject.class);
        } else if (StringUtils.isNotEmpty((String)String.valueOf(history.get("modelid")))) {
            String modelid = history.remove("modelid");
            model = BusinessDataServiceHelper.loadSingle((Object)modelid, (String)"fgptas_fireport_template");
        } else {
            this.saveFailLog(Long.valueOf(history.get("wordId")), ResManager.loadKDString((String)"\u62a5\u544a\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"ReportGPTAction_4", (String)"fi-fgptas-business", (Object[])new Object[0]));
            throw new KDBizException(ResManager.loadKDString((String)"\u62a5\u544a\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"ReportGPTAction_4", (String)"fi-fgptas-business", (Object[])new Object[0]));
        }
        return model;
    }

    private void getGptResult(Map<String, String> history, String paramName) {
        JSONObject jsonObject;
        String wordId = history.get("wordId");
        String text = "";
        if (null == ReportConfigHelper.getGptConfig() || !StringUtils.isNotEmpty((String)ReportConfigHelper.getGptConfig().get((Object)"commonprompt").toString())) {
            history.put("errorMessage", String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u627e\u5230\u62a5\u544a\u751f\u6210\u63d0\u793a\u8bed wordid:%s", (String)"ReportGPTAction_7", (String)"fi-fgptas-business", (Object[])new Object[0]), wordId));
            return;
        }
        String commonprompt = ReportConfigHelper.getGptConfig().get((Object)"commonprompt").toString();
        if (!StringUtils.isNotEmpty((String)history.get(paramName))) {
            return;
        }
        if (StringUtils.isEmpty((String)history.get("outlineid"))) {
            return;
        }
        String outlineid = history.get("outlineid");
        JSONObject dataSource = JSONObject.parseObject((String)history.get("dataSource"));
        JSONObject outlineData = dataSource.getJSONObject(outlineid);
        String dataInput = null;
        if (null != outlineData) {
            dataInput = outlineData.toJSONString().replaceAll("\\\"", "\"");
        }
        if (StringUtils.isEmpty((String)history.get(paramName))) {
            return;
        }
        HashMap<String, String> variableMap = new HashMap<String, String>(2);
        variableMap.put("DATA1", dataInput);
        variableMap.put("reportInput", history.get(paramName));
        log.info("GPT \u62a5\u544a\u751f\u6210\u63d0\u793a\u8bed\u6570\u5165\u53c2\uff1a" + variableMap);
        if (variableMap.containsKey("DATA1")) {
            DynamicObject dataSourcelog = BusinessDataServiceHelper.newDynamicObject((String)"fgptas_report_gptlog");
            dataSourcelog.set("id", (Object)DBServiceHelper.genGlobalLongId());
            dataSourcelog.set("modifier", (Object)RequestContext.get().getCurrUserId());
            dataSourcelog.set("modifytime", (Object)TimeServiceHelper.now());
            dataSourcelog.set("creator", (Object)RequestContext.get().getCurrUserId());
            dataSourcelog.set("createtime", (Object)TimeServiceHelper.now());
            dataSourcelog.set("docid", (Object)this.curDocId);
            dataSourcelog.set("word", (Object)wordId);
            dataSourcelog.set("sequence", (Object)1);
            dataSourcelog.set("remark", (Object)ResManager.loadKDString((String)"\u6570\u636e\u6e90\u8fd4\u56de\u3002", (String)"ReportGPTAction_11", (String)"fi-fgptas-business", (Object[])new Object[0]));
            dataSourcelog.set("gptnumber", (Object)"DataPullResult");
            dataSourcelog.set("reportlog_tag", variableMap);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataSourcelog});
        }
        try {
            String result = this.invokeSyncService(commonprompt, "1", variableMap);
            if (StringUtils.isNotEmpty((String)result)) {
                text = ReportGptHelper.getContentFromResult(result);
            }
        }
        catch (InterruptedException e) {
            history.put("errorMessage", String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u627e\u5230\u62a5\u544a\u751f\u6210\u63d0\u793a\u8bed wordid:%s", (String)"ReportGPTAction_7", (String)"fi-fgptas-business", (Object[])new Object[0]), wordId));
            log.error(e.getMessage());
            throw new KDBizException(e.getMessage());
        }
        history.remove(paramName);
        if (StringUtils.isNotEmpty((String)text)) {
            jsonObject = new JSONObject();
            JSONObject assistant = new JSONObject();
            assistant.put("content", (Object)text);
            assistant.put("outlineId", (Object)outlineid);
            jsonObject.put("assistant", (Object)assistant);
            jsonObject.put("time", (Object)new Date().getTime());
            JSONArray input = null == history.get("input") ? new JSONArray() : JSONArray.parseArray((String)history.get("input"));
            input.add((Object)jsonObject);
            if (!ReportConfigHelper.getWpsConfig().getBoolean("available").booleanValue()) {
                history.put("txtContent", jsonObject.toJSONString());
            }
            history.put("input", input.toJSONString());
        } else {
            jsonObject = new JSONObject();
            JSONObject assistant = new JSONObject();
            assistant.put("content", null);
            assistant.put("outlineId", (Object)outlineid);
            jsonObject.put("assistant", (Object)assistant);
            history.put("txtContent", jsonObject.toJSONString());
        }
    }

    private Long getLasterWordId(Map<String, String> history) {
        String wordId = history.get("wordId");
        if (!StringUtils.isEmpty((String)wordId)) {
            return LongUtil.toLong((Object)wordId);
        }
        String input = history.get("input");
        if (StringUtils.isEmpty((String)input)) {
            return DBServiceHelper.genGlobalLongId();
        }
        JSONArray jsonArray = JSONArray.parseArray((String)input);
        for (int i = jsonArray.size() - 1; i >= 0; --i) {
            int end;
            int pkIndex;
            String assistant;
            JSONObject jsonObject = (JSONObject)jsonArray.get(i);
            if (jsonObject == null || !(assistant = jsonObject.getString("assistant")).startsWith("bizAction://currentPage?") || !assistant.contains("fgptas") || !assistant.contains("fgptas_report_design") || (pkIndex = assistant.indexOf("billPkId")) < 0 || (end = assistant.indexOf(125, pkIndex)) <= 0) continue;
            String word = assistant.substring(pkIndex, end).replace("\"", "").replace("billPkId:", "").replace("}", "");
            return LongUtil.toLong((Object)word);
        }
        return DBServiceHelper.genGlobalLongId();
    }
}

