/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fgptas.business.report.helper;

import com.alibaba.fastjson.JSONObject;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.PermissionService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.fgptas.business.datatable.InvokePluginHelper;
import kd.fi.fgptas.business.enums.GlobalFieldEnum;
import kd.fi.fgptas.business.report.helper.ReportTemDataHelper;
import kd.fi.fgptas.common.enums.DatasourceEnum;

public class ReportGPTActionDataHelper {
    private static final Log LOGGER = LogFactory.getLog(ReportGPTActionDataHelper.class);

    public static String allReportType() {
        QFilter filter = new QFilter("status", "=", (Object)"C");
        filter.and(new QFilter("enable", "=", (Object)"1"));
        String selectFields = "name";
        DynamicObjectCollection query = QueryServiceHelper.query((String)"fgptas_report_type", (String)selectFields, (QFilter[])filter.toArray());
        Set name = query.stream().map(q -> q.getString("name")).collect(Collectors.toSet());
        return JSONObject.toJSONString(name);
    }

    public static String getAllUseOrg() {
        DynamicObjectCollection allUseOrg = BaseDataServiceHelper.getAllUseOrg((String)"fgptas_fireport_template");
        Set orgNameSet = allUseOrg.stream().limit(200L).map(o -> o.getString("name")).collect(Collectors.toSet());
        return JSONObject.toJSONString(orgNameSet);
    }

    public static DynamicObject getOrgByName(String name) {
        if (StringUtils.isEmpty((String)name)) {
            return null;
        }
        QFilter filter = new QFilter("name", "=", (Object)name);
        LOGGER.info("org name :" + name);
        return QueryServiceHelper.queryOne((String)"bos_org", (String)"id,name", (QFilter[])filter.toArray());
    }

    public static DynamicObject getReportTypeByName(String name) {
        if (StringUtils.isEmpty((String)name)) {
            return null;
        }
        QFilter filter = new QFilter("name", "=", (Object)name);
        LOGGER.info("report type name :" + name);
        return QueryServiceHelper.queryOne((String)"fgptas_report_type", (String)"id,name", (QFilter[])filter.toArray());
    }

    public static QFilter getReportDataRuleForBdProp(List<Long> orgIds) {
        long currUserId = RequestContext.get().getCurrUserId();
        PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
        return permissionService.getDataRuleForBdProp(currUserId, "fgptas", "fgptas_report_list", "reporttype", orgIds);
    }

    public static Set<Long> getReportTypeIds(QFilter[] qFilters) {
        if (qFilters == null || qFilters.length < 1) {
            return null;
        }
        DynamicObjectCollection idCol = QueryServiceHelper.query((String)"fgptas_report_type", (String)"id", (QFilter[])qFilters);
        if (idCol == null || idCol.size() < 1) {
            return null;
        }
        return idCol.stream().map(entity -> entity.getLong("id")).collect(Collectors.toSet());
    }

    public static String getNameById(Object id, String entityNumber) {
        if (ObjectUtils.isEmpty((Object)id) || StringUtils.isEmpty((String)entityNumber)) {
            return null;
        }
        QFilter filter = new QFilter("id", "=", id);
        DynamicObject name = QueryServiceHelper.queryOne((String)entityNumber, (String)"name", (QFilter[])filter.toArray());
        return name == null ? null : name.getString("name");
    }

    public static Set<String> getAllDataTableEntity() {
        DynamicObjectCollection allTableCol = QueryServiceHelper.query((String)"fgptas_datatable", (String)"number", null);
        return allTableCol.stream().map(dyn -> dyn.getString("number")).collect(Collectors.toSet());
    }

    public static Map<String, Map<String, Set<String>>> getReportTempGlobalFieldValue(long templateId) {
        HashMap<String, HashMap<Long, String>> dataGlobalRequire = ReportTemDataHelper.getDataGlobalRequire(templateId);
        if (dataGlobalRequire == null || dataGlobalRequire.isEmpty()) {
            return null;
        }
        Map<String, DynamicObject> dataTableConfig = ReportGPTActionDataHelper.getDataTableConfig(dataGlobalRequire.keySet());
        if (dataTableConfig == null) {
            LOGGER.info(String.format("The tables not in fgptas_datatable.tables:%s", dataGlobalRequire.keySet()));
            ErrorCode errorCode = new ErrorCode("checkReportTemplateData", ResManager.loadKDString((String)"\u62a5\u544a\u6a21\u7248\u914d\u7f6e\u7684\u6570\u636e\u6765\u6e90\u8868\u975e\u201c\u6570\u636e\u8868\u914d\u7f6e\u201d\u4e2d\u7684\u8868\u3002", (String)"ReportGPTActionDataHelper_0", (String)"fi-fgptas-business", (Object[])new Object[0]));
            throw new KDException(errorCode, new Object[0]);
        }
        HashMap<String, Map<String, Set<String>>> fieldsValues = new HashMap<String, Map<String, Set<String>>>((int)((float)dataGlobalRequire.size() / 0.75f) + 1);
        for (Map.Entry<String, HashMap<Long, String>> table : dataGlobalRequire.entrySet()) {
            String entityNumber = table.getKey();
            HashMap<Long, String> fields = table.getValue();
            fields.remove(GlobalFieldEnum.ORG.getId());
            if (fields.size() < 1) continue;
            DynamicObject config = dataTableConfig.get(entityNumber);
            if (config == null) {
                LOGGER.info(String.format("the table not in fgptas_datatable.table:%s", entityNumber));
                continue;
            }
            HashMap<String, Set<String>> oneTableFieldsValues = new HashMap<String, Set<String>>((int)((float)fields.size() / 0.75f) + 1);
            String dataSource = config.getString("datasource");
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            for (String fieldKey : fields.values()) {
                if ("scenario_year_period".equals(fieldKey)) {
                    String[] split;
                    for (String key : split = fieldKey.split("_")) {
                        ReportGPTActionDataHelper.getFieldValue(entityNumber, config, oneTableFieldsValues, dataSource, mainEntityType, key);
                    }
                }
                ReportGPTActionDataHelper.getFieldValue(entityNumber, config, oneTableFieldsValues, dataSource, mainEntityType, fieldKey);
            }
            if (oneTableFieldsValues.isEmpty()) continue;
            fieldsValues.put(entityNumber, oneTableFieldsValues);
        }
        return fieldsValues.isEmpty() ? null : fieldsValues;
    }

    private static void getFieldValue(String entityNumber, DynamicObject config, Map<String, Set<String>> oneTableFieldsValues, String dataSource, MainEntityType mainEntityType, String fieldKey) {
        Set<String> fieldValue;
        DynamicProperty dynamicProperty = mainEntityType.getProperty(fieldKey);
        if (dynamicProperty == null) {
            LOGGER.info(String.format("the entity {%s} not exist field {%s},please check config.", entityNumber, fieldKey));
            return;
        }
        if (dynamicProperty instanceof BasedataProp) {
            DynamicObjectCollection baseDataArr;
            BasedataProp basedataProp = (BasedataProp)dynamicProperty;
            String baseDataFormId = basedataProp.getBaseEntityId();
            BasedataEntityType dt = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)baseDataFormId);
            String nameProperty = dt.getNameProperty();
            if (DatasourceEnum.TABLE.getValue().equals(dataSource)) {
                baseDataArr = QueryServiceHelper.query((String)baseDataFormId, (String)nameProperty, null, null, (int)200);
            } else if (DatasourceEnum.INTERFACE.getValue().equals(dataSource)) {
                String className = config.getString("retrievalplugin");
                Object[] args = new Object[]{entityNumber, fieldKey, null, null};
                List baseDataIdList = (List)InvokePluginHelper.invokePlugin(className, "getBaseDataId", args);
                QFilter filter = new QFilter("id", "in", (Object)baseDataIdList);
                baseDataArr = QueryServiceHelper.query((String)dt.getName(), (String)nameProperty, (QFilter[])filter.toArray());
            } else {
                LOGGER.info(String.format("the table{%s} data source is error.", entityNumber));
                return;
            }
            fieldValue = baseDataArr.stream().map(baseData -> baseData.getString(nameProperty)).collect(Collectors.toSet());
        } else if (dynamicProperty instanceof ComboProp) {
            ComboProp comboProp = (ComboProp)dynamicProperty;
            fieldValue = comboProp.getComboItems().stream().map(item -> item.getName().getLocaleValue()).collect(Collectors.toSet());
        } else {
            fieldValue = Collections.singleton(ReportGPTActionDataHelper.getOtherPropertyFieldValue(entityNumber, fieldKey));
        }
        oneTableFieldsValues.put(fieldKey, fieldValue);
    }

    public static Map<String, DynamicObject> getDataTableConfig(Set<String> tables) {
        QFilter numberFilter = new QFilter("number", "in", tables);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"fgptas_datatable", (String)"id,number,datasource,retrievalplugin", (QFilter[])numberFilter.toArray());
        if (query == null || query.size() < 1) {
            return null;
        }
        return query.stream().collect(Collectors.toMap(k -> k.getString("number"), v -> v));
    }

    public static String getOtherPropertyFieldValue(String entityNumber, String fieldKey) {
        QFilter filter = new QFilter("number", "=", (Object)entityNumber);
        filter.and(new QFilter("entryentity.fieldnumber", "=", (Object)fieldKey));
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"fgptas_datatable", (String)"entryentity.fieldname fieldname,entryentity.fielddesc fielddesc", (QFilter[])filter.toArray());
        if (dynamicObject == null) {
            return "";
        }
        return dynamicObject.getString("fieldname") + "_" + dynamicObject.getString("fielddesc");
    }

    public static boolean isNullParams(String param) {
        return param == null || StringUtils.isEmpty((String)param) || "null".equals(param);
    }

    public static JSONObject handleJsonString(String jsonString) {
        int jsonBeginIndex = jsonString.indexOf(123);
        int jsonEndIndex = jsonString.lastIndexOf(125);
        if (jsonBeginIndex != -1 && jsonEndIndex != -1) {
            return JSONObject.parseObject((String)jsonString.substring(jsonBeginIndex, jsonEndIndex + 1));
        }
        return JSONObject.parseObject((String)jsonString);
    }

    public static String standardJsonString(String jsonString) {
        int jsonBeginIndex = jsonString.indexOf(123);
        int jsonEndIndex = jsonString.lastIndexOf(125);
        return jsonString.substring(jsonBeginIndex, jsonEndIndex + 1);
    }
}

