/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fgptas.business.report.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.fgptas.business.report.dto.TocNode;
import kd.fi.fgptas.business.report.dto.UserChatData;

public class ReportGptHelper {
    private static final Log logger = LogFactory.getLog(ReportGptHelper.class);

    public static void createToc(List<JSONObject> jsonList, List<TocNode> tocNodes) {
        for (TocNode node : tocNodes) {
            if (node.getType() > 0 && node.getType() < 10) {
                jsonList.add(ReportGptHelper.createText(node.getChat(), 1, 10.5f, true, false));
            }
            ReportGptHelper.createToc(jsonList, node.getChildNodes());
        }
    }

    public static void createContent(List<JSONObject> jsonList, List<TocNode> tocNodes) {
        int index = 0;
        for (TocNode node : tocNodes) {
            if (node.getType() == 1) {
                jsonList.add(ReportGptHelper.createText(node.getChat(), 1, 20.0f, true, false));
            } else if (node.getType() == 2) {
                jsonList.add(ReportGptHelper.createText(node.getChat(), 1, 15.0f, true, false));
            } else if (node.getType() >= 3 && node.getType() < 10) {
                jsonList.add(ReportGptHelper.createText(node.getChat(), 1, 12.0f, true, false));
            } else if (node.getType() == 99) {
                jsonList.add(ReportGptHelper.createImage("image" + ++index, node.getChat()));
            } else if (node.getType() == 100) {
                jsonList.add(ReportGptHelper.createChart("chat" + ++index, node.getChat()));
            } else {
                jsonList.add(ReportGptHelper.createText(node.getChat(), 1, 10.5f, true, false));
            }
            ReportGptHelper.createContent(jsonList, node.getChildNodes());
        }
    }

    public static JSONObject createText(TocNode node, int index) {
        JSONObject result = node.getType() == 1 ? ReportGptHelper.createText(node.getChat(), 1, 20.0f, true, false) : (node.getType() == 2 ? ReportGptHelper.createText(node.getChat(), 1, 15.0f, true, false) : (node.getType() >= 3 && node.getType() < 10 ? ReportGptHelper.createText(node.getChat(), 1, 12.0f, true, false) : (node.getType() == 99 ? ReportGptHelper.createImage("image" + index, node.getChat()) : (node.getType() == 100 ? ReportGptHelper.createChart("chat" + index, node.getChat()) : ReportGptHelper.createText(node.getChat(), 1, 10.5f, true, false)))));
        return result;
    }

    public static JSONObject createChart(String key, UserChatData chat) {
        JSONObject chatObject;
        try {
            chatObject = JSON.parseObject((String)chat.getText());
        }
        catch (Exception ex) {
            chatObject = new JSONObject();
        }
        JSONObject dataOject = chatObject.getJSONObject("data");
        if (dataOject == null) {
            dataOject = new JSONObject();
        }
        if ("table".equals(dataOject.getString("type"))) {
            return ReportGptHelper.createTable(chat);
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("type", (Object)"image");
        jsonObject.put("key", (Object)key);
        jsonObject.put("url", (Object)"");
        jsonObject.put("data", (Object)dataOject);
        jsonObject.put("source", chatObject.get((Object)"source"));
        jsonObject.put("chatId", (Object)chat.getId());
        return jsonObject;
    }

    public static JSONObject createImage(String key, UserChatData chat) {
        JSONObject chatObject;
        try {
            chatObject = JSON.parseObject((String)chat.getText());
        }
        catch (Exception ex) {
            chatObject = new JSONObject();
        }
        String url = chatObject.getString("imageUrl");
        url = url + "&access_token=" + RequestContext.get().getGlobalSessionId();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("type", (Object)"image");
        jsonObject.put("key", (Object)key);
        jsonObject.put("url", (Object)(StringUtils.isEmpty((String)url) ? "" : url));
        jsonObject.put("chatId", (Object)chat.getId());
        return jsonObject;
    }

    public static JSONObject createTable(UserChatData chat) {
        JSONObject chatObject;
        try {
            chatObject = JSON.parseObject((String)chat.getText());
        }
        catch (Exception ex) {
            chatObject = new JSONObject();
        }
        JSONObject dataOject = chatObject.getJSONObject("data");
        if (dataOject == null) {
            dataOject = new JSONObject();
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("type", (Object)"table");
        jsonObject.put("warp", (Object)1);
        jsonObject.put("font", (Object)ReportGptHelper.createFont(8.0f, false, true, 0));
        jsonObject.put("content", (Object)dataOject.getJSONArray("data"));
        jsonObject.put("chatId", (Object)chat.getId());
        jsonObject.put("source", chatObject.get((Object)"source"));
        return jsonObject;
    }

    public static JSONObject createText(String content, int warp, float fontSize, boolean bold, boolean center) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("type", (Object)"text");
        jsonObject.put("warp", (Object)warp);
        jsonObject.put("font", (Object)ReportGptHelper.createFont(fontSize, bold, center, 0));
        jsonObject.put("content", (Object)content);
        return jsonObject;
    }

    public static JSONObject createText(UserChatData chat, int warp, float fontSize, boolean bold, boolean center) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("type", (Object)"text");
        jsonObject.put("warp", (Object)warp);
        jsonObject.put("font", (Object)ReportGptHelper.createFont(fontSize, bold, center, 0));
        jsonObject.put("content", (Object)chat.getText());
        jsonObject.put("chatId", (Object)chat.getId().toString());
        return jsonObject;
    }

    public static JSONObject createNextpage() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("type", (Object)"nextpage");
        return jsonObject;
    }

    public static JSONObject createFont(float fontSize, boolean bold, boolean center, int indent) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("size", (Object)Float.valueOf(fontSize));
        jsonObject.put("color", (Object)"#000");
        jsonObject.put("bold", (Object)bold);
        jsonObject.put("center", (Object)center);
        jsonObject.put("indent", (Object)indent);
        return jsonObject;
    }

    public static String getWordMode(Long wordId) {
        String gptnumber = "";
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
        qFilters.add(new QFilter("word", "=", (Object)wordId));
        qFilters.add(new QFilter("gptnumber", "like", (Object)"GPT-IGPTAction%"));
        DynamicObjectCollection logs = QueryServiceHelper.query((String)"fgptas_report_gptlog", (String)"id,gptnumber", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"modifytime desc", (int)1);
        if (logs.size() > 0) {
            gptnumber = ((DynamicObject)logs.get(0)).getString("gptnumber");
        }
        return gptnumber;
    }

    public static Tuple<List<UserChatData>, DynamicObject> getUserChats(Long wordId, String gptnumber) {
        String reportlog_tag;
        ArrayList<UserChatData> list = new ArrayList<UserChatData>(2);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
        qFilters.add(new QFilter("word", "=", (Object)wordId));
        qFilters.add(new QFilter("gptnumber", "=", (Object)gptnumber));
        DynamicObject log = QueryServiceHelper.queryOne((String)"fgptas_report_gptlog", (String)"id,reportlog_tag,gptstatus", (QFilter[])qFilters.toArray(new QFilter[0]));
        if (log != null && !StringUtils.isEmpty((String)(reportlog_tag = log.getString("reportlog_tag")))) {
            JSONObject gptresult = JSON.parseObject((String)reportlog_tag);
            JSONArray inputObject = gptresult.getJSONArray("input");
            if (inputObject == null) {
                return new Tuple(list, (Object)log);
            }
            int index = 0;
            for (Object obj : inputObject) {
                JSONObject item = (JSONObject)obj;
                String assistant = item.getString("assistant");
                String time = item.getString("time");
                if (StringUtils.isEmpty((String)assistant) || assistant.length() <= 10) continue;
                String type = "text";
                try {
                    JSONObject content = JSONObject.parseObject((String)assistant);
                    if ("aiword".equals(content.getString("aiword"))) {
                        type = content.getString("type");
                    }
                }
                catch (Exception ex) {
                    type = "text";
                }
                list.add(new UserChatData(type, assistant, index, time));
                ++index;
            }
        }
        return new Tuple(list, (Object)log);
    }

    public static TocNode getTocNode(List<TocNode> nodes, Long outlineId) {
        if (nodes == null) {
            return null;
        }
        for (TocNode node : nodes) {
            if (node.getOutlineId().equals(outlineId)) {
                return node;
            }
            TocNode find = ReportGptHelper.getTocNode(node.getChildNodes(), outlineId);
            if (find == null) continue;
            return find;
        }
        return null;
    }

    public static TocNode getParentTocNode(List<TocNode> firestList, int level) {
        TocNode parentNode = null;
        if (firestList.size() > 0) {
            parentNode = firestList.get(firestList.size() - 1);
        }
        if (null != parentNode && level > 1) {
            parentNode = ReportGptHelper.getParentTocNode(parentNode.getChildNodes(), level - 1);
        }
        return parentNode;
    }

    public static String getContentFromResult(String reportlog_tag) {
        String msg = "";
        try {
            if (StringUtils.isEmpty((String)reportlog_tag)) {
                throw new KDBizException(ResManager.loadKDString((String)"GPT\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a\uff01", (String)"ReportGptHelper_0", (String)"fi-fgptas-business", (Object[])new Object[0]));
            }
            JSONObject jsonObject = JSONObject.parseObject((String)reportlog_tag);
            String dataStr = jsonObject.getString("data");
            if (StringUtils.isEmpty((String)dataStr)) {
                throw new KDBizException(ResManager.loadKDString((String)"GPT\u8fd4\u56de\u6570\u636e\u4e2ddata\u8282\u70b9\u6570\u636e\u4e3a\u7a7a\uff01", (String)"ReportGptHelper_1", (String)"fi-fgptas-business", (Object[])new Object[0]));
            }
            JSONObject dataObject = JSONObject.parseObject((String)dataStr);
            String llmValue = dataObject.getString("llmValue");
            if (StringUtils.isEmpty((String)llmValue)) {
                throw new KDBizException(ResManager.loadKDString((String)"GPT\u8fd4\u56de\u6570\u636e\u4e2ddata.llmValue\u6570\u636e\u4e3a\u7a7a\uff01", (String)"ReportGptHelper_2", (String)"fi-fgptas-business", (Object[])new Object[0]));
            }
            return llmValue;
        }
        catch (KDBizException kdEx) {
            throw kdEx;
        }
        catch (Exception ex) {
            msg = ResManager.loadKDString((String)"GPT\u8fd4\u56de\u6570\u636e\u89e3\u6790\u5931\u8d25\uff01", (String)"ReportGptHelper_3", (String)"fi-fgptas-business", (Object[])new Object[0]);
            logger.error(msg, (Throwable)ex);
            throw new KDBizException(msg);
        }
    }

    public static int getSpaceCount(String str) {
        int spaceCount = 0;
        for (char c : str.toCharArray()) {
            if (c == ' ') {
                ++spaceCount;
                continue;
            }
            if (c != '\t') break;
            spaceCount += 4;
        }
        return spaceCount;
    }
}

