/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fgptas.business.report.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.fgptas.common.enums.ReportStatusEnum;

public class ReportGptService {
    private static final Log logger = LogFactory.getLog(ReportGptService.class);
    private static final String ERR_MSG = "errMsg";
    private static final String ERR_PRICACY = "ai.gai.50004";
    private static final String ERR_SERVICE = "ai.gai.50003";

    public static JSONObject invokeAyncService(Long worId, String docId, String promptNumber, String input) {
        return ReportGptService.invokeAyncService(worId, docId, promptNumber, input, false);
    }

    public static JSONObject invokeAyncService(Long worId, String docId, String promptNumber, String input, boolean stream) {
        DynamicObject prompt = ReportGptService.getDynamicObject(promptNumber, "Report promptNumber not exists promptNumber:");
        HashMap<String, String> variableMap = new HashMap<String, String>(2);
        String gpttaskid = "";
        String errCode = "";
        int gptstatus = ReportStatusEnum.Running.getNumber();
        JSONObject inputJson = new JSONObject();
        JSONObject result = ReportGptService.invokeAyncService((Long)prompt.getLong("id"), input, variableMap, stream);
        if (result != null) {
            inputJson.put("input", (Object)input);
            inputJson.put("variableMap", variableMap);
            inputJson.put("aync", (Object)result);
            JSONObject data = result.getJSONObject("data");
            gpttaskid = data != null ? data.getString("task_id") : "";
            errCode = result.get((Object)"errCode").toString();
        } else {
            result = new JSONObject();
        }
        if (StringUtils.isEmpty((String)gpttaskid) || !"0".equals(errCode)) {
            gptstatus = ReportStatusEnum.Fail.getNumber();
        }
        boolean isError = ReportStatusEnum.Fail.getNumber() == gptstatus && null != result && null != result.get((Object)ERR_MSG);
        String remark = isError ? result.get((Object)ERR_MSG).toString() : "";
        DynamicObject log = BusinessDataServiceHelper.newDynamicObject((String)"fgptas_report_gptlog");
        log.set("id", (Object)DBServiceHelper.genGlobalLongId());
        log.set("modifier", (Object)RequestContext.get().getCurrUserId());
        log.set("modifytime", (Object)TimeServiceHelper.now());
        log.set("creator", (Object)RequestContext.get().getCurrUserId());
        log.set("createtime", (Object)TimeServiceHelper.now());
        log.set("docid", (Object)docId);
        log.set("word", (Object)worId);
        log.set("sequence", (Object)1);
        log.set("remark", (Object)remark);
        log.set("gptnumber", (Object)promptNumber);
        log.set("gpttaskid", (Object)gpttaskid);
        log.set("gptstatus", (Object)gptstatus);
        log.set("gptinputjson", (Object)inputJson.toJSONString());
        log.set("reportlog_tag", (Object)"");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{log});
        if (StringUtils.isNotEmpty((String)log.getString("id"))) {
            result.put("gptLogId", (Object)log.getString("id"));
        } else {
            result.put("gptLogId", (Object)"");
        }
        return result;
    }

    private static DynamicObject getDynamicObject(String promptNumber, String x) {
        DynamicObject prompt = QueryServiceHelper.queryOne((String)"gai_prompt", (String)"id,number,name", (QFilter[])new QFilter("number", "=", (Object)promptNumber).toArray());
        if (prompt == null) {
            logger.error(x + promptNumber);
            throw new KDBizException("PromptNumber:" + promptNumber + " not exists!");
        }
        return prompt;
    }

    private static JSONObject invokeAyncService(Long promptId, String input, Map<String, String> variableMap, boolean stream) {
        if (variableMap == null) {
            variableMap = new HashMap<String, String>(2);
        }
        HashMap<String, String> callBackInfo = new HashMap<String, String>(2);
        callBackInfo.put("cloudId", "fi");
        callBackInfo.put("appId", "fatvs");
        callBackInfo.put("serviceName", "IFatvsGptPromptCallBackService");
        callBackInfo.put("methodName", "notify");
        Object result = DispatchServiceHelper.invokeBizService((String)"ai", (String)"gai", (String)"GaiPromptService", (String)"asyncCall", (Object[])new Object[]{callBackInfo, stream, promptId, input, variableMap});
        logger.info("GaiPromptService return :" + result);
        return JSON.parseObject((String)JSON.toJSONString((Object)result));
    }

    public static boolean update(Object response) {
        DynamicObject log;
        JSONObject jsonObject;
        String jonsStr;
        block10: {
            if (response == null) {
                return false;
            }
            jonsStr = "";
            jonsStr = response instanceof String ? response.toString() : JSON.toJSONString((Object)response);
            jsonObject = new JSONObject();
            try {
                jsonObject = JSON.parseObject((String)jonsStr);
            }
            catch (Exception ex) {
                JSONArray array = JSONArray.parseArray((String)response.toString());
                if (array.size() <= 0) break block10;
                jsonObject = array.getJSONObject(0);
            }
        }
        if (jsonObject.getJSONObject("data") == null) {
            logger.error("AiWord data not exist:" + jonsStr);
            return false;
        }
        String taskId = jsonObject.getJSONObject("data").getString("taskId");
        DynamicObject find = QueryServiceHelper.queryOne((String)"fgptas_report_gptlog", (String)"id", (QFilter[])new QFilter("gpttaskid", "=", (Object)taskId).toArray());
        if (find == null) {
            DynamicObjectCollection list;
            boolean isFail = true;
            if (StringUtils.isEmpty((String)taskId) && (list = QueryServiceHelper.query((String)"fgptas_report_gptlog", (String)"id,gptstatus,gpttaskid", (QFilter[])new QFilter[0], (String)"createtime desc", (int)1)).size() > 0) {
                find = (DynamicObject)list.get(0);
                if (ReportStatusEnum.Running.getNumber() == find.getInt("gptstatus")) {
                    isFail = false;
                    taskId = find.getString("gpttaskid");
                }
            }
            if (isFail) {
                logger.error("AiWord taskId not exist taskId:" + taskId);
                return false;
            }
        }
        int gptstatus = ReportStatusEnum.Fail.getNumber();
        if ("0".equals(jsonObject.getString("errCode"))) {
            gptstatus = ReportStatusEnum.Success.getNumber();
        }
        if ((log = BusinessDataServiceHelper.loadSingle((Object)find.getLong("id"), (String)"fgptas_report_gptlog")) != null) {
            log.set("reportlog_tag", (Object)jsonObject.toJSONString());
            log.set("gptstatus", (Object)gptstatus);
            log.set("modifytime", (Object)TimeServiceHelper.now());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{log});
        }
        return true;
    }

    public static String getResult(String taskId) {
        if (StringUtils.isEmpty((String)taskId)) {
            throw new KDBizException("taskId is empty!");
        }
        DynamicObject find = QueryServiceHelper.queryOne((String)"fgptas_report_gptlog", (String)"id,gptstatus,reportlog_tag", (QFilter[])new QFilter("gpttaskid", "=", (Object)taskId).toArray());
        if (find == null) {
            throw new KDBizException("taskId not exist taskid:" + taskId);
        }
        String result = find.getString("reportlog_tag");
        if (StringUtils.isEmpty((String)result)) {
            throw new KDBizException("task is running!");
        }
        return result;
    }

    public static JSONObject invokeSyncService(Long worId, String docId, String promptNumber, String input) {
        DynamicObject prompt = ReportGptService.getDynamicObject(promptNumber, "AI promptNumber not exists promptNumber:");
        HashMap<String, String> variableMap = new HashMap<String, String>(2);
        String gpttaskid = "";
        String errCode = "";
        int gptstatus = ReportStatusEnum.Running.getNumber();
        JSONObject inputJson = new JSONObject();
        JSONObject result = ReportGptService.invokeSyncService(prompt.getLong("id"), input, variableMap);
        if (null != result.getJSONObject("data")) {
            inputJson.put("input", (Object)input);
            inputJson.put("variableMap", variableMap);
            JSONObject data = result.getJSONObject("data");
            if (data != null) {
                gpttaskid = data.getString("taskId");
            }
            errCode = result.get((Object)"errCode").toString();
        } else {
            result = new JSONObject();
        }
        gptstatus = StringUtils.isEmpty((String)gpttaskid) || !"0".equals(errCode) ? ReportStatusEnum.Fail.getNumber() : ReportStatusEnum.Success.getNumber();
        DynamicObject log = BusinessDataServiceHelper.newDynamicObject((String)"fgptas_report_gptlog");
        log.set("id", (Object)DBServiceHelper.genGlobalLongId());
        log.set("modifier", (Object)RequestContext.get().getCurrUserId());
        log.set("modifytime", (Object)TimeServiceHelper.now());
        log.set("creator", (Object)RequestContext.get().getCurrUserId());
        log.set("createtime", (Object)TimeServiceHelper.now());
        log.set("docid", (Object)docId);
        log.set("word", (Object)worId);
        log.set("sequence", (Object)1);
        log.set("remark", (Object)(ReportStatusEnum.Fail.getNumber() == gptstatus ? result.get((Object)ERR_MSG).toString() : ""));
        log.set("gptnumber", (Object)promptNumber);
        log.set("gpttaskid", (Object)gpttaskid);
        log.set("gptstatus", (Object)gptstatus);
        log.set("gptinputjson", (Object)inputJson.toJSONString());
        log.set("reportlog_tag", (Object)result.toJSONString());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{log});
        result.put("gptLogId", (Object)log.getString("id"));
        result.put("gptStatus", (Object)gptstatus);
        return result;
    }

    public static JSONObject invokeSyncService(Long worId, String docId, String promptNumber, String input, Map<String, String> variableMap) {
        DynamicObject prompt = ReportGptService.getDynamicObject(promptNumber, "AI promptNumber not exists promptNumber:");
        String gpttaskid = "";
        String errCode = "";
        int gptstatus = ReportStatusEnum.Running.getNumber();
        JSONObject inputJson = new JSONObject();
        JSONObject result = ReportGptService.invokeSyncService(prompt.getLong("id"), input, variableMap);
        if (null != result.getJSONObject("data")) {
            JSONObject data;
            inputJson.put("input", (Object)input);
            if (!variableMap.containsKey("DATA1")) {
                inputJson.put("variableMap", variableMap);
            }
            if ((data = result.getJSONObject("data")) != null) {
                gpttaskid = data.getString("taskId");
            }
            errCode = result.get((Object)"errCode").toString();
        } else {
            result = new JSONObject();
        }
        gptstatus = StringUtils.isEmpty((String)gpttaskid) || !"0".equals(errCode) ? ReportStatusEnum.Fail.getNumber() : ReportStatusEnum.Success.getNumber();
        DynamicObject log = BusinessDataServiceHelper.newDynamicObject((String)"fgptas_report_gptlog");
        log.set("id", (Object)DBServiceHelper.genGlobalLongId());
        log.set("modifier", (Object)RequestContext.get().getCurrUserId());
        log.set("modifytime", (Object)TimeServiceHelper.now());
        log.set("creator", (Object)RequestContext.get().getCurrUserId());
        log.set("createtime", (Object)TimeServiceHelper.now());
        log.set("docid", (Object)docId);
        log.set("word", (Object)worId);
        log.set("sequence", (Object)1);
        log.set("remark", (Object)(ReportStatusEnum.Fail.getNumber() == gptstatus ? result.get((Object)ERR_MSG).toString() : ""));
        log.set("gptnumber", (Object)promptNumber);
        log.set("gpttaskid", (Object)gpttaskid);
        log.set("gptstatus", (Object)gptstatus);
        String inputString = inputJson.toJSONString().trim().replaceAll("\\\"", "\"");
        log.set("gptinputjson", (Object)inputString);
        log.set("reportlog_tag", (Object)result.toJSONString());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{log});
        result.put("gptLogId", (Object)log.getString("id"));
        result.put("gptStatus", (Object)gptstatus);
        return result;
    }

    private static JSONObject invokeSyncService(Long promptId, String input, Map<String, String> variableMap) {
        String errCode;
        if (variableMap == null) {
            variableMap = new HashMap<String, String>(2);
        }
        Object[] params = new Object[]{promptId, input, variableMap};
        Object returnData = DispatchServiceHelper.invokeBizService((String)"ai", (String)"gai", (String)"GaiPromptService", (String)"syncCall", (Object[])params);
        JSONObject result = JSON.parseObject((String)JSON.toJSONString((Object)returnData));
        switch (errCode = result.get((Object)"errCode").toString()) {
            case "ai.gai.50004": {
                throw new KDBizException(ERR_PRICACY);
            }
            case "ai.gai.50003": {
                throw new KDBizException(ERR_SERVICE);
            }
        }
        return result;
    }
}

