/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fgptas.business.report.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.fgptas.business.report.helper.ReportExceptionHelper;
import kd.fi.fgptas.business.report.helper.ReportFileHelper;
import kd.fi.fgptas.common.constant.ReportConstants;

public class ReportHelper {
    private static final Log logger = LogFactory.getLog(ReportHelper.class);

    public static JSONObject getPropsDataResult(Object dataType) {
        JSONObject dataObj = new JSONObject();
        dataObj.put("dataType", dataType);
        dataObj.put("t", (Object)TimeServiceHelper.now());
        return dataObj;
    }

    public static JSONObject getPropsDataResult(Object dataType, Object data, String primaryKey) {
        JSONObject dataObj = new JSONObject();
        dataObj.put("dataType", dataType);
        dataObj.put("data", data);
        dataObj.put("t", (Object)TimeServiceHelper.now());
        dataObj.put("primaryKey", (Object)(StringUtils.isEmpty((String)primaryKey) ? "" : primaryKey));
        return dataObj;
    }

    public static JSONObject dataInit(Object pageConfig, Object ii18n) {
        JSONObject dataObj = new JSONObject();
        dataObj.put("dataType", (Object)ReportConstants.PropsDataType.DATA_INIT);
        dataObj.put("designMode", (Object)Boolean.TRUE);
        dataObj.put("pageConfig", pageConfig);
        dataObj.put("i18n", ii18n);
        dataObj.put("t", (Object)TimeServiceHelper.now());
        return dataObj;
    }

    public static JSONObject dataListView(Object data) {
        JSONObject dataObj = new JSONObject();
        dataObj.put("dataType", (Object)ReportConstants.PropsDataType.DATA_LIST_VIEW);
        dataObj.put("data", data);
        dataObj.put("i18n", (Object)ReportHelper.getI18n());
        dataObj.put("t", (Object)TimeServiceHelper.now());
        return dataObj;
    }

    public static JSONObject dataListOperate(String type) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("type", (Object)type);
        JSONObject dataObj = new JSONObject();
        dataObj.put("dataType", (Object)ReportConstants.PropsDataType.DATA_OPERATE);
        dataObj.put("data", (Object)jsonObject);
        dataObj.put("t", (Object)TimeServiceHelper.now());
        return dataObj;
    }

    public static JSONObject reportShow(String title, String subtitle, Object charts, Object dopont) {
        JSONObject dataObj = new JSONObject();
        dataObj.put("dataType", (Object)ReportConstants.PropsDataType.DATA_REPORT);
        dataObj.put("title", (Object)title);
        dataObj.put("subtitle", (Object)Boolean.TRUE);
        dataObj.put("charts", charts);
        dataObj.put("dopont", dopont);
        dataObj.put("t", (Object)TimeServiceHelper.now());
        return dataObj;
    }

    public static DynamicObject getWord(Long wordId) {
        DynamicObject chapterDy = BusinessDataServiceHelper.loadSingle((String)"fgptas_report", (String)"id,name,url,entity,year,period_startdate,period_enddate,createtime,creator.name,modifytime,modifier.name,model,period_json_tag,enable,report_period", (QFilter[])new QFilter("id", "=", (Object)wordId).toArray());
        if (chapterDy == null) {
            logger.error("report not exist:" + wordId);
            throw new KDBizException(ResManager.loadKDString((String)"\u6587\u6863\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"ReportHelper_0", (String)"fi-fgptas-business", (Object[])new Object[0]));
        }
        return chapterDy;
    }

    public static JSONObject dataInit(Long wordId) {
        DynamicObject word = ReportHelper.getWord(wordId);
        JSONObject pageConfig = ReportHelper.getDefaultPageConfig(word, word.getString("url"), false);
        JSONObject i18n = ReportHelper.getI18n();
        return ReportHelper.dataInit(pageConfig, i18n);
    }

    public static JSONObject dataCardList(List<QFilter> qFilters) {
        DynamicObjectCollection list = QueryServiceHelper.query((String)"fgptas_report", (String)"id,name,url,entity,year,period_startdate,period_enddate,createtime,creator.name,modifytime,modifier.name", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"createtime desc");
        ArrayList<JSONObject> data = new ArrayList<JSONObject>(2);
        for (DynamicObject word : list) {
            JSONObject item = new JSONObject();
            item.put("id", (Object)word.getString("id"));
            item.put("name", (Object)word.getString("name"));
            item.put("entity", (Object)word.getString("entity"));
            item.put("year", (Object)word.getString("year"));
            item.put("period_startdate", (Object)word.getString("period_startdate"));
            item.put("period_enddate", (Object)word.getString("period_enddate"));
            item.put("createtime", (Object)word.getDate("createtime"));
            item.put("modifytime", (Object)word.getDate("modifytime"));
            item.put("modifierName", (Object)word.getString("modifier.name"));
            item.put("creatorName", (Object)word.getString("creator.name"));
            data.add(item);
        }
        return ReportHelper.dataListView(data);
    }

    public static Object dataError(Throwable ex) {
        String title = ResManager.loadKDString((String)"\u521d\u59cb\u5316\u5931\u8d25", (String)"ReportHelper_1", (String)"fi-fgptas-business", (Object[])new Object[0]);
        logger.error(title, ex);
        String errorMsg = ReportExceptionHelper.buildExceptionMsg(title, ex, 30);
        return ReportHelper.dataError(errorMsg);
    }

    private static Object dataError(String errorMsg) {
        HashMap data = new HashMap(2);
        HashMap<String, String> error = new HashMap<String, String>(2);
        error.put("msg", errorMsg);
        data.put("error", error);
        if (RequestContext.get() != null && RequestContext.get().getClientFullContextPath() != null) {
            JSONObject result = ReportHelper.getPropsDataResult(ReportConstants.PropsDataType.DATA_ERROR, data, "");
            return result;
        }
        throw new KDBizException(errorMsg);
    }

    private static JSONObject getDefaultPageConfig(DynamicObject word, String url, boolean isRead) {
        Long wordId = word.getLong("id");
        boolean autostart = false;
        if (StringUtils.isEmpty((String)word.getString("url"))) {
            autostart = true;
        }
        Map<String, String> result = ReportFileHelper.createDocTempUrl(wordId, url, isRead);
        JSONObject dataObj = new JSONObject();
        dataObj.put("id", (Object)wordId.toString());
        dataObj.put("docId", (Object)result.get("docId"));
        dataObj.put("wpsUrl", (Object)result.get("url"));
        dataObj.put("type", (Object)"wps");
        dataObj.put("autoStart", (Object)autostart);
        dataObj.put("name", (Object)word.getString("name"));
        dataObj.put("entity", (Object)word.getString("entity"));
        dataObj.put("year", (Object)word.getString("year"));
        dataObj.put("period_startdate", (Object)word.getString("period_startdate"));
        dataObj.put("period_enddate", (Object)word.getString("period_enddate"));
        return dataObj;
    }

    public static JSONObject getI18n() {
        Lang lang = Lang.get();
        JSONObject dataObj = new JSONObject();
        dataObj.put("lang", (Object)lang.getLangTag());
        return dataObj;
    }

    public static boolean save(Long wordId, String eventArgs) {
        JSONObject jsonObject = JSON.parseObject((String)eventArgs);
        JSONObject pageConfig = jsonObject.getJSONObject("pageConfig");
        DynamicObject word = BusinessDataServiceHelper.loadSingle((Object)wordId, (String)"fgptas_report");
        if (word == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6587\u6863\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"ReportHelper_0", (String)"fi-fgptas-business", (Object[])new Object[0]));
        }
        String docId = pageConfig.getString("docId");
        QFilter qf = new QFilter("docid", "=", (Object)docId);
        DynamicObjectCollection wpsfileList = QueryServiceHelper.query((String)"fgptas_report_wpsfile", (String)"id,downloadurl,version", (QFilter[])new QFilter[]{qf}, (String)"version");
        if (wpsfileList.size() == 0) {
            throw new KDBizException("docId=" + docId + "not exists");
        }
        DynamicObject wpsfile = (DynamicObject)wpsfileList.get(wpsfileList.size() - 1);
        String tempUrl = wpsfile.getString("downloadurl");
        String formId = "fgptas_report_design";
        String fileName = word.getString("name") + ".docx";
        String newFileUrl = ReportFileHelper.uploadFile(wordId, tempUrl, formId, docId, fileName);
        word.set("url", (Object)newFileUrl);
        word.set("modifytime", (Object)TimeServiceHelper.now());
        try (TXHandle tx = TX.required();){
            try {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{word});
            }
            catch (Exception e) {
                tx.markRollback();
                throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
            }
        }
        return true;
    }
}

