/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fgptas.business.report.helper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.DataMutex;
import kd.bos.mutex.impl.MutexFactory;
import kd.bos.mutex.impl.MutexLockDataInfo;
import kd.bos.mutex.impl.MutexLockInfo;

public class ReportMutexHelper {
    public static final String OP_MODIFY = "op_modify";
    public static final String KEY_MUTEXFORM = "key_mutexform";
    public static final String CALLBACKID_MUTEXDROP = "CALLBACKID_MUTEXDROP";
    private static final Log logger = LogFactory.getLog(ReportMutexHelper.class);

    public static boolean viewRequire(AbstractFormPlugin plugin, String pkId, String entityId) {
        Throwable throwable;
        DataMutex dataMutex;
        boolean success = true;
        MutexLockInfo mutexLockInfo = new MutexLockInfo(pkId, null, "fgptas_report", entityId, OP_MODIFY, true, null);
        List mutexResult = new ArrayList(2);
        try {
            dataMutex = MutexFactory.createDataMutex();
            throwable = null;
            try {
                mutexResult = dataMutex.getLockInfo(Collections.singletonList(mutexLockInfo));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dataMutex != null) {
                    if (throwable != null) {
                        try {
                            dataMutex.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        dataMutex.close();
                    }
                }
            }
        }
        catch (IOException ex) {
            logger.error("aiword dataMutex getLockInfo fail", (Throwable)ex);
        }
        if (mutexResult.size() > 0) {
            Tuple<Integer, String> msgResult = ReportMutexHelper.getFormMutexResult((MutexLockDataInfo)mutexResult.get(0));
            if (msgResult != null) {
                if ((Integer)msgResult.item1 == 1) {
                    plugin.getView().getPageCache().put(KEY_MUTEXFORM, SerializationUtils.toJsonString((Object)mutexLockInfo));
                    plugin.getView().showConfirm((String)msgResult.item2, MessageBoxOptions.YesNo, new ConfirmCallBackListener(CALLBACKID_MUTEXDROP, (IFormPlugin)plugin));
                } else {
                    plugin.getView().showTipNotification((String)msgResult.item2);
                }
                success = false;
            }
        } else {
            try {
                dataMutex = MutexFactory.createDataMutex();
                throwable = null;
                try {
                    success = dataMutex.require(mutexLockInfo);
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (dataMutex != null) {
                        if (throwable != null) {
                            try {
                                dataMutex.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            dataMutex.close();
                        }
                    }
                }
            }
            catch (IOException ex) {
                logger.error("aiword dataMutex require fail", (Throwable)ex);
            }
        }
        return success;
    }

    public static boolean viewRelease(AbstractFormPlugin plugin) {
        String mutexform = plugin.getView().getPageCache().get(KEY_MUTEXFORM);
        if (StringUtils.isEmpty((CharSequence)mutexform)) {
            return false;
        }
        MutexLockInfo mutexLockInfo = (MutexLockInfo)SerializationUtils.fromJsonString((String)mutexform, MutexLockInfo.class);
        if (mutexLockInfo == null) {
            return false;
        }
        boolean success = true;
        try (DataMutex dataMutex = MutexFactory.createDataMutex();){
            success = dataMutex.release(mutexLockInfo.getDataObjId(), mutexLockInfo.getEntityNumber(), mutexLockInfo.getOperationKey());
        }
        catch (IOException ex) {
            logger.error("aiword dataMutex getLockInfo fail", (Throwable)ex);
        }
        if (success) {
            MutexLockInfo newMutexLockInfo = new MutexLockInfo(mutexLockInfo.getDataObjId(), null, "fgptas_report", mutexLockInfo.getEntityNumber(), mutexLockInfo.getOperationKey(), true, null);
            try (DataMutex dataMutex = MutexFactory.createDataMutex();){
                success = dataMutex.require(newMutexLockInfo);
            }
            catch (IOException ex) {
                logger.error("aiword dataMutex require fail", (Throwable)ex);
            }
        }
        return success;
    }

    public static boolean viewRelease(String pkId, String entityId) {
        boolean success = true;
        MutexLockInfo mutexLockInfo = new MutexLockInfo(pkId, null, "fgptas_report", entityId, OP_MODIFY, true, null);
        List mutexResult = new ArrayList(2);
        try (DataMutex dataMutex = MutexFactory.createDataMutex();){
            mutexResult = dataMutex.getLockInfo(Collections.singletonList(mutexLockInfo));
        }
        catch (IOException ex) {
            logger.error("aiword dataMutex getLockInfo fail", (Throwable)ex);
        }
        if (mutexResult.size() > 0) {
            MutexLockDataInfo lockDataInfo = (MutexLockDataInfo)mutexResult.get(0);
            if (!StringUtils.equals((CharSequence)lockDataInfo.getUserId(), (CharSequence)RequestContext.get().getUserId())) {
                return false;
            }
            try (DataMutex dataMutex = MutexFactory.createDataMutex();){
                success = dataMutex.release(mutexLockInfo.getDataObjId(), mutexLockInfo.getEntityNumber(), mutexLockInfo.getOperationKey());
            }
            catch (IOException ex) {
                logger.error("aiword dataMutex release fail", (Throwable)ex);
            }
        }
        return success;
    }

    private static Tuple<Integer, String> getFormMutexResult(MutexLockDataInfo lockInfo) {
        if (lockInfo != null && StringUtils.isNotBlank((CharSequence)lockInfo.getDataObjId())) {
            StringBuilder errMsg = new StringBuilder();
            int errType = 0;
            String userIdStr = String.valueOf(lockInfo.getUserId());
            String sessionId = lockInfo.getGlobalSession();
            String client = lockInfo.getClient();
            if (userIdStr != null) {
                MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"bos_user");
                long userId = Long.parseLong(userIdStr);
                Map cacheUserObjs = BusinessDataReader.loadFromCache((Object[])new Object[]{userId}, (DynamicObjectType)dt);
                DynamicObject userObj = (DynamicObject)cacheUserObjs.get(userId);
                if (userObj != null) {
                    errMsg.append(userObj.getString("name")).append(" ");
                }
            }
            if (StringUtils.isNotBlank((CharSequence)client)) {
                errMsg.append(ReportMutexHelper.getClientDescription(client));
            } else {
                errMsg.append(ResManager.loadKDString((String)"\u6b63\u5728\u7f16\u8f91\u8be5\u8bb0\u5f55", (String)"ReportMutexHelper_0", (String)"fi-fgptas-business", (Object[])new Object[0]));
            }
            if (StringUtils.equals((CharSequence)userIdStr, (CharSequence)RequestContext.get().getUserId()) && !StringUtils.equals((CharSequence)sessionId, (CharSequence)RequestContext.get().getGlobalSessionId()) && "web".equals(RequestContext.get().getClient())) {
                errMsg = new StringBuilder(String.format(ResManager.loadKDString((String)"%s\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5f3a\u5236\u8e22\u51fa\u53e6\u4e00\u4e2a\u767b\u5f55\u7528\u6237\u3002", (String)"ReportMutexHelper_1", (String)"fi-fgptas-business", (Object[])new Object[0]), errMsg.toString()));
                errType = 1;
            } else {
                if (StringUtils.equals((CharSequence)userIdStr, (CharSequence)RequestContext.get().getUserId()) && StringUtils.equals((CharSequence)sessionId, (CharSequence)RequestContext.get().getGlobalSessionId())) {
                    errMsg = new StringBuilder();
                    errMsg.append(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u5df2\u5728\u5176\u4ed6\u9875\u7b7e\u4e2d\u6253\u5f00\uff0c\u5982\u9700\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u5173\u95ed\u5355\u636e\u540e\u91cd\u8bd5\uff0c\u6216\u91cd\u65b0\u767b\u5f55\u540e\uff0c\u518d\u6b21\u5c1d\u8bd5\u3002", (String)"ReportMutexHelper_2", (String)"fi-fgptas-business", (Object[])new Object[0]));
                    return null;
                }
                errMsg = new StringBuilder(String.format(ResManager.loadKDString((String)"%s\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5f3a\u5236\u8e22\u51fa\u53e6\u4e00\u4e2a\u767b\u5f55\u7528\u6237\u3002", (String)"ReportMutexHelper_1", (String)"fi-fgptas-business", (Object[])new Object[0]), errMsg.toString()));
                errType = 1;
            }
            if (errMsg.length() == 0) {
                return null;
            }
            return new Tuple((Object)errType, (Object)errMsg.toString());
        }
        return null;
    }

    private static String getClientDescription(String clientType) {
        if ("web".equals(clientType)) {
            return ResManager.loadKDString((String)"\u6b63\u5728PC\u7aef\u7f16\u8f91\u8be5\u8bb0\u5f55", (String)"ReportMutexHelper_3", (String)"fi-fgptas-business", (Object[])new Object[0]);
        }
        if ("mobile".equals(clientType)) {
            return ResManager.loadKDString((String)"\u6b63\u5728\u79fb\u52a8\u7aef\u7f16\u8f91\u8be5\u8bb0\u5f55", (String)"ReportMutexHelper_4", (String)"fi-fgptas-business", (Object[])new Object[0]);
        }
        return !"batch".equals(clientType) && !"MQ".equals(clientType) ? ResManager.loadKDString((String)"\u6b63\u5728PC\u7aef\u7f16\u8f91\u8be5\u8bb0\u5f55", (String)"ReportMutexHelper_3", (String)"fi-fgptas-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6b63\u5728\u540e\u53f0\u4efb\u52a1\u7f16\u8f91\u8be5\u8bb0\u5f55", (String)"ReportMutexHelper_5", (String)"fi-fgptas-business", (Object[])new Object[0]);
    }
}

