/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fgptas.business.report.helper;

import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.codec.binary.Base64;

public class ReportSignatureUtil {
    private static final Log logger = LogFactory.getLog(ReportSignatureUtil.class);

    public static String getKeyValueStr(final Map<String, String> params) {
        ArrayList<String> keys = new ArrayList<String>(){
            {
                for (Map.Entry entry : params.entrySet()) {
                    this.add(entry.getKey());
                }
            }
        };
        StringBuilder sb = new StringBuilder();
        for (String key : keys) {
            String value = params.get(key) + "&";
            sb.append(key).append("=").append(value);
        }
        return sb.toString();
    }

    public static String getSignature(final Map<String, String> params, String appSecret) {
        ArrayList<String> keys = new ArrayList<String>(){
            {
                for (Map.Entry entry : params.entrySet()) {
                    this.add(entry.getKey());
                }
            }
        };
        keys.sort(String::compareTo);
        StringBuilder contents = new StringBuilder();
        for (String key : keys) {
            if (key.equals("_w_signature")) continue;
            contents.append(key).append("=").append(params.get(key));
        }
        contents.append("_w_secretkey=").append(appSecret);
        byte[] bytes = ReportSignatureUtil.hmacSha1(appSecret.getBytes(), contents.toString().getBytes());
        String sign = Base64.encodeBase64String((byte[])bytes);
        try {
            return URLEncoder.encode(sign, "UTF-8");
        }
        catch (Exception ex) {
            logger.error("aiword getSignature fail", (Throwable)ex);
            return null;
        }
    }

    public static byte[] hmacSha1(byte[] key, byte[] data) {
        try {
            SecretKeySpec signingKey = new SecretKeySpec(key, "HmacSHA1");
            Mac mac = Mac.getInstance(signingKey.getAlgorithm());
            mac.init(signingKey);
            return mac.doFinal(data);
        }
        catch (Exception ex) {
            logger.error("aiword hmacSha1 fail", (Throwable)ex);
            return null;
        }
    }
}

