/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fgptas.business.report.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.fgptas.business.enums.GlobalFieldEnum;
import kd.fi.fgptas.common.constant.ReportConstant;

public class ReportTemDataHelper {
    private static final Log log = LogFactory.getLog(ReportTemDataHelper.class);

    public static HashMap<String, HashMap<Long, String>> getDataGlobalRequire(long templateId) {
        String selectTemFields = ReportConstant.buildSelectField((String[])new String[]{"datarequire", "datatable"});
        DynamicObject template = BusinessDataServiceHelper.loadSingle((Object)templateId, (String)"fgptas_fireport_template", (String)selectTemFields);
        if (template == null) {
            return null;
        }
        DynamicObjectCollection dataRequire = template.getDynamicObjectCollection("datarequire");
        Set<Long> globalFieldKeys = dataRequire.stream().map(dy -> dy.getLong("fbasedataid_id")).collect(Collectors.toSet());
        DynamicObjectCollection outlines = template.getDynamicObjectCollection("outlineentry");
        if (outlines.size() < 1) {
            return null;
        }
        HashSet<String> dataSourceEntities = new HashSet<String>(8);
        for (DynamicObject outline : outlines) {
            for (DynamicObject dataSr : outline.getDynamicObjectCollection("datasourcesubentry")) {
                String dataEntity = dataSr.getString("datatable_id");
                if (!StringUtils.isNotEmpty((String)dataEntity)) continue;
                dataSourceEntities.add(dataEntity);
            }
        }
        return ReportTemDataHelper.getDataGlobalRequire(globalFieldKeys, dataSourceEntities);
    }

    public static HashMap<String, HashMap<Long, String>> getDataGlobalRequire(Set<Long> globalFieldKeys, Set<String> dataSourceEntities) {
        if (globalFieldKeys.size() < 1 || dataSourceEntities.size() < 1) {
            return null;
        }
        HashMap<String, HashMap<Long, String>> result = new HashMap<String, HashMap<Long, String>>(dataSourceEntities.size());
        QFilter filter = new QFilter("id", "in", globalFieldKeys);
        filter.and(new QFilter("entryentity.entity", "in", dataSourceEntities));
        String selectFields = "id," + ReportConstant.buildSelectField((String[])new String[]{"entryentity.entity", "entryentity.fieldnumber"});
        DynamicObjectCollection query = QueryServiceHelper.query((String)"fgptas_tablecol_mapping", (String)selectFields, (QFilter[])filter.toArray());
        for (DynamicObject row : query) {
            String fieldNumber = row.getString("entryentity.fieldnumber");
            if (!StringUtils.isNotEmpty((String)fieldNumber)) continue;
            String entityNumber = row.getString("entryentity.entity");
            result.computeIfAbsent(entityNumber, m -> new HashMap(5)).put(row.getLong("id"), fieldNumber);
        }
        return result;
    }

    public static HashMap<Long, String> getDataGlobalRequire(long templateId, String dataSourceEntity) {
        DynamicObject temp = BusinessDataServiceHelper.loadSingle((Object)templateId, (String)"fgptas_fireport_template", (String)"datarequire");
        if (temp == null) {
            return null;
        }
        DynamicObjectCollection dataRequireCol = temp.getDynamicObjectCollection("datarequire");
        if (dataRequireCol == null || dataRequireCol.isEmpty()) {
            return null;
        }
        Set<Long> globalFieldKeys = dataRequireCol.stream().map(dy -> dy.getLong("fbasedataid_id")).collect(Collectors.toSet());
        return ReportTemDataHelper.getDataGlobalRequire(globalFieldKeys, dataSourceEntity);
    }

    public static HashMap<Long, String> getDataGlobalRequire(Set<Long> globalFieldKeys, String dataSourceEntity) {
        HashMap<Long, String> result = new HashMap<Long, String>((int)((float)globalFieldKeys.size() / 0.75f) + 1);
        QFilter filter = new QFilter("id", "in", globalFieldKeys);
        filter.and(new QFilter("entryentity.entity", "=", (Object)dataSourceEntity));
        String selectFields = "id," + ReportConstant.buildSelectField((String[])new String[]{"entryentity.entity", "entryentity.fieldnumber"});
        DynamicObjectCollection query = QueryServiceHelper.query((String)"fgptas_tablecol_mapping", (String)selectFields, (QFilter[])filter.toArray());
        for (DynamicObject ele : query) {
            String fieldNumber = ele.getString("entryentity.fieldnumber");
            if (!StringUtils.isNotEmpty((String)fieldNumber)) continue;
            result.put(ele.getLong("id"), fieldNumber);
        }
        return result;
    }

    public static boolean existEnableTemplate(long orgId, long reportType, Long currentTempId) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(5);
        if (currentTempId != null && !currentTempId.equals(0L)) {
            filters.add(new QFilter("id", "not in", (Object)currentTempId));
        }
        QFilter orgFilter = new QFilter("createorg", "=", (Object)orgId);
        filters.add(orgFilter);
        QFilter typeFilter = new QFilter("reporttype", "=", (Object)reportType);
        filters.add(typeFilter);
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        filters.add(statusFilter);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        filters.add(enableFilter);
        return QueryServiceHelper.exists((String)"fgptas_fireport_template", (QFilter[])filters.toArray(new QFilter[0]));
    }

    public static Map<Long, Boolean> existSameTypeTemplate(Long orgId, List<Long> templateIds) {
        if (ObjectUtils.isEmpty((Object)orgId) || ObjectUtils.isEmpty(templateIds)) {
            return null;
        }
        QFilter idFilter = new QFilter("id", "in", templateIds);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"fgptas_fireport_template", (String)"id,reporttype", (QFilter[])idFilter.toArray());
        Map<Long, Long> typeMap = query.stream().collect(Collectors.toMap(q -> q.getLong("id"), q -> q.getLong("reporttype")));
        if (typeMap.isEmpty()) {
            return null;
        }
        HashMap<Long, Boolean> typeExistMap = ReportTemDataHelper.existEnableTemplate(orgId, new HashSet<Long>(typeMap.values()));
        HashMap<Long, Boolean> results = new HashMap<Long, Boolean>((int)((float)typeMap.size() / 0.75f) + 1);
        for (Map.Entry<Long, Long> type : typeMap.entrySet()) {
            Long tempId = type.getKey();
            Long typeId = type.getValue();
            results.put(tempId, typeExistMap.get(typeId));
        }
        return results;
    }

    public static HashMap<Long, Boolean> existEnableTemplate(long orgId, Set<Long> reportTypes) {
        HashMap<Long, Boolean> results = new HashMap<Long, Boolean>((int)((float)reportTypes.size() / 0.75f) + 1);
        QFilter orgFilter = new QFilter("createorg", "=", (Object)orgId);
        QFilter typeFilter = new QFilter("reporttype", "in", reportTypes);
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        DynamicObjectCollection query = QueryServiceHelper.query((String)"fgptas_fireport_template", (String)"reporttype", (QFilter[])new QFilter[]{orgFilter, typeFilter, statusFilter, enableFilter});
        if (query == null) {
            return results;
        }
        Set existTypes = query.stream().map(d -> d.getLong("reporttype")).collect(Collectors.toSet());
        for (Long type : reportTypes) {
            if (existTypes.contains(type)) {
                results.put(type, Boolean.TRUE);
                continue;
            }
            results.put(type, Boolean.FALSE);
        }
        return results;
    }

    public static Set<String> getConditionFields(String entityNumber) {
        QFilter filter = new QFilter("number", "=", (Object)entityNumber);
        filter.and(new QFilter("entryentity.fieldquery", "=", (Object)Boolean.TRUE));
        DynamicObjectCollection datatable = QueryServiceHelper.query((String)"fgptas_datatable", (String)"entryentity.fieldnumber fieldnumber", (QFilter[])filter.toArray());
        return datatable.stream().map(d -> d.getString("fieldnumber")).collect(Collectors.toSet());
    }

    public static Set<String> getDataTableFields(String entityNumber) {
        QFilter filter = new QFilter("number", "=", (Object)entityNumber);
        DynamicObjectCollection datatable = QueryServiceHelper.query((String)"fgptas_datatable", (String)"entryentity.fieldnumber fieldnumber", (QFilter[])filter.toArray());
        return datatable.stream().map(d -> d.getString("fieldnumber")).collect(Collectors.toSet());
    }

    public static List<Map<String, Map<String, Object>>> getReportRequire(long templateId) {
        String selectTemFields = ReportConstant.buildSelectField((String[])new String[]{"datarequire", "datatable"});
        DynamicObject template = BusinessDataServiceHelper.loadSingle((Object)templateId, (String)"fgptas_fireport_template", (String)selectTemFields);
        if (template == null) {
            return null;
        }
        DynamicObjectCollection dataRequire = template.getDynamicObjectCollection("datarequire");
        Set globalFieldKeys = dataRequire.stream().map(dy -> dy.getLong("fbasedataid_id")).collect(Collectors.toSet());
        if (!globalFieldKeys.contains(GlobalFieldEnum.REPORT_PERIOD.getId())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u62a5\u544a\u671f\u95f4\u6620\u5c04\u5173\u7cfb\u672a\u914d\u7f6e\u3002", (String)"ReportTemDataHelper_0", (String)"fi-fgptas-business", (Object[])new Object[0]));
        }
        DynamicObjectCollection outlines = template.getDynamicObjectCollection("outlineentry");
        if (outlines.size() < 1) {
            return null;
        }
        HashSet<String> dataSourceEntities = new HashSet<String>(8);
        for (DynamicObject outline : outlines) {
            for (DynamicObject dataSr : outline.getDynamicObjectCollection("datasourcesubentry")) {
                String dataEntity = dataSr.getDynamicObject("datatable").getString("number");
                if (!StringUtils.isNotEmpty((String)dataEntity)) continue;
                dataSourceEntities.add(dataEntity);
            }
        }
        log.info("getReportRequire param:" + dataSourceEntities);
        return ReportTemDataHelper.getReportRequire(dataSourceEntities);
    }

    public static List<Map<String, Map<String, Object>>> getReportRequire(Set<String> dataSourceEntities) {
        ArrayList<Map<String, Map<String, Object>>> resultList = new ArrayList<Map<String, Map<String, Object>>>(2);
        ArrayList<String> noModelTableList = new ArrayList<String>();
        QFilter filter = new QFilter("id", "in", (Object)GlobalFieldEnum.REPORT_PERIOD.getId());
        filter.and(new QFilter("entryentity.entity", "in", dataSourceEntities));
        String selectFields = "id," + ReportConstant.buildSelectField((String[])new String[]{"entryentity.entity", "entryentity.tablename", "entryentity.tableid", "entryentity.fieldtype", "entryentity.fieldnumber", "entryentity.fieldproperty"});
        DynamicObjectCollection query = QueryServiceHelper.query((String)"fgptas_tablecol_mapping", (String)selectFields, (QFilter[])filter.toArray());
        DynamicObject[] datatable = BusinessDataServiceHelper.load((String)"fgptas_datatable", (String)"id,number,name,entryentity.fieldnumber,entryentity.fieldtype,entryentity.fieldpropertyjson_tag,entryentity.fixedvalue", (QFilter[])new QFilter("number", "in", dataSourceEntities).toArray());
        Map<String, DynamicObject> datatableMap = Arrays.stream(datatable).collect(Collectors.toMap(d -> d.getString("number"), d -> d));
        HashMap hbMap = new HashMap();
        HashMap tableMap = new HashMap();
        for (DynamicObject row : query) {
            StringBuilder nameString;
            ArrayList<Long> property;
            String fieldNumber = row.getString("entryentity.fieldnumber");
            Long entityId = row.getLong("entryentity.tableid");
            String name = row.getString("entryentity.tablename");
            String tableNumber = row.getString("entryentity.entity");
            String fieldProperty = row.getString("entryentity.fieldproperty");
            if (StringUtils.isNotEmpty((String)fieldNumber) && "scenario_year_period".equals(fieldNumber)) {
                StringBuilder hbNameString;
                ArrayList<Long> hbTableIds;
                HashMap<String, Object> modelMap;
                DynamicObject datatableObject = datatableMap.get(tableNumber);
                String modelNum = null;
                if (null != datatableObject) {
                    DynamicObjectCollection entryentity = datatableObject.getDynamicObjectCollection("entryentity");
                    DynamicObject modelObject = null;
                    for (DynamicObject dynamicObject : entryentity) {
                        if (!"modelnum".equals(dynamicObject.getString("fieldnumber"))) continue;
                        modelObject = dynamicObject;
                    }
                    if (null == modelObject) {
                        noModelTableList.add(datatableObject.getString("name"));
                        continue;
                    }
                    modelNum = modelObject.getString("fixedvalue");
                    if (StringUtils.isEmpty((String)modelNum)) {
                        noModelTableList.add(datatableObject.getString("name"));
                        continue;
                    }
                }
                if (null == (modelMap = (HashMap<String, Object>)hbMap.get(modelNum))) {
                    modelMap = new HashMap<String, Object>();
                    hbTableIds = new ArrayList<Long>();
                    hbTableIds.add(entityId);
                    modelMap.put("tableId", hbTableIds);
                    hbNameString = new StringBuilder(name);
                    modelMap.put("name", hbNameString);
                } else {
                    hbTableIds = (ArrayList<Long>)modelMap.get("tableId");
                    if (null == hbTableIds) {
                        hbTableIds = new ArrayList();
                    }
                    hbTableIds.add(entityId);
                    modelMap.put("tableId", hbTableIds);
                    hbNameString = (StringBuilder)modelMap.get("name");
                    if (hbNameString.length() != 0 && StringUtils.isNotEmpty((String)name) && !hbNameString.toString().contains(name)) {
                        hbNameString.append('\u3001');
                        hbNameString.append(name);
                    }
                    modelMap.put("name", hbNameString);
                }
                modelMap.put("fieldType", "Basedata");
                hbMap.put(modelNum, modelMap);
                continue;
            }
            if (!StringUtils.isNotEmpty((String)fieldNumber)) continue;
            String fieldType = row.getString("entryentity.fieldtype");
            HashMap<String, Object> periodMap = (HashMap<String, Object>)tableMap.get(fieldProperty);
            if (null == periodMap) {
                periodMap = new HashMap<String, Object>();
                property = new ArrayList<Long>();
                property.add(entityId);
                periodMap.put("tableId", property);
                nameString = new StringBuilder(name);
                periodMap.put("name", nameString);
            } else {
                property = (ArrayList<Long>)periodMap.get("tableId");
                if (null == property) {
                    property = new ArrayList();
                }
                property.add(entityId);
                periodMap.put("tableId", property);
                nameString = (StringBuilder)periodMap.get("name");
                if (nameString.length() != 0 && StringUtils.isNotEmpty((String)name) && !nameString.toString().contains(name)) {
                    nameString.append('\u3001');
                    nameString.append(name);
                }
                periodMap.put("name", nameString);
            }
            periodMap.put("fieldType", fieldType);
            tableMap.put(fieldProperty, periodMap);
        }
        if (noModelTableList.size() > 0) {
            String notModelTableName = noModelTableList.stream().collect(Collectors.joining(","));
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u914d\u7f6e\u4f53\u7cfb\u56fa\u5b9a\u503c\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u751f\u6210\u62a5\u544a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ReportTemDataHelper_1", (String)"fi-fgptas-business", (Object[])new Object[0]), notModelTableName));
        }
        if (hbMap.size() == 0 && tableMap.size() == 0) {
            return null;
        }
        resultList.add(hbMap);
        resultList.add(tableMap);
        return resultList;
    }
}

