/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fgptas.business.report.helper.process;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.fgptas.business.report.dto.UserChatData;
import kd.fi.fgptas.business.report.helper.ReportHelper;
import kd.fi.fgptas.common.constant.ReportConstants;
import kd.fi.fgptas.common.enums.ReportChartEnum;

public class ReportChartHelper {
    private static final Log log = LogFactory.getLog(ReportChartHelper.class);

    public static JSONObject createChartData(List<UserChatData> contentList, int index, List<JSONObject> newData) {
        int i;
        UserChatData chat = contentList.get(index);
        int columnCount = chat.getText().split("\\|").length - 1;
        if (columnCount <= 1) {
            return null;
        }
        Boolean fisteIsNumeric = null;
        ArrayList<Object> xColumnList = new ArrayList<String>(2);
        ArrayList<String> sourceColumns = new ArrayList<String>(2);
        for (i = index - 1; i >= 0; --i) {
            String[] xColumns = contentList.get(i).getText().split("\\|");
            if (columnCount != xColumns.length - 1) continue;
            xColumnList = new ArrayList<String>(Arrays.asList(xColumns));
            xColumnList.remove(0);
            contentList.get(i).setIsProcess(true);
            String chatId = contentList.get(i).getId().toString();
            JSONObject find = newData.stream().filter(m -> chatId.equals(m.getString("chatId"))).findAny().orElse(null);
            if (find != null) {
                newData.remove(find);
            }
            sourceColumns.addAll(xColumnList);
            break;
        }
        if (xColumnList.size() == 0) {
            for (i = 0; i < columnCount; ++i) {
                xColumnList.add(String.format(ResManager.loadKDString((String)"\u672a\u77e5%s", (String)"ReportChartHelper_0", (String)"fi-fgptas-business", (Object[])new Object[0]), index));
            }
        }
        int nomatchIndex = 0;
        LinkedHashMap<String, List<BigDecimal>> rowData = new LinkedHashMap<String, List<BigDecimal>>(2);
        ArrayList<List<String>> sourceRows = new ArrayList<List<String>>(2);
        for (int i2 = index + 1; i2 < contentList.size(); ++i2) {
            String[] curCells = contentList.get(i2).getText().split("\\|");
            if (columnCount != curCells.length - 1) continue;
            ArrayList<BigDecimal> decimalList = new ArrayList<BigDecimal>(2);
            String serie = "";
            ArrayList<String> souceCells = new ArrayList<String>(2);
            for (int j = 1; j < curCells.length; ++j) {
                String cell = curCells[j];
                souceCells.add(cell);
                if (fisteIsNumeric == null && !(fisteIsNumeric = Boolean.valueOf(ReportChartHelper.isNumeric(cell))).booleanValue()) {
                    xColumnList.remove(0);
                }
                if (!fisteIsNumeric.booleanValue() && j == 1) {
                    serie = cell;
                    if (!StringUtils.isEmpty((String)serie)) continue;
                    serie = String.format(ResManager.loadKDString((String)"\u672a\u77e5%s", (String)"ReportChartHelper_0", (String)"fi-fgptas-business", (Object[])new Object[0]), ++nomatchIndex);
                    continue;
                }
                decimalList.add(ReportChartHelper.convertToNum(cell));
            }
            rowData.put(serie, decimalList);
            sourceRows.add(souceCells);
            contentList.get(i2).setIsProcess(true);
        }
        JSONObject chartData = null;
        for (int i3 = newData.size() - 1; i3 >= 0; --i3) {
            ReportChartEnum chartEnum;
            String content;
            JSONObject item = newData.get(i3);
            if (!"text".equals(item.getString("type")) || StringUtils.isEmpty((String)(content = item.getString("content"))) || (chartEnum = ReportChartEnum.getByContent((String)content)) == null) continue;
            chartData = ReportChartHelper.creteChartByType(rowData, xColumnList, chartEnum.getNumber());
            if (chartData == null) break;
            item.put("content", (Object)content.replace(chartEnum.getName(), ""));
            break;
        }
        if (chartData == null) {
            chartData = ReportChartHelper.creteTable(sourceRows, sourceColumns);
        }
        JSONObject soucre = new JSONObject();
        soucre.put("rows", rowData);
        soucre.put("cloumns", xColumnList);
        soucre.put("type", (Object)"table");
        JSONObject result = new JSONObject();
        result.put("data", (Object)chartData.toJSONString());
        result.put("source", (Object)soucre.toJSONString());
        result.put("aiword", (Object)"aiword");
        result.put("type", (Object)"chart");
        result.put("url", (Object)"");
        return result;
    }

    private static JSONObject creteLine(Map<String, List<BigDecimal>> rowData, List<String> xColumnList) {
        JSONObject itemObject = new JSONObject();
        itemObject.put("id", (Object)String.valueOf(DBServiceHelper.genGlobalLongId()));
        itemObject.put("name", (Object)"line");
        itemObject.put("type", (Object)ReportChartEnum.analysis_line_chart_polyline.getNumber());
        itemObject.put("xAxis", xColumnList);
        ArrayList data = new ArrayList(2);
        for (Map.Entry<String, List<BigDecimal>> entry : rowData.entrySet()) {
            LinkedHashMap<String, Object> item = new LinkedHashMap<String, Object>(2);
            item.put("data", entry.getValue());
            item.put("name", entry.getKey());
            item.put("type", "line");
            data.add(item);
        }
        itemObject.put("series", data);
        return itemObject;
    }

    private static JSONObject creteArea(Map<String, List<BigDecimal>> rowData, List<String> xColumnList) {
        JSONObject itemObject = new JSONObject();
        itemObject.put("id", (Object)String.valueOf(DBServiceHelper.genGlobalLongId()));
        itemObject.put("name", (Object)"area");
        itemObject.put("type", (Object)ReportChartEnum.analysis_line_chart_stack_square.getNumber());
        itemObject.put("xAxis", xColumnList);
        ArrayList data = new ArrayList(2);
        for (Map.Entry<String, List<BigDecimal>> entry : rowData.entrySet()) {
            LinkedHashMap<String, Object> item = new LinkedHashMap<String, Object>(2);
            item.put("areaStyle", new HashMap(2));
            item.put("data", entry.getValue());
            item.put("name", entry.getKey());
            item.put("type", "line");
            data.add(item);
        }
        itemObject.put("series", data);
        return itemObject;
    }

    private static JSONObject creteBar(Map<String, List<BigDecimal>> rowData, List<String> xColumnList, boolean isXAxis) {
        JSONObject itemObject = new JSONObject();
        itemObject.put("id", (Object)String.valueOf(DBServiceHelper.genGlobalLongId()));
        itemObject.put("name", (Object)"bar");
        if (isXAxis) {
            itemObject.put("type", (Object)ReportChartEnum.analysis_bar_chart_bar_areata.getNumber());
            itemObject.put("xAxis", xColumnList);
        } else {
            itemObject.put("type", (Object)ReportChartEnum.analysis_bar_chart_areata_bar_chart.getNumber());
            itemObject.put("yAxis", xColumnList);
        }
        ArrayList data = new ArrayList(2);
        for (Map.Entry<String, List<BigDecimal>> entry : rowData.entrySet()) {
            LinkedHashMap<String, Object> item = new LinkedHashMap<String, Object>(2);
            item.put("data", entry.getValue());
            item.put("name", entry.getKey());
            item.put("type", "bar");
            data.add(item);
        }
        itemObject.put("series", data);
        return itemObject;
    }

    private static JSONObject creteDoughnut(Map<String, List<BigDecimal>> rowData, List<String> xColumnList) {
        JSONObject itemObject = new JSONObject();
        itemObject.put("id", (Object)String.valueOf(DBServiceHelper.genGlobalLongId()));
        itemObject.put("name", (Object)"doughnut");
        itemObject.put("type", (Object)ReportChartEnum.analysis_pie_chart_doughnut.getNumber());
        ArrayList data = new ArrayList(2);
        for (Map.Entry<String, List<BigDecimal>> entry : rowData.entrySet()) {
            for (int i = 0; i < entry.getValue().size(); ++i) {
                String name = entry.getKey();
                if (xColumnList.size() > 1 && xColumnList.size() > i) {
                    name = entry.getKey() + "-" + xColumnList.get(i);
                }
                LinkedHashMap<String, Object> item = new LinkedHashMap<String, Object>(2);
                item.put("name", name);
                item.put("value", entry.getValue().get(i));
                data.add(item);
            }
        }
        itemObject.put("data", data);
        return itemObject;
    }

    private static JSONObject cretePie(Map<String, List<BigDecimal>> rowData, List<String> xColumnList) {
        JSONObject itemObject = new JSONObject();
        itemObject.put("id", (Object)String.valueOf(DBServiceHelper.genGlobalLongId()));
        itemObject.put("name", (Object)"pie");
        itemObject.put("type", (Object)ReportChartEnum.analysis_pie_chart_pie.getNumber());
        ArrayList data = new ArrayList(2);
        for (Map.Entry<String, List<BigDecimal>> entry : rowData.entrySet()) {
            for (int i = 0; i < entry.getValue().size(); ++i) {
                String name = entry.getKey();
                if (xColumnList.size() > 1 && xColumnList.size() > i) {
                    name = entry.getKey() + "-" + xColumnList.get(i);
                }
                LinkedHashMap<String, Object> item = new LinkedHashMap<String, Object>(2);
                item.put("name", name);
                item.put("value", entry.getValue().get(i));
                data.add(item);
            }
        }
        itemObject.put("data", data);
        return itemObject;
    }

    private static JSONObject creteTable(List<List<String>> sourceRows, List<String> sourceColumns) {
        JSONObject itemObject = new JSONObject();
        itemObject.put("id", (Object)String.valueOf(DBServiceHelper.genGlobalLongId()));
        itemObject.put("name", (Object)"table");
        itemObject.put("type", (Object)"table");
        ArrayList data = new ArrayList(2);
        ArrayList columns = new ArrayList(2);
        for (String string : sourceColumns) {
            LinkedHashMap<String, Object> item = new LinkedHashMap<String, Object>(2);
            item.put("text", string);
            item.put("bold", false);
            columns.add(item);
        }
        data.add(columns);
        for (List list : sourceRows) {
            ArrayList rows = new ArrayList(2);
            for (String cell : list) {
                LinkedHashMap<String, Object> item = new LinkedHashMap<String, Object>(2);
                item.put("text", cell);
                item.put("bold", false);
                rows.add(item);
            }
            data.add(rows);
        }
        itemObject.put("data", data);
        return itemObject;
    }

    private static BigDecimal convertToNum(Object d) {
        BigDecimal val = new BigDecimal(0);
        if (Objects.nonNull(d)) {
            try {
                val = new BigDecimal(ReportChartHelper.getFormatNumberText(d.toString().trim()));
            }
            catch (Exception ex) {
                log.warn("aiword convertToNum failed:", (Throwable)ex);
            }
        }
        return val;
    }

    private static String getFormatNumberText(String content) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < content.length(); ++i) {
            char c = content.charAt(i);
            if (c != '0' && c != '1' && c != '2' && c != '3' && c != '4' && c != '5' && c != '6' && c != '7' && c != '8' && c != '9' && c != '-' && c != '.') continue;
            sb.append(c);
        }
        return sb.toString();
    }

    private static boolean isNumeric(String str) {
        if (null == str || "".equals(str)) {
            return false;
        }
        String regx = "[+-]*\\d+\\.?\\d*[Ee]*[+-]*\\d+";
        Pattern pattern = Pattern.compile(regx);
        boolean isNumber = pattern.matcher(str).matches();
        if (isNumber) {
            return isNumber;
        }
        regx = "^[-\\+]?[.\\d]*$";
        pattern = Pattern.compile(regx);
        return pattern.matcher(str).matches();
    }

    public static JSONObject table2chart(String docId, String eventArgs) {
        JSONObject jsonObject = JSON.parseObject((String)eventArgs);
        String primaryKey = "";
        int index = -1;
        String type = "";
        if (jsonObject != null) {
            index = jsonObject.getIntValue("index");
            type = jsonObject.getString("type");
            primaryKey = jsonObject.getString("primaryKey");
        }
        String msg = "";
        if (StringUtils.isEmpty((String)docId) || StringUtils.isEmpty((String)type) || index < 0) {
            msg = ResManager.loadKDString((String)"\u8868\u683c\u8f6c\u6362\u56fe\u8868\u63a7\u4ef6\uff0c\u8f93\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"ReportChartHelper_1", (String)"fi-fgptas-business", (Object[])new Object[0]);
            throw new KDBizException(msg);
        }
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
        qFilters.add(new QFilter("docid", "=", (Object)docId));
        qFilters.add(new QFilter("gptnumber", "=", (Object)"GPT-RESULT"));
        DynamicObjectCollection logs = QueryServiceHelper.query((String)"fgptas_report_gptlog", (String)"id,reportlog_tag,gptstatus", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"createtime asc");
        int chatIndex = 0;
        JSONObject chartData = null;
        for (DynamicObject log : logs) {
            JSONObject resultJson = JSON.parseObject((String)log.getString("reportlog_tag"));
            JSONArray array = resultJson.getJSONArray("data");
            if (array.size() == 0) continue;
            for (Object itemObject : array) {
                JSONObject source;
                JSONObject item = (JSONObject)itemObject;
                if (!"table".equals(item.getString("type"))) continue;
                if (index == ++chatIndex && (source = item.getJSONObject("source")) != null) {
                    HashMap<String, List<BigDecimal>> rowData = new HashMap(2);
                    List<String> xColumnList = new ArrayList<String>(2);
                    if (source.get((Object)"rows") != null) {
                        rowData = (Map)source.get((Object)"rows");
                    }
                    if (source.get((Object)"cloumns") != null) {
                        xColumnList = (List)source.get((Object)"cloumns");
                    }
                    if ((chartData = ReportChartHelper.creteChartByType(rowData, xColumnList, type)) == null) {
                        msg = ResManager.loadKDString((String)"\u8f6c\u6362\u56fe\u8868\u7c7b\u578b\u76ee\u524d\u4e0d\u652f\u6301\uff01", (String)"ReportChartHelper_2", (String)"fi-fgptas-business", (Object[])new Object[0]);
                        throw new KDBizException(msg);
                    }
                }
                if (chartData == null) continue;
                break;
            }
            if (chartData == null) continue;
            break;
        }
        if (chartData == null) {
            msg = ResManager.loadKDString((String)"\u8868\u683c\u6570\u636e\u4e0d\u5b58\u5728\uff01", (String)"ReportChartHelper_3", (String)"fi-fgptas-business", (Object[])new Object[0]);
            throw new KDBizException(msg);
        }
        return ReportHelper.getPropsDataResult(ReportConstants.PropsDataType.DATA_TABLE2CHART, chartData, primaryKey);
    }

    private static JSONObject creteChartByType(Map<String, List<BigDecimal>> rowData, List<String> xColumnList, String type) {
        JSONObject chartData = null;
        if (ReportChartEnum.analysis_pie_chart_pie.getNumber().equals(type)) {
            chartData = ReportChartHelper.cretePie(rowData, xColumnList);
        } else if (ReportChartEnum.analysis_pie_chart_doughnut.getNumber().equals(type)) {
            chartData = ReportChartHelper.creteDoughnut(rowData, xColumnList);
        } else if (ReportChartEnum.analysis_bar_chart_bar_areata.getNumber().equals(type)) {
            chartData = ReportChartHelper.creteBar(rowData, xColumnList, true);
        } else if (ReportChartEnum.analysis_bar_chart_areata_bar_chart.getNumber().equals(type)) {
            chartData = ReportChartHelper.creteBar(rowData, xColumnList, false);
        } else if (ReportChartEnum.analysis_line_chart_polyline.getNumber().equals(type)) {
            chartData = ReportChartHelper.creteLine(rowData, xColumnList);
        } else if (ReportChartEnum.analysis_line_chart_stack_square.getNumber().equals(type)) {
            chartData = ReportChartHelper.creteArea(rowData, xColumnList);
        }
        return chartData;
    }
}

