/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fgptas.business.report.helper.process;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.fgptas.business.report.dto.TocNode;
import kd.fi.fgptas.business.report.dto.UserChatData;
import kd.fi.fgptas.business.report.helper.ReportGptHelper;
import kd.fi.fgptas.business.report.helper.ReportHelper;
import kd.fi.fgptas.business.report.helper.process.ReportChartHelper;
import kd.fi.fgptas.business.report.helper.process.ReportProcessBase;
import kd.fi.fgptas.business.report.helper.process.ReportProcessRedis;
import kd.fi.fgptas.common.enums.ReportStatusEnum;
import kd.fi.fgptas.common.utils.LongUtil;

public class ReportGenerateProcess
extends ReportProcessBase
implements Runnable {
    private static final Log log = LogFactory.getLog(ReportGenerateProcess.class);

    public ReportGenerateProcess(Long wordId, String docId) {
        log.info("AiWordProcessYL create curDocId=" + docId);
        this.curWordId = wordId;
        this.curDocId = docId;
    }

    @Override
    public void run() {
        try {
            log.info("AiWordProcessYL runtime data run curDocId=" + this.curDocId);
            this.doExecute();
        }
        catch (Exception e) {
            ReportProcessRedis.setStatus(this.curDocId, -1);
            ReportProcessRedis.setErrorMsg(this.curDocId, e.getMessage());
            log.error("AiWordProcessYL update runtime data error :" + e.getMessage(), (Throwable)e);
        }
    }

    private void doExecute() throws InterruptedException {
        log.info("Report Generate Process runtime data begin curDocId=" + this.curDocId);
        DynamicObject word = ReportHelper.getWord(this.curWordId);
        Long startTime = word.getDate("createtime").getTime();
        int progress = 1;
        int per = 8;
        ArrayList<String> timeList = new ArrayList<String>(100);
        int maxCount = 2000;
        int imageIndex = 0;
        Long gptStatus = 0L;
        boolean isCover = false;
        List<TocNode> tocNodes = new ArrayList<TocNode>(2);
        while (gptStatus == 0L && maxCount > 0) {
            --maxCount;
            if (ReportProcessRedis.getStatus(this.curDocId) != 0) break;
            JSONArray array = new JSONArray();
            ReportProcessRedis.setStatus(this.curDocId, 0);
            ReportProcessRedis.setProgress(this.curDocId, progress, ResManager.loadKDString((String)"\u83b7\u53d6\u804a\u5929\u5386\u53f2\u6570\u636e", (String)"ReportGenerateProcess_0", (String)"fi-fgptas-business", (Object[])new Object[0]));
            Tuple<List<UserChatData>, DynamicObject> userChatResult = ReportGptHelper.getUserChats(this.curWordId, "GPT-IGPTAction");
            List userChats = userChatResult.item1 == null ? new ArrayList(2) : (List)userChatResult.item1;
            DynamicObject log = (DynamicObject)userChatResult.item2;
            if (log == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u804a\u5929\u5386\u53f2\u6570\u636e\u4e3a\u7a7a\uff01", (String)"ReportGenerateProcess_1", (String)"fi-fgptas-business", (Object[])new Object[0]));
            }
            gptStatus = log.getLong("gptstatus");
            String progressTips = ResManager.loadKDString((String)"\u89e3\u6790\u6570\u636e\u4e2d", (String)"ReportGenerateProcess_2", (String)"fi-fgptas-business", (Object[])new Object[0]);
            int chatIndex = 0;
            for (UserChatData chat : userChats) {
                ReportProcessRedis.setProgress(this.curDocId, progress, progressTips + " " + ++chatIndex + "/" + userChats.size());
                if (timeList.contains(chat.getTime())) continue;
                timeList.add(chat.getTime());
                if (chat.getIsProcess() || LongUtil.toLong((Object)chat.getTime()) <= startTime || StringUtils.isEmpty((String)chat.getText()) || chat.getText().startsWith("bizAction://currentPage")) continue;
                if (!isCover) {
                    Tuple<Boolean, Integer> coverResult = this.createCoverPage(chat.getText(), array);
                    if (((Boolean)coverResult.item1).booleanValue()) {
                        isCover = true;
                        chat.setIsProcess(true);
                        per = 100 / (Integer)coverResult.item2;
                        if (per < 1) {
                            per = 1;
                        }
                    }
                }
                if (!chat.getIsProcess() && tocNodes.size() == 0) {
                    Tuple<Boolean, List<TocNode>> tocResult = this.createOutline(chat.getText(), array);
                    if (((Boolean)tocResult.item1).booleanValue()) {
                        tocNodes = (List)tocResult.item2;
                        chat.setIsProcess(true);
                    }
                }
                if (chat.getIsProcess() || tocNodes.size() == 0) continue;
                imageIndex = this.createText(chat, tocNodes, array, imageIndex);
                chat.setIsProcess(true);
            }
            this.formatText(array);
            if (array.size() > 0 || gptStatus != 0L) {
                if ((progress += per) > 100) {
                    progress = 99;
                }
                JSONObject resultJson = new JSONObject();
                resultJson.put("data", (Object)array);
                resultJson.put("tocNodes", tocNodes);
                this.saveRedisContent(resultJson);
            }
            Thread.sleep(1000L);
        }
        progress = 100;
        if (ReportProcessRedis.getStatus(this.curDocId) == 0) {
            ReportProcessRedis.setStatus(this.curDocId, 1);
            ReportProcessRedis.setProgress(this.curDocId, progress, ResManager.loadKDString((String)"\u751f\u6210\u6587\u6863\u5b8c\u6bd5", (String)"ReportGenerateProcess_3", (String)"fi-fgptas-business", (Object[])new Object[0]));
        }
        log.info("Reprot Generate Process runtime data end curDocId=" + this.curDocId);
    }

    private void formatText(JSONArray array) {
        for (Object obj : array) {
            JSONObject jsonObject = (JSONObject)obj;
            if (jsonObject == null) continue;
            String type = jsonObject.getString("type");
            String content = jsonObject.getString("content");
            if (!"text".equals(type) || StringUtils.isEmpty((String)content)) continue;
            content = this.getFormatText(content);
            jsonObject.put("content", (Object)content);
        }
    }

    private String getFormatText(String content) {
        char[] chars = new char[content.length()];
        boolean isfind = false;
        for (int i = 0; i < content.length(); ++i) {
            char c;
            chars[i] = c = content.charAt(i);
            if (i >= 5 || i <= 0 || c != '\u3001' && c != ']' && c != '-') continue;
            chars[i] = 32;
            isfind = true;
        }
        if (isfind) {
            content = new String(chars);
        }
        return content;
    }

    private int createText(UserChatData sourceChat, List<TocNode> tocNodes, JSONArray array, int imageIndex) {
        JSONObject textObject = JSONObject.parseObject((String)sourceChat.getText());
        Long outlineId = textObject.getLong("outlineId");
        String text = textObject.getString("content");
        TocNode tocNode = ReportGptHelper.getTocNode(tocNodes, outlineId);
        String[] contentList = text.split("\n");
        ArrayList<UserChatData> newChats = new ArrayList<UserChatData>(2);
        for (String content : contentList) {
            if (StringUtils.isEmpty((String)content)) continue;
            newChats.add(new UserChatData(sourceChat.getType(), content, sourceChat.getIndex(), sourceChat.getTime()));
        }
        ArrayList<JSONObject> newData = new ArrayList<JSONObject>(2);
        if (null != tocNode && tocNode.getType() < 10) {
            newData.add(ReportGptHelper.createText(tocNode, imageIndex));
            tocNode.getChat().setIsProcess(true);
        }
        int index = -1;
        for (UserChatData chat : newChats) {
            JSONObject itemObject;
            ++index;
            if (chat.getIsProcess()) continue;
            if (chat.getText().contains("|----|----|") && (itemObject = ReportChartHelper.createChartData(newChats, index, newData)) != null) {
                TocNode find = new TocNode(100, new UserChatData(chat.getType(), itemObject.toJSONString(), chat.getIndex(), chat.getTime()), null);
                newData.add(ReportGptHelper.createText(find, ++imageIndex));
                find.getChat().setIsProcess(true);
                continue;
            }
            if (null != tocNode && tocNode.getType() >= 99) {
                ++imageIndex;
            }
            newData.add(ReportGptHelper.createText(new TocNode(0, chat, null), imageIndex));
        }
        if (newData.size() > 0) {
            array.addAll(newData);
        }
        return imageIndex;
    }

    private Tuple<Boolean, List<TocNode>> createOutline(String content, JSONArray array) {
        Tuple<Boolean, List<TocNode>> tocResult = this.getOutline(content);
        if (((Boolean)tocResult.item1).booleanValue()) {
            ArrayList<JSONObject> jsonList = new ArrayList<JSONObject>(2);
            String tips = ResManager.loadKDString((String)"\u5927\u7eb2", (String)"ReportGenerateProcess_4", (String)"fi-fgptas-business", (Object[])new Object[0]);
            array.add((Object)ReportGptHelper.createText(tips, 1, 25.0f, false, true));
            ReportGptHelper.createToc(jsonList, (List)tocResult.item2);
            array.addAll(jsonList);
            array.add((Object)ReportGptHelper.createNextpage());
        }
        return tocResult;
    }

    private Tuple<Boolean, List<TocNode>> getOutline(String content) {
        ArrayList<TocNode> firestList = new ArrayList<TocNode>(2);
        boolean isToc = false;
        if (StringUtils.isEmpty((String)content)) {
            return new Tuple((Object)isToc, firestList);
        }
        JSONArray jsonArray = JSONArray.parseArray((String)content);
        TocNode curNode = null;
        for (Object obj : jsonArray) {
            TocNode parentNode;
            JSONObject json = (JSONObject)obj;
            String title = json.getString("outlinename");
            Long outlineId = json.getLong("outlineId");
            if (StringUtils.isEmpty((String)title)) continue;
            String key = this.getFormatText(title.trim());
            int level = json.getInteger("outlinelevel");
            if (level == 1) {
                curNode = new TocNode(1, new UserChatData("text", key, -1), null, outlineId);
                firestList.add(curNode);
                isToc = true;
                continue;
            }
            if (level == 2) {
                parentNode = ReportGptHelper.getParentTocNode(firestList, 1);
                curNode = new TocNode(2, new UserChatData("text", key, -1), parentNode, outlineId);
                if (parentNode == null) {
                    firestList.add(curNode);
                } else {
                    parentNode.getChildNodes().add(curNode);
                }
                isToc = true;
                continue;
            }
            if (level == 3) {
                parentNode = ReportGptHelper.getParentTocNode(firestList, 2);
                curNode = new TocNode(3, new UserChatData("text", key, -1), parentNode, outlineId);
                if (parentNode == null) {
                    firestList.add(curNode);
                } else {
                    parentNode.getChildNodes().add(curNode);
                }
                isToc = true;
                continue;
            }
            if (level != 4) continue;
            parentNode = ReportGptHelper.getParentTocNode(firestList, 3);
            curNode = new TocNode(4, new UserChatData("text", key, -1), parentNode, outlineId);
            if (parentNode == null) {
                firestList.add(curNode);
            } else {
                parentNode.getChildNodes().add(curNode);
            }
            isToc = true;
        }
        return new Tuple((Object)isToc, firestList);
    }

    private Tuple<Boolean, Integer> createCoverPage(String content, JSONArray array) {
        String[] titles;
        int defaultLine = 10;
        if (StringUtils.isEmpty((String)content)) {
            return new Tuple((Object)Boolean.FALSE, (Object)defaultLine);
        }
        String result = "";
        String entity = "";
        String name = "";
        String year = "";
        String period = "";
        String lines = "";
        for (String title : titles = content.split("\n")) {
            String item = title.trim();
            result = this.getCoverPageString(item, ResManager.loadKDString((String)"\u62a5\u544a\u540d\u79f0\uff1a", (String)"ReportGenerateProcess_5", (String)"fi-fgptas-business", (Object[])new Object[0]));
            if (StringUtils.isNotEmpty((String)result)) {
                name = result;
            }
            if (StringUtils.isNotEmpty((String)(result = this.getCoverPageString(item, ResManager.loadKDString((String)"\u7ec4\u7ec7\uff1a", (String)"ReportGenerateProcess_6", (String)"fi-fgptas-business", (Object[])new Object[0]))))) {
                entity = result;
            }
            if (StringUtils.isNotEmpty((String)(result = this.getCoverPageString(item, ResManager.loadKDString((String)"\u8d22\u5e74\uff1a", (String)"ReportGenerateProcess_7", (String)"fi-fgptas-business", (Object[])new Object[0]))))) {
                year = result;
            }
            if (StringUtils.isNotEmpty((String)(result = this.getCoverPageString(item, ResManager.loadKDString((String)"\u671f\u95f4\uff1a", (String)"ReportGenerateProcess_8", (String)"fi-fgptas-business", (Object[])new Object[0]))))) {
                period = result;
            }
            if (!StringUtils.isNotEmpty((String)(result = this.getCoverPageString(item, ResManager.loadKDString((String)"\u6bb5\u843d\uff1a", (String)"ReportGenerateProcess_9", (String)"fi-fgptas-business", (Object[])new Object[0]))))) continue;
            lines = result;
        }
        if (StringUtils.isNotEmpty((String)name) && StringUtils.isNotEmpty((String)entity) && StringUtils.isNotEmpty((String)year) && StringUtils.isNotEmpty((String)period)) {
            DynamicObject word = BusinessDataServiceHelper.loadSingle((Object)this.curWordId, (String)"fgptas_report");
            if (word != null) {
                array.add((Object)ReportGptHelper.createText(entity, 1, 48.0f, true, true));
                array.add((Object)ReportGptHelper.createText(name, 1, 20.0f, true, true));
                array.add((Object)ReportGptHelper.createText(period.contains(year) ? period : year + period, 1, 15.0f, true, true));
                array.add((Object)ReportGptHelper.createNextpage());
                defaultLine = this.getLinesCount(lines);
            }
            return new Tuple((Object)Boolean.TRUE, (Object)defaultLine);
        }
        return new Tuple((Object)Boolean.FALSE, (Object)defaultLine);
    }

    private Integer getLinesCount(String lines) {
        int defaultLine = 10;
        try {
            if (StringUtils.isEmpty((String)lines)) {
                return defaultLine;
            }
            String numberStr = lines.replace(ResManager.loadKDString((String)"\u6bb5\u843d\uff1a", (String)"ReportGenerateProcess_9", (String)"fi-fgptas-business", (Object[])new Object[0]), "");
            if (StringUtils.isEmpty((String)numberStr)) {
                return defaultLine;
            }
            Integer result = Integer.parseInt(numberStr);
            if (result <= 0) {
                result = defaultLine;
            }
            return result;
        }
        catch (Exception ex) {
            log.error("aiword convert int fails", (Throwable)ex);
            return defaultLine;
        }
    }

    private String getCoverPageString(String item, String flag) {
        String result = "";
        int index = item.indexOf(flag);
        if (index >= 0) {
            result = item.substring(index + flag.length(), item.length() - index);
        }
        return result;
    }

    private void saveRedisContent(JSONObject resultJson) {
        DynamicObject log = BusinessDataServiceHelper.newDynamicObject((String)"fgptas_report_gptlog");
        log.set("id", (Object)DBServiceHelper.genGlobalLongId());
        log.set("modifier", (Object)RequestContext.get().getCurrUserId());
        log.set("modifytime", (Object)TimeServiceHelper.now());
        log.set("creator", (Object)RequestContext.get().getCurrUserId());
        log.set("createtime", (Object)TimeServiceHelper.now());
        log.set("docid", (Object)this.curDocId);
        log.set("word", (Object)this.curWordId);
        log.set("sequence", (Object)1);
        log.set("remark", (Object)"GPT-RESULT");
        log.set("gptnumber", (Object)"GPT-RESULT");
        log.set("gpttaskid", (Object)"");
        log.set("gptstatus", (Object)ReportStatusEnum.Running.getNumber());
        log.set("gptinputjson", (Object)"");
        log.set("reportlog_tag", (Object)resultJson.toJSONString());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{log});
    }

    public static JSONArray getData(String docId) {
        JSONArray array = new JSONArray();
        ArrayList<Long> ids = new ArrayList<Long>(2);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
        qFilters.add(new QFilter("docid", "=", (Object)docId));
        qFilters.add(new QFilter("gptnumber", "=", (Object)"GPT-RESULT"));
        qFilters.add(new QFilter("gptstatus", "=", (Object)ReportStatusEnum.Running.getNumber()));
        DynamicObjectCollection logs = QueryServiceHelper.query((String)"fgptas_report_gptlog", (String)"id,reportlog_tag,gptstatus", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"createtime asc");
        for (DynamicObject[] log : logs) {
            JSONObject resultJson = JSON.parseObject((String)log.getString("reportlog_tag"));
            JSONArray data = resultJson.getJSONArray("data");
            if (data.size() > 0) {
                array.addAll((Collection)data);
            }
            ids.add(log.getLong("id"));
        }
        if (ids.size() > 0) {
            DynamicObject[] data;
            for (DynamicObject item : data = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fgptas_report_gptlog"))) {
                item.set("gptstatus", (Object)ReportStatusEnum.Success.getNumber());
                item.set("modifier", (Object)RequestContext.get().getCurrUserId());
                item.set("modifytime", (Object)TimeServiceHelper.now());
            }
            SaveServiceHelper.save((DynamicObject[])data);
        } else {
            try {
                int stauts = ReportProcessRedis.getStatus(docId);
                if (stauts == 0) {
                    qFilters = new ArrayList(2);
                    qFilters.add(new QFilter("docid", "=", (Object)docId));
                    qFilters.add(new QFilter("gptnumber", "=", (Object)"GPT-RESULT"));
                    logs = QueryServiceHelper.query((String)"fgptas_report_gptlog", (String)"id,reportlog_tag,gptstatus,createtime", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"createtime desc", (int)1);
                    if (logs.size() > 0) {
                        Calendar cal = Calendar.getInstance();
                        cal.setTime(TimeServiceHelper.now());
                        cal.add(12, -5);
                        Date date = cal.getTime();
                        if (date.compareTo(((DynamicObject)logs.get(0)).getDate("createtime")) > 0) {
                            ReportProcessRedis.setStatus(docId, -1);
                            ReportProcessRedis.setErrorMsg(docId, ResManager.loadKDString((String)"\u5206\u6790\u8d85\u65f6\uff0c\u4e3b\u52a8\u4e2d\u65ad", (String)"ReportGenerateProcess_10", (String)"fi-fgptas-business", (Object[])new Object[0]));
                        }
                    }
                }
            }
            catch (Exception ex) {
                log.error("aiword setstauts fail", (Throwable)ex);
            }
        }
        return array;
    }
}

