/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fgptas.business.report.helper.process;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.fgptas.business.report.helper.ReportGptService;
import kd.fi.fgptas.business.report.helper.process.ReportProcessRedis;
import kd.fi.fgptas.common.enums.ReportStatusEnum;
import kd.fi.fgptas.common.utils.LongUtil;

public class ReportProcessBase {
    private static final Log logger = LogFactory.getLog(ReportProcessBase.class);
    protected String curDocId;
    protected Long curWordId;

    protected String invokeSyncService(String gptNumber, String input, Map<String, String> variableMap) throws InterruptedException {
        return this.invokeSyncService(gptNumber, input, variableMap, true);
    }

    protected String invokeSyncService(String gptNumber, String input, Map<String, String> variableMap, boolean isThread) throws InterruptedException {
        String msg = ResManager.loadKDString((String)"\u4e2d\u6b62\u5206\u6790\u7ebf\u7a0b\u8fd0\u884c!", (String)"ReportProcessBase_0", (String)"fi-fgptas-business", (Object[])new Object[0]);
        int invokeTimes = 1;
        String result = "";
        int maxInvoke = 10;
        if (maxInvoke > 0) {
            --maxInvoke;
            JSONObject invokeResult = ReportGptService.invokeSyncService(this.curWordId, this.curDocId, gptNumber, input, variableMap);
            logger.info("aiword invokeSyncService data:" + invokeResult.toJSONString());
            int gptStatus = invokeResult.getIntValue("gptStatus");
            Thread.sleep(1000 * invokeTimes);
            if (isThread && ReportProcessRedis.getStatus(this.curDocId) != 0) {
                throw new KDBizException(msg);
            }
            if (ReportStatusEnum.Success.getNumber() == gptStatus) {
                result = JSON.toJSONString((Object)invokeResult);
                ReportGptService.update(result);
            } else {
                result = JSON.toJSONString((Object)invokeResult);
                ReportGptService.update(result);
                String error = StringUtils.isNotEmpty((String)invokeResult.getString("errMsg")) ? invokeResult.getString("errMsg") : ResManager.loadKDString((String)"\u5fae\u670d\u52a1\u63a5\u53e3\u8d85\u65f6\uff01", (String)"ReportProcessBase_1", (String)"fi-fgptas-business", (Object[])new Object[0]);
                throw new KDBizException(error);
            }
        }
        return result;
    }

    protected String invokeSyncService(String gptNumber, String input) throws InterruptedException {
        return this.invokeSyncService(gptNumber, input, true);
    }

    protected String invokeSyncService(String gptNumber, String input, boolean isThread) throws InterruptedException {
        String msg = ResManager.loadKDString((String)"\u4e2d\u6b62\u5206\u6790\u7ebf\u7a0b\u8fd0\u884c!", (String)"ReportProcessBase_0", (String)"fi-fgptas-business", (Object[])new Object[0]);
        int invokeTimes = 1;
        String result = "";
        int maxInvoke = 10;
        if (maxInvoke > 0) {
            --maxInvoke;
            JSONObject invokeResult = ReportGptService.invokeSyncService(this.curWordId, this.curDocId, gptNumber, input);
            logger.info("aiword invokeSyncService data:" + invokeResult.toJSONString());
            int gptStatus = invokeResult.getIntValue("gptStatus");
            Thread.sleep(1000 * invokeTimes);
            if (isThread && ReportProcessRedis.getStatus(this.curDocId) != 0) {
                throw new KDBizException(msg);
            }
            if (ReportStatusEnum.Success.getNumber() == gptStatus) {
                result = JSON.toJSONString((Object)invokeResult);
                ReportGptService.update(result);
            } else {
                result = JSON.toJSONString((Object)invokeResult);
                ReportGptService.update(result);
                String error = ResManager.loadKDString((String)"\u5fae\u670d\u52a1\u63a5\u53e3\u8d85\u65f6\uff01", (String)"ReportProcessBase_1", (String)"fi-fgptas-business", (Object[])new Object[0]);
                throw new KDBizException(error);
            }
        }
        return result;
    }

    protected Map<String, String> invokeAyncService(String gptNumber, List<String> inputList) throws InterruptedException {
        int invokeTimes = 1;
        String msg = ResManager.loadKDString((String)"\u4e2d\u6b62\u5206\u6790\u7ebf\u7a0b\u8fd0\u884c!", (String)"ReportProcessBase_0", (String)"fi-fgptas-business", (Object[])new Object[0]);
        LinkedHashMap<String, String> resultMap = new LinkedHashMap<String, String>(2);
        for (String item : inputList) {
            if (StringUtils.isEmpty((String)item)) continue;
            resultMap.put(item, "");
        }
        int maxInvoke = 10;
        block1: while (maxInvoke > 0) {
            --maxInvoke;
            LinkedHashMap logIds = new LinkedHashMap(2);
            for (Map.Entry item : resultMap.entrySet()) {
                if (!StringUtils.isEmpty((String)((String)item.getValue()))) continue;
                JSONObject ayncResult = ReportGptService.invokeAyncService(this.curWordId, this.curDocId, gptNumber, (String)item.getKey());
                logger.info("aiword invokeAyncService data:" + ayncResult.toJSONString());
                Thread.sleep(1000 * invokeTimes);
                if (ReportProcessRedis.getStatus(this.curDocId) != 0) {
                    throw new KDBizException(msg);
                }
                Long logId = LongUtil.toLong((Object)ayncResult.get((Object)"gptLogId"));
                logIds.put(logId, item.getKey());
            }
            if (logIds.size() == 0) break;
            for (int count = 300; count > 0; --count) {
                DynamicObjectCollection finds = QueryServiceHelper.query((String)"fgptas_report_gptlog", (String)"id,gptstatus", (QFilter[])new QFilter("id", "in", (Object)logIds.values().toArray()).toArray());
                for (DynamicObject find : finds) {
                    Long logId = find.getLong("id");
                    int status = find.getInt("gptstatus");
                    if (ReportStatusEnum.Success.getNumber() == status) {
                        DynamicObject item = QueryServiceHelper.queryOne((String)"fgptas_report_gptlog", (String)"id,reportlog_tag", (QFilter[])new QFilter("id", "=", (Object)logId).toArray());
                        if (item == null) continue;
                        resultMap.put((String)logIds.remove(logId), item.getString("reportlog_tag"));
                        continue;
                    }
                    if (ReportStatusEnum.Fail.getNumber() != status) continue;
                    logIds.remove(logId);
                }
                if (logIds.size() == 0) continue block1;
                Thread.sleep(1000L);
                if (ReportProcessRedis.getStatus(this.curDocId) == 0) continue;
                throw new KDBizException(msg);
            }
        }
        return resultMap;
    }
}

