/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fgptas.business.report.helper.process;

import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public class ReportProcessRedis {
    private static final Log log = LogFactory.getLog(ReportProcessRedis.class);
    private static final DistributeSessionlessCache CACHE = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();

    public static int getStatus(String docId) {
        if (StringUtils.isEmpty((String)docId)) {
            return 0;
        }
        String status = (String)CACHE.get(ReportProcessRedis.buildCacheType(docId), "status");
        return StringUtils.isEmpty((String)status) ? 0 : Integer.parseInt(status);
    }

    public static void setStatus(String docId, int status) {
        if (StringUtils.isEmpty((String)docId)) {
            return;
        }
        CACHE.put(ReportProcessRedis.buildCacheType(docId), "status", (Object)String.valueOf(status));
    }

    public static String getErrorMsg(String docId) {
        if (StringUtils.isEmpty((String)docId)) {
            return "";
        }
        String progress = (String)CACHE.get(ReportProcessRedis.buildCacheType(docId), "errorMsg");
        return StringUtils.isEmpty((String)progress) ? "" : progress;
    }

    public static void setErrorMsg(String docId, String errorMsg) {
        if (StringUtils.isEmpty((String)docId)) {
            return;
        }
        CACHE.put(ReportProcessRedis.buildCacheType(docId), "errorMsg", (Object)errorMsg);
    }

    public static void setProgress(String docId, int progress, String progressMsg) {
        if (StringUtils.isEmpty((String)docId)) {
            return;
        }
        if (progress > 100) {
            progress = 99;
        }
        if (progress < 0) {
            progress = 0;
        }
        CACHE.put(ReportProcessRedis.buildCacheType(docId), "progress", (Object)String.valueOf(progress));
        CACHE.put(ReportProcessRedis.buildCacheType(docId), "progressMsg", (Object)progressMsg);
    }

    public static int getProgress(String docId) {
        if (StringUtils.isEmpty((String)docId)) {
            return 0;
        }
        String progress = (String)CACHE.get(ReportProcessRedis.buildCacheType(docId), "progress");
        return StringUtils.isEmpty((String)progress) ? 0 : Integer.parseInt(progress);
    }

    public static String getProgressMsg(String docId) {
        if (StringUtils.isEmpty((String)docId)) {
            return "";
        }
        String progressMsg = (String)CACHE.get(ReportProcessRedis.buildCacheType(docId), "progressMsg");
        return StringUtils.isEmpty((String)progressMsg) ? "" : progressMsg;
    }

    private static String buildCacheType(String docId) {
        return "ReportGenerateProcess_" + CacheKeyUtil.getAcctId() + docId;
    }
}

