/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fgptas.business.report.task;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fgptas.business.report.helper.ReportGPTAction;
import kd.fi.fgptas.business.report.redis.ManualGenReportRedis;
import kd.fi.fgptas.business.report.task.ReportThreadPools;

public class ManualGenReportTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(ReportGPTAction.class);

    public void execute(RequestContext requestContext, Map<String, Object> params) throws KDException {
        this.feedbackProgress(0, ResManager.loadKDString((String)"\u5df2\u7ecf\u8fdb\u5165\u4efb\u52a1\u6267\u884c\u73af\u8282\uff0c\u5f00\u59cb\u6267\u884c\u4efb\u52a1\u3002", (String)"ManualGenReportTask_0", (String)"fi-fgptas-business", (Object[])new Object[0]), null);
        Long wordId = Long.parseLong(params.get("wordId").toString());
        log.info("ManualGenReportTask,wordId:{}", (Object)wordId);
        DynamicObject word = BusinessDataServiceHelper.loadSingle((Object)wordId, (String)"fgptas_report");
        DynamicObject model = word.getDynamicObject("model");
        log.info("ManualGenReportTask,model:{}", (Object)model);
        model = BusinessDataServiceHelper.loadSingle((Object)model.getPkValue(), (String)"fgptas_fireport_template");
        DynamicObjectCollection outlineentry = model.getDynamicObjectCollection("outlineentry");
        int totalProgress = outlineentry.size();
        ManualGenReportRedis.setReportProgress(String.valueOf(wordId), String.valueOf(0));
        Callable<String> callable = () -> {
            StringBuilder msg = new StringBuilder();
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
            qFilters.add(new QFilter("word", "=", (Object)wordId));
            qFilters.add(new QFilter("gptnumber", "=", (Object)"GPT-IGPTAction"));
            DynamicObject reportLog = QueryServiceHelper.queryOne((String)"fgptas_report_gptlog", (String)"id", (QFilter[])qFilters.toArray(new QFilter[0]));
            log.info("ManualGenReportTask,model:{},reportLog:{}", (Object)word.getDynamicObject("model"), (Object)reportLog);
            if (null != word.getDynamicObject("model") && null == reportLog) {
                List<String> emptyContent;
                HashMap<String, String> inputData = new HashMap<String, String>();
                inputData.put("wordId", wordId.toString());
                inputData.put("org", word.getDynamicObject("entity").getString("id"));
                inputData.put("orgName", word.getDynamicObject("entity").getString("name"));
                inputData.put("modelid", word.getDynamicObject("model").getString("id"));
                ReportGPTAction reportGPTAction = new ReportGPTAction();
                reportGPTAction.invokeAction("BLANK", inputData);
                inputData.put("manualGenReport", "1");
                reportGPTAction.invokeAction("BEGIN", inputData);
                if (StringUtils.isNotEmpty((CharSequence)((CharSequence)inputData.get("emptyContent"))) && (emptyContent = Arrays.asList(((String)inputData.get("emptyContent")).split(","))).size() > 0) {
                    for (String line : emptyContent) {
                        msg.append(line).append('\n');
                    }
                }
            }
            return msg.toString();
        };
        Future future = ReportThreadPools.MANUAL_GEN_REPORT_THREAD_POOL.submit(callable);
        int oldSchedule = 0;
        try {
            while (!future.isDone()) {
                int nowSchedule = Integer.parseInt(ManualGenReportRedis.getReportProgress(String.valueOf(wordId)));
                log.info("ManualGenReportTask,execute,oldSchedule:{},nowSchedule:{}", (Object)oldSchedule, (Object)nowSchedule);
                if (oldSchedule != nowSchedule) {
                    this.feedbackProgress(100 / totalProgress * nowSchedule, String.format(ResManager.loadKDString((String)"\u5f00\u59cb\u751f\u6210%1$s/%2$s\u6bb5\u62a5\u544a\u6b63\u6587......", (String)"ManualGenReportTask_1", (String)"fi-fgptas-business", (Object[])new Object[0]), nowSchedule, totalProgress), null);
                    oldSchedule = nowSchedule;
                }
                Thread.sleep(5000L);
            }
            String getMsg = (String)future.get();
            if (StringUtils.isNotEmpty((CharSequence)getMsg)) {
                HashMap<String, String> feedBackMsg = new HashMap<String, String>();
                feedBackMsg.put("msg", getMsg);
                this.feedbackCustomdata(feedBackMsg);
            }
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            String message = StringUtils.isNotBlank((CharSequence)cause.getMessage()) ? cause.getMessage() : ResManager.loadKDString((String)"\u62a5\u544a\u751f\u6210\u5f02\u5e38\u3002", (String)"ManualGenReportTask_2", (String)"fi-fgptas-business", (Object[])new Object[0]);
            log.info("ManualGenReportTask,error message:{}", (Object)message);
            if (cause.getCause() instanceof SQLException || message.contains("syntax error, expect")) {
                message = ResManager.loadKDString((String)"\u62a5\u544a\u6570\u636e\u67e5\u8be2\u5f02\u5e38\u3002", (String)"ManualGenReportTask_3", (String)"fi-fgptas-business", (Object[])new Object[0]);
            }
            log.info("ManualGenReportTask,exception:{}", (Object)Arrays.toString(cause.getStackTrace()));
            HashMap<String, String> feedBackMsg = new HashMap<String, String>();
            feedBackMsg.put("errMsg", message);
            this.feedbackCustomdata(feedBackMsg);
        }
        catch (KDException e) {
            log.info("ManualGenReportTask,exception:{}", (Object)Arrays.toString(e.getStackTrace()));
            HashMap<String, String> feedBackMsg = new HashMap<String, String>();
            feedBackMsg.put("errMsg", e.getMessage());
            this.feedbackCustomdata(feedBackMsg);
        }
        catch (Exception e) {
            log.info("ManualGenReportTask,exception:{}", (Object)Arrays.toString(e.getStackTrace()));
            HashMap<String, String> feedBackMsg = new HashMap<String, String>();
            feedBackMsg.put("errMsg", e.getMessage());
            this.feedbackCustomdata(feedBackMsg);
        }
    }
}

