/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fgptas.business.skill;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class HomeSkillHelper {
    private static final Log log = LogFactory.getLog(HomeSkillHelper.class);

    public static List<DynamicObject> getSkillList() {
        QFilter qFilter = new QFilter("enable", "=", (Object)"1");
        String selectFields = "id,number,name,description,gpttaskid,formmetaid,skillicon,configformmetaid,interactionmode,createtime";
        DynamicObjectCollection skillQueryList = QueryServiceHelper.query((String)"fgptas_skill", (String)selectFields, (QFilter[])qFilter.toArray(), (String)"description");
        List<DynamicObject> collect = skillQueryList.stream().collect(Collectors.toList());
        return collect;
    }

    public static DynamicObject getSkillDetail(long skillId) {
        QFilter qFilter = new QFilter("id", "=", (Object)skillId);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"fgptas_skill", (QFilter[])qFilter.toArray());
        return dynamicObject;
    }

    public static DynamicObject getSkillDetailbyQuery(long skillId) {
        QFilter qFilter = new QFilter("id", "=", (Object)skillId);
        String selectFields = "gpttaskid";
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"fgptas_skill", (String)selectFields, (QFilter[])qFilter.toArray());
        return dynamicObject;
    }

    public static Map<String, Object> getSkillCardDetail(long cardId) {
        String sql = "select fseq,fid,fentryid,fdatatabletype,fcardname from t_fgptas_skillcard where fentryid=" + cardId;
        DataSet dataSet = DB.queryDataSet((String)"HomeSkillHelper.getSkillCardDetail", (DBRoute)DBRoute.of((String)"fi"), (String)sql);
        if (!dataSet.hasNext()) {
            return null;
        }
        Row next = dataSet.next();
        HashMap<String, Object> map = new HashMap<String, Object>(1);
        map.put("datatabletype", next.getString("fdatatabletype"));
        return map;
    }

    public static List<Map<String, Object>> getSkillCardOptions(long cardId) {
        String sql = "select fseq,foptionname, foptionjson, foptioncode, fentryid, fdetailid, foptionmodifytime from t_fgptas_skillcardoption where fentryid=" + cardId + " order by foptionmodifytime desc";
        DataSet dataSet = DB.queryDataSet((String)"HomeSkillHelper.getSkillCardOptions", (DBRoute)DBRoute.of((String)"fi"), (String)sql);
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(1);
        while (dataSet.hasNext()) {
            Row next = dataSet.next();
            HashMap<String, Object> map = new HashMap<String, Object>(5);
            map.put("optionjson", next.getString("foptionjson"));
            map.put("seq", next.getLong("fseq"));
            map.put("detailid", next.getString("fdetailid"));
            map.put("optioncode", next.getString("foptioncode"));
            map.put("optionname", next.getString("foptionname"));
            list.add(map);
        }
        return list;
    }

    public static Map<String, Object> getSkillCardOptionDetail(long optionId) {
        String sql = "select fseq,foptionname, foptionjson, foptioncode, fentryid, fdetailid, foptionmodifytime from t_fgptas_skillcardoption where fdetailid=" + optionId;
        DataSet dataSet = DB.queryDataSet((String)"HomeSkillHelper.getSkillCardOptionDetail", (DBRoute)DBRoute.of((String)"fi"), (String)sql);
        if (!dataSet.hasNext()) {
            return null;
        }
        Row next = dataSet.next();
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        map.put("optionjson", next.getString("foptionjson"));
        map.put("seq", next.getLong("fseq"));
        map.put("detailid", next.getString("fdetailid"));
        return map;
    }

    public static Boolean getGPTTask(long taskId) {
        String sql = "select fid from t_gai_process where fenable='1' and fid=" + taskId;
        DataSet dataSet = DB.queryDataSet((String)"HomeSkillHelper.getGPTTask", (DBRoute)DBRoute.of((String)"aidb"), (String)sql);
        return dataSet.hasNext();
    }

    public static Map<String, Object> getGPTTaskDetail(long taskId) {
        String sql = "select fid,fdesc from t_gai_process where fenable='1' and fstatus='C' and fid=" + taskId;
        DataSet dataSet = DB.queryDataSet((String)"HomeSkillHelper.getGPTTask", (DBRoute)DBRoute.of((String)"aidb"), (String)sql);
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        if (dataSet.hasNext()) {
            Row next = dataSet.next();
            map.put("id", next.getString("fid"));
            map.put("desc", next.getString("fdesc"));
        }
        return map;
    }

    public static boolean hasGPTTaskPrei(long taskId) {
        String sql = "select fbasedataid from t_gai_process_app where fid=" + taskId;
        DataSet dataSet = DB.queryDataSet((String)"HomeSkillHelper.hasGPTTaskPrei", (DBRoute)DBRoute.of((String)"aidb"), (String)sql);
        if (!dataSet.hasNext()) {
            return true;
        }
        QFilter numberFilter = new QFilter("number", "=", (Object)"fgptas");
        DynamicObject metaInfo = BusinessDataServiceHelper.loadSingle((String)"bos_devportal_bizapp", (String)"fid,bizcloud,number", (QFilter[])new QFilter[]{numberFilter});
        String bizAppId = metaInfo.getString("id");
        if (StringUtils.isBlank((CharSequence)bizAppId)) {
            return false;
        }
        while (dataSet.hasNext()) {
            Row next = dataSet.next();
            if (!bizAppId.equals(next.getString("fbasedataid"))) continue;
            return true;
        }
        return false;
    }

    public static String getMetaName(String metanum) {
        String sql = "select fname,flocaleid from t_meta_formdesign_l where fnumber='" + metanum + "'";
        DataSet dataSet = DB.queryDataSet((String)"HomeSkillHelper.getMetaName", (DBRoute)DBRoute.of((String)"sys.meta"), (String)sql);
        String fname = "";
        while (dataSet.hasNext()) {
            Row next = dataSet.next();
            if (!"zh_CN".equals(next.getString("flocaleid"))) continue;
            fname = next.getString("fname");
        }
        return fname;
    }

    public static Boolean saveSkillCaRdOptionUp(long optionId) {
        String sql = "update t_fgptas_skillcardoption set foptionmodifytime='" + new Timestamp(new Date().getTime()).toString() + "' where fdetailid=" + optionId;
        return DB.execute((DBRoute)DBRoute.of((String)"fi"), (String)sql);
    }
}

