/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fgptas.opplugin.datatable;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.fgptas.business.datatable.ExtAppUtil;
import kd.fi.fgptas.business.datatable.WorkBillConfigDTO;
import kd.fi.fgptas.business.datatable.builder.BillFormModelBuilder;
import kd.fi.fgptas.business.datatable.builder.WorkBillConfigDTOBuilder;

public class DatatableDefineDeletePlugin
extends AbstractOperationServicePlugIn {
    private static final String bizUnitId = "2O+0I8AANUD9";
    private static final Log log = LogFactory.getLog(DatatableDefineDeletePlugin.class);

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        ArrayList<DynamicObject> successDataEntities = new ArrayList<DynamicObject>(dataEntities.length);
        ValidateResultCollection validateResultCollection = this.getOperationResult().getValidateResult();
        List validateResults = validateResultCollection.getValidateErrors();
        for (DynamicObject dynamicObject : dataEntities) {
            DynamicObject workBill = BusinessDataServiceHelper.loadSingle((Object)dynamicObject.getLong("id"), (String)"fgptas_datatable");
            WorkBillConfigDTO billConfig = WorkBillConfigDTOBuilder.createWorkBillConfigDTO((String)this.getExtBizAppId(), (DynamicObject)workBill);
            Map delResult = new BillFormModelBuilder(billConfig).deleteBillFormModel();
            if (delResult == null) continue;
            boolean success = (Boolean)delResult.get("success");
            if (success) {
                successDataEntities.add(workBill);
                continue;
            }
            String workBillName = workBill.getString("name");
            ValidationErrorInfo info = new ValidationErrorInfo(workBillName, workBill.getPkValue(), 0, 0, "errorcode_001", "", workBillName + "\uff1a" + delResult.get("message"), ErrorLevel.Error);
            ValidateResult validateResult = new ValidateResult();
            validateResult.addErrorInfo((OperateErrorInfo)info);
            validateResults.add(validateResult);
        }
        DynamicObject[] successDynamicObjectArray = successDataEntities.toArray(new DynamicObject[successDataEntities.size()]);
        e.setDataEntities(successDynamicObjectArray);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
    }

    private String getExtBizAppId() {
        QFilter numberFilter = new QFilter("number", "=", (Object)"fgptas");
        DynamicObject metaInfo = BusinessDataServiceHelper.loadSingle((String)"bos_devportal_bizapp", (String)"fid,bizcloud,number", (QFilter[])new QFilter[]{numberFilter});
        String bizCloudId = metaInfo.getString("bizcloud");
        String bizAppId = metaInfo.getString("id");
        return ExtAppUtil.getExtApp((String)bizCloudId, (String)bizAppId);
    }
}

