/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fgptas.opplugin.datatable;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.param.ParameterWriter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.fgptas.business.datatable.ExtAppUtil;
import kd.fi.fgptas.business.datatable.WorkBillConfigDTO;
import kd.fi.fgptas.business.datatable.builder.BillFormModelBuilder;
import kd.fi.fgptas.business.datatable.builder.WorkBillConfigDTOBuilder;
import kd.fi.fgptas.opplugin.datatable.DatatableDefineValidator;

public class DatatableDefineSavePlugin
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(DatatableDefineSavePlugin.class);

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new DatatableDefineValidator());
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        String bizAppId = this.getExtBizAppId();
        OperationResult operationResult = this.getOperationResult();
        ValidateResultCollection collection = operationResult.getValidateResult();
        List validateResults = collection.getValidateErrors();
        List successPkIds = operationResult.getSuccessPkIds();
        ArrayList<DynamicObject> successData = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> errorData = new ArrayList<DynamicObject>();
        ArrayList<String> newFormIds = new ArrayList<String>();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>(1);
        params.put("isviewbill", true);
        if (StringUtils.isEmpty((String)bizAppId)) {
            ValidationErrorInfo info = new ValidationErrorInfo("", null, 0, 0, "errorcode_001", "", ResManager.loadKDString((String)"\u521b\u5efa\u6269\u5c55\u5e94\u7528\u9519\u8bef", (String)"DatatableDefineSavePlugin_1", (String)"fi-fgptas-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
            ValidateResult validateResult = new ValidateResult();
            validateResult.addErrorInfo((OperateErrorInfo)info);
            validateResults.add(validateResult);
            return;
        }
        for (DynamicObject workBill : dataEntities) {
            boolean preset = workBill.getBoolean("preset");
            if (!successPkIds.contains(workBill.getPkValue()) || preset) continue;
            WorkBillConfigDTO workBillConfigDTO = WorkBillConfigDTOBuilder.createWorkBillConfigDTO((String)bizAppId, (DynamicObject)workBill);
            String formId2 = workBill.getString("entityid");
            workBillConfigDTO.setFormId(formId2);
            BillFormModelBuilder billModelBuilder = new BillFormModelBuilder(workBillConfigDTO);
            boolean exist = StringUtils.isNotEmpty((String)formId2);
            Map createMetaDataResult = null;
            createMetaDataResult = exist ? billModelBuilder.updateBillFormModel() : billModelBuilder.createBillFormModel();
            boolean success = (Boolean)createMetaDataResult.get("success");
            if (!success) {
                log.error("DatatableDefineSavePlugin create billForm model error\uff1a" + createMetaDataResult.get("message"));
                successPkIds.remove(workBill.getPkValue());
                ValidationErrorInfo info = new ValidationErrorInfo("", workBill.getPkValue(), 0, 0, "errorcode_001", "", String.format(ResManager.loadKDString((String)"\u6570\u636e\u8868\u914d\u7f6e\u521b\u5efa\u5143\u6570\u636e\u5931\u8d25:%s", (String)"DatatableDefineSavePlugin_0", (String)"fi-fgptas-opplugin", (Object[])new Object[0]), createMetaDataResult.get("message")), ErrorLevel.Error);
                ValidateResult validateResult = new ValidateResult();
                validateResult.addErrorInfo((OperateErrorInfo)info);
                validateResults.add(validateResult);
                errorData.add(workBill);
                continue;
            }
            if (!exist && StringUtils.isNotEmpty((String)(formId2 = (String)createMetaDataResult.get("formid")))) {
                workBill.set("entityid", (Object)formId2);
                String number = workBill.getString("number");
                newFormIds.add(number);
            }
            workBill.set("status", (Object)"C");
            workBill.set("enable", (Object)"1");
            successData.add(workBill);
        }
        if (successData.size() > 0) {
            this.handleSuccessData(successData);
            try {
                SaveServiceHelper.save((DynamicObject[])successData.toArray(new DynamicObject[0]));
                newFormIds.forEach(formId -> ParameterWriter.saveBillParameter((String)formId, (Map)params));
            }
            catch (Throwable throwable) {
                String numbers = successData.stream().map(dyo -> dyo.getString("number")).collect(Collectors.joining(","));
                log.error("\u521b\u5efa\u5143\u6570\u636e\u6210\u529f\uff0c\u4f46\u56de\u5199\u5171\u4eab\u5de5\u5355\u201c\u662f\u5426\u751f\u6210\u5143\u6570\u636e\u201d\u6807\u8bc6\u5931\u8d25\uff0c\u5931\u8d25\u5de5\u5355\u7f16\u7801\uff1a" + numbers, throwable);
                throw new RuntimeException(throwable);
            }
        }
        if (errorData.size() > 0) {
            this.handleErrorData(errorData);
            try {
                SaveServiceHelper.save((DynamicObject[])successData.toArray(new DynamicObject[0]));
            }
            catch (Throwable throwable) {
                String numbers = errorData.stream().map(dyo -> dyo.getString("number")).collect(Collectors.joining(","));
                log.error("\u521b\u5efa\u5143\u6570\u636e\u5931\u8d25\u7684\u6570\u636e\u56de\u5199\u5171\u4eab\u5de5\u5355\u201c\u662f\u5426\u751f\u6210\u5143\u6570\u636e\u201d\u6807\u8bc6\u5931\u8d25\uff0c\u5931\u8d25\u5de5\u5355\u7f16\u7801\uff1a" + numbers, throwable);
                throw new RuntimeException(throwable);
            }
        }
    }

    private String getExtBizAppId() {
        QFilter numberFilter = new QFilter("number", "=", (Object)"fgptas");
        DynamicObject metaInfo = BusinessDataServiceHelper.loadSingle((String)"bos_devportal_bizapp", (String)"fid,bizcloud,number", (QFilter[])new QFilter[]{numberFilter});
        String bizCloudId = metaInfo.getString("bizcloud");
        String bizAppId = metaInfo.getString("id");
        return ExtAppUtil.getExtApp((String)bizCloudId, (String)bizAppId);
    }

    private void handleSuccessData(List<DynamicObject> createdMetaDtaList) {
        for (DynamicObject data : createdMetaDtaList) {
            data.set("pcheckmeta", (Object)"1");
            DynamicObjectCollection entryData = data.getDynamicObjectCollection("entryentity");
            for (DynamicObject dyo : entryData) {
                dyo.set("fcheckmeta", (Object)"1");
            }
        }
    }

    private void handleErrorData(List<DynamicObject> createdMetaDtaList) {
        for (DynamicObject data : createdMetaDtaList) {
            String checkMeta = data.getString("pcheckmeta");
            if ("2".equals(checkMeta)) {
                data.set("pcheckmeta", (Object)"1");
            }
            DynamicObjectCollection entryData = data.getDynamicObjectCollection("entryentity");
            for (DynamicObject dyo : entryData) {
                String fcheckMeta = dyo.getString("fcheckmeta");
                if (!"2".equals(fcheckMeta)) continue;
                dyo.set("fcheckmeta", (Object)"1");
            }
        }
    }
}

