/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fgptas.opplugin.report;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.util.StringUtils;
import kd.fi.fgptas.business.enums.GlobalFieldEnum;
import kd.fi.fgptas.business.report.helper.ReportTemDataHelper;

public class ReportTemplateDataValidator
extends AbstractValidator {
    public void validate() {
        if (this.dataEntities.length > 1) {
            HashSet<Long> typeIds = new HashSet<Long>(this.dataEntities.length);
            ExtendedDataEntity[] extendedDataEntityArray = this.dataEntities;
            int n = extendedDataEntityArray.length;
            for (int i = 0; i < n; ++i) {
                ExtendedDataEntity dataEntity = extendedDataEntityArray[i];
                Long typeId = dataEntity.getDataEntity().getDynamicObject("reporttype").getLong("id");
                if (typeIds.add(typeId)) continue;
                String msg = ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u6279\u91cf\u64cd\u4f5c\u5177\u6709\u76f8\u540c\u62a5\u544a\u7c7b\u578b\u7684\u6a21\u7248\u3002", (String)"ReportTemplateDataValidator_5", (String)"fi-fgptas-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(dataEntity, msg);
                return;
            }
        }
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            String msg;
            HashMap<Long, String> globalFields;
            DynamicObject template = dataEntity.getDataEntity();
            DynamicObject createOrgDyn = template.getDynamicObject("createorg");
            DynamicObject reportTypeDyn = template.getDynamicObject("reporttype");
            if (reportTypeDyn == null) continue;
            boolean exist = ReportTemDataHelper.existEnableTemplate((long)createOrgDyn.getLong("id"), (long)reportTypeDyn.getLong("id"), (Long)template.getLong("id"));
            if (exist) {
                String msg2 = String.format(ResManager.loadKDString((String)"%1s\uff08%2s\uff09\u5df2\u7ecf\u5b58\u5728\u672c\u7ec4\u7ec7\u521b\u5efa\u4e14\u53ef\u7528\u7684%3s\uff08%4s\uff09\u6a21\u677f\u3002", (String)"ReportTemplateDataValidator_0", (String)"fi-fgptas-opplugin", (Object[])new Object[0]), createOrgDyn.getString("name"), createOrgDyn.getString("number"), reportTypeDyn.getString("name"), reportTypeDyn.getString("number"));
                this.addErrorMessage(dataEntity, msg2);
            }
            DynamicObjectCollection outlines = template.getDynamicObjectCollection("outlineentry");
            List leafOutlines = outlines.stream().filter(o -> o.getBoolean("isleaf")).collect(Collectors.toList());
            HashSet<String> uncheckOutlines = new HashSet<String>(8);
            for (DynamicObject lOutline : leafOutlines) {
                String contentPrompt = lOutline.getString("contentprompt_tag");
                if (!StringUtils.isEmpty((String)contentPrompt)) continue;
                uncheckOutlines.add(lOutline.getString("outlinenumber") + " " + lOutline.getString("outlinename"));
            }
            if (uncheckOutlines.size() > 0) {
                String msg3 = String.format(ResManager.loadKDString((String)"\u53f6\u5b50\u8282\u70b9\u5927\u7eb2{%s}\u4e2d\u201c\u5185\u5bb9\u8981\u6c42\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ReportTemplateDataValidator_1", (String)"fi-fgptas-opplugin", (Object[])new Object[0]), String.join((CharSequence)"\u3001", uncheckOutlines));
                this.addErrorMessage(dataEntity, msg3);
            }
            if (!(globalFields = this.getGlobalFields(template)).containsKey(GlobalFieldEnum.ORG.getId()) || !globalFields.containsKey(GlobalFieldEnum.REPORT_PERIOD.getId())) {
                String msg4 = ResManager.loadKDString((String)"\u201c\u6570\u636e\u6574\u4f53\u8981\u6c42\u201d\u5b57\u6bb5\u5fc5\u987b\u914d\u7f6e\u201c\u7ec4\u7ec7\u201d\u548c\u201c\u62a5\u544a\u671f\u95f4\u201d\u3002", (String)"ReportTemplateDataValidator_4", (String)"fi-fgptas-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(dataEntity, msg4);
            }
            HashMap<String, String> dataSourceEntities = this.getDS(outlines, dataEntity);
            HashMap dataGlobalRequire = ReportTemDataHelper.getDataGlobalRequire(globalFields.keySet(), dataSourceEntities.keySet());
            if (dataGlobalRequire == null) continue;
            ArrayList<String> errorMsg = new ArrayList<String>(4);
            ArrayList<String> noticeMsg = new ArrayList<String>(4);
            for (Map.Entry<String, String> ds : dataSourceEntities.entrySet()) {
                String msg5;
                HashMap fieldMap = (HashMap)dataGlobalRequire.get(ds.getKey());
                HashSet<String> notConfigFields = new HashSet<String>(4);
                HashSet<String> notPresetFields = new HashSet<String>(4);
                for (Map.Entry<Long, String> gField : globalFields.entrySet()) {
                    Long globalFieldKey = gField.getKey();
                    String value = gField.getValue();
                    if (fieldMap == null && (gField.getKey().equals(GlobalFieldEnum.REPORT_PERIOD.getId()) || gField.getKey().equals(GlobalFieldEnum.ORG.getId()))) {
                        notPresetFields.add(value);
                        continue;
                    }
                    if (fieldMap == null) {
                        notConfigFields.add(value);
                        continue;
                    }
                    if (fieldMap.get(globalFieldKey) != null) continue;
                    notConfigFields.add(value);
                }
                if (notPresetFields.size() > 0) {
                    msg5 = String.format(ResManager.loadKDString((String)"%1s\u5b57\u6bb5\u5728{%2s}\u8868\u672a\u7ef4\u62a4\u6620\u5c04\u5173\u7cfb\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u63d0\u4ea4", (String)"ReportTemplateDataValidator_3", (String)"fi-fgptas-opplugin", (Object[])new Object[0]), String.join((CharSequence)"\u3001", notPresetFields), ds.getValue());
                    errorMsg.add(msg5);
                }
                if (notConfigFields.size() <= 0) continue;
                msg5 = String.format(ResManager.loadKDString((String)"%1s\u5b57\u6bb5\u5728{%2s}\u8868\u672a\u7ef4\u62a4\u6620\u5c04\u5173\u7cfb\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u63d0\u4ea4", (String)"ReportTemplateDataValidator_3", (String)"fi-fgptas-opplugin", (Object[])new Object[0]), String.join((CharSequence)"\u3001", notConfigFields), ds.getValue());
                noticeMsg.add(msg5);
            }
            if (errorMsg.size() > 0) {
                msg = String.format(ResManager.loadKDString((String)"\u6570\u636e\u6765\u6e90-\u6570\u636e\u8868\u672a\u5b8c\u5168\u914d\u7f6e\u201c\u6570\u636e\u6574\u4f53\u8981\u6c42\u201d\u5b57\u6bb5\u6620\u5c04\u5173\u7cfb\uff1a%s\u3002", (String)"ReportTemplateDataValidator_2", (String)"fi-fgptas-opplugin", (Object[])new Object[0]), String.join((CharSequence)"\uff1b", errorMsg));
                this.addErrorMessage(dataEntity, msg);
                continue;
            }
            if (noticeMsg.size() <= 0) continue;
            msg = String.format(ResManager.loadKDString((String)"\u6570\u636e\u6765\u6e90-\u6570\u636e\u8868\u672a\u5b8c\u5168\u914d\u7f6e\u201c\u6570\u636e\u6574\u4f53\u8981\u6c42\u201d\u5b57\u6bb5\u6620\u5c04\u5173\u7cfb\uff1a%s\u3002", (String)"ReportTemplateDataValidator_2", (String)"fi-fgptas-opplugin", (Object[])new Object[0]), String.join((CharSequence)"\uff1b", noticeMsg));
            this.addMessage(dataEntity, msg, ErrorLevel.Info);
        }
    }

    private HashMap<Long, String> getGlobalFields(DynamicObject template) {
        DynamicObjectCollection requireData = template.getDynamicObjectCollection("datarequire");
        HashMap<Long, String> globalFieldKeys = new HashMap<Long, String>(8);
        for (DynamicObject dynObj : requireData) {
            DynamicObject baseData = dynObj.getDynamicObject("fbasedataid");
            if (baseData == null) continue;
            globalFieldKeys.put(baseData.getLong("id"), baseData.getString("name"));
        }
        return globalFieldKeys;
    }

    private HashMap<String, String> getDS(DynamicObjectCollection outlines, ExtendedDataEntity dataEntity) {
        HashMap<String, String> dataSourceEntities = new HashMap<String, String>(8);
        for (DynamicObject outline : outlines) {
            for (DynamicObject dataSr : outline.getDynamicObjectCollection("datasourcesubentry")) {
                DynamicObject ds = dataSr.getDynamicObject("datatable");
                if (ds == null) continue;
                dataSourceEntities.put(ds.getString("number"), ds.getString("name"));
            }
            Iterator iterator = outline.getDynamicObjectCollection("datasourcesubentry").iterator();
            int count = 0;
            while (iterator.hasNext()) {
                ++count;
                DynamicObject row = (DynamicObject)iterator.next();
                DynamicObject ds = row.getDynamicObject("datatable");
                String dp = row.getString("dataprop");
                if (ds == null && StringUtils.isBlank((String)dp)) {
                    iterator.remove();
                    continue;
                }
                if (!StringUtils.isBlank((String)dp)) continue;
                String str = outline.getString("outlinenumber") + " " + outline.getString("contentprompt_tag");
                String msg = String.format(ResManager.loadKDString((String)"\u53f6\u5b50\u8282\u70b9\u5927\u7eb2{%1$s}\u6570\u636e\u6765\u6e90\u7684\u7b2c%2$s\u884c\u201c\u6570\u636e\u8868\u5217\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ReportTemplateDataValidator_6", (String)"fi-fgptas-opplugin", (Object[])new Object[0]), str, count);
                this.addErrorMessage(dataEntity, msg);
            }
        }
        return dataSourceEntities;
    }
}

