/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fgptas.common.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringJoiner;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.DynamicObjectSerializationBinder;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class DynamicObjectUtil {
    private static final Log log = LogFactory.getLog(DynamicObjectUtil.class);

    public static String toDisplayName(String mulField, String entityNumber, Object pk) {
        if (StringUtils.isBlank((CharSequence)mulField)) {
            return "";
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        String[] fields = mulField.split(",");
        String basicKey = "basic";
        HashMap<String, List> fieldSet = new HashMap<String, List>();
        for (String field : fields) {
            String[] props = field.trim().split("\\.");
            String prop = props[0];
            if (StringUtils.isBlank((CharSequence)prop)) continue;
            List propList = dataEntityType.getProperty(prop) instanceof DynamicCollectionProperty ? fieldSet.computeIfAbsent(prop, key -> new ArrayList(16)) : fieldSet.computeIfAbsent(basicKey, key -> new ArrayList(16));
            propList.add(field);
        }
        StringJoiner sj = new StringJoiner(",");
        for (List value : fieldSet.values()) {
            String queryField = String.join((CharSequence)",", value);
            DynamicObjectCollection dataCollection = null;
            try {
                dataCollection = QueryServiceHelper.query((String)entityNumber, (String)queryField, (QFilter[])new QFilter("id", "=", pk).toArray(), null, (int)2000);
            }
            catch (Exception e) {
                log.error("invalid queryField:" + queryField, (Throwable)e);
            }
            if (dataCollection == null) {
                log.error(entityNumber + "_" + pk + " is not exist!!");
                continue;
            }
            for (DynamicObject dataEntity : dataCollection) {
                DynamicObjectSerializationBinder b = new DynamicObjectSerializationBinder(dataEntity.getDynamicObjectType());
                b.setOnlyDbProperty(false);
                DcJsonSerializer jsr = new DcJsonSerializer((DcBinder)b);
                String result = jsr.serializeToString((Object)dataEntity, null);
                result = result.replaceAll("\"_Type_\":\".*?\",", "").replaceAll(",\"_Type_\":\".*?\"", "");
                for (String field : fields) {
                    String[] props = field.split("\\.");
                    StringBuilder displayNameBuilder = DynamicObjectUtil.fillPropDisplayName((DynamicObjectType)dataEntityType, props);
                    if (displayNameBuilder == null) continue;
                    result = result.replaceAll(field, displayNameBuilder.toString());
                }
                sj.add(result);
            }
        }
        return sj.toString();
    }

    private static StringBuilder fillPropDisplayName(DynamicObjectType dt, String[] p) {
        StringBuilder subPropDesc = new StringBuilder();
        IDataEntityProperty property = null;
        for (String s : p) {
            if (property == null) {
                property = (IDataEntityProperty)dt.getProperties().get((Object)s);
            } else if (property instanceof IComplexProperty) {
                property = (IDataEntityProperty)((IComplexProperty)property).getComplexType().getProperties().get((Object)s);
            } else if (property instanceof DynamicCollectionProperty) {
                property = (IDataEntityProperty)((DynamicCollectionProperty)property).getDynamicCollectionItemPropertyType().getProperties().get((Object)s);
            } else {
                return null;
            }
            if (property == null) {
                return null;
            }
            if (subPropDesc.length() > 0) {
                subPropDesc.append(".");
            }
            subPropDesc.append(property.getDisplayName());
        }
        return subPropDesc;
    }
}

