/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fgptas.common.helper;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;

public class MarkDownDataHelper {
    private static final char NEW_LINE = '\r';
    private static final char NEXT_ROW = '|';

    public static String queryDataOfMarkDownFormat(String entityName, String selectFields, QFilter[] filters, String orderBys) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
        String[] properties = selectFields.split(",");
        if (properties.length < 1) {
            return null;
        }
        StringBuilder sb = new StringBuilder(124);
        for (String prop : properties) {
            DynamicProperty property = dataEntityType.getProperty(prop);
            if (property == null) continue;
            sb.append(property.getDisplayName().getLocaleValue());
            sb.append('|');
        }
        sb.append("\r|");
        for (int i = 0; i < properties.length; ++i) {
            sb.append("----|");
        }
        sb.append('\r');
        String mergeField = "'|'+" + selectFields.replaceAll(",", "+'|'+") + "+'|' mergeRow";
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"fgptas.queryMarkDownData", (String)entityName, (String)selectFields, (QFilter[])filters, (String)orderBys);){
            DataSet mergeRowDs;
            DataSet mKDs;
            if (ds.hasNext() && (mKDs = (mergeRowDs = ds.select(new String[]{mergeField})).groupBy().groupConcat("mergeRow", "makeDown", String.valueOf('\r')).finish()).hasNext()) {
                Row row = mKDs.next();
                sb.append(row.getString("makeDown"));
            }
        }
        return sb.toString();
    }

    public static String queryDataOfMarkDownFormat(Map<String, String> dataMetaMap, String selectFields, JSONArray jsonArray) {
        String[] properties = selectFields.split(",");
        if (properties.length < 1) {
            return null;
        }
        StringBuilder sb = new StringBuilder(124);
        for (String prop : properties) {
            String propertyName = dataMetaMap.get(prop);
            if (!StringUtils.isNotEmpty((String)propertyName)) continue;
            sb.append(propertyName);
            sb.append('|');
        }
        sb.append("\r|");
        for (int i = 0; i < properties.length; ++i) {
            sb.append("----|");
        }
        sb.append('\r');
        String mergeField = "'|'+" + selectFields.replaceAll(",", "+'|'+") + "+'|' mergeRow";
        for (Object o : jsonArray) {
            JSONObject json = (JSONObject)o;
            sb.append('|');
            for (String property : properties) {
                sb.append(json.get((Object)property));
                sb.append('|');
            }
            sb.append('\r');
        }
        return sb.toString();
    }
}

