/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fgptas.common.spread;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.orm.util.ReflectionUtils;
import kd.fi.fgptas.common.spread.ISpreadContainer;
import kd.fi.fgptas.common.spread.command.AreasStyle;
import kd.fi.fgptas.common.spread.command.CellArea;
import kd.fi.fgptas.common.spread.command.CellStyleInfo;
import kd.fi.fgptas.common.spread.command.Workbook;
import kd.fi.fgptas.common.spread.command.Worksheet;

public class SpreadContainer
implements ISpreadContainer {
    protected String spreadKey;
    protected transient IClientViewProxy clientViewProxy;

    public SpreadContainer(IFormView view, String spreadKey) {
        this.clientViewProxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
        this.spreadKey = spreadKey;
    }

    @Override
    public void addSheets(int index, String name, int totalRow, int totalCol) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        HashMap<String, Object[]> fea = new HashMap<String, Object[]>();
        Object[] objects = new Object[]{params};
        params.put("index", index);
        params.put("name", name);
        params.put("rc", totalRow);
        params.put("cc", totalCol);
        fea.put("sheets", objects);
        this.clientViewProxy.invokeControlMethod(this.spreadKey, "addSheets", new Object[]{fea});
    }

    @Override
    public void upDataValue(List<Map<String, Object>> parameters) {
        this.clientViewProxy.invokeControlMethod(this.spreadKey, "updataValue", new Object[]{parameters});
    }

    @Override
    public void closeToolbar() {
        HashMap parasMap = new HashMap();
        this.clientViewProxy.invokeControlMethod(this.spreadKey, "closeToolbar", new Object[]{parasMap});
    }

    @Override
    public void setWorkbookOptions(Workbook workbookOptions) {
        this.clientViewProxy.invokeControlMethod(this.spreadKey, "setWorkbookOptions", new Object[]{workbookOptions});
    }

    @Override
    public void setWorksheetOptions(List<Worksheet> worksheet) {
        this.clientViewProxy.invokeControlMethod(this.spreadKey, "setWorksheetOptions", new Object[]{worksheet});
    }

    @Override
    public void setToolbarExpandBtnVisible(Boolean visible) {
        HashMap<String, Boolean> parasmap = new HashMap<String, Boolean>();
        parasmap.put("visible", visible);
        this.clientViewProxy.invokeControlMethod(this.spreadKey, "setExpandBtnVisible", new Object[]{parasmap});
    }

    @Override
    public void lockSheets(List<Integer> sheetIndexes) {
        if (sheetIndexes != null && sheetIndexes.size() > 0) {
            this.clientViewProxy.invokeControlMethod(this.spreadKey, "lockSheet", new Object[]{sheetIndexes});
        }
    }

    @Override
    public void setColumnsWidth(List<Integer> colIndexes, int width) {
        if (colIndexes == null || colIndexes.size() == 0) {
            return;
        }
        HashMap<String, Object> parasMap = new HashMap<String, Object>();
        parasMap.put("index", colIndexes);
        parasMap.put("num", width);
        this.clientViewProxy.invokeControlMethod(this.spreadKey, "setColumnsWidth", new Object[]{parasMap});
    }

    @Override
    public void setRowsHeight(List<Integer> rowIndexes, int height) {
        if (rowIndexes == null || rowIndexes.size() == 0) {
            return;
        }
        HashMap<String, Object> parasMap = new HashMap<String, Object>();
        parasMap.put("index", rowIndexes);
        parasMap.put("num", height);
        this.clientViewProxy.invokeControlMethod(this.spreadKey, "setRowsHeight", new Object[]{parasMap});
    }

    @Override
    public void setCellStyle(List<AreasStyle> areasStyles) {
        if (areasStyles == null || areasStyles.size() == 0) {
            return;
        }
        Object paras = this.packageAreaStyles(areasStyles);
        if (paras != null) {
            this.clientViewProxy.invokeControlMethod(this.spreadKey, "setCellStyle", new Object[]{paras});
        }
    }

    private Object packageAreaStyles(List<AreasStyle> areasStyles) {
        ArrayList rangestyles = new ArrayList();
        for (AreasStyle areasStyle : areasStyles) {
            List<CellArea> areas;
            if (areasStyle == null || (areas = areasStyle.getRange()) == null || areas.size() == 0) continue;
            CellStyleInfo cellStyleInfo = areasStyle.getStyle();
            Field[] fields = cellStyleInfo.getClass().getDeclaredFields();
            LinkedHashMap<String, Object> style = new LinkedHashMap<String, Object>();
            LinkedHashMap<String, Object> bls = new LinkedHashMap<String, Object>();
            for (Field field : fields) {
                String fieldname = field.getName();
                Object value = null;
                try {
                    ReflectionUtils.makeAccessible((Field)field);
                    value = field.get(cellStyleInfo);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (value == null) continue;
                if ("bls".equals(fieldname) || "blc".equals(fieldname)) {
                    bls.put(fieldname, value);
                    continue;
                }
                if ("ha".equals(fieldname) || "va".equals(fieldname)) {
                    if (!(value instanceof Integer) || (Integer)value < 0) continue;
                    style.put(fieldname, value);
                    continue;
                }
                style.put(fieldname, value);
            }
            if (bls.size() > 0) {
                style.put("bl", bls);
            }
            if (style.size() <= 0 || areas.size() <= 0) continue;
            LinkedHashMap<String, Object> rangestyle = new LinkedHashMap<String, Object>();
            rangestyle.put("range", areas);
            rangestyle.put("style", style);
            rangestyles.add(rangestyle);
        }
        if (rangestyles.size() > 0) {
            return rangestyles;
        }
        return null;
    }
}

