/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fgptas.common.utils;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.DynamicObjectSerializationBinder;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;

public class SerializationUtil {
    public static String toDynamicObjectJson(DynamicObject obj) {
        DynamicObjectType type = obj.getDynamicObjectType();
        DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder(type);
        DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
        jser.setIsLocaleValueFull(true);
        jser.setSerializeComplexProperty(true);
        binder.setOnlyDbProperty(false);
        return jser.serializeToString((Object)obj, null);
    }

    public static DynamicObject fromDynamicString(String value, MainEntityType entityType) {
        DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder((DynamicObjectType)entityType);
        DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
        jser.setIsLocaleValueFull(true);
        jser.setSerializeComplexProperty(true);
        binder.setOnlyDbProperty(false);
        return (DynamicObject)jser.deserializeFromString(value, null);
    }

    public static String toQFilterListJson(List<QFilter> qFilterList) {
        if (qFilterList == null) {
            return null;
        }
        ArrayList<String> qFilterStringList = new ArrayList<String>(qFilterList.size());
        for (QFilter qFilter : qFilterList) {
            qFilterStringList.add(qFilter.toSerializedString());
        }
        return SerializationUtils.toJsonString(qFilterStringList);
    }

    public static List<QFilter> fromQFilterListJson(String qFilterListJson) {
        if (StringUtils.isEmpty((String)qFilterListJson)) {
            return null;
        }
        List qFilterStringList = SerializationUtils.fromJsonStringToList((String)qFilterListJson, String.class);
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(qFilterStringList.size());
        for (String qFilterString : qFilterStringList) {
            qFilterList.add(QFilter.fromSerializedString((String)qFilterString));
        }
        return qFilterList;
    }
}

