/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fircm.opplugin.creditappeal;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.fircm.business.CreditScoreLockDecorate;

public class CreditAppealAuditPlugin
extends AbstractOperationServicePlugIn {
    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        OperationResult operationResult = this.getOperationResult();
        List validateResults = operationResult.getValidateResult().getValidateErrors();
        List successPkIds = operationResult.getSuccessPkIds();
        Map<String, Object> resultMap = this.saveCreditModifyLog(e.getDataEntities());
        List failIds = (List)resultMap.get("failIds");
        successPkIds.remove(failIds);
        String opsMsg = (String)resultMap.get("opMsg");
        if (StringUtils.isNotEmpty((String)opsMsg)) {
            ValidationErrorInfo info = new ValidationErrorInfo("", null, 0, 0, "errorcode_001", "", opsMsg, ErrorLevel.Error);
            ValidateResult validateResult = new ValidateResult();
            validateResult.addErrorInfo((OperateErrorInfo)info);
            validateResults.add(validateResult);
        }
    }

    private Map<String, Object> saveCreditModifyLog(DynamicObject[] bills) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        StringBuilder errorMsg = new StringBuilder();
        ArrayList<Object> failedIds = new ArrayList<Object>(8);
        StringBuilder billNoStr = new StringBuilder();
        for (DynamicObject bill : bills) {
            String billNo = bill.getString("billno");
            String billEntity = "fircm_creditappeal";
            String billId = bill.getString("id");
            DynamicObject appealData = BusinessDataServiceHelper.loadSingle((Object)bill.getPkValue(), (String)"fircm_creditappeal");
            if (appealData == null) {
                billNoStr.append(billNo).append(",");
                failedIds.add(bill.getPkValue());
                continue;
            }
            BigDecimal auditScore = appealData.getBigDecimal("auditscore");
            BigDecimal applyScore = appealData.getBigDecimal("applyaddscore");
            Long userId = appealData.getDynamicObject("creator").getLong("id");
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("billno", billNo);
            param.put("billentity", billEntity);
            param.put("billid", billId);
            param.put("auditscore", auditScore);
            param.put("applyscore", applyScore);
            param.put("userid", userId);
            CreditScoreLockDecorate.creditAppealPoints(param);
        }
        if (StringUtils.isBlank((String)billNoStr.toString())) {
            resultMap.put("opsMsg", billNoStr.toString());
        } else {
            errorMsg.append("[");
            errorMsg.append(billNoStr.substring(0, billNoStr.length() - 1));
            errorMsg.append("]");
            errorMsg.append(ResManager.loadKDString((String)"\u672a\u627e\u5230\uff0c\u65e0\u6cd5\u751f\u6210\u4fe1\u7528\u53d8\u66f4\u65e5\u5fd7\u3002", (String)"", (String)"fi-fircm-oppulgin", (Object[])new Object[0]));
            resultMap.put("opsMsg", errorMsg.toString());
            resultMap.put("failIds", failedIds);
        }
        return resultMap;
    }
}

