/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fircm.function;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.CustomAggFunction;
import kd.bos.algo.DataType;

public class GroupTopFunction
extends CustomAggFunction<List<String>> {
    private int top;
    private char separator;

    public GroupTopFunction(int top, char separator) {
        super("ssc_group_top", (DataType)DataType.StringType);
        this.top = top;
        this.separator = separator;
    }

    public List<String> newAggValue() {
        return new ArrayList<String>(this.top);
    }

    public List<String> addValue(List<String> aggValue, Object value) {
        if (value != null && aggValue.size() < this.top) {
            aggValue.add(value.toString());
        }
        return aggValue;
    }

    public List<String> combineAggValue(List<String> aggValue1, List<String> aggValue2) {
        int i = aggValue1.size() - this.top;
        for (String val : aggValue2) {
            if (i >= 0) break;
            aggValue1.add(val);
            ++i;
        }
        return aggValue1;
    }

    public Object getResult(List<String> aggValue) {
        StringBuilder sb = new StringBuilder();
        for (String val : aggValue) {
            sb.append(this.separator).append(val);
        }
        if (sb.length() > 0) {
            return sb.substring(1);
        }
        return "";
    }
}

