/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fircm.task.util;

import java.util.ArrayList;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.servicehelper.license.LicenseServiceHelper;

public class FircmLicenseUtil {
    public static boolean checkGroupLicense(PreOpenFormEventArgs e) {
        String version = LicenseServiceHelper.getProductVersion();
        if ("6.0".equals(version) || "7.0".equals(version)) {
            return FircmLicenseUtil.checkLicense(e);
        }
        return true;
    }

    private static boolean checkLicense(PreOpenFormEventArgs e) {
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        LicenseCheckResult checkResult = LicenseServiceHelper.checkUserInGroup((Long)userId, (Long)401L);
        Set modules = LicenseServiceHelper.getLicenseModules();
        if (checkResult == null || modules == null) {
            e.setCancelMessage(String.format("License Exception: userId = %s, checkResult = %s, modules = %s", userId, checkResult, modules));
            e.setCancel(true);
            return false;
        }
        String appId_ = AppMetadataCache.getAppInfo((String)"som").getId();
        if (!checkResult.getHasLicense().booleanValue() || !modules.contains(appId_)) {
            String msg = ResManager.loadKDString((String)"\u6ca1\u6709\"\u8d22\u52a1+\u4f9b\u5e94\u94fe+\u5236\u9020\u5206\u7ec4\"\u4e2d\"\u5171\u4eab\u8fd0\u8425\u7ba1\u7406\"\u6a21\u5757\u8bb8\u53ef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"FircmLicenseUtil_0", (String)"fi-fircm-common", (Object[])new Object[0]);
            e.setCancelMessage(msg);
            String detail = ResManager.loadKDString((String)"\u7528\u6237\u9700\u8981\u5206\u914d\"\u8d22\u52a1+\u4f9b\u5e94\u94fe+\u5236\u9020\u5206\u7ec4\"\u8bb8\u53ef\u5206\u7ec4\u3002", (String)"FircmLicenseUtil_1", (String)"ssc-task-common", (Object[])new Object[0]);
            ArrayList<String> details = new ArrayList<String>();
            details.add(detail);
            FormShowParameter licParameter = LicenseServiceHelper.buildNoticeFormShowParameter((String)msg, details);
            e.setCancelFormShowParameter(licParameter.toString());
            e.setCancel(true);
            return false;
        }
        return true;
    }
}

