/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fircm.utils;

import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.orm.query.QFilter;

public class DateSpanUtils {
    public static QFilter timeSection(String property, LocalDate startTime, LocalDate endTime) {
        if (endTime == null) {
            if (startTime == null) {
                return null;
            }
            return QFilter.of((String)(property + " >= ?"), (Object[])new Object[]{startTime});
        }
        if (startTime == null) {
            return QFilter.of((String)(property + " <= ?"), (Object[])new Object[]{endTime});
        }
        return QFilter.of((String)(property + " >= ? and " + property + " < ?"), (Object[])new Object[]{startTime, endTime});
    }

    public static DataSet filterDataSet(DataSet dataSet, String property, LocalDate startDate, LocalDate endDate) {
        if (startDate != null || endDate != null) {
            Map<String, Object> dateRange = DateSpanUtils.createDateRangeMap(startDate, endDate);
            if (endDate == null) {
                return dataSet.filter(property + " >= startDate", dateRange);
            }
            if (startDate == null) {
                return dataSet.filter(property + " < endDate", dateRange);
            }
            return dataSet.filter(property + " >= startDate and " + property + " < endDate ", dateRange);
        }
        return dataSet;
    }

    public static Map<String, Object> createDateRangeMap(LocalDate startDate, LocalDate endDate) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (startDate != null) {
            map.put("startDate", DateSpanUtils.localDate2Date(startDate));
        }
        if (endDate != null) {
            map.put("endDate", DateSpanUtils.localDate2Date(endDate));
        }
        return map;
    }

    public static Date localDate2Date(LocalDate localDate) {
        if (null == localDate) {
            return null;
        }
        ZonedDateTime zonedDateTime = localDate.atStartOfDay(ZoneId.systemDefault());
        return Date.from(zonedDateTime.toInstant());
    }
}

