/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fircm.upgradeservice;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.ExceptionUtils;

public class CreditFileOrgUpgradeServiceImpl
implements IUpgradeService {
    private static final String QUERY_SQL0 = "select fuser from t_tk_creditfiles where forg = 0 and fstatus != 'D'";
    private static final String UPDATE_SQL1 = "update t_tk_creditfiles set forg = ? where fuser = ? and fstatus != 'D'";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        List<Long> userIds = this.getCreditFileUserIds();
        if (userIds.isEmpty()) {
            return this.buildSuccessResult();
        }
        List userMainOrgIds = UserServiceHelper.getUserMainOrgId(userIds);
        List<Object[]> paramList = this.buildParamList(userMainOrgIds);
        if (CollectionUtils.isEmpty(paramList)) {
            return this.buildSuccessResult();
        }
        return this.updateCreditFiles(paramList);
    }

    private UpgradeResult updateCreditFiles(List<Object[]> paramList) {
        try {
            DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)UPDATE_SQL1, paramList);
        }
        catch (Exception e) {
            return this.buildErrorResult(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
        return this.buildSuccessResult();
    }

    private List<Object[]> buildParamList(List<Map<Long, Long>> userMainOrgIds) {
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(8);
        if (CollectionUtils.isEmpty(userMainOrgIds)) {
            return paramList;
        }
        for (Map<Long, Long> userInfoMap : userMainOrgIds) {
            if (userInfoMap == null || userInfoMap.isEmpty()) continue;
            for (Map.Entry<Long, Long> entry : userInfoMap.entrySet()) {
                if (entry.getValue() == null) continue;
                Object[] paramArr = new Object[]{entry.getValue(), entry.getKey()};
                paramList.add(paramArr);
            }
        }
        return paramList;
    }

    private UpgradeResult buildSuccessResult() {
        UpgradeResult result = new UpgradeResult();
        result.setLog("Credit file upgrade success.");
        result.setSuccess(true);
        return result;
    }

    private UpgradeResult buildErrorResult(String errorInfo) {
        UpgradeResult result = new UpgradeResult();
        result.setErrorInfo(errorInfo);
        result.setLog("Credit file upgrade error.");
        result.setSuccess(false);
        return result;
    }

    private List<Long> getCreditFileUserIds() {
        String algoKey = this.getClass() + "beforeExecuteSqlWithResult()";
        ArrayList<Long> userIds = new ArrayList<Long>(8);
        try (DataSet resultSet = DB.queryDataSet((String)(algoKey + "_0"), (DBRoute)DBRoute.of((String)"ssc"), (String)QUERY_SQL0);){
            if (resultSet == null || resultSet.isEmpty()) {
                ArrayList<Long> arrayList = userIds;
                return arrayList;
            }
            while (resultSet.hasNext()) {
                Row row = resultSet.next();
                userIds.add((Long)row.get("fuser"));
            }
        }
        return userIds;
    }
}

