/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fircm.upgradeservice;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.util.StringUtils;

public class FircmAppParamTransferServiceImpl
implements IUpgradeService {
    private static final String QUERY_SQL0 = "select fparamvalue from t_tk_paramcontrol where fparamname ='creditFilesExecTime'";
    private static final String QUERY_SQL1 = "select fparamvalue from t_tk_paramcontrol where fparamname ='creditExcuteRecord'";
    private static final String QUERY_SQL2 = "select b.fdata,b.fparamid from t_bas_sysparaconsole a,t_bas_sysparameter b where a.fappid ='1ZH12M=M8H7O' and b.fparamid =a.fid";
    private static final String UPDATE_SQL = "update t_bas_sysparameter set fdata ='%1$s' where fparamid ='%2$s'";
    private static final String DELETE_SQL = "delete from t_tk_paramcontrol where fparamname in ('creditFilesExecTime','creditExcuteRecord')";

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        String algoKey = this.getClass() + ".afterExecuteSqlWithResult()";
        String creditFilesExecTime = this.getCreditFilesExecTime(algoKey);
        String creditExcuteRecord = this.getCreditExcuteRecord(algoKey);
        if (StringUtils.isEmpty((String)creditExcuteRecord) || StringUtils.isEmpty((String)creditFilesExecTime)) {
            return this.getFailResult("creditExcuteRecord or creditFilesExecTime is empty");
        }
        List<String> creditSysParam = this.getCreditSysParam(algoKey);
        if (creditSysParam == null || creditSysParam.isEmpty()) {
            return this.getFailResult("creditSysParam is empty");
        }
        String updateSql = this.buildUpdateSql(creditSysParam, creditFilesExecTime, creditExcuteRecord);
        return this.transferFircmParam(updateSql);
    }

    private String buildUpdateSql(List<String> creditSysParam, String creditFilesExecTime, String creditExcuteRecord) {
        String paramJsonStr = creditSysParam.get(0);
        String paramId = creditSysParam.get(1);
        JSONObject paramJsonObj = JSON.parseObject((String)paramJsonStr);
        paramJsonObj.put("creditfilesexectime", (Object)creditFilesExecTime);
        paramJsonObj.put("creditexcuterecord", (Object)creditExcuteRecord);
        String json = JSON.toJSONString((Object)paramJsonObj);
        String updateSql = String.format(UPDATE_SQL, json, paramId);
        return updateSql;
    }

    private List<String> getCreditSysParam(String algoKey) {
        try (DataSet resultSet = DB.queryDataSet((String)(algoKey + "_3"), (DBRoute)DBRoute.of((String)"sys"), (String)QUERY_SQL2);){
            ArrayList<String> creditSysConfigList = new ArrayList<String>(8);
            if (resultSet.hasNext()) {
                Row next = resultSet.next();
                creditSysConfigList.add(next.get("fdata") + "");
                creditSysConfigList.add(next.get("fparamid") + "");
            }
            ArrayList<String> arrayList = creditSysConfigList;
            return arrayList;
        }
    }

    private String getCreditFilesExecTime(String algoKey) {
        try (DataSet resultSet = DB.queryDataSet((String)(algoKey + "_0"), (DBRoute)DBRoute.of((String)"ssc"), (String)QUERY_SQL0);){
            if (resultSet.hasNext()) {
                Row next = resultSet.next();
                String string = next.get("fparamvalue") + "";
                return string;
            }
            String string = "";
            return string;
        }
    }

    private String getCreditExcuteRecord(String algoKey) {
        try (DataSet resultSet = DB.queryDataSet((String)(algoKey + "_1"), (DBRoute)DBRoute.of((String)"ssc"), (String)QUERY_SQL1);){
            if (resultSet.hasNext()) {
                Row next = resultSet.next();
                String string = next.get("fparamvalue") + "";
                return string;
            }
            String string = "";
            return string;
        }
    }

    private UpgradeResult transferFircmParam(String updateSql) {
        try (TXHandle h = TX.requiresNew((String)"update_sys_fircm_param");){
            try {
                DB.execute((DBRoute)DBRoute.of((String)"sys"), (String)updateSql);
            }
            catch (Throwable e) {
                h.markRollback();
                UpgradeResult upgradeResult = this.getFailResult(e.getMessage());
                if (h != null) {
                    if (var3_3 != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable throwable) {
                            var3_3.addSuppressed(throwable);
                        }
                    } else {
                        h.close();
                    }
                }
                return upgradeResult;
            }
        }
        h = TX.requiresNew((String)"delete_ssc_fircm_param");
        var3_3 = null;
        try {
            try {
                DB.execute((DBRoute)DBRoute.of((String)"ssc"), (String)DELETE_SQL);
            }
            catch (Throwable e) {
                h.markRollback();
                UpgradeResult upgradeResult = this.getFailResult(e.getMessage());
                if (h != null) {
                    if (var3_3 != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable throwable) {
                            var3_3.addSuppressed(throwable);
                        }
                    } else {
                        h.close();
                    }
                }
                return upgradeResult;
            }
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (h != null) {
                if (var3_3 != null) {
                    try {
                        h.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    h.close();
                }
            }
        }
        return this.getSuccessResult();
    }

    private UpgradeResult getSuccessResult() {
        UpgradeResult result = new UpgradeResult();
        result.setLog(ResManager.loadKDString((String)"\u62a5\u8d26\u4fe1\u7528\u53c2\u6570\u8fc1\u79fb\u5b8c\u6210", (String)"FircmAppParamTransferServiceImpl_0", (String)"fi-fircm-upgradeservice", (Object[])new Object[0]));
        result.setSuccess(true);
        return result;
    }

    private UpgradeResult getFailResult(String errorInfo) {
        UpgradeResult result = new UpgradeResult();
        result.setErrorInfo(errorInfo);
        result.setLog(ResManager.loadKDString((String)"\u62a5\u8d26\u4fe1\u7528\u53c2\u6570\u8fc1\u79fb\u5931\u8d25", (String)"FircmAppParamTransferServiceImpl_1", (String)"fi-fircm-upgradeservice", (Object[])new Object[0]));
        result.setSuccess(false);
        return result;
    }
}

