/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fircm.upgradeservice;

import java.util.ArrayList;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.mulilang.GLDataServiceHelper;
import kd.bos.util.ExceptionUtils;

public class MultilingualFieldUpgradeServiceImpl
implements IUpgradeService {
    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            String defaultLocaleId = GLDataServiceHelper.getDefaultLocaleId();
            this.repairCreditAppealData(defaultLocaleId);
            this.repairCreditArgNameData(defaultLocaleId);
            this.repairCreditArgAppNameData(defaultLocaleId);
            this.repairCreditByImageNewData(defaultLocaleId);
            this.repairCreditFilesData(defaultLocaleId);
            this.repairCreditLevelNameData(defaultLocaleId);
            this.repairCreditLevelDescribeData(defaultLocaleId);
            this.repairCreditRuleNameData(defaultLocaleId);
            this.repairCreditRuleRemarkData(defaultLocaleId);
            result.setSuccess(true);
            result.setLog(ResManager.loadKDString((String)"\u591a\u8bed\u8a00\u5b57\u6bb5\u6570\u636e\u5347\u7ea7\u5b8c\u6210\u3002", (String)"MultilingualFieldUpgradeServiceImpl_0", (String)"fi-fircm-upgradeservice", (Object[])new Object[0]));
        }
        catch (Exception e) {
            result.setSuccess(false);
            result.setLog(ResManager.loadKDString((String)"\u591a\u8bed\u8a00\u5b57\u6bb5\u6570\u636e\u5347\u7ea7\u5931\u8d25\u3002", (String)"MultilingualFieldUpgradeServiceImpl_1", (String)"fi-fircm-upgradeservice", (Object[])new Object[0]));
            result.setErrorInfo(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
        return result;
    }

    private void repairCreditAppealData(String defaultLocaleId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fid,b.fposition from t_fircm_creditappeal a inner join t_fircm_creditappeal_l b on a.fid = b.fid where (a.fposition = '' or a.fposition = ' ') and b.fposition !=' ' and b.fposition !='' ", new Object[0]);
        sqlBuilder.append("and b.flocaleid = ? ", new Object[]{defaultLocaleId});
        ArrayList<Object[]> upParams = new ArrayList<Object[]>(32);
        try (DataSet dataSet = DB.queryDataSet((String)"repairCreditAppealData", (DBRoute)DBRoute.of((String)"ssc"), (SqlBuilder)sqlBuilder);){
            for (Row row : dataSet) {
                String position = row.getString("fposition");
                long id = row.getLong("fid");
                upParams.add(new Object[]{position, id});
            }
        }
        if (!upParams.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)"update t_fircm_creditappeal set fposition = ? where fid = ?", upParams);
        }
    }

    private void repairCreditArgNameData(String defaultLocaleId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fid,b.fdesc from t_fircm_creditarg a inner join t_fircm_creditarg_l b on a.fid = b.fid where (a.fdesc = '' or a.fdesc = ' ') and b.fdesc !=' ' and b.fdesc !=''  ", new Object[0]);
        sqlBuilder.append("and b.flocaleid = ? ", new Object[]{defaultLocaleId});
        ArrayList<Object[]> upParams = new ArrayList<Object[]>(32);
        try (DataSet dataSet = DB.queryDataSet((String)"repairCreditArgNameData", (DBRoute)DBRoute.of((String)"ssc"), (SqlBuilder)sqlBuilder);){
            for (Row row : dataSet) {
                String position = row.getString("fdesc");
                long id = row.getLong("fid");
                upParams.add(new Object[]{position, id});
            }
        }
        if (!upParams.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)"update t_fircm_creditarg set fdesc = ? where fid = ?", upParams);
        }
    }

    private void repairCreditArgAppNameData(String defaultLocaleId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fid,b.fappobjname from t_fircm_creditarg a inner join t_fircm_creditarg_l b on a.fid = b.fid where (a.fappobjname = '' or a.fappobjname = ' ') and b.fappobjname !=' ' and b.fappobjname !='' ", new Object[0]);
        sqlBuilder.append("and b.flocaleid = ? ", new Object[]{defaultLocaleId});
        ArrayList<Object[]> upParams = new ArrayList<Object[]>(32);
        try (DataSet dataSet = DB.queryDataSet((String)"repairCreditArgAppNameData", (DBRoute)DBRoute.of((String)"ssc"), (SqlBuilder)sqlBuilder);){
            for (Row row : dataSet) {
                String position = row.getString("fappobjname");
                long id = row.getLong("fid");
                upParams.add(new Object[]{position, id});
            }
        }
        if (!upParams.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)"update t_fircm_creditarg set fappobjname = ? where fid = ?", upParams);
        }
    }

    private void repairCreditByImageNewData(String defaultLocaleId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fid,b.fname from t_tk_creditbyimage a inner join t_tk_creditbyimage_l b on a.fid = b.fid where (a.fname = '' or a.fname = ' ')  and b.fname !=' ' and b.fname !='' ", new Object[0]);
        sqlBuilder.append("and b.flocaleid = ? ", new Object[]{defaultLocaleId});
        ArrayList<Object[]> upParams = new ArrayList<Object[]>(32);
        try (DataSet dataSet = DB.queryDataSet((String)"repairCreditByImageNewData", (DBRoute)DBRoute.of((String)"ssc"), (SqlBuilder)sqlBuilder);){
            for (Row row : dataSet) {
                String position = row.getString("fname");
                long id = row.getLong("fid");
                upParams.add(new Object[]{position, id});
            }
        }
        if (!upParams.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)"update t_tk_creditbyimage set fname = ? where fid = ?", upParams);
        }
    }

    private void repairCreditFilesData(String defaultLocaleId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fid,b.fcorrectdescription from t_tk_creditfiles a inner join t_tk_creditfiles_l b on a.fid = b.fid where (a.fcorrectdescription = '' or a.fcorrectdescription = ' ')  and b.fcorrectdescription !=' ' and b.fcorrectdescription !='' ", new Object[0]);
        sqlBuilder.append("and b.flocaleid = ? ", new Object[]{defaultLocaleId});
        ArrayList<Object[]> upParams = new ArrayList<Object[]>(32);
        try (DataSet dataSet = DB.queryDataSet((String)"repairCreditFilesData", (DBRoute)DBRoute.of((String)"ssc"), (SqlBuilder)sqlBuilder);){
            for (Row row : dataSet) {
                String position = row.getString("fcorrectdescription");
                long id = row.getLong("fid");
                upParams.add(new Object[]{position, id});
            }
        }
        if (!upParams.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)"update t_tk_creditfiles set fcorrectdescription = ? where fid = ?", upParams);
        }
    }

    private void repairCreditLevelNameData(String defaultLocaleId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fid,b.fname from t_tk_creditlevel a inner join t_tk_creditlevel_l b on a.fid = b.fid where (a.fname = '' or a.fname = ' ') and b.fname !=' ' and b.fname !='' ", new Object[0]);
        sqlBuilder.append("and b.flocaleid = ? ", new Object[]{defaultLocaleId});
        ArrayList<Object[]> upParams = new ArrayList<Object[]>(32);
        try (DataSet dataSet = DB.queryDataSet((String)"repairCreditLevelData", (DBRoute)DBRoute.of((String)"ssc"), (SqlBuilder)sqlBuilder);){
            for (Row row : dataSet) {
                String position = row.getString("fname");
                long id = row.getLong("fid");
                upParams.add(new Object[]{position, id});
            }
        }
        if (!upParams.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)"update t_tk_creditlevel set fname = ? where fid = ?", upParams);
        }
    }

    private void repairCreditLevelDescribeData(String defaultLocaleId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fid,b.fdescribe from t_tk_creditlevel a inner join t_tk_creditlevel_l b on a.fid = b.fid where (a.fdescribe = '' or a.fdescribe = ' ') and b.fdescribe !=' ' and b.fdescribe !='' ", new Object[0]);
        sqlBuilder.append("and b.flocaleid = ? ", new Object[]{defaultLocaleId});
        ArrayList<Object[]> upParams = new ArrayList<Object[]>(32);
        try (DataSet dataSet = DB.queryDataSet((String)"repairCreditLevelDescribeData", (DBRoute)DBRoute.of((String)"ssc"), (SqlBuilder)sqlBuilder);){
            for (Row row : dataSet) {
                String position = row.getString("fdescribe");
                long id = row.getLong("fid");
                upParams.add(new Object[]{position, id});
            }
        }
        if (!upParams.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)"update t_tk_creditlevel set fdescribe = ? where fid = ?", upParams);
        }
    }

    private void repairCreditRuleNameData(String defaultLocaleId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fid,b.fname from t_tk_creditcommrule a inner join t_tk_creditcommrule_l b on a.fid = b.fid where (a.fname = '' or a.fname = ' ')  and b.fname !=' ' and b.fname !='' ", new Object[0]);
        sqlBuilder.append("and b.flocaleid = ? ", new Object[]{defaultLocaleId});
        ArrayList<Object[]> upParams = new ArrayList<Object[]>(32);
        try (DataSet dataSet = DB.queryDataSet((String)"repairCreditRuleNameData", (DBRoute)DBRoute.of((String)"ssc"), (SqlBuilder)sqlBuilder);){
            for (Row row : dataSet) {
                String position = row.getString("fname");
                long id = row.getLong("fid");
                upParams.add(new Object[]{position, id});
            }
        }
        if (!upParams.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)"update t_tk_creditcommrule set fname = ? where fid = ?", upParams);
        }
    }

    private void repairCreditRuleRemarkData(String defaultLocaleId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fid,b.fremark from t_tk_creditcommrule a inner join t_tk_creditcommrule_l b on a.fid = b.fid where (a.fremark = '' or a.fremark = ' ') and b.fremark !=' ' and b.fremark !='' ", new Object[0]);
        sqlBuilder.append("and b.flocaleid = ? ", new Object[]{defaultLocaleId});
        ArrayList<Object[]> upParams = new ArrayList<Object[]>(32);
        try (DataSet dataSet = DB.queryDataSet((String)"repairCreditRuleNameData", (DBRoute)DBRoute.of((String)"ssc"), (SqlBuilder)sqlBuilder);){
            for (Row row : dataSet) {
                String position = row.getString("fremark");
                long id = row.getLong("fid");
                upParams.add(new Object[]{position, id});
            }
        }
        if (!upParams.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)"update t_tk_creditcommrule set fremark = ? where fid = ?", upParams);
        }
    }
}

