/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fircm.service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.fircm.business.CreditScoreLockDecorate;
import kd.fi.fircm.business.helper.CreditServiceHelper;
import kd.fi.fircm.business.helper.WorkFlowCreditHelper;
import kd.fi.fircm.service.ICreditService;

public class CreditServiceImpl
implements ICreditService {
    private static final Log log = LogFactory.getLog(CreditServiceImpl.class);

    public void directCreditPoints(String creditPointDTOStr) {
        CreditScoreLockDecorate.updateCreditPoints((String)creditPointDTOStr);
    }

    public void minusCreditPoints(String param, int offset) {
        Map map = new HashMap();
        map = (Map)SerializationUtils.fromJsonString((String)param, map.getClass());
        CreditScoreLockDecorate.minusCreditPoints(map, (int)offset);
    }

    public void deductCreditPoints(List<Long> subScoreRuleIds, String modifySource, String creditPointDTOStr, String description) {
        CreditScoreLockDecorate.deductCreditPoints(subScoreRuleIds, (String)modifySource, (String)creditPointDTOStr, (String)description);
    }

    public DynamicObject getCreditFileByUserId(Long userId) {
        return CreditServiceHelper.queryCreditFileByBillInfo((long)userId);
    }

    public DynamicObject getCreditLevelByUserId(Long userId) {
        return CreditServiceHelper.queryCreditLevelByUserId((Long)userId);
    }

    public List<Long> getSubScoreRuleIdsByBillNumAndType(String billNum, String type) {
        return CreditServiceHelper.querySubScoreRuleIdsByBillNumAndType((String)billNum, (String)type);
    }

    public boolean isConfigCreditArg(String billType) {
        return CreditServiceHelper.isConfigCreditArg((String)billType);
    }

    public void insertCreditModLogOfZero(String creditPointDTOStr, String sourceType, String description) {
        CreditScoreLockDecorate.insertCreditModLogOfZero((String)creditPointDTOStr, (String)sourceType, (String)description);
    }

    public Long getCreditArgAppObj(String billType, String billId) {
        return CreditServiceHelper.queryCreditArgAppObj((String)billType, (String)billId);
    }

    public String handleCreditScoreWhenWFNodeLeave(Map<String, String> handleBizData) {
        return WorkFlowCreditHelper.handleCreditScoreWhenWFNodeLeave(handleBizData);
    }
}

