/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fircm.business;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.fircm.business.helper.CreditPlusAndMinusPointsHelper;
import kd.fi.fircm.business.helper.CreditServiceHelper;
import kd.ssc.task.workflow.dto.CreditPointDTO;

public class CreditScoreLockDecorate {
    protected static Log logger = LogFactory.getLog(CreditScoreLockDecorate.class);
    private static final String LOCK_PREFIx = "/fi/fircm/creditscore/";
    private static final long TRY_LOCK_MAX_TIME = 5000L;

    private static DLock createDLock(Long userId) {
        return DLock.create((String)(LOCK_PREFIx + userId)).fastMode();
    }

    public static void deductCreditPoints(List<Long> subScoreRuleIds, String modifySource, String creditPointDTOStr, String description) {
        CreditPointDTO creditPointDTO = (CreditPointDTO)SerializationUtils.fromJsonString((String)creditPointDTOStr, CreditPointDTO.class);
        Long userId = creditPointDTO.getUserId();
        try (DLock lock = CreditScoreLockDecorate.createDLock(userId);){
            if (lock.tryLock(5000L)) {
                CreditServiceHelper.deductCreditPoints(subScoreRuleIds, modifySource, creditPointDTOStr, description);
            } else {
                logger.info(String.format("%s deductCreditPoints require lock timeout", userId));
            }
        }
    }

    public static void minusCreditPoints(Map<String, String> param, int offset) {
        Long userId = Long.valueOf(param.get("userId"));
        try (DLock lock = CreditScoreLockDecorate.createDLock(userId);){
            if (lock.tryLock(5000L)) {
                CreditPlusAndMinusPointsHelper.minusCreditPoints(param, offset);
            } else {
                logger.info(String.format("%s minusCreditPoints require lock timeout", userId));
            }
        }
    }

    public static void updateCreditPoints(String creditPointDTOStr) {
        CreditPointDTO creditPointDTO = (CreditPointDTO)SerializationUtils.fromJsonString((String)creditPointDTOStr, CreditPointDTO.class);
        Long userId = creditPointDTO.getUserId();
        try (DLock lock = CreditScoreLockDecorate.createDLock(userId);){
            if (lock.tryLock(5000L)) {
                CreditPlusAndMinusPointsHelper.updateCreditPoints(creditPointDTOStr);
            } else {
                logger.info(String.format("%s updateCreditPoints require lock timeout", userId));
            }
        }
    }

    public static void creditAppealPoints(Map<String, Object> param) {
        Long userId = (Long)param.get("userid");
        try (DLock lock = CreditScoreLockDecorate.createDLock(userId);){
            if (lock.tryLock(5000L)) {
                CreditPlusAndMinusPointsHelper.creditAppealPoints(param);
            } else {
                logger.info(String.format("%s creditAppealPoints require lock timeout", userId));
            }
        }
    }

    public static void insertCreditModLogOfZero(String creditPointDTOStr, String sourceType, String description) {
        CreditPointDTO creditPointDTO = (CreditPointDTO)SerializationUtils.fromJsonString((String)creditPointDTOStr, CreditPointDTO.class);
        Long userId = creditPointDTO.getUserId();
        try (DLock lock = CreditScoreLockDecorate.createDLock(userId);){
            if (lock.tryLock(5000L)) {
                CreditServiceHelper.insertCreditModLogOfZero(creditPointDTOStr, sourceType, description);
            } else {
                logger.info(String.format("%s insertCreditModLogOfZero require lock timeout", userId));
            }
        }
    }
}

